/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.home.navto;

import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.DisplayMetrics;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.handmark.pulltorefresh.library.PullToRefreshBase;
import com.handmark.pulltorefresh.library.PullToRefreshListView;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.mobile.image.CircleImageView;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.image.PauseOnScrollListener;
import com.yy.mobile.image.PressedRecycleImageView;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.plugin.homeapi.ui.home.LivingClientConstant;
import com.yy.mobile.plugin.homepage.core.live.livecore.IHomepageLiveCore;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.plugin.main.events.ILiveCoreClient_onTopicDetailInfo_EventArgs;
import com.yy.mobile.ui.home.IRefreshTitle;
import com.yy.mobile.ui.home.navto.TopicDetailFragment$$EventBinder;
import com.yy.mobile.ui.utils.NavigationUtils;
import com.yy.mobile.ui.widget.EndlessListScrollListener;
import com.yy.mobile.ui.widget.StatusLayout;
import com.yy.mobile.ui.widget.headerviewpager.AbsListViewDelegate;
import com.yy.mobile.ui.widget.headerviewpager.ScrollableListener;
import com.yy.mobile.ui.widget.headerviewpager.ViewDelegate;
import com.yy.mobile.ui.widget.pager.PagerFragment;
import com.yy.mobile.util.DimenConverter;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.StringUtils;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.LivingCoreConstant;
import com.yymobile.core.channel.slipchannel.ISlipChannelCore;
import com.yymobile.core.channel.slipchannel.SlipChannelInfo;
import com.yymobile.core.channel.slipchannel.SlipParam;
import com.yymobile.core.live.livecore.ILiveCore;
import com.yymobile.core.live.livecore.JoinChannelIntent;
import com.yymobile.core.live.livedata.DoubleItemInfo;
import com.yymobile.core.live.livedata.HomeItemInfo;
import com.yymobile.core.live.livedata.LineData;
import com.yymobile.core.live.livedata.TopicDetailInfo;
import com.yymobile.core.mobilelive.MobileLiveConstant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TopicDetailFragment
extends PagerFragment
implements ScrollableListener<AbsListView> {
    public static final String KEY_IS_LAST_PAGE = "KEY_IS_LAST_PAGE";
    public static final String KEY_BANNER_URL = "KEY_BANNER_URL";
    public static final String KEY_TOPIC_NAME = "KEY_TOPIC_NAME";
    public static final String KEY_TOPIC_DESC = "KEY_TOPIC_DESC";
    public static final String KEY_PAGE_NO = "KEY_PAGE_NO";
    private static final String DATA_LIST = "DATA_LIST";
    private static final String KEY_FEATURE_ID = "KEY_FEATURE_ID";
    private static final String MOBILE_LIVE_FEATURE_INFO = "mobile_live_feature_info";
    private static final int LIVE_MODULE_TOPICS_HEADER = 1003;
    private PullToRefreshListView mListView;
    private AbsListViewDelegate mViewDelegate = new AbsListViewDelegate();
    private EndlessListScrollListener mEndlessListScrollListener;
    private TopicDetailAdapter mAdapter;
    private int mPageNo = 1;
    private boolean isLastPage = false;
    private boolean isFirstLoadData = true;
    private boolean isFirstLoadBanner = true;
    private IRefreshTitle iRefreshTitle;
    private FeatureBannerHolder fbHolder = new FeatureBannerHolder();
    private int featureId;
    private List<LineData> recommendInfos = new ArrayList<LineData>();
    private TopicDetailInfo mFeatureInfo = new TopicDetailInfo();
    private Runnable checkRequestTimeoutTask = new Runnable(){

        @Override
        public void run() {
            TopicDetailFragment.this.mEndlessListScrollListener.onLoadComplete();
            TopicDetailFragment.this.mListView.onRefreshComplete();
            if (TopicDetailFragment.this.mAdapter == null || TopicDetailFragment.this.mAdapter.getCount() == 0) {
                TopicDetailFragment.this.showNoMobileLiveData();
            }
        }
    };
    View.OnClickListener mOnclick = new View.OnClickListener(){

        public void onClick(View v) {
            TopicDetailFragment.this.loadFirstPage(true, TopicDetailFragment.this.getView());
        }
    };
    private EventBinder mEventBinder;

    public static TopicDetailFragment newInstance(int id2) {
        TopicDetailFragment fragment = new TopicDetailFragment();
        Bundle bundle = new Bundle();
        bundle.putInt(KEY_FEATURE_ID, id2);
        fragment.setArguments(bundle);
        return fragment;
    }

    public void setIRefreshTitle(IRefreshTitle iRefreshTitle) {
        this.iRefreshTitle = iRefreshTitle;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        Bundle arguMent = this.getArguments();
        if (arguMent != null) {
            this.featureId = arguMent.getInt(KEY_FEATURE_ID);
        }
        View view = inflater.inflate(R.layout.fragment_lvbc_hot, container, false);
        this.mListView = (PullToRefreshListView)view.findViewById(R.id.lvbc_listview_h);
        this.mListView.setOnRefreshListener((PullToRefreshBase.OnRefreshListener)new PullToRefreshBase.OnRefreshListener<ListView>(){

            public void onRefresh(PullToRefreshBase<ListView> refreshView) {
                TopicDetailFragment.this.loadFirstPage(false, TopicDetailFragment.this.getView());
            }
        });
        this.mAdapter = new TopicDetailAdapter((Context)this.getActivity());
        this.mAdapter.setFeatureID(this.featureId);
        this.mListView.setAdapter((ListAdapter)this.mAdapter);
        ((ListView)this.mListView.getRefreshableView()).setSelector(R.drawable.transparent);
        this.mEndlessListScrollListener = new EndlessListScrollListener((StatusLayout)view.findViewById(R.id.lvbc_container_h));
        this.mEndlessListScrollListener.setVisibleThreshold(3);
        this.mEndlessListScrollListener.setListener(new EndlessListScrollListener.EndlessListener(){

            public void onLoadData() {
                if (TopicDetailFragment.this.checkNetToast()) {
                    TopicDetailFragment.this.mPageNo++;
                    TopicDetailFragment.this.getHandler().postDelayed(TopicDetailFragment.this.checkRequestTimeoutTask, 10000L);
                    ((ILiveCore)CoreFactory.getCore(ILiveCore.class)).requestTopicDetailPage(TopicDetailFragment.this.mPageNo, TopicDetailFragment.this.featureId);
                } else {
                    TopicDetailFragment.this.mEndlessListScrollListener.onLoadComplete();
                    TopicDetailFragment.this.mListView.onRefreshComplete();
                }
            }

            public boolean shouldLoadData() {
                return TopicDetailFragment.this.checkNetToast() && !TopicDetailFragment.this.isLastPage;
            }
        });
        this.mEndlessListScrollListener.setParentOnScrollListener(new AbsListView.OnScrollListener(){

            public void onScrollStateChanged(AbsListView view, int scrollState) {
            }

            public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
            }
        });
        this.mListView.setOnScrollListener((AbsListView.OnScrollListener)new PauseOnScrollListener(false, true, (AbsListView.OnScrollListener)this.mEndlessListScrollListener));
        if (savedInstanceState != null) {
            this.isFirstLoadData = false;
            this.mPageNo = savedInstanceState.getInt(KEY_PAGE_NO, 1);
            this.isLastPage = savedInstanceState.getBoolean(KEY_IS_LAST_PAGE, false);
            this.fbHolder.bannerUrl = savedInstanceState.getString(KEY_BANNER_URL);
            this.fbHolder.topicName = savedInstanceState.getString(KEY_TOPIC_NAME);
            this.fbHolder.topicDesc = savedInstanceState.getString(KEY_TOPIC_DESC);
            this.mFeatureInfo = (TopicDetailInfo)savedInstanceState.getParcelable(MOBILE_LIVE_FEATURE_INFO);
            TopicDetailInfo featureInfo = new TopicDetailInfo();
            if (this.mFeatureInfo != null && !FP.empty((Collection)this.mFeatureInfo.dataList)) {
                featureInfo.dataList.addAll(this.mFeatureInfo.dataList);
            }
            if (this.mFeatureInfo != null) {
                featureInfo.isLastPage = this.mFeatureInfo.isLastPage;
                featureInfo.bannerUrl = this.mFeatureInfo.bannerUrl;
                featureInfo.topicName = this.mFeatureInfo.topicName;
                featureInfo.topicDesc = this.mFeatureInfo.topicDesc;
            }
            ((ILiveCore)CoreFactory.getCore(ILiveCore.class)).handleAttentionLivelist(featureInfo.dataList, this.recommendInfos);
            this.mAdapter.setData(this.recommendInfos, true, this.isLastPage);
        } else if (this.isFirstLoadData) {
            this.isFirstLoadData = false;
            this.loadFirstPage(true, view);
        }
        return view;
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putBoolean(KEY_IS_LAST_PAGE, this.isLastPage);
        outState.putString(KEY_TOPIC_NAME, this.fbHolder.topicName);
        outState.putString(KEY_TOPIC_DESC, this.fbHolder.topicDesc);
        outState.putString(KEY_BANNER_URL, this.fbHolder.bannerUrl);
        outState.putInt(KEY_PAGE_NO, this.mPageNo);
        outState.putParcelable(MOBILE_LIVE_FEATURE_INFO, (Parcelable)this.mFeatureInfo);
    }

    public void onDestroyView() {
        super.onDestroyView();
        if (this.getHandler() != null) {
            this.getHandler().removeCallbacks(this.checkRequestTimeoutTask);
        }
    }

    public void onPause() {
        super.onPause();
        if (this.mListView.isRefreshing()) {
            this.mListView.onRefreshComplete();
        }
    }

    public void onPageScrollComplete(int position) {
        super.onPageScrollComplete(position);
        if ((this.isFirstLoadData || this.mAdapter != null && this.mAdapter.getCount() == 0) && this.isNetworkAvailable()) {
            this.loadFirstPage(true, this.getView());
        }
        this.isFirstLoadData = false;
    }

    private void loadFirstPage(boolean isShow, View view) {
        this.mPageNo = 1;
        if (isShow) {
            this.showLoading(view, 0, 0);
        }
        this.getHandler().postDelayed(this.checkRequestTimeoutTask, 10000L);
        ((ILiveCore)CoreFactory.getCore(ILiveCore.class)).requestTopicDetailPage(this.mPageNo, this.featureId);
    }

    @BusEvent(busType=1, busName="plugin_main")
    public void onTopicDetailInfo(ILiveCoreClient_onTopicDetailInfo_EventArgs busEventArgs) {
        int code = busEventArgs.getCode();
        TopicDetailInfo data = busEventArgs.getData();
        this.getHandler().removeCallbacks(this.checkRequestTimeoutTask);
        this.mEndlessListScrollListener.onLoadComplete();
        this.mListView.onRefreshComplete();
        this.hideStatus();
        if (code == 0 && data != null) {
            if (this.mPageNo == 1) {
                this.getHandler().removeCallbacks(this.checkRequestTimeoutTask);
                if (FP.empty((Collection)data.dataList)) {
                    this.mAdapter.clearData();
                    this.showNoMobileLiveData();
                } else {
                    this.recommendInfos.clear();
                    this.addData(data, true);
                    ((ILiveCore)CoreFactory.getCore(ILiveCore.class)).handleAttentionLivelist(data.dataList, this.recommendInfos);
                    this.mAdapter.setData(this.recommendInfos, true, data.isLastPage());
                }
            } else {
                this.addData(data, false);
                ((ILiveCore)CoreFactory.getCore(ILiveCore.class)).handleAttentionLivelist(data.dataList, this.recommendInfos);
                this.mAdapter.setData(this.recommendInfos, false, data.isLastPage());
            }
            this.isLastPage = data.isLastPage();
            if (this.isFirstLoadBanner) {
                if (this.iRefreshTitle != null) {
                    this.fbHolder.topicName = data.topicName;
                    this.fbHolder.topicDesc = data.topicDesc;
                    this.fbHolder.numCare = "0";
                    this.fbHolder.bannerUrl = data.bannerUrl;
                    this.iRefreshTitle.refreshTitle(this.fbHolder);
                }
                this.isFirstLoadBanner = false;
            }
        } else if (this.mPageNo == 1) {
            this.getHandler().removeCallbacks(this.checkRequestTimeoutTask);
            if (this.mAdapter != null && this.mAdapter.getCount() > 0) {
                this.checkNetToast();
            } else if (this.isNetworkAvailable()) {
                this.showNoMobileLiveData();
            } else {
                this.showNetworkErr();
            }
        } else {
            --this.mPageNo;
            this.checkNetToast();
        }
    }

    private void addData(TopicDetailInfo data, boolean isClear) {
        if (FP.empty((Collection)data.dataList)) {
            return;
        }
        if (isClear) {
            this.mFeatureInfo.dataList.clear();
        }
        this.mFeatureInfo.isLastPage = data.isLastPage;
        this.mFeatureInfo.bannerUrl = data.bannerUrl;
        this.mFeatureInfo.topicName = data.topicName;
        this.mFeatureInfo.topicDesc = data.topicDesc;
        this.mFeatureInfo.dataList.addAll(data.dataList);
    }

    public View.OnClickListener getLoadListener() {
        return this.mOnclick;
    }

    public View.OnClickListener getNoMobileLiveDataListener() {
        return this.mOnclick;
    }

    public ViewDelegate<AbsListView> getViewDelegate() {
        return this.mViewDelegate;
    }

    public AbsListView getDelegateView() {
        return (AbsListView)this.mListView.getRefreshableView();
    }

    public void onEventBind() {
        super.onEventBind();
        if (this.mEventBinder == null) {
            this.mEventBinder = new TopicDetailFragment$$EventBinder();
        }
        this.mEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mEventBinder != null) {
            this.mEventBinder.unBindEvent();
        }
    }

    private class TopicDetailAdapter
    extends BaseAdapter {
        private Context mContext;
        private static final int TYPE_COUNT = 30;
        private List<LineData> mData = new ArrayList<LineData>();
        private List<SlipChannelInfo> slipChannelInfos = new ArrayList<SlipChannelInfo>();
        private DoubleLiveViewHolder doubleHolder;

        TopicDetailAdapter(Context context) {
            this.mContext = context;
        }

        public int getCount() {
            return this.mData.size();
        }

        public LineData getItem(int position) {
            return this.mData.get(position);
        }

        public long getItemId(int position) {
            return 0L;
        }

        public int getItemViewType(int position) {
            return this.getItem((int)position).moduleType;
        }

        public int getViewTypeCount() {
            return 30;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            switch (this.getItem((int)position).moduleType) {
                case 1005: {
                    LineData lineInfo = this.getItem(position);
                    DoubleItemInfo doubleData = (DoubleItemInfo)lineInfo.data;
                    if (convertView == null) {
                        convertView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.item_living_topic_detail_style, parent, false);
                        this.doubleHolder = new DoubleLiveViewHolder();
                        this.doubleHolder = this.getItemHolderS(convertView);
                        convertView.setTag((Object)this.doubleHolder);
                    } else {
                        this.doubleHolder = (DoubleLiveViewHolder)convertView.getTag();
                    }
                    this.setDoubleLiveS(this.doubleHolder, doubleData);
                    break;
                }
                case 109: {
                    convertView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.item_mobile_broadcast_footer, parent, false);
                    break;
                }
                case 1003: {
                    convertView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.item_living_topic_detail_header, parent, false);
                    TopicTitleHeader topicTitleHeader = new TopicTitleHeader();
                    topicTitleHeader.title = (TextView)convertView.findViewById(R.id.mobile_feature_title);
                    topicTitleHeader.bannerImg = (RecycleImageView)convertView.findViewById(R.id.mobile_live_feature_banner);
                    topicTitleHeader.description = (TextView)convertView.findViewById(R.id.mobile_feature_description);
                    if (TopicDetailFragment.this.mFeatureInfo == null) break;
                    if (!StringUtils.isEmptyString((String)((TopicDetailFragment)TopicDetailFragment.this).mFeatureInfo.topicName)) {
                        topicTitleHeader.title.setText((CharSequence)((TopicDetailFragment)TopicDetailFragment.this).mFeatureInfo.topicName);
                    }
                    if (!StringUtils.isEmptyString((String)((TopicDetailFragment)TopicDetailFragment.this).mFeatureInfo.topicDesc)) {
                        topicTitleHeader.description.setText((CharSequence)((TopicDetailFragment)TopicDetailFragment.this).mFeatureInfo.topicDesc);
                    }
                    RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)topicTitleHeader.bannerImg.getLayoutParams();
                    DisplayMetrics dm = TopicDetailFragment.this.getResources().getDisplayMetrics();
                    params.width = dm.widthPixels;
                    params.height = dm.widthPixels * 9 / 16;
                    topicTitleHeader.bannerImg.setLayoutParams((ViewGroup.LayoutParams)params);
                    ImageLoader.loadImage((String)((TopicDetailFragment)TopicDetailFragment.this).fbHolder.bannerUrl, (RecycleImageView)topicTitleHeader.bannerImg, (ImageConfig)ImageConfig.defaultImageConfig(), (int)R.drawable.mbl_feature_default);
                    break;
                }
            }
            return convertView;
        }

        public void setData(List<LineData> liveList, boolean clear, boolean isLastPage) {
            if (liveList == null) {
                return;
            }
            if (clear) {
                this.mData.clear();
                this.slipChannelInfos.clear();
            }
            if (this.mData.size() == 0) {
                LineData header = new LineData();
                header.moduleType = 1003;
                this.mData.add(header);
            }
            this.mData.addAll(liveList);
            this.setSlipChannelInfo(liveList);
            if (isLastPage) {
                LineData info = new LineData();
                info.moduleType = 109;
                this.mData.add(info);
            }
            this.notifyDataSetChanged();
        }

        public void clearData() {
            this.mData.clear();
            this.notifyDataSetChanged();
        }

        public void setFeatureID(int id2) {
            TopicDetailFragment.this.featureId = id2;
        }

        private DoubleLiveViewHolder getItemHolderS(View view) {
            DoubleLiveViewHolder vHolder = new DoubleLiveViewHolder();
            vHolder.left.container = view.findViewById(R.id.topic_detail_container_left);
            vHolder.left.thumb = (PressedRecycleImageView)view.findViewById(R.id.topic_detail_thumb_asl);
            vHolder.left.isReplay = (TextView)view.findViewById(R.id.topic_detail_live_asl);
            vHolder.left.liveTag = (TextView)view.findViewById(R.id.topic_detail_tag_asl);
            vHolder.left.liveDesc = (TextView)view.findViewById(R.id.topic_detail_livedesc_asl);
            vHolder.left.everSeen = (TextView)view.findViewById(R.id.topic_detail_ever_seen_asl);
            vHolder.right.container = view.findViewById(R.id.topic_detail_container_right);
            vHolder.right.thumb = (PressedRecycleImageView)view.findViewById(R.id.topic_detail_thumb_asr);
            vHolder.right.isReplay = (TextView)view.findViewById(R.id.topic_detail_live_asr);
            vHolder.right.liveTag = (TextView)view.findViewById(R.id.topic_detail_tag_asr);
            vHolder.right.liveDesc = (TextView)view.findViewById(R.id.topic_detail_livedesc_asr);
            vHolder.right.everSeen = (TextView)view.findViewById(R.id.topic_detail_ever_seen_asr);
            return vHolder;
        }

        private void setDoubleLiveS(DoubleLiveViewHolder holder, DoubleItemInfo data) {
            if (holder == null || data == null) {
                return;
            }
            this.setSingleLiveS(holder.left, data.first);
            if (data.second == null) {
                holder.right.container.setVisibility(4);
            } else {
                holder.right.container.setVisibility(0);
                this.setSingleLiveS(holder.right, data.second);
            }
        }

        private void setSingleLiveS(SingleLiveViewHolder holder, HomeItemInfo data) {
            if (holder == null || data == null) {
                return;
            }
            switch (data.type) {
                case 1: {
                    this.setCommonItemS(holder, data);
                    holder.isReplay.setVisibility(8);
                    break;
                }
                case 2: {
                    this.setCommonItemS(holder, data);
                    holder.isReplay.setVisibility(0);
                    holder.isReplay.setText((CharSequence)TopicDetailFragment.this.getResources().getString(R.string.living_replay));
                    holder.isReplay.setBackgroundResource(R.drawable.living_tag_replay_bg);
                    holder.isReplay.setPadding(DimenConverter.dip2px((Context)this.mContext, (float)8.0f), 4, DimenConverter.dip2px((Context)this.mContext, (float)8.0f), 5);
                    break;
                }
                case 4: 
                case 8: {
                    this.setCommonItemS(holder, data);
                    holder.isReplay.setVisibility(8);
                    break;
                }
            }
        }

        private void setCommonItemS(SingleLiveViewHolder holder, final HomeItemInfo item) {
            holder.liveDesc.setText((CharSequence)item.desc);
            if (item.tagStyle == 0) {
                holder.liveTag.setVisibility(8);
            } else {
                holder.liveTag.setVisibility(0);
                holder.liveTag.setBackgroundResource(R.drawable.live_tag_bg_gray);
                holder.liveTag.setText((CharSequence)item.tag);
                holder.liveTag.setPadding(DimenConverter.dip2px((Context)this.mContext, (float)5.0f), 0, DimenConverter.dip2px((Context)this.mContext, (float)7.0f), 0);
            }
            ImageLoader.loadImage((String)item.thumb2, (RecycleImageView)holder.thumb, (ImageConfig)ImageConfig.defaultImageConfig(), (int)R.drawable.hp_living_default_bg);
            holder.everSeen.setText((CharSequence)LivingClientConstant.formatCount((long)item.users));
            holder.container.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    TopicDetailAdapter.this.doOnClick(item);
                }
            });
        }

        private void doOnClick(HomeItemInfo item) {
            switch (item.type) {
                case 1: {
                    SlipParam param = ((IHomepageLiveCore)CoreFactory.getCore(IHomepageLiveCore.class)).getTopicSlipParam();
                    if (param == null) {
                        param = new SlipParam();
                    }
                    param.setSlipChannelInfos(this.slipChannelInfos);
                    ((ISlipChannelCore)ICoreManagerBase.getCore(ISlipChannelCore.class)).setSlipParam(15, param);
                    JoinChannelIntent.instance((long)item.sid, (long)item.ssid).anchorUid(item.uid).src(1).templateId(item.tpl).thumb(item.thumb2).token(item.token).build().joinChannel(this.mContext);
                    break;
                }
                case 2: {
                    NavigationUtils.toMobileLiveReplayWithTitle(this.mContext, item.pid, item.uid, item.url, item.thumb2, item.desc, MobileLiveConstant.TO_MOBILE_LIVE_REPLAY_PATH_BY_TAB);
                    break;
                }
                case 4: 
                case 8: {
                    SlipParam param = ((IHomepageLiveCore)CoreFactory.getCore(IHomepageLiveCore.class)).getTopicSlipParam();
                    if (param == null) {
                        param = new SlipParam();
                    }
                    param.setSlipChannelInfos(this.slipChannelInfos);
                    ((ISlipChannelCore)ICoreManagerBase.getCore(ISlipChannelCore.class)).setSlipParam(15, param);
                    JoinChannelIntent.instance((long)item.sid, (long)item.ssid).src(1).templateId(item.tpl).token(item.token).build().joinChannel(this.mContext);
                    break;
                }
            }
        }

        private void setSlipChannelInfo(List<LineData> liveList) {
            for (int i = 0; i < liveList.size(); ++i) {
                LineData item = liveList.get(i);
                if (item == null || !(item.data instanceof DoubleItemInfo)) continue;
                HomeItemInfo info = ((DoubleItemInfo)item.data).first;
                if (info != null && LivingCoreConstant.isLiveType((int)info.type)) {
                    this.slipChannelInfos.add(new SlipChannelInfo(info));
                }
                if ((info = ((DoubleItemInfo)item.data).second) == null || !LivingCoreConstant.isLiveType((int)info.type)) continue;
                this.slipChannelInfos.add(new SlipChannelInfo(info));
            }
        }

        public class SingleLiveViewHolder {
            View container;
            PressedRecycleImageView thumb;
            TextView isReplay;
            TextView everSeen;
            TextView liveTag;
            CircleImageView avatar;
            TextView liveDesc;
            TextView stageName;
            ImageView verify;
        }

        private class DoubleLiveViewHolder {
            SingleLiveViewHolder left;
            SingleLiveViewHolder right;

            DoubleLiveViewHolder() {
                this.left = new SingleLiveViewHolder();
                this.right = new SingleLiveViewHolder();
            }
        }

        private class TopicTitleHeader {
            TextView title;
            TextView description;
            RecycleImageView bannerImg;

            private TopicTitleHeader() {
            }
        }
    }

    public static class FeatureBannerHolder {
        String bannerUrl;
        String topicName;
        String topicDesc;
        String numCare;
    }
}

