/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.home.navto;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.BitmapFactory;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.BaseAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.handmark.pulltorefresh.library.PullToRefreshBase;
import com.handmark.pulltorefresh.library.PullToRefreshListView;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.calender.CalenderUtils;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.plugin.homeapi.ui.home.LivingClientConstant;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.plugin.main.events.IAuthClient_onKickOff_EventArgs;
import com.yy.mobile.plugin.main.events.IAuthClient_onLoginSucceed_EventArgs;
import com.yy.mobile.plugin.main.events.IAuthClient_onLogout_EventArgs;
import com.yy.mobile.plugin.main.events.ILiveCoreClient_onPreviewInfo_EventArgs;
import com.yy.mobile.plugin.main.events.ILiveCoreClient_onReservationProgramReq_EventArgs;
import com.yy.mobile.plugin.main.events.ILiveCoreClient_onReservationProgramResult_EventArgs;
import com.yy.mobile.share.BaseCopyClickListener;
import com.yy.mobile.share.BasePlatform;
import com.yy.mobile.share.BasePlatformActionListener;
import com.yy.mobile.share.BaseShareContentCustomizeCallback;
import com.yy.mobile.share.ShareApi;
import com.yy.mobile.share.ShareRequest;
import com.yy.mobile.ui.home.navto.PreviewFragment$$EventBinder;
import com.yy.mobile.ui.mobilelive.ShareComponentConfig;
import com.yy.mobile.ui.refreshutil.IRefreshToHead;
import com.yy.mobile.ui.subscribeNotify.SubscribedNotify;
import com.yy.mobile.ui.utils.NavigationUtils;
import com.yy.mobile.ui.widget.EndlessListScrollListener;
import com.yy.mobile.ui.widget.StatusLayout;
import com.yy.mobile.ui.widget.extend.RxViewExt;
import com.yy.mobile.ui.widget.pager.PagerFragment;
import com.yy.mobile.ui.widget.toast.Toast;
import com.yy.mobile.util.CommonUtils;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.ObjectTimeslotTool;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.ylink.bridge.CoreApiManager;
import com.yy.mobile.yyprotocol.core.Uint32;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.CoreManager;
import com.yymobile.core.UriProvider;
import com.yymobile.core.live.livecore.ILiveCore;
import com.yymobile.core.live.livecore.ILiveCoreProtocol;
import com.yymobile.core.live.livecore.SpeItemInfo;
import com.yymobile.core.share.IShareInfoCore;
import com.yymobile.core.statistic.IHiidoStatisticCore;
import io.reactivex.functions.Consumer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PreviewFragment
extends PagerFragment
implements IRefreshToHead {
    private static final String TAG = "PreviewFragment";
    public static final String KEY_EXPAND_ID = "key_expand_id";
    private PullToRefreshListView mListView;
    private EndlessListScrollListener mEndlessListScrollListener;
    private PreviewAdapter mAdapter;
    private int mPageNo = 1;
    private static final int START_PAGE_NO = 1;
    private List<Integer> mEventIds = new ArrayList<Integer>();
    private boolean isLastPage = false;
    private int expdId = -1;
    private int thumbHeight = 405;
    private boolean firstLoadData;
    public static String DEFAULT_PREVIEW_CONTENT_DESC = "\u8fd9\u4e2aYY\u76f4\u64ad\u6709\u70b9\u610f\u601d\uff01\u5343\u4e07\u522b\u70b9\u9519\uff01";
    private static String DEFAULT_PREVIEW_CONTENT_FORMAT = "\u300a${objectTitle}\u300b\u5c06\u5728${startTime}\u51c6\u65f6\u5f00\u64ad\uff01${shareWord}";
    private SimpleDateFormat mSimpleDateFormat = CommonUtils.getSimpleDateFormat((String)"MM\u6708dd\u65e5 H:mm");
    private boolean isFromChannel = false;
    private boolean isPaused = false;
    String onShareStyle = "00";
    private ObjectTimeslotTool mTimeSlotTool = new ObjectTimeslotTool();
    private Runnable checkRequestTimeoutTask = new Runnable(){

        @Override
        public void run() {
            PreviewFragment.this.finishLoadData();
            if (PreviewFragment.this.mAdapter != null && PreviewFragment.this.mAdapter.getCount() > 0) {
                PreviewFragment.this.checkNetToast();
            } else {
                PreviewFragment.this.showNetworkErr();
            }
        }
    };
    View.OnClickListener mOnclick = new View.OnClickListener(){

        public void onClick(View v) {
            if (PreviewFragment.this.mTimeSlotTool.isProcessing()) {
                return;
            }
            PreviewFragment.this.showLoading();
            PreviewFragment.this.reLoadData();
        }
    };
    private EventBinder mEventBinder;

    public static PreviewFragment newInstance(int expId) {
        PreviewFragment fragment = new PreviewFragment();
        Bundle bundle = new Bundle();
        bundle.putInt(KEY_EXPAND_ID, expId);
        fragment.setArguments(bundle);
        return fragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.firstLoadData = true;
        Bundle arguMent = this.getArguments();
        if (arguMent != null) {
            this.expdId = arguMent.getInt(KEY_EXPAND_ID, -1);
            this.isFromChannel = this.expdId == -100;
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_living_preview, container, false);
        this.mListView = (PullToRefreshListView)view.findViewById(R.id.living_pre_list_view);
        this.mListView.setOnRefreshListener((PullToRefreshBase.OnRefreshListener)new PullToRefreshBase.OnRefreshListener<ListView>(){

            public void onRefresh(PullToRefreshBase<ListView> refreshView) {
                PreviewFragment.this.reLoadData();
            }
        });
        this.initThumbHeight();
        this.mAdapter = new PreviewAdapter((Context)this.getActivity());
        this.mListView.setAdapter((ListAdapter)this.mAdapter);
        ((ListView)this.mListView.getRefreshableView()).setSelector(R.drawable.transparent);
        this.mEndlessListScrollListener = new EndlessListScrollListener((StatusLayout)view.findViewById(R.id.living_pre_container));
        this.mEndlessListScrollListener.setVisibleThreshold(3);
        this.mEndlessListScrollListener.setListener(new EndlessListScrollListener.EndlessListener(){

            public void onLoadData() {
                if (PreviewFragment.this.checkNetToast()) {
                    PreviewFragment.this.loadMoreData();
                } else {
                    PreviewFragment.this.mEndlessListScrollListener.onLoadComplete();
                    PreviewFragment.this.mListView.onRefreshComplete();
                }
            }

            public boolean shouldLoadData() {
                return PreviewFragment.this.checkNetToast() && !PreviewFragment.this.isLastPage;
            }
        });
        this.mListView.setOnScrollListener((AbsListView.OnScrollListener)this.mEndlessListScrollListener);
        this.showLoading(view);
        this.reLoadData();
        return view;
    }

    public void onPause() {
        super.onPause();
        this.isPaused = true;
    }

    public void onResume() {
        super.onResume();
        this.isPaused = false;
    }

    public void onPageScrollComplete(int position) {
        super.onPageScrollComplete(position);
        if (this.mAdapter != null && this.mAdapter.getCount() == 0 && this.isNetworkAvailable()) {
            this.reLoadData();
        }
    }

    private void reLoadData() {
        this.mPageNo = 1;
        this.loadData();
    }

    private void loadMoreData() {
        ++this.mPageNo;
        this.loadData();
    }

    private void loadData() {
        this.getHandler().postDelayed(this.checkRequestTimeoutTask, 10000L);
        if (this.isFromChannel) {
            ((ILiveCore)CoreFactory.getCore(ILiveCore.class)).requestChannelPreview();
        } else {
            ((ILiveCore)CoreFactory.getCore(ILiveCore.class)).requestPreviewPage(this.mPageNo);
        }
    }

    private void finishLoadData() {
        if (this.mListView != null) {
            this.mListView.onRefreshComplete();
        }
        if (this.mEndlessListScrollListener != null) {
            this.mEndlessListScrollListener.onLoadComplete();
        }
    }

    public void share(SpeItemInfo item) {
        String shareText;
        final ShareApi shareApi = (ShareApi)CoreApiManager.getInstance().getApi(ShareApi.class);
        if (shareApi == null) {
            MLog.error((String)"share", (String)"shareapi is null");
            return;
        }
        final String url = UriProvider.MOBILE_LIVE_PREVIEW_SHARE + item.id + ".html?u=" + item.uid;
        ShareRequest request2 = new ShareRequest();
        String title = item.title;
        String titleFormat = ((IShareInfoCore)CoreFactory.getCore(IShareInfoCore.class)).getShareInfo(3, 1, 2);
        if (FP.empty((CharSequence)titleFormat)) {
            titleFormat = "${objectTitle}";
        }
        request2.title = FP.empty((CharSequence)title) ? "YY\u76f4\u64ad" : titleFormat.replace("${objectTitle}", title);
        String contentFormat = ((IShareInfoCore)CoreFactory.getCore(IShareInfoCore.class)).getShareInfo(3, 1, 4);
        if (FP.empty((CharSequence)contentFormat)) {
            contentFormat = DEFAULT_PREVIEW_CONTENT_FORMAT;
        }
        if (FP.empty((CharSequence)title)) {
            shareText = DEFAULT_PREVIEW_CONTENT_DESC;
        } else {
            String shareWords = ((IShareInfoCore)CoreFactory.getCore(IShareInfoCore.class)).getShareInfo(3, 1, 0);
            if (FP.empty((CharSequence)shareWords)) {
                shareWords = "\u660e\u660e\u6709\u624d\u534e\uff0c\u504f\u8981\u9760\u989c\u503c\uff01";
            }
            String dateStr = "";
            try {
                dateStr = this.mSimpleDateFormat.format(item.timeStart);
            }
            catch (Throwable t) {
                MLog.error((String)TAG, (String)("convert to date error e=" + t));
            }
            shareText = contentFormat.replace("${objectTitle}", title).replace("${shareWord}", shareWords).replace("${startTime}", dateStr);
        }
        request2.text = shareText;
        request2.context = this.getContext();
        request2.showText = true;
        request2.imageUrl = item.thumb;
        request2.notificationIcon = R.drawable.ic_launcher_yy;
        request2.url = url;
        request2.titleUrl = url;
        if (FP.empty((CharSequence)request2.imageUrl)) {
            MLog.info((String)TAG, (String)"no imageurl, use default.");
            request2.imageData = BitmapFactory.decodeResource((Resources)this.getResources(), (int)R.drawable.mn_yy_bear_logo);
        }
        request2.copyClickListener = new BaseCopyClickListener(){

            public String makeCopyText() {
                return url;
            }

            public void onClick(View view) {
                super.onClick(view);
                PreviewFragment.this.onShareStyle = "06";
                ShareComponentConfig.shareTypeStatic((String)PreviewFragment.this.onShareStyle, (int)11);
            }
        };
        BaseShareContentCustomizeCallback shareContentCustomizeCallback = new BaseShareContentCustomizeCallback(){

            public boolean onShare(BasePlatform platform, BasePlatform.ShareParams paramsToShare) {
                String platformName = platform.getName() == null ? "" : platform.getName();
                MLog.info((String)PreviewFragment.TAG, (String)("platformName=" + platformName));
                if (platformName.equals(shareApi.getSinaWeiboName())) {
                    String webTopic = ((IShareInfoCore)CoreFactory.getCore(IShareInfoCore.class)).getShareInfo(3, 1, 1);
                    if (FP.empty((CharSequence)webTopic)) {
                        webTopic = "#YY\u76f4\u64ad#";
                    }
                    paramsToShare.setText(webTopic + shareText + " @YY\u76f4\u64ad");
                    PreviewFragment.this.onShareStyle = "00";
                } else if (platformName.equals(shareApi.getWechatMomentsName())) {
                    paramsToShare.setTitle(shareText);
                    PreviewFragment.this.onShareStyle = "02";
                } else if ("QZone".equals(platformName)) {
                    PreviewFragment.this.onShareStyle = "05";
                } else if ("QQ".equals(platformName)) {
                    PreviewFragment.this.onShareStyle = "04";
                } else if (platformName.equals(shareApi.getWechatName())) {
                    PreviewFragment.this.onShareStyle = "01";
                }
                ShareComponentConfig.shareTypeStatic((String)PreviewFragment.this.onShareStyle, (int)11);
                return false;
            }
        };
        shareApi.showShare(this.getContext(), request2, shareContentCustomizeCallback, new BasePlatformActionListener(){

            public void onComplete(BasePlatform platform, int i, HashMap<String, Object> hashMap) {
                ShareComponentConfig.shareSuccessStatic((String)PreviewFragment.this.onShareStyle, (int)11);
            }

            public void onError(BasePlatform platform, int i, Throwable throwable) {
            }

            public void onCancel(BasePlatform platform, int i) {
            }
        });
    }

    public View.OnClickListener getLoadListener() {
        return this.mOnclick;
    }

    public View.OnClickListener getNoMobileLiveDataListener() {
        return this.mOnclick;
    }

    @BusEvent
    public void onPreviewInfo(ILiveCoreClient_onPreviewInfo_EventArgs busEventArgs) {
        int code = busEventArgs.getCode();
        ArrayList data = busEventArgs.getData();
        int page = busEventArgs.getPage();
        int isLast = busEventArgs.getIsLast();
        this.getHandler().removeCallbacks(this.checkRequestTimeoutTask);
        this.mEndlessListScrollListener.onLoadComplete();
        this.mListView.onRefreshComplete();
        this.hideStatus();
        if (data != null && code != -1) {
            boolean bl = this.isLastPage = isLast == 1;
            if (data.size() != 0) {
                this.mAdapter.setData(data, page == 1, this.isLastPage);
                if (this.firstLoadData) {
                    ((ILiveCore)CoreFactory.getCore(ILiveCore.class)).setPreviewExpandPos(this.expdId, true);
                    this.firstLoadData = false;
                } else {
                    ((ILiveCore)CoreFactory.getCore(ILiveCore.class)).setPreviewExpandPos(0, false);
                }
                if (page == 1) {
                    this.mEventIds.clear();
                }
                for (SpeItemInfo itemInfo : data) {
                    this.mEventIds.add(itemInfo.eventId);
                }
                if (LoginUtil.isLogined() && !FP.empty(this.mEventIds)) {
                    ((ILiveCore)CoreManager.getCore(ILiveCore.class)).requestPredictionState(this.mEventIds);
                    this.mAdapter.notifyDataSetChanged();
                } else {
                    this.mAdapter.notifyDataSetChanged();
                    ((ListView)this.mListView.getRefreshableView()).setSelection(((ILiveCore)CoreFactory.getCore(ILiveCore.class)).getPreviewExpandPos() + 1);
                }
            } else if (page == 1) {
                this.mAdapter.clearData();
                this.showNoData(R.drawable.mobile_live_personal_replay_no_data, "\u6682\u65e0\u9884\u544a\uff0c\u8bf7\u7a0d\u540e\u518d\u6765");
            }
        } else if (this.mAdapter != null && this.mAdapter.getCount() > 0) {
            this.checkNetToast();
        } else {
            this.showNetworkErr();
        }
    }

    @BusEvent
    public void onReservationProgramReq(ILiveCoreClient_onReservationProgramReq_EventArgs busEventArgs) {
        Map statusMap = busEventArgs.getStatusMap();
        this.mAdapter.setItemFollowState(statusMap);
        ((ListView)this.mListView.getRefreshableView()).setSelection(((ILiveCore)CoreFactory.getCore(ILiveCore.class)).getPreviewExpandPos() + 1);
    }

    @BusEvent
    public void onLoginSucceed(IAuthClient_onLoginSucceed_EventArgs busEventArgs) {
        if (!FP.empty(this.mEventIds)) {
            ((ILiveCore)CoreManager.getCore(ILiveCore.class)).requestPredictionState(this.mEventIds);
        }
    }

    @BusEvent
    public void onLogout(IAuthClient_onLogout_EventArgs busEventArgs) {
        this.mAdapter.removeAllFollowStates();
    }

    @BusEvent
    public void onKickOff(IAuthClient_onKickOff_EventArgs busEventArgs) {
        this.mAdapter.removeAllFollowStates();
    }

    @BusEvent
    public void onReservationProgramResult(ILiveCoreClient_onReservationProgramResult_EventArgs busEventArgs) {
        boolean success = busEventArgs.getSuccess();
        int eventId = busEventArgs.getEventId();
        Uint32 act = busEventArgs.getAct();
        if (success && !FP.empty(this.mEventIds) && this.mEventIds.contains(eventId)) {
            boolean isOrder = act.equals((Object)ILiveCoreProtocol.UpdatePredictionStateReq.KEY_ACT_ORDER);
            this.mAdapter.setItemFollowState(eventId, isOrder);
            if (isOrder && !this.isPaused) {
                SubscribedNotify.instance().subcribedSuceefulNotifyMessage(this.getContext(), SubscribedNotify.TYPE.Booking);
            }
        }
    }

    public void refreshData() {
        if (this.mListView != null) {
            this.getHandler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    ((ListView)PreviewFragment.this.mListView.getRefreshableView()).setSelection(0);
                }
            }, 10L);
            this.reLoadData();
        }
    }

    private void initThumbHeight() {
        DisplayMetrics dm = new DisplayMetrics();
        this.getActivity().getWindowManager().getDefaultDisplay().getMetrics(dm);
        this.thumbHeight = dm.widthPixels * 9 / 16;
    }

    private void scrollToSuit(int pos) {
        if (this.mListView != null && this.mListView.getRefreshableView() != null) {
            int last;
            int first = pos - ((ListView)this.mListView.getRefreshableView()).getFirstVisiblePosition();
            if (first < (last = ((ListView)this.mListView.getRefreshableView()).getLastVisiblePosition() - pos)) {
                if (first < 2) {
                    ((ListView)this.mListView.getRefreshableView()).smoothScrollByOffset(-1);
                }
            } else if (first > last && last < 2) {
                ((ListView)this.mListView.getRefreshableView()).smoothScrollByOffset(1);
            }
        }
    }

    public void onEventBind() {
        super.onEventBind();
        if (this.mEventBinder == null) {
            this.mEventBinder = new PreviewFragment$$EventBinder();
        }
        this.mEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mEventBinder != null) {
            this.mEventBinder.unBindEvent();
        }
    }

    private static class ViewHolder {
        View container;
        RelativeLayout rlTop;
        TextView atteBtn;
        TextView preInfor;
        TextView preTitle;
        TextView preTag;
        RelativeLayout rlThumb;
        RecycleImageView thumb;
        RecycleImageView toPlay;
        TextView desc;
        TextView cycleTips;
        RelativeLayout rlShare;
        RecycleImageView share;

        private ViewHolder() {
        }
    }

    private class PreviewAdapter
    extends BaseAdapter {
        private Context mContext;
        private static final int LIVE_TYPE_PERVIEW = 0;
        private static final int LIVE_TYPE_FOOTER = 1;
        private static final int TYPE_COUNT = 3;
        private static final int DEFAULT_IS_THUMB = 0;
        private static final int HAS_VIDEO_URL = 1;
        private List<SpeItemInfo> mData = new ArrayList<SpeItemInfo>();
        private TextView followBtn;

        PreviewAdapter(Context context) {
            this.mContext = context;
        }

        public int getCount() {
            return this.mData.size();
        }

        public SpeItemInfo getItem(int position) {
            return this.mData.get(position);
        }

        public long getItemId(int position) {
            return 0L;
        }

        public int getItemViewType(int position) {
            return this.getItem((int)position).viewType;
        }

        public int getViewTypeCount() {
            return 3;
        }

        void showFollowState(ViewHolder holder, SpeItemInfo item) {
            if (item.isFollow) {
                holder.atteBtn.setText((CharSequence)PreviewFragment.this.getResources().getString(R.string.living_previewed));
                holder.atteBtn.setTextColor(PreviewFragment.this.getResources().getColor(R.color.txt_color_four));
                holder.atteBtn.setBackgroundResource(R.drawable.bg_preview_btn_unsubcribed);
            } else {
                holder.atteBtn.setText((CharSequence)PreviewFragment.this.getResources().getString(R.string.living_preview));
                holder.atteBtn.setTextColor(PreviewFragment.this.getResources().getColor(R.color.txt_color_two));
                holder.atteBtn.setBackgroundResource(R.drawable.bg_preview_btn_selector);
            }
        }

        public View getView(final int position, View convertView, ViewGroup parent) {
            SpeItemInfo preInfo = this.getItem(position);
            final boolean isChoosed = ((ILiveCore)CoreFactory.getCore(ILiveCore.class)).getPreviewExpandPos() == position;
            switch (preInfo.viewType) {
                case 0: {
                    ViewHolder holder;
                    if (convertView == null) {
                        convertView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.item_mobile_live_preview_detail, parent, false);
                        holder = this.initViewHolder(convertView);
                        convertView.setTag((Object)holder);
                    } else {
                        holder = (ViewHolder)convertView.getTag();
                    }
                    this.bindViewHolder(holder, isChoosed, preInfo);
                    holder.container.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View view) {
                            if (!isChoosed) {
                                ((ILiveCore)CoreFactory.getCore(ILiveCore.class)).setPreviewExpandPos(position, false);
                                PreviewAdapter.this.notifyDataSetChanged();
                                ((IHiidoStatisticCore)CoreManager.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "1913", "0003");
                                PreviewFragment.this.scrollToSuit(position + 1);
                            }
                        }
                    });
                    break;
                }
                case 1: {
                    convertView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.item_mobile_broadcast_footer, parent, false);
                    break;
                }
            }
            return convertView;
        }

        public void setData(List<SpeItemInfo> liveList, boolean clear, boolean isLastPage) {
            if (liveList == null) {
                return;
            }
            if (clear) {
                this.clearData();
            }
            this.mData.addAll(liveList);
            if (isLastPage) {
                SpeItemInfo item = new SpeItemInfo();
                item.viewType = 1;
                this.mData.add(item);
            }
        }

        public void removeAllFollowStates() {
            if (!FP.empty(this.mData)) {
                for (SpeItemInfo item : this.mData) {
                    item.isFollow = false;
                }
                this.notifyDataSetChanged();
            }
        }

        public void clearData() {
            this.mData.clear();
            this.notifyDataSetChanged();
        }

        private void setItemFollowState(int eventId, boolean state) {
            if (!FP.empty(this.mData)) {
                for (SpeItemInfo item : this.mData) {
                    if (item.eventId != eventId) continue;
                    item.isFollow = state;
                    if (state) {
                        ++item.fans;
                        break;
                    }
                    if (item.fans <= 0) break;
                    --item.fans;
                    break;
                }
                if (this.followBtn != null) {
                    this.followBtn.setEnabled(true);
                }
                this.notifyDataSetChanged();
            }
        }

        private void setItemFollowState(Map<Integer, Boolean> stateMap) {
            if (!FP.empty(this.mData)) {
                if (!FP.empty(stateMap)) {
                    for (SpeItemInfo item : this.mData) {
                        if (!stateMap.containsKey(item.eventId)) continue;
                        item.isFollow = stateMap.get(item.eventId);
                    }
                }
                this.notifyDataSetChanged();
            }
        }

        ViewHolder initViewHolder(View convertView) {
            ViewHolder holder = new ViewHolder();
            holder.container = convertView.findViewById(R.id.pre_container_d);
            holder.rlTop = (RelativeLayout)convertView.findViewById(R.id.rl_pre_top);
            holder.atteBtn = (TextView)convertView.findViewById(R.id.pre_follow_btn_d);
            holder.preInfor = (TextView)convertView.findViewById(R.id.pre_info_d);
            holder.preTitle = (TextView)convertView.findViewById(R.id.pre_title_d);
            holder.preTag = (TextView)convertView.findViewById(R.id.pre_title_tag_d);
            holder.rlThumb = (RelativeLayout)convertView.findViewById(R.id.rl_pre_thumnb_d);
            holder.thumb = (RecycleImageView)convertView.findViewById(R.id.pre_thumb_d);
            holder.thumb.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, PreviewFragment.this.thumbHeight));
            holder.toPlay = (RecycleImageView)convertView.findViewById(R.id.pre_play_d);
            holder.desc = (TextView)convertView.findViewById(R.id.pre_desc_d);
            holder.cycleTips = (TextView)convertView.findViewById(R.id.pre_cycle_tips_d);
            holder.rlShare = (RelativeLayout)convertView.findViewById(R.id.rl_pre_share_d);
            holder.share = (RecycleImageView)convertView.findViewById(R.id.pre_share_d);
            return holder;
        }

        void bindViewHolder(final ViewHolder holder, boolean isChoosed, final SpeItemInfo preInfo) {
            holder.preInfor.setText((CharSequence)(LivingClientConstant.convertTime((long)preInfo.timeStart) + "      " + String.valueOf(preInfo.fans) + "\u4eba\u9884\u8ba2"));
            holder.preTitle.setText((CharSequence)preInfo.title);
            String name = LivingClientConstant.getNavBizName((String)preInfo.biz);
            holder.preTag.setText((CharSequence)name);
            holder.atteBtn.setOnClickListener(new View.OnClickListener(){
                SpeItemInfo mItem;
                {
                    this.mItem = preInfo;
                }

                public void onClick(View view) {
                    if (PreviewFragment.this.mTimeSlotTool.isProcessing()) {
                        return;
                    }
                    this.onFollowBtnClick();
                }

                private void onFollowBtnClick() {
                    if (!LoginUtil.isLogined()) {
                        NavigationUtils.toLogin((Context)PreviewFragment.this.getActivity(), true, false);
                    } else if (LoginUtil.getUid() == this.mItem.uid) {
                        Toast.makeText((Context)PreviewFragment.this.getContext(), (CharSequence)PreviewAdapter.this.mContext.getResources().getString(R.string.xianchang_follow_tips), (int)0).show();
                    } else if (this.mItem.isFollow) {
                        if (this.mItem.calendarStatus == 1) {
                            this.onDeleteCalenndar();
                        } else {
                            this.onCancelSubcribedNotifyMessage();
                        }
                    } else if (this.mItem.calendarStatus == 1) {
                        this.onAddCalendar();
                    } else {
                        holder.atteBtn.setEnabled(false);
                        PreviewAdapter.this.followBtn = holder.atteBtn;
                        ((ILiveCore)CoreFactory.getCore(ILiveCore.class)).updatePredictionState(this.mItem.eventId, ILiveCoreProtocol.UpdatePredictionStateReq.KEY_ACT_ORDER);
                    }
                }

                private void onAddCalendar() {
                    CalenderUtils.addCalendarEvent((Context)PreviewFragment.this.getContext(), (String)this.mItem.calendarTitle, (String)this.mItem.calendarUrl, (long)this.mItem.timeStart, (CalenderUtils.CalenderPermissionCallBack)new CalenderUtils.CalenderPermissionCallBack(){

                        public void allowCalenderPermission(boolean isAllow) {
                            if (isAllow) {
                                holder.atteBtn.setEnabled(false);
                                PreviewAdapter.this.followBtn = holder.atteBtn;
                                ((ILiveCore)CoreFactory.getCore(ILiveCore.class)).updatePredictionState(mItem.eventId, ILiveCoreProtocol.UpdatePredictionStateReq.KEY_ACT_ORDER);
                            }
                        }
                    });
                }

                private void onDeleteCalenndar() {
                    CalenderUtils.deleteCalendarEvent((Context)PreviewFragment.this.getContext(), (String)this.mItem.calendarTitle, (CalenderUtils.CalenderPermissionCallBack)new CalenderUtils.CalenderPermissionCallBack(){

                        public void allowCalenderPermission(boolean isAllow) {
                            if (isAllow) {
                                this.onCancelSubcribedNotifyMessage();
                            }
                        }
                    });
                }

                private void onCancelSubcribedNotifyMessage() {
                    SubscribedNotify.instance().cancelSubcribedNotifyMessage(PreviewAdapter.this.mContext, SubscribedNotify.TYPE.Booking, new SubscribedNotify.CancelSubcribedCallback(){

                        public void callBack(boolean isOk) {
                            if (isOk) {
                                holder.atteBtn.setEnabled(false);
                                PreviewAdapter.this.followBtn = holder.atteBtn;
                                ((ILiveCore)CoreFactory.getCore(ILiveCore.class)).updatePredictionState(mItem.eventId, ILiveCoreProtocol.UpdatePredictionStateReq.KEY_ACT_DISORDER);
                            }
                        }
                    });
                }
            });
            this.showFollowState(holder, preInfo);
            if (isChoosed) {
                holder.rlTop.setBackgroundColor(PreviewFragment.this.getResources().getColor(R.color.bg_preview_expand));
                holder.rlThumb.setVisibility(0);
                holder.desc.setVisibility(0);
                holder.rlShare.setVisibility(0);
                if (FP.empty((CharSequence)preInfo.cycleTips)) {
                    holder.cycleTips.setVisibility(8);
                } else {
                    holder.cycleTips.setVisibility(0);
                    holder.cycleTips.setText((CharSequence)preInfo.cycleTips);
                }
                if (FP.empty((CharSequence)preInfo.desc)) {
                    holder.desc.setVisibility(8);
                } else {
                    holder.desc.setVisibility(0);
                    holder.desc.setText((CharSequence)preInfo.desc);
                }
                holder.share.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        PreviewFragment.this.share(preInfo);
                        ((IHiidoStatisticCore)CoreManager.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "1906", "0013");
                    }
                });
                ImageLoader.loadImage((String)preInfo.thumb, (RecycleImageView)holder.thumb, (ImageConfig)ImageConfig.defaultImageConfig(), (int)R.drawable.mobile_live_default_background);
                if (preInfo.previewType == 1) {
                    holder.toPlay.setVisibility(0);
                    RxViewExt.safelyClicks((View)holder.toPlay, (Consumer)new Consumer<Object>(){

                        public void accept(Object o) throws Exception {
                            NavigationUtils.toPlayPreviewVideo((Activity)PreviewAdapter.this.mContext, preInfo.video);
                        }
                    });
                } else {
                    holder.toPlay.setVisibility(8);
                }
            } else {
                holder.rlTop.setBackgroundColor(PreviewFragment.this.getResources().getColor(R.color.bg_preview_shrink));
                holder.rlThumb.setVisibility(8);
                holder.desc.setVisibility(8);
                holder.cycleTips.setVisibility(8);
                holder.rlShare.setVisibility(8);
            }
        }
    }
}

