/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.home.navto;

import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.fragment.app.Fragment;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.plugin.homeapi.ui.home.LivingClientConstant;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.ui.BaseActivity;
import com.yy.mobile.ui.home.navto.PreviewFragment;
import com.yy.mobile.ui.refreshutil.IRefreshToHead;
import com.yy.mobile.ui.widget.SimpleTitleBar;
import com.yy.mobile.util.FP;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.live.livecore.ILiveCore;
import com.yymobile.core.statistic.IHiidoStatisticCore;
import java.util.ArrayList;
import java.util.Collection;

public class PreviewActivity
extends BaseActivity {
    public static final String EXPAND_ID = "expand_id";
    private IRefreshToHead iRefreshToHead;
    private View container;
    private LinearLayout navContent;
    private View shadow;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.layout_living_other_page);
        this.container = this.findViewById(R.id.living_other_page_nav_content);
        this.navContent = (LinearLayout)this.findViewById(R.id.ll_nav_container);
        this.shadow = this.findViewById(R.id.living_other_page_shadow);
        int expid = this.getIntent().getExtras().getInt(EXPAND_ID, -1);
        SimpleTitleBar bar = (SimpleTitleBar)this.findViewById(R.id.living_other_page_bar);
        bar.setLeftBtn(R.drawable.icon_nav_back, new View.OnClickListener(){

            public void onClick(View v) {
                PreviewActivity.this.finish();
            }
        });
        if (expid != -100) {
            bar.setRightBtn(R.drawable.preview_nav_selector, new View.OnClickListener(){

                public void onClick(View v) {
                    if (PreviewActivity.this.container != null) {
                        if (PreviewActivity.this.container.getVisibility() != 0) {
                            PreviewActivity.this.setPopupNavData();
                        } else {
                            PreviewActivity.this.container.setVisibility(8);
                            PreviewActivity.this.shadow.setVisibility(8);
                        }
                    }
                }
            });
        }
        bar.setCenterOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (PreviewActivity.this.iRefreshToHead != null) {
                    PreviewActivity.this.iRefreshToHead.refreshData();
                }
            }
        });
        bar.setTitlte("\u9884\u544a");
        PreviewFragment fragment = PreviewFragment.newInstance(expid);
        this.getSupportFragmentManager().beginTransaction().replace(R.id.living_other_page_content, (Fragment)fragment).commitAllowingStateLoss();
        if (fragment instanceof IRefreshToHead) {
            this.iRefreshToHead = fragment;
        }
    }

    public void setPopupNavData() {
        LinearLayout tempLayout = null;
        if (this.navContent == null) {
            return;
        }
        this.navContent.removeAllViews();
        this.container.setVisibility(0);
        this.shadow.setVisibility(0);
        this.shadow.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                PreviewActivity.this.container.setVisibility(8);
                PreviewActivity.this.shadow.setVisibility(8);
            }
        });
        ArrayList bizs = ((ILiveCore)CoreFactory.getCore(ILiveCore.class)).getPreviewBizs();
        if (!FP.empty((Collection)bizs)) {
            for (int i = 0; i < bizs.size(); ++i) {
                int per = i % 4;
                if (per == 0) {
                    LinearLayout layout2;
                    LayoutInflater mInflater = LayoutInflater.from((Context)this.getContext());
                    tempLayout = layout2 = (LinearLayout)mInflater.inflate(R.layout.fragment_preview_nav_pop_item, null);
                    this.navContent.addView((View)tempLayout);
                }
                TextView mNavItem = per == 0 ? (TextView)tempLayout.findViewById(R.id.living_preview_nav_1) : (per == 1 ? (TextView)tempLayout.findViewById(R.id.living_preview_nav_2) : (per == 2 ? (TextView)tempLayout.findViewById(R.id.living_preview_nav_3) : (TextView)tempLayout.findViewById(R.id.living_preview_nav_4)));
                final String biz = (String)bizs.get(i);
                mNavItem.setClickable(true);
                mNavItem.setVisibility(0);
                if (biz != null && biz.equals("All")) {
                    mNavItem.setText((CharSequence)"\u5168\u90e8\u7c7b\u578b");
                } else {
                    mNavItem.setText((CharSequence)LivingClientConstant.getNavBizName((String)biz));
                }
                String choosedNav = ((ILiveCore)CoreFactory.getCore(ILiveCore.class)).getChoosedNav();
                if (biz != null && biz.equals(choosedNav)) {
                    mNavItem.setBackgroundResource(R.drawable.bg_living_pop_up_item_pressed);
                    mNavItem.setEnabled(false);
                    continue;
                }
                mNavItem.setBackgroundResource(R.drawable.bg_preview_nav_pop_title);
                mNavItem.setEnabled(true);
                mNavItem.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        PreviewActivity.this.container.setVisibility(8);
                        PreviewActivity.this.shadow.setVisibility(8);
                        ((ILiveCore)CoreFactory.getCore(ILiveCore.class)).notifyClientOnPreviewInfoByBiz(biz);
                    }
                });
            }
        }
        ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "50012", "0002");
    }
}

