/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.home.navto;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.mobile.RxBus;
import com.yy.mobile.baseapi.model.store.YYStore;
import com.yy.mobile.model.ReqAction;
import com.yy.mobile.plugin.homeapi.MultiLineAction;
import com.yy.mobile.plugin.homepage.core.live.livecore.IHomepageLiveCore;
import com.yy.mobile.plugin.homepage.ui.widget.pager.PagerFragment;
import com.yy.mobile.plugin.main.events.HomeTabChangedEventArgs;
import com.yy.mobile.plugin.main.events.ILiveCoreClient_onRequestMorePage_EventArgs;
import com.yy.mobile.ui.home.IMultiLineCallback;
import com.yy.mobile.ui.home.IMultiLineView;
import com.yy.mobile.ui.home.navto.LivingMorePageFragment$$EventBinder;
import com.yy.mobile.ui.widget.toast.Toast;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.RxUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.LivingCoreConstant;
import com.yymobile.core.live.livedata.NearTabInfo;
import com.yymobile.core.live.livenav.LiveNavInfo;
import com.yymobile.core.live.livenav.SubLiveNavItem;
import io.reactivex.functions.Consumer;
import java.util.ArrayList;
import java.util.List;

public class LivingMorePageFragment
extends PagerFragment
implements IMultiLineCallback {
    private static final String TAG = "LivingMorePageFragment";
    private IMultiLineView mMultiLineView;
    private LiveNavInfo mNavInfo;
    private SubLiveNavItem mSubNavInfo;
    private int mPageNo = 0;
    private int mModuleId;
    private String mPageId = "";
    private EventBinder mEventBinder;

    public static LivingMorePageFragment newInstance(LiveNavInfo navInfo, SubLiveNavItem subLiveNavItem, int modId) {
        MLog.info((String)TAG, (String)("[Life Cycle]newInstance by mNavInfo.biz=" + navInfo.biz + ", subLiveNavItem.biz = " + subLiveNavItem.biz));
        LivingMorePageFragment fragment = new LivingMorePageFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelable("key_nav_info", (Parcelable)navInfo);
        bundle.putParcelable("key_sub_nav_info", (Parcelable)subLiveNavItem);
        bundle.putString("key_page_id", "fragment_tag_more");
        bundle.putInt("key_module_id", modId);
        bundle.putString("key_from", TAG);
        fragment.setArguments(bundle);
        return fragment;
    }

    @SuppressLint(value={"CheckResult"})
    public void onCreate(Bundle savedInstanceState) {
        MLog.info((String)TAG, (String)("[Life Cycle]onCreate savedInstanceState = " + savedInstanceState));
        super.onCreate(savedInstanceState);
        Bundle args = this.getArguments();
        if (args != null) {
            this.mNavInfo = (LiveNavInfo)args.getParcelable("key_nav_info");
            this.mSubNavInfo = (SubLiveNavItem)args.getParcelable("key_sub_nav_info");
            this.mModuleId = args.getInt("key_module_id");
            this.mPageId = args.getString("key_page_id");
            RxBus.getDefault().post((Object)new HomeTabChangedEventArgs(TAG, this.mNavInfo, this.mSubNavInfo));
        }
        YYStore.INSTANCE.dispatchWithError((ReqAction)new MultiLineAction(this.getContext(), (IMultiLineCallback)this)).subscribe((Consumer)new Consumer<IMultiLineView>(){

            public void accept(IMultiLineView iMultiLineView) throws Exception {
                LivingMorePageFragment.this.mMultiLineView = iMultiLineView;
            }
        }, RxUtils.errorConsumer((String)TAG, (String)"fetch MultiLineView error."));
        if (this.mMultiLineView == null) {
            MLog.error((String)TAG, (String)"fetch MultiLineView error.");
            return;
        }
        this.mMultiLineView.onCreate(args);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        super.onCreateView(inflater, container, savedInstanceState);
        ((IHomepageLiveCore)CoreFactory.getCore(IHomepageLiveCore.class)).initNearTabInfo(this.mPageId);
        MLog.info((String)TAG, (String)("[Life Cycle]onCreateView by mNavInfo.biz=" + this.mNavInfo.biz + ", subLiveNavItem.biz = " + this.mSubNavInfo.biz));
        return this.mMultiLineView.onCreateView(inflater, container, savedInstanceState);
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.mMultiLineView.onViewCreated();
    }

    public void onResume() {
        MLog.info((String)TAG, (String)("[Life Cycle]onResume by mNavInfo.biz=" + this.mNavInfo.biz + ", subLiveNavItem.biz = " + this.mSubNavInfo.biz));
        super.onResume();
        this.mMultiLineView.notifyHiddenChanged(false);
        this.mMultiLineView.onResume();
    }

    public void onPause() {
        MLog.info((String)TAG, (String)("[Life Cycle]onPause by mNavInfo.biz=" + this.mNavInfo.biz + ", subLiveNavItem.biz = " + this.mSubNavInfo.biz));
        this.mMultiLineView.notifyHiddenChanged(true);
        super.onPause();
    }

    public void onStop() {
        super.onStop();
        this.mMultiLineView.onStop();
    }

    public void onDestroy() {
        super.onDestroy();
        this.mMultiLineView.onDestroy();
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.mMultiLineView.onDestroyView();
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putParcelable("key_nav_info", (Parcelable)this.mNavInfo);
        outState.putParcelable("key_sub_nav_info", (Parcelable)this.mSubNavInfo);
    }

    @BusEvent
    public void onRequestMorePage(ILiveCoreClient_onRequestMorePage_EventArgs busEventArgs) {
        List data = busEventArgs.getData();
        int isLast = busEventArgs.getIsLast();
        String pageId = busEventArgs.getPageId();
        MLog.info((String)TAG, (String)("onRequestMorePage size = " + (data == null ? 0 : data.size()) + ", pageId = " + pageId + ",isLast = " + isLast + ", mNavInfo.biz = " + this.mNavInfo.biz + ", mSubNavInfo.biz = " + this.mSubNavInfo.biz));
        if (this.mNavInfo == null || !this.mPageId.equals(pageId)) {
            return;
        }
        if (data != null && this.mPageNo == 1) {
            this.showNoLiveTips();
        }
        this.mMultiLineView.onRequestMorePage(new ArrayList(busEventArgs.getData()), busEventArgs.getPageId(), busEventArgs.getIsLast(), busEventArgs.getPage());
    }

    void showNoLiveTips() {
        NearTabInfo nearInfo;
        if (LivingCoreConstant.isNearTab((LiveNavInfo)this.mNavInfo, (SubLiveNavItem)this.mSubNavInfo) && (nearInfo = ((IHomepageLiveCore)CoreFactory.getCore(IHomepageLiveCore.class)).getNearTabInfo(this.mPageId)) != null && !FP.empty((CharSequence)nearInfo.noliveTips)) {
            Toast.makeText((Context)this.getContext(), (CharSequence)nearInfo.noliveTips, (int)0).show();
        }
    }

    public void requestFirstPage(LiveNavInfo navInfo, SubLiveNavItem subLiveNavItem, String pageId, int loadType, int pageIndex) {
        MLog.info((String)TAG, (String)("[requestFirstPage] pageId = " + pageId + ", loadType = " + loadType + ", pageIndex = " + pageIndex + ", mModuleId = " + this.mModuleId));
        ((IHomepageLiveCore)CoreFactory.getCore(IHomepageLiveCore.class)).requestMorePage(this.mNavInfo, this.mSubNavInfo, this.mModuleId, 1, pageIndex, pageId);
    }

    public void requestMorePage(LiveNavInfo navInfo, SubLiveNavItem subNavInfo, int moduleId, int page, int index, String pageId) {
        MLog.info((String)TAG, (String)("[requestMorePage] pageId = " + pageId + ", index = " + index + ", page = " + page + ", moduleId = " + moduleId + ", mModuleId = " + this.mModuleId));
        ((IHomepageLiveCore)CoreFactory.getCore(IHomepageLiveCore.class)).requestMorePage(this.mNavInfo, this.mSubNavInfo, this.mModuleId, page, index, pageId);
    }

    public void onEventBind() {
        super.onEventBind();
        if (this.mEventBinder == null) {
            this.mEventBinder = new LivingMorePageFragment$$EventBinder();
        }
        this.mEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mEventBinder != null) {
            this.mEventBinder.unBindEvent();
        }
    }
}

