/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.home.navto;

import android.app.Activity;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.View;
import androidx.fragment.app.Fragment;
import com.yy.mobile.RxBus;
import com.yy.mobile.plugin.homepage.ui.event.HideDeeplinkChannel_EventArgs;
import com.yy.mobile.plugin.homepage.ui.widget.pager.PagerFragment;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.ui.BaseDarkModeActivity;
import com.yy.mobile.ui.deeplink.DeepLinkBackManager;
import com.yy.mobile.ui.deeplink.LinkBackToThirdPresenter;
import com.yy.mobile.ui.home.SubNavHomeFragment;
import com.yy.mobile.ui.home.navto.ChooseLocateDialog;
import com.yy.mobile.ui.home.navto.LivingMorePageFragment;
import com.yy.mobile.ui.refreshutil.IRefreshToHead;
import com.yy.mobile.ui.widget.SimpleTitleBar;
import com.yy.mobile.util.ObjectTimeslotTool;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.taskexecutor.YYTaskExecutor;
import com.yymobile.core.live.livenav.LiveNavInfo;
import com.yymobile.core.live.livenav.SubLiveNavItem;

public class LivingMorePageActivity
extends BaseDarkModeActivity {
    private static final String TAG = "LivingMorePageActivity";
    public static final String LIVE_TAB_NAME = "live_tab_name";
    public static final String LIVE_NAV_INFO = "live_nav_info";
    public static final String LIVE_SUB_NAV_INFO = "live_sub_nav_info";
    public static final String LIVE_MODULE_ID = "live_module_id";
    public static final String FRAGMENT_TYPE = "fragment_type";
    public IRefreshToHead iRefreshToHead;
    public int type;
    public static final int FRAGMENT_SUB_PAGE = 1;
    public static final String NEW_SUBNAVFRAGMENT_STYLE = "new_subnavfragment_style";
    public String subnavfragmentStyle = "";
    private LinkBackToThirdPresenter linkBackToThirdPresenter;
    private ObjectTimeslotTool mTimeSlotTool = new ObjectTimeslotTool();

    protected void onCreate(Bundle savedInstanceState) {
        PagerFragment fragment;
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.layout_living_other_page);
        this.getWindow().setFormat(-3);
        this.type = this.getIntent().getExtras().getInt(FRAGMENT_TYPE, -1);
        this.subnavfragmentStyle = this.getIntent().getExtras().getString(NEW_SUBNAVFRAGMENT_STYLE);
        String tabName = this.getIntent().getExtras().getString(LIVE_TAB_NAME, "\u5176\u4ed6");
        this.initView(tabName);
        switch (this.type) {
            case 1: {
                LiveNavInfo navInfoPage = (LiveNavInfo)this.getIntent().getExtras().get(LIVE_NAV_INFO);
                SubLiveNavItem subNavInfoPage = (SubLiveNavItem)this.getIntent().getExtras().get(LIVE_SUB_NAV_INFO);
                fragment = SubNavHomeFragment.newInstance(navInfoPage, subNavInfoPage);
                if (this.subnavfragmentStyle == null || !this.subnavfragmentStyle.equals("1")) break;
                fragment.setStyle(1);
                break;
            }
            default: {
                LiveNavInfo navInfo = (LiveNavInfo)this.getIntent().getExtras().get(LIVE_NAV_INFO);
                SubLiveNavItem subNavInfo = (SubLiveNavItem)this.getIntent().getExtras().get(LIVE_SUB_NAV_INFO);
                int moduleId = this.getIntent().getExtras().getInt(LIVE_MODULE_ID);
                fragment = LivingMorePageFragment.newInstance(navInfo, subNavInfo, moduleId);
            }
        }
        if (fragment != null) {
            if (fragment instanceof IRefreshToHead) {
                this.iRefreshToHead = (IRefreshToHead)fragment;
            }
            this.getSupportFragmentManager().beginTransaction().replace(R.id.living_other_page_content, (Fragment)fragment).commitAllowingStateLoss();
        }
        this.linkBackToThirdPresenter = new LinkBackToThirdPresenter();
    }

    private void initView(String title) {
        SimpleTitleBar bar = (SimpleTitleBar)this.findViewById(R.id.living_other_page_bar);
        bar.setLeftBtn(R.drawable.icon_nav_back, new View.OnClickListener(){

            public void onClick(View v) {
                LivingMorePageActivity.this.finish();
            }
        });
        bar.setCenterOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (LivingMorePageActivity.this.mTimeSlotTool.isProcessing()) {
                    return;
                }
                if (LivingMorePageActivity.this.iRefreshToHead != null) {
                    LivingMorePageActivity.this.iRefreshToHead.refreshData();
                }
            }
        });
        bar.setTitlte(title);
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 4 && event.getAction() == 0) {
            if (DeepLinkBackManager.Companion.getInstance().isDeeplinkIntercept() && this.linkBackToThirdPresenter != null) {
                MLog.debug((String)TAG, (String)"\u8fd4\u56de\u6d4f\u89c8\u5668");
                this.dealBackPressed();
                return true;
            }
            try {
                if (this.getSupportFragmentManager().popBackStackImmediate()) {
                    return false;
                }
            }
            catch (IllegalStateException ex) {
                MLog.error((String)TAG, (String)ex.toString());
                return false;
            }
            ChooseLocateDialog chooseLocateDialog = (ChooseLocateDialog)this.getSupportFragmentManager().findFragmentByTag("choose_locate");
            if (chooseLocateDialog != null) {
                chooseLocateDialog.cancelChooseLocateDialog();
                return false;
            }
            this.finish();
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    protected void onResume() {
        super.onResume();
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                LivingMorePageActivity.this.showDeepLinkBackView();
            }
        }, (long)500L);
    }

    protected void onStop() {
        super.onStop();
    }

    protected void onDestroy() {
        super.onDestroy();
        this.hideDeeplinkView();
    }

    public void showDeepLinkBackView() {
        MLog.info((String)TAG, (String)"showDeepLinkBackView");
        if (this.linkBackToThirdPresenter != null && !this.linkBackToThirdPresenter.isPopWindowShow()) {
            this.linkBackToThirdPresenter.showBackPopView((Activity)this);
        }
    }

    public void hideDeeplinkView() {
        MLog.info((String)TAG, (String)"hideDeeplinkView");
        String channel = DeepLinkBackManager.Companion.getInstance().getMDpLinkInfo().getChannelTag();
        if (!TextUtils.isEmpty((CharSequence)channel) && this.linkBackToThirdPresenter != null && this.linkBackToThirdPresenter.isPopWindowShow()) {
            RxBus.getDefault().post((Object)new HideDeeplinkChannel_EventArgs());
        }
    }

    public void dealBackPressed() {
        if (this.linkBackToThirdPresenter != null) {
            this.linkBackToThirdPresenter.doOnClick((Activity)this);
        }
    }
}

