/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.home.label;

import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.hiidostatis.defs.obj.Property;
import com.yy.mobile.RxBus;
import com.yy.mobile.baseapi.model.store.YYStore;
import com.yy.mobile.model.ReqAction;
import com.yy.mobile.plugin.homeapi.MultiLineAction;
import com.yy.mobile.plugin.homepage.core.live.livecore.IHomepageLiveCore;
import com.yy.mobile.plugin.homepage.ui.widget.pager.PagerFragment;
import com.yy.mobile.plugin.main.events.HomeTabChangedEventArgs;
import com.yy.mobile.plugin.main.events.ILiveCoreClient_onRequestLabelPage_EventArgs;
import com.yy.mobile.ui.home.IMultiLineCallback;
import com.yy.mobile.ui.home.IMultiLineView;
import com.yy.mobile.ui.home.label.LivingLabelPageFragment$$EventBinder;
import com.yy.mobile.ui.refreshutil.IRefreshToHead;
import com.yy.mobile.util.RxUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.live.livenav.LabelNavInfo;
import com.yymobile.core.live.livenav.LiveNavInfo;
import com.yymobile.core.live.livenav.SubLiveNavItem;
import com.yymobile.core.statistic.IBaseHiidoStatisticCore;
import io.reactivex.functions.Consumer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class LivingLabelPageFragment
extends PagerFragment
implements IMultiLineCallback,
IRefreshToHead {
    public static final String KEY_LABEL = "key_label";
    public static final String KEY_FROM = "key_from_label";
    private static final String TAG = "LivingLabelPageFragment";
    private IMultiLineView mMultiLineView;
    private LiveNavInfo mNavInfo;
    private SubLiveNavItem mSubNavInfo;
    private String mLabel;
    private String mFrom;
    private int moduleId;
    private EventBinder mEventBinder;

    public static LivingLabelPageFragment newInstance(LabelNavInfo labelNavInfo) {
        MLog.info((String)TAG, (String)("[mLabelLife Cycle]newInstance " + (labelNavInfo == null ? "" : labelNavInfo.label) + ", mFrom = " + (labelNavInfo == null ? "" : labelNavInfo.from)));
        LivingLabelPageFragment fragment = new LivingLabelPageFragment();
        Bundle bundle = new Bundle();
        if (labelNavInfo != null) {
            bundle.putParcelable("key_nav_info", (Parcelable)labelNavInfo.liveNavInfo);
            bundle.putParcelable("key_sub_nav_info", (Parcelable)labelNavInfo.subLiveNavItem);
            bundle.putInt("key_module_id", labelNavInfo.moduleId);
            bundle.putString("key_page_id", "fragment_tag_label");
            bundle.putString(KEY_LABEL, labelNavInfo.label);
            bundle.putString(KEY_FROM, labelNavInfo.from);
        }
        bundle.putString("key_from", TAG);
        fragment.setArguments(bundle);
        return fragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        MLog.info((String)TAG, (String)("[Life Cycle]onCreate savedInstanceState" + savedInstanceState));
        super.onCreate(savedInstanceState);
        Bundle args = this.getArguments();
        if (args != null) {
            this.mLabel = args.getString(KEY_LABEL);
            this.mFrom = args.getString(KEY_FROM);
            this.mNavInfo = (LiveNavInfo)args.getParcelable("key_nav_info");
            this.mSubNavInfo = (SubLiveNavItem)args.getParcelable("key_sub_nav_info");
            this.moduleId = args.getInt("key_module_id");
            RxBus.getDefault().post((Object)new HomeTabChangedEventArgs(TAG, this.mNavInfo, this.mSubNavInfo));
        }
        YYStore.INSTANCE.dispatchWithError((ReqAction)new MultiLineAction(this.getContext(), (IMultiLineCallback)this)).subscribe((Consumer)new Consumer<IMultiLineView>(){

            public void accept(IMultiLineView iMultiLineView) throws Exception {
                LivingLabelPageFragment.this.mMultiLineView = iMultiLineView;
            }
        }, RxUtils.errorConsumer((String)TAG, (String)"fetch MultiLineView error."));
        if (this.mMultiLineView == null) {
            MLog.error((String)TAG, (String)"fetch MultiLineView error.");
            return;
        }
        this.mMultiLineView.onCreate(args);
        this.initStatics(this.mLabel, this.mFrom);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        super.onCreateView(inflater, container, savedInstanceState);
        return this.mMultiLineView.onCreateView(inflater, container, savedInstanceState);
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.mMultiLineView.onViewCreated();
    }

    public void onResume() {
        MLog.info((String)TAG, (String)("[Life Cycle]onResume by mLabel=" + this.mLabel + ", mFrom = " + this.mFrom));
        this.mMultiLineView.notifyHiddenChanged(false);
        this.mMultiLineView.onResume();
        super.onResume();
    }

    public void onPause() {
        MLog.info((String)TAG, (String)("[Life Cycle]onPause by mLabel=" + this.mLabel + ", mFrom = " + this.mFrom));
        this.mMultiLineView.notifyHiddenChanged(true);
        super.onPause();
    }

    public void onStop() {
        super.onStop();
        this.mMultiLineView.onStop();
    }

    public void onDestroyView() {
        MLog.info((String)TAG, (String)("[Life Cycle]onDestroyView by mLabel=" + this.mLabel + ", mFrom = " + this.mFrom));
        this.mMultiLineView.onDestroy();
        super.onDestroyView();
    }

    private void initStatics(String label, String from) {
        Property property = new Property();
        property.putString("key1", Uri.encode((String)label));
        property.putString("key2", from);
        ((IBaseHiidoStatisticCore)CoreFactory.getCore(IBaseHiidoStatisticCore.class)).sendEventStatistic("52201", "0001", (Serializable)property);
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putParcelable("key_nav_info", (Parcelable)this.mNavInfo);
        outState.putParcelable("key_sub_nav_info", (Parcelable)this.mSubNavInfo);
    }

    @BusEvent
    public void onRequestLabelPage(ILiveCoreClient_onRequestLabelPage_EventArgs busEventArgs) {
        List data = busEventArgs.getData();
        int isLast = busEventArgs.getIsLast();
        String tag = busEventArgs.getTag();
        this.mMultiLineView.onRequestMorePage(new ArrayList(data), tag, isLast, busEventArgs.getPage());
    }

    public void refreshData() {
        this.mMultiLineView.refreshData();
    }

    public void requestFirstPage(LiveNavInfo navInfo, SubLiveNavItem subLiveNavItem, String pageId, int loadType, int pageIndex) {
        ((IHomepageLiveCore)CoreFactory.getCore(IHomepageLiveCore.class)).requestLabelPage(this.mLabel, 1, this.moduleId, pageId);
    }

    public void requestMorePage(LiveNavInfo navInfo, SubLiveNavItem subNavInfo, int moduleId, int page, int index, String pageId) {
        ((IHomepageLiveCore)CoreFactory.getCore(IHomepageLiveCore.class)).requestLabelPage(this.mLabel, page, moduleId, pageId);
    }

    public void onEventBind() {
        super.onEventBind();
        if (this.mEventBinder == null) {
            this.mEventBinder = new LivingLabelPageFragment$$EventBinder();
        }
        this.mEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mEventBinder != null) {
            this.mEventBinder.unBindEvent();
        }
    }
}

