/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.home.label;

import android.content.Intent;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.View;
import androidx.fragment.app.Fragment;
import com.yy.mobile.plugin.homepage.core.live.livecore.IHomepageLiveCore;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.ui.BaseActivity;
import com.yy.mobile.ui.common.IBaseMethod;
import com.yy.mobile.ui.home.label.LivingLabelPageFragment;
import com.yy.mobile.ui.refreshutil.IRefreshToHead;
import com.yy.mobile.ui.widget.SimpleTitleBar;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.CoreManager;
import com.yymobile.core.live.livenav.LabelNavInfo;
import com.yymobile.core.live.livenav.LiveNavInfo;
import com.yymobile.core.live.livenav.SubLiveNavItem;

public class LivingLabelPageActivity
extends BaseActivity
implements IBaseMethod {
    private static final String TAG = "LivingLabelPageActivity";
    private SimpleTitleBar titleBar;
    public IRefreshToHead iRefreshToHead;
    public static final String LIVE_TAB_LABEL = "live_tab_label";
    public static final String LIVE_TAB_FROM = "live_tab_from";

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.getWindow().setFormat(-3);
        this.setContentView(R.layout.layout_living_label_page);
        this.injectView();
        this.init();
        this.setListener();
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        MLog.info((String)TAG, (String)"[zy] LivingLabelPageActivity onNewIntent");
        if (intent == null) {
            return;
        }
        String label = intent.getStringExtra(LIVE_TAB_LABEL);
        String from = intent.getStringExtra(LIVE_TAB_FROM);
        this.titleBar.setTitlte(label);
        LabelNavInfo coreLabelInfo = this.initTabInfo(label, from);
        LivingLabelPageFragment fragment = LivingLabelPageFragment.newInstance(coreLabelInfo);
        this.getSupportFragmentManager().beginTransaction().replace(R.id.living_label_page_content, (Fragment)fragment).commitAllowingStateLoss();
        if (fragment instanceof IRefreshToHead) {
            this.iRefreshToHead = fragment;
        }
    }

    public void injectView() {
        this.titleBar = (SimpleTitleBar)this.findViewById(R.id.living_label_page_bar);
    }

    public void setListener() {
        this.titleBar.setLeftBtn(R.drawable.icon_nav_back, new View.OnClickListener(){

            public void onClick(View v) {
                LivingLabelPageActivity.this.finish();
            }
        });
        this.titleBar.setCenterOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (LivingLabelPageActivity.this.iRefreshToHead != null) {
                    LivingLabelPageActivity.this.iRefreshToHead.refreshData();
                }
            }
        });
    }

    public void init() {
        String label = this.getIntent().getStringExtra(LIVE_TAB_LABEL);
        String from = this.getIntent().getStringExtra(LIVE_TAB_FROM);
        this.titleBar.setTitlte(label);
        LabelNavInfo coreLabelInfo = this.initTabInfo(label, from);
        LivingLabelPageFragment fragment = LivingLabelPageFragment.newInstance(coreLabelInfo);
        this.getSupportFragmentManager().beginTransaction().replace(R.id.living_label_page_content, (Fragment)fragment).commitAllowingStateLoss();
        if (fragment instanceof IRefreshToHead) {
            this.iRefreshToHead = fragment;
        }
    }

    public LabelNavInfo initTabInfo(String label, String from) {
        LabelNavInfo labelNavInfo = null;
        LabelNavInfo coreLabelNavInfo = ((IHomepageLiveCore)CoreManager.getCore(IHomepageLiveCore.class)).getLabelNavInfo();
        if (coreLabelNavInfo == null) {
            labelNavInfo = new LabelNavInfo();
            labelNavInfo.label = label;
            labelNavInfo.tabName = label;
            labelNavInfo.from = from;
            labelNavInfo.liveNavInfo = new LiveNavInfo();
            labelNavInfo.subLiveNavItem = new SubLiveNavItem();
            ((IHomepageLiveCore)CoreManager.getCore(IHomepageLiveCore.class)).setLabelNavInfo(labelNavInfo);
        } else {
            coreLabelNavInfo.label = label;
            coreLabelNavInfo.tabName = label;
            coreLabelNavInfo.from = from;
            if (coreLabelNavInfo.liveNavInfo == null) {
                coreLabelNavInfo.liveNavInfo = new LiveNavInfo();
            } else if (!coreLabelNavInfo.from.equals("2") && !coreLabelNavInfo.from.equals("3")) {
                coreLabelNavInfo.liveNavInfo = new LiveNavInfo();
            }
            if (coreLabelNavInfo.subLiveNavItem == null) {
                coreLabelNavInfo.subLiveNavItem = new SubLiveNavItem();
            } else if (!coreLabelNavInfo.from.equals("2") && !coreLabelNavInfo.from.equals("3")) {
                coreLabelNavInfo.subLiveNavItem = new SubLiveNavItem();
            }
            ((IHomepageLiveCore)CoreManager.getCore(IHomepageLiveCore.class)).setLabelNavInfo(coreLabelNavInfo);
        }
        return ((IHomepageLiveCore)CoreManager.getCore(IHomepageLiveCore.class)).getLabelNavInfo();
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 4 && event.getAction() == 0) {
            this.finish();
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }
}

