/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.home.image;

import android.app.Activity;
import android.content.Context;
import android.widget.ImageView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.RequestOptions;
import com.yy.mobile.http.httpsparser.HttpsParser;
import com.yy.mobile.sdkwrapper.flowmanagement.base.util.ActivityCheckUtils;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.log.MLog;

public class GlideImageManager {
    private static final String TAG = "GlideImageManager";

    public static void loadImage(Context context, String url, ImageView imgView, int placeholderId) {
        GlideImageManager.loadImage(context, url, imgView, placeholderId, placeholderId, 1.0f);
    }

    public static void loadImage(Context context, String url, ImageView imgView, int placeholderId, float sizeMultiplier) {
        GlideImageManager.loadImage(context, url, imgView, placeholderId, placeholderId, sizeMultiplier);
    }

    public static void loadImage(Context context, String url, ImageView imgView, int placeholderId, int errorId, float sizeMultiplier) {
        if (context == null || imgView == null) {
            return;
        }
        if (context instanceof Activity && !ActivityCheckUtils.checkActivityValid((Activity)((Activity)context))) {
            MLog.error((Object)TAG, (String)"loadImage failed, invalid context, url: %s", (Object[])new Object[]{url});
            return;
        }
        if (GlideImageManager.isGifUrl(url)) {
            GlideImageManager.loadImageAsGif(context, url, imgView, placeholderId, errorId);
        } else {
            Glide.with((Context)context).load((Object)HttpsParser.convertToHttps((String)url)).apply(new RequestOptions().placeholder(placeholderId).sizeMultiplier(sizeMultiplier).error(errorId).dontTransform()).into(imgView);
        }
    }

    private static void loadImageAsGif(Context context, String url, ImageView imgView, int placeholderId, int errorId) {
        Glide.with((Context)context).asGif().load(HttpsParser.convertToHttps((String)url)).apply(new RequestOptions().diskCacheStrategy(DiskCacheStrategy.AUTOMATIC).placeholder(placeholderId).error(errorId)).into(imgView);
    }

    private static boolean isGifUrl(String url) {
        return !FP.empty((CharSequence)url) && url.endsWith(".gif");
    }
}

