/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.home.custom;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.ui.widget.CircleImageViewNotRecycle;

public class IdentityImageView
extends ViewGroup {
    int radius;
    private Context mContext;
    private CircleImageViewNotRecycle bigImageView;
    private CircleImageViewNotRecycle smallImageView;
    private float radiusScale;
    private int smallRadius;
    private double angle = 45.0;
    private boolean isProgress;
    private int progressColor;
    private int borderColor = 0;
    private int borderWidth;
    private TextView textView;
    private boolean hintSmallView;
    private Paint mBorderPaint;
    private Paint mProgressPaint;
    private float progress;
    private Drawable bigImage;
    private Drawable smallImage;
    private int setprogressColor = 0;
    private int setborderColor = 0;
    private int totalwidth;

    public IdentityImageView(Context context) {
        this(context, null);
    }

    public IdentityImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public IdentityImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        this.setWillNotDraw(false);
        this.addThreeView();
        this.initAttrs(attrs);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int viewWidthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int viewHeightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int viewWidht = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int viewHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
        switch (viewWidthMode) {
            case 0x40000000: {
                this.totalwidth = viewWidht < viewHeight ? viewWidht : viewHeight;
                float scale = 1.0f + this.radiusScale;
                int radius2 = this.totalwidth / 2;
                this.radius = (int)((float)radius2 / scale);
                break;
            }
            case -2147483648: {
                this.radius = 200;
                this.totalwidth = (int)(((float)this.radius + (float)this.radius * this.radiusScale) * 2.0f);
                break;
            }
            default: {
                this.radius = 200;
                this.totalwidth = (int)(((float)this.radius + (float)this.radius * this.radiusScale) * 2.0f);
            }
        }
        this.setMeasuredDimension(this.totalwidth, this.totalwidth);
        this.adjustThreeView();
    }

    protected void onDraw(Canvas canvas) {
        this.initPaint();
        if (this.borderWidth > 0) {
            this.drawBorder(canvas);
        }
        if (this.isProgress) {
            this.drawProgress(canvas);
        }
    }

    private void drawBorder(Canvas canvas) {
        canvas.drawCircle((float)(this.totalwidth / 2), (float)(this.totalwidth / 2), (float)(this.radius - this.borderWidth / 2), this.mBorderPaint);
    }

    private void drawProgress(Canvas canvas) {
        RectF rectf = new RectF((float)(this.smallRadius + this.borderWidth / 2), (float)(this.smallRadius + this.borderWidth / 2), (float)(this.getWidth() - this.smallRadius - this.borderWidth / 2), (float)(this.getHeight() - this.smallRadius - this.borderWidth / 2));
        canvas.drawArc(rectf, (float)this.angle, this.progress, false, this.mProgressPaint);
    }

    private void initPaint() {
        if (this.mBorderPaint == null) {
            this.mBorderPaint = new Paint();
            this.mBorderPaint.setStyle(Paint.Style.STROKE);
            this.mBorderPaint.setAntiAlias(true);
        }
        if (this.setborderColor != 0) {
            this.mBorderPaint.setColor(this.getResources().getColor(this.setborderColor));
        } else {
            this.mBorderPaint.setColor(this.borderColor);
        }
        this.mBorderPaint.setStrokeWidth((float)this.borderWidth);
        if (this.mProgressPaint == null) {
            this.mProgressPaint = new Paint();
            this.mProgressPaint.setStyle(Paint.Style.STROKE);
            this.mProgressPaint.setAntiAlias(true);
        }
        if (this.setprogressColor != 0) {
            this.mProgressPaint.setColor(this.getResources().getColor(this.setprogressColor));
        } else {
            this.mProgressPaint.setColor(this.progressColor);
        }
        this.mProgressPaint.setStrokeWidth((float)this.borderWidth);
    }

    protected void onLayout(boolean b, int i, int i1, int i2, int i3) {
        double cos = Math.cos(this.angle * Math.PI / 180.0);
        double sin = Math.sin(this.angle * Math.PI / 180.0);
        double left = (double)(this.totalwidth / 2) + ((double)this.radius * cos - (double)this.smallRadius);
        double top = (double)(this.totalwidth / 2) + ((double)this.radius * sin - (double)this.smallRadius);
        int right = (int)(left + (double)(2 * this.smallRadius));
        int bottom = (int)(top + (double)(2 * this.smallRadius));
        this.bigImageView.layout(this.smallRadius + this.borderWidth / 2, this.smallRadius + this.borderWidth / 2, this.totalwidth - this.smallRadius - this.borderWidth / 2, this.totalwidth - this.smallRadius - this.borderWidth / 2);
        this.textView.layout((int)left, (int)top, right, bottom);
        this.smallImageView.layout((int)left, (int)top, right, bottom);
    }

    private void adjustThreeView() {
        this.bigImageView.setLayoutParams(new ViewGroup.LayoutParams(this.radius, this.radius));
        this.smallRadius = (int)((float)this.radius * this.radiusScale);
        this.smallImageView.setLayoutParams(new ViewGroup.LayoutParams(this.smallRadius, this.smallRadius));
        this.textView.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
    }

    private void addThreeView() {
        this.bigImageView = new CircleImageViewNotRecycle(this.mContext);
        this.smallImageView = new CircleImageViewNotRecycle(this.mContext);
        this.textView = new TextView(this.mContext);
        this.textView.setGravity(17);
        this.addView((View)this.bigImageView, 0, new ViewGroup.LayoutParams(this.radius, this.radius));
        this.smallRadius = (int)((float)this.radius * this.radiusScale);
        this.addView((View)this.smallImageView, 1, new ViewGroup.LayoutParams(this.smallRadius, this.smallRadius));
        this.addView((View)this.textView, new ViewGroup.LayoutParams(-2, -2));
        this.smallImageView.bringToFront();
    }

    private void initAttrs(AttributeSet attrs) {
        TypedArray tta = this.getContext().obtainStyledAttributes(attrs, R.styleable.IdentityImageView);
        this.bigImage = tta.getDrawable(R.styleable.IdentityImageView_iciv_bigimage);
        this.smallImage = tta.getDrawable(R.styleable.IdentityImageView_iciv_smallimage);
        this.angle = tta.getFloat(R.styleable.IdentityImageView_iciv_angle, 45.0f);
        this.radiusScale = tta.getFloat(R.styleable.IdentityImageView_iciv_radiusscale, 0.28f);
        this.isProgress = tta.getBoolean(R.styleable.IdentityImageView_iciv_isprogress, false);
        this.progressColor = tta.getColor(R.styleable.IdentityImageView_iciv_progress_collor, 0);
        this.borderColor = tta.getColor(R.styleable.IdentityImageView_iciv_border_color, 0);
        this.borderWidth = tta.getInteger(R.styleable.IdentityImageView_iciv_border_width, 0);
        this.hintSmallView = tta.getBoolean(R.styleable.IdentityImageView_iciv_hint_smallimageview, false);
        if (this.hintSmallView) {
            this.smallImageView.setVisibility(8);
        }
        if (this.bigImage != null) {
            this.bigImageView.setImageDrawable(this.bigImage);
        }
        if (this.smallImage != null) {
            this.smallImageView.setImageDrawable(this.smallImage);
        }
        tta.recycle();
    }

    public TextView getTextView() {
        if (this.textView != null) {
            return this.textView;
        }
        return null;
    }

    public CircleImageViewNotRecycle getBigCircleImageView() {
        if (this.bigImageView != null) {
            return this.bigImageView;
        }
        return null;
    }

    public CircleImageViewNotRecycle getSmallCircleImageView() {
        if (this.smallImageView != null) {
            return this.smallImageView;
        }
        return null;
    }

    public void setProgress(float angle) {
        if (this.progress == angle) {
            return;
        }
        this.progress = angle;
        this.requestLayout();
        this.invalidate();
    }

    public void setAngle(int angles) {
        if ((double)angles == this.angle) {
            return;
        }
        this.angle = angles;
        this.requestLayout();
        this.invalidate();
    }

    public void setRadiusScale(float v) {
        if (v == this.radiusScale) {
            return;
        }
        this.radiusScale = v;
        this.requestLayout();
        this.invalidate();
    }

    public void setIsprogress(boolean b) {
        if (b == this.isProgress) {
            return;
        }
        this.isProgress = b;
        this.requestLayout();
        this.invalidate();
    }

    public void setBorderColor(int color2) {
        if (color2 == this.borderColor) {
            return;
        }
        this.setborderColor = color2;
        this.requestLayout();
        this.invalidate();
    }

    public void setProgressColor(int color2) {
        if (color2 == this.progressColor) {
            return;
        }
        this.setprogressColor = color2;
        this.requestLayout();
        this.invalidate();
    }

    public void setBorderWidth(int width) {
        if (width == this.borderWidth) {
            return;
        }
        this.borderWidth = width;
        this.requestLayout();
        this.invalidate();
    }
}

