/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.home;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.mobile.RxBus;
import com.yy.mobile.baseapi.model.store.YYStore;
import com.yy.mobile.event.LivingSubNavCreatedEventArgs;
import com.yy.mobile.event.ui.NewSubNavHomeStyle_EventArgs;
import com.yy.mobile.model.ReqAction;
import com.yy.mobile.plugin.homeapi.MultiLineAction;
import com.yy.mobile.plugin.homepage.core.live.livecore.IHomepageLiveCore;
import com.yy.mobile.plugin.homepage.ui.widget.pager.PagerFragment;
import com.yy.mobile.plugin.main.events.HomeTabChangedEventArgs;
import com.yy.mobile.plugin.main.events.ILiveCoreClient_onRequestSubNavHomePage_EventArgs;
import com.yy.mobile.plugin.main.events.ILiveCoreClient_onRequstSubNavMorePages_EventArgs;
import com.yy.mobile.ui.home.IMultiLineCallback;
import com.yy.mobile.ui.home.IMultiLineView;
import com.yy.mobile.ui.home.SubNavHomeFragment$$EventBinder;
import com.yy.mobile.ui.home.utils.LivingStatisticUtils;
import com.yy.mobile.ui.home.utils.SubNavFragmentDataParser;
import com.yy.mobile.util.RxUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.live.livenav.LiveNavInfo;
import com.yymobile.core.live.livenav.SubLiveNavItem;
import io.reactivex.functions.Consumer;
import java.util.ArrayList;
import java.util.List;

@SuppressLint(value={"NewApi"})
public class SubNavHomeFragment
extends PagerFragment
implements IMultiLineCallback {
    public static final String KEY_SUB_PAGE_TYPE = "key_sub_page_type";
    public static final int FROM_SUB_NAV_HOME_ACTIVITY = 0;
    public static final int FROM_LIVING_MORE_PAGE_ACTIVITY = 1;
    private static final String TAG = "SubNavHomeFragment";
    public int pageType = 0;
    private IMultiLineView mMultiLineView;
    private static final String SELECT_PIECE_TAB_BIZ = "piece";
    private LiveNavInfo mNavInfo;
    private SubLiveNavItem mSubNavInfo;
    private boolean firstShow = true;
    private int style = 0;
    private static final String ONE_PIECE_TIPS_SHOW = "ONE_PIECE_TIPS_SHOW";
    private SubNavFragmentDataParser mDataParser;
    private EventBinder mEventBinder;

    public static SubNavHomeFragment newInstance(LiveNavInfo navInfo, int position, SubLiveNavItem subNavItem) {
        MLog.info((String)TAG, (String)("[Life Cycle]onDestroy by mNavInfo.biz = " + navInfo.biz + ", mSubNavInfo.biz = " + subNavItem.biz));
        SubNavHomeFragment fragment = new SubNavHomeFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelable("key_nav_info", (Parcelable)navInfo);
        bundle.putInt("key_sub_page_index", position);
        bundle.putInt("key_position_in_parent", position);
        bundle.putParcelable("key_sub_nav_info", (Parcelable)subNavItem);
        bundle.putString("key_from", TAG);
        fragment.setArguments(bundle);
        return fragment;
    }

    public static SubNavHomeFragment newInstance(LiveNavInfo navInfo, SubLiveNavItem subNavItem) {
        MLog.info((String)TAG, (String)("[Life Cycle]onDestroy by mNavInfo.biz = " + navInfo.biz + ", mSubNavInfo.biz = " + subNavItem.biz));
        SubNavHomeFragment fragment = new SubNavHomeFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelable("key_nav_info", (Parcelable)navInfo);
        bundle.putInt(KEY_SUB_PAGE_TYPE, 1);
        bundle.putParcelable("key_sub_nav_info", (Parcelable)subNavItem);
        bundle.putString("key_from", "LivingSubNavFragmentAlone");
        fragment.setArguments(bundle);
        return fragment;
    }

    public void setStyle(int style2) {
        this.style = style2;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        MLog.info((String)TAG, (String)"[Life Cycle]onCreate");
        Bundle args = this.getArguments();
        this.mDataParser = new SubNavFragmentDataParser((Context)this.getActivity());
        if (args != null) {
            this.pageType = args.getInt(KEY_SUB_PAGE_TYPE, 0);
            this.mNavInfo = (LiveNavInfo)args.getParcelable("key_nav_info");
            this.mSubNavInfo = (SubLiveNavItem)args.getParcelable("key_sub_nav_info");
            RxBus.getDefault().post((Object)new LivingSubNavCreatedEventArgs(this.mNavInfo, this.mSubNavInfo));
            RxBus.getDefault().post((Object)new HomeTabChangedEventArgs(TAG, this.mNavInfo, this.mSubNavInfo));
        }
        YYStore.INSTANCE.dispatchWithError((ReqAction)new MultiLineAction(this.getContext(), (IMultiLineCallback)this)).subscribe((Consumer)new Consumer<IMultiLineView>(){

            public void accept(IMultiLineView iMultiLineView) throws Exception {
                SubNavHomeFragment.this.mMultiLineView = iMultiLineView;
            }
        }, RxUtils.errorConsumer((String)TAG, (String)"fetch MultiLineView error."));
        if (this.mMultiLineView == null) {
            MLog.error((String)TAG, (String)"fetch MultiLineView error.");
            return;
        }
        this.mMultiLineView.onCreate(args);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        super.onCreateView(inflater, container, savedInstanceState);
        MLog.info((String)TAG, (String)("[Life Cycle] onCreateViewsavedInstanceState" + savedInstanceState));
        if (this.isFromLivingSubNavActivity()) {
            LivingStatisticUtils.INSTANCE.sendLivingHomePageLoading(this.mNavInfo.biz + "_" + this.mSubNavInfo.biz);
        }
        return this.mMultiLineView.onCreateView(inflater, container, savedInstanceState);
    }

    @BusEvent
    public void goToRandomLiveRoom(NewSubNavHomeStyle_EventArgs args) {
        if (this.isVisible() && this.firstShow && this.style == 1) {
            List datas = this.mMultiLineView.getDataList();
            this.mDataParser.enterRandomLiveRoom(datas);
            this.firstShow = false;
        }
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.mMultiLineView.onViewCreated();
    }

    public void onResume() {
        super.onResume();
        this.mMultiLineView.onResume();
    }

    public void onSelected(int position) {
        super.onSelected(position);
        this.mMultiLineView.onSelected(position);
    }

    public void onUnSelected(int position) {
        super.onUnSelected(position);
        this.mMultiLineView.onUnSelected(position);
        this.mMultiLineView.notifyHiddenChanged(true);
    }

    public void onPause() {
        super.onPause();
    }

    public void onStop() {
        super.onStop();
        this.mMultiLineView.onStop();
        this.mMultiLineView.dismissOnepieceTips();
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.mMultiLineView.onDestroyView();
    }

    public void onDestroy() {
        super.onDestroy();
        this.mMultiLineView.onDestroy();
    }

    private boolean isFromLivingSubNavActivity() {
        return this.pageType == 1;
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putInt(KEY_SUB_PAGE_TYPE, this.pageType);
    }

    @BusEvent
    public void onRequestSubNavHomePage(ILiveCoreClient_onRequestSubNavHomePage_EventArgs busEventArgs) {
        this.mMultiLineView.onRequestFirstPage(new ArrayList(busEventArgs.getData()), busEventArgs.getPageId(), busEventArgs.getHasPageable());
    }

    @BusEvent
    public void onRequstSubNavMorePages(ILiveCoreClient_onRequstSubNavMorePages_EventArgs busEventArgs) {
        this.mMultiLineView.onRequestMorePage(new ArrayList(busEventArgs.getData()), busEventArgs.getPageId(), busEventArgs.getIsLast(), busEventArgs.getPage());
    }

    public void requestFirstPage(LiveNavInfo navInfo, SubLiveNavItem subLiveNavItem, String pageId, int loadType, int pageIndex) {
        ((IHomepageLiveCore)CoreFactory.getCore(IHomepageLiveCore.class)).requestSubNavHomePage(navInfo, subLiveNavItem, pageId, pageIndex);
    }

    public void requestMorePage(LiveNavInfo navInfo, SubLiveNavItem subNavInfo, int moduleId, int page, int index, String pageId) {
        ((IHomepageLiveCore)CoreFactory.getCore(IHomepageLiveCore.class)).requestSubNavMorePages(navInfo, subNavInfo, moduleId, page, index, pageId);
    }

    public void onPageChange(int oldPosition, int newPosition) {
        super.onPageChange(oldPosition, newPosition);
        this.mMultiLineView.onPageChange(oldPosition, newPosition);
    }

    public void onEventBind() {
        super.onEventBind();
        if (this.mEventBinder == null) {
            this.mEventBinder = new SubNavHomeFragment$$EventBinder();
        }
        this.mEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mEventBinder != null) {
            this.mEventBinder.unBindEvent();
        }
    }
}

