/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.home;

import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.alibaba.android.arouter.core.LogisticsCenter;
import com.alibaba.android.arouter.facade.Postcard;
import com.alibaba.android.arouter.launcher.ARouter;
import com.yy.mobile.plugin.homeapi.core.IHomeCore;
import com.yy.mobile.plugin.homepage.core.live.livecore.IHomepageLiveCore;
import com.yy.mobile.plugin.homepage.ui.widget.pager.PagerFragment;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.ui.DialogBaseActivity;
import com.yy.mobile.ui.home.SubNavHomeFragment;
import com.yy.mobile.ui.home.utils.LivingStatisticUtils;
import com.yy.mobile.ui.widget.PagerSlidingTabStrip;
import com.yy.mobile.ui.widget.pager.FixedPageFragmentAdapter;
import com.yy.mobile.ui.widget.pager.SelectedViewPager;
import com.yy.mobile.util.FP;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.CoreManager;
import com.yymobile.core.live.livenav.LiveNavInfo;
import com.yymobile.core.live.livenav.SubLiveNavItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class LivingSubNavActivity
extends DialogBaseActivity {
    public static final String LIVING_NAV_INFO = "living_nav_info";
    public static final String SUB_NAV_INFO = "sub_nav_info";
    public static final String SUB_NAV_TAB_ID = "sub_nav_tab_id";
    public static final int OFFSCREEN_LIMIT = 2;
    private PagerSlidingTabStrip mPagerSliding;
    public SelectedViewPager mViewPager;
    private ImageView mImgBack;
    private RelativeLayout mEdit;
    private SubNavPagerAdapter mAdapter;
    private List<SubLiveNavItem> mSubNavs = new ArrayList<SubLiveNavItem>();
    private LiveNavInfo mNavInfo;
    private SubLiveNavItem mSubLiveItem;
    private int tabId;
    private PagerSlidingTabStrip.SlidingTabListener mPageListener = new PagerSlidingTabStrip.SlidingTabListener(){

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        }

        public void onPageSelected(int oldPosition, int position) {
            String subBiz;
            if (LivingSubNavActivity.this.mNavInfo != null && !FP.empty((CharSequence)(subBiz = ((SubLiveNavItem)((LivingSubNavActivity)LivingSubNavActivity.this).mNavInfo.getNavs().get((int)position)).biz))) {
                if (!subBiz.equals("shenqu") && !subBiz.equals("duanpai")) {
                    LivingStatisticUtils.INSTANCE.sendLivingHomePageLoading(((LivingSubNavActivity)LivingSubNavActivity.this).mNavInfo.biz + "_" + subBiz);
                }
                String pageId = subBiz.equals("idx") ? ((LivingSubNavActivity)LivingSubNavActivity.this).mNavInfo.biz : ((LivingSubNavActivity)LivingSubNavActivity.this).mNavInfo.biz + "_" + subBiz;
                LivingStatisticUtils.INSTANCE.sendSubNavClickEvent(LivingSubNavActivity.this.mNavInfo, pageId);
                if (LivingSubNavActivity.this.mNavInfo != null && !FP.empty((Collection)LivingSubNavActivity.this.mSubNavs) && LivingSubNavActivity.this.mSubNavs.get(oldPosition) != null) {
                    LivingStatisticUtils.INSTANCE.sendStatisticForPagerExposure(((LivingSubNavActivity)LivingSubNavActivity.this).mNavInfo.biz + ((SubLiveNavItem)((LivingSubNavActivity)LivingSubNavActivity.this).mSubNavs.get((int)oldPosition)).biz + "idx", LivingSubNavActivity.this.mNavInfo, (SubLiveNavItem)LivingSubNavActivity.this.mSubNavs.get(oldPosition));
                }
                LivingSubNavActivity.this.mAdapter.getItem(position);
                ((IHomeCore)CoreManager.getCore(IHomeCore.class)).setSubActivityIndex(position);
            }
        }

        public void onPageScrollStateChanged(int state) {
        }
    };

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_living_sub_nav_layout);
        if (this.getIntent() != null) {
            this.mNavInfo = (LiveNavInfo)this.getIntent().getParcelableExtra(LIVING_NAV_INFO);
            this.mSubLiveItem = (SubLiveNavItem)this.getIntent().getParcelableExtra(SUB_NAV_INFO);
            this.tabId = this.getIntent().getIntExtra(SUB_NAV_TAB_ID, -1);
        }
        this.initPagerSlidingTab();
        this.initView();
        this.measureEditWidth();
    }

    private void initPagerSlidingTab() {
        this.mPagerSliding = (PagerSlidingTabStrip)this.findViewById(R.id.sub_top_tab_navs);
        this.mPagerSliding.setTypeface(null, 0);
        this.mPagerSliding.setShouldExpand(true);
        this.mPagerSliding.setUseFadeEffect(true);
        this.mPagerSliding.setFadeEnabled(true);
        this.mPagerSliding.setZoomMax(0.15f);
    }

    private void initView() {
        this.mViewPager = (SelectedViewPager)this.findViewById(R.id.pager);
        this.mViewPager.setOffscreenPageLimit(0);
        this.mImgBack = (ImageView)this.findViewById(R.id.sub_nav_back);
        this.mEdit = (RelativeLayout)this.findViewById(R.id.edit);
        this.mAdapter = new SubNavPagerAdapter(this.getSupportFragmentManager());
        this.setData();
        this.mViewPager.setAdapter((PagerAdapter)this.mAdapter);
        this.mPagerSliding.setViewPager((ViewPager)this.mViewPager);
        this.mPagerSliding.setOnPageChangeListener(this.mPageListener);
        this.mViewPager.setOffscreenPageLimit(2);
        this.mImgBack.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                LivingSubNavActivity.this.finish();
            }
        });
    }

    public void measureEditWidth() {
        ViewTreeObserver vto = this.mEdit.getViewTreeObserver();
        vto.addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                if (Build.VERSION.SDK_INT < 16) {
                    LivingSubNavActivity.this.mEdit.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                } else {
                    LivingSubNavActivity.this.mEdit.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
                if (LivingSubNavActivity.this.mSubNavs.size() <= 2) {
                    LivingSubNavActivity.this.mPagerSliding.setPadding(0, 0, LivingSubNavActivity.this.mEdit.getMeasuredWidth(), 0);
                } else {
                    LivingSubNavActivity.this.mPagerSliding.minusOffset(LivingSubNavActivity.this.mEdit.getMeasuredWidth());
                }
                LivingSubNavActivity.this.setCurrentTab();
            }
        });
    }

    private void setData() {
        if (this.mNavInfo != null && !FP.empty((Collection)this.mNavInfo.getNavs()) && this.mSubNavs != null) {
            this.mSubNavs.clear();
            this.mSubNavs.addAll(this.mNavInfo.getNavs());
        }
        if (this.mSubNavs.size() > 0) {
            this.mAdapter.setNavList(this.mSubNavs);
        }
    }

    private void setCurrentTab() {
        if (this.tabId != -1) {
            this.mViewPager.setCurrentItem(this.tabId);
            ((IHomeCore)CoreManager.getCore(IHomeCore.class)).setSubActivityIndex(this.tabId);
            if (this.tabId == 0) {
                this.mViewPager.setFirstOnPageSelected();
            }
        }
    }

    private class SubNavPagerAdapter
    extends FixedPageFragmentAdapter {
        private List<SubLiveNavItem> mNavList;
        private PagerFragment mCurrentView;

        SubNavPagerAdapter(FragmentManager fm) {
            super(fm);
            this.mNavList = new ArrayList<SubLiveNavItem>();
        }

        public void setPrimaryItem(ViewGroup container, int position, Object object) {
            this.mCurrentView = (PagerFragment)object;
        }

        public PagerFragment getPrimaryItem() {
            return this.mCurrentView;
        }

        public Fragment getItem(int position) {
            if (!FP.empty(this.mNavList)) {
                if (LivingSubNavActivity.this.mPagerSliding != null) {
                    ((IHomepageLiveCore)CoreFactory.getCore(IHomepageLiveCore.class)).setSubHomeCurPos(LivingSubNavActivity.this.mPagerSliding.getCurrentPosition());
                }
                if (this.mNavList.get((int)position).biz.equals("shenqu")) {
                    Postcard postcard = ARouter.getInstance().build("/TinyVideo/Music");
                    LogisticsCenter.completion((Postcard)postcard);
                    Class clz = postcard.getDestination();
                    return Fragment.instantiate((Context)LivingSubNavActivity.this.getBaseContext(), (String)clz.getName());
                }
                if (this.mNavList.get((int)position).biz.equals("duanpai")) {
                    Postcard postcard = ARouter.getInstance().build("/TinyVideo/Square");
                    LogisticsCenter.completion((Postcard)postcard);
                    Class clz = postcard.getDestination();
                    return Fragment.instantiate((Context)LivingSubNavActivity.this.getBaseContext(), (String)clz.getName());
                }
                return SubNavHomeFragment.newInstance(LivingSubNavActivity.this.mNavInfo, position, (SubLiveNavItem)LivingSubNavActivity.this.mNavInfo.getNavs().get(position));
            }
            return new PagerFragment();
        }

        public int getCount() {
            return this.mNavList.size();
        }

        public List<SubLiveNavItem> getData() {
            return this.mNavList;
        }

        public void setNavList(List<SubLiveNavItem> data) {
            if (this.mNavList != null) {
                this.mNavList.clear();
                this.mNavList.addAll(data);
            }
        }

        public CharSequence getPageTitle(int position) {
            return ((SubLiveNavItem)((LivingSubNavActivity)LivingSubNavActivity.this).mSubNavs.get((int)position)).name;
        }
    }
}

