/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.home;

import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import com.handmark.pulltorefresh.library.PullToRefreshBase;
import com.handmark.pulltorefresh.library.PullToRefreshListView;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.immersion.ImmersionBar;
import com.yy.mobile.baseapi.model.store.YYStore;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.model.ReqAction;
import com.yy.mobile.plugin.homeapi.action.ChangeViewInHomeActivityDirectionAction;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.plugin.main.events.IAuthClient_onKickOff_EventArgs;
import com.yy.mobile.plugin.main.events.ILivePushClient_onQueryLivePushList_EventArgs;
import com.yy.mobile.ui.BaseLinkFragment;
import com.yy.mobile.ui.home.BackHandledDispatcher;
import com.yy.mobile.ui.home.BackHandledListener;
import com.yy.mobile.ui.home.HomeLiveNoticeAdapter;
import com.yy.mobile.ui.home.LiveNoticeFragment$$EventBinder;
import com.yy.mobile.ui.utils.NavigationUtils;
import com.yy.mobile.ui.widget.extend.RxViewExt;
import com.yy.mobile.util.DimenConverter;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.ScreenUtil;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.livepush.ILivePushCore;
import io.reactivex.functions.Consumer;
import java.util.Collection;
import java.util.List;

public class LiveNoticeFragment
extends BaseLinkFragment
implements BackHandledListener {
    private static final String TAG = "LiveNoticeFragment";
    public static String TAG_FRAGMENT = "liveNotice";
    public static int FRAGMENT_STATE = 0;
    private TextView mLiveNoticeNumView;
    private View mLine;
    private PullToRefreshListView mListView;
    private static int PageNo = 1;
    private static int PageSize = 100;
    private HomeLiveNoticeAdapter mAapter;
    private View mLiveNoticeNoData;
    private View mLoginView;
    private View mStatusView;
    private int mItemHeight = 0;
    private int maxItemNum = 4;
    public static final int SHOW_LOADING = 1;
    public static final int SHOW_NOLOGIN = 2;
    public static final int SHOW_NODATA = 3;
    public static final int SHOW_LIST = 4;
    public static final int SHOW_TITLE = 5;
    public static final int SHOW_LINE = 6;
    public Runnable mTimeOut = new Runnable(){

        @Override
        public void run() {
            LiveNoticeFragment.this.hideStatus();
            LiveNoticeFragment.this.showView(3);
        }
    };
    private EventBinder mEventBinder;

    public static LiveNoticeFragment newInstance() {
        return new LiveNoticeFragment();
    }

    public static void attachToActivity(FragmentActivity act) {
        View view = act.findViewById(R.id.home_live_notice_fragment);
        if (view == null) {
            LinearLayout linearLayout = new LinearLayout((Context)act);
            linearLayout.setId(R.id.home_live_notice_fragment);
            ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-2, -2);
            act.addContentView((View)linearLayout, layoutParams);
        } else {
            view.setVisibility(0);
        }
        FRAGMENT_STATE = 1;
        ChangeViewInHomeActivityDirectionAction insertViewToHomeActivityPublicContainerAction = new ChangeViewInHomeActivityDirectionAction((Fragment)LiveNoticeFragment.newInstance(), R.id.home_live_notice_fragment, true, 0, false);
        insertViewToHomeActivityPublicContainerAction.setHomeViewDirection(1);
        YYStore.INSTANCE.dispatch((ReqAction)insertViewToHomeActivityPublicContainerAction);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_live_notice, container, false);
        this.initView(view);
        this.initData(view);
        return view;
    }

    public void showView(int currentShowId) {
        if (!this.checkActivityValid()) {
            return;
        }
        this.viewStateChange(this.mStatusView, 1, currentShowId);
        this.viewStateChange(this.mLoginView, 2, currentShowId);
        this.viewStateChange(this.mLiveNoticeNoData, 3, currentShowId);
        this.viewStateChange((View)this.mListView, 4, currentShowId);
        this.viewStateChange((View)this.mLiveNoticeNumView, 5, currentShowId);
        this.viewStateChange(this.mLine, 6, currentShowId);
    }

    private void viewStateChange(View view, int viewId, int currentShowId) {
        if (view != null) {
            if (viewId == currentShowId) {
                view.setVisibility(0);
            } else {
                view.setVisibility(8);
            }
        }
    }

    public void initData(View view) {
        this.mItemHeight = DimenConverter.dip2px((Context)this.getContext(), (float)64.0f);
        if (LoginUtil.isLogined()) {
            this.getHandler().postDelayed(this.mTimeOut, 10000L);
            ((ILivePushCore)ICoreManagerBase.getCore(ILivePushCore.class)).onLivePushList(LoginUtil.getUid(), 0, 0);
            this.showView(1);
            this.showLoading(view, 0, 0);
        } else {
            this.showView(2);
        }
    }

    private void initView(View view) {
        this.mStatusView = view.findViewById(R.id.status_layout);
        View mLiveNoticeBg1 = view.findViewById(R.id.live_notice_bg1);
        View mLiveNoticeBg2 = view.findViewById(R.id.live_notice_bg2);
        RxViewExt.safelyClicks((View)mLiveNoticeBg1, (Consumer)new Consumer<Object>(){

            public void accept(Object o) throws Exception {
                LiveNoticeFragment.this.removeFragment();
                ((ILivePushCore)CoreFactory.getCore(ILivePushCore.class)).reinvokeNoticeReq();
            }
        });
        RxViewExt.safelyClicks((View)mLiveNoticeBg2, (Consumer)new Consumer<Object>(){

            public void accept(Object o) throws Exception {
                LiveNoticeFragment.this.removeFragment();
                ((ILivePushCore)CoreFactory.getCore(ILivePushCore.class)).reinvokeNoticeReq();
            }
        });
        this.mLiveNoticeNumView = (TextView)view.findViewById(R.id.live_notice_num);
        this.mLine = view.findViewById(R.id.live_notice_split_line);
        this.mListView = (PullToRefreshListView)view.findViewById(R.id.live_notice_list);
        this.mListView.setMode(PullToRefreshBase.Mode.DISABLED);
        this.mAapter = new HomeLiveNoticeAdapter(this.getContext(), new HomeLiveNoticeAdapter.OnClickCallBack(){

            @Override
            public void cancelFollow(int size) {
                LiveNoticeFragment.this.mLiveNoticeNumView.setText((CharSequence)String.format("\u6b63\u5728\u76f4\u64ad(%d)", size));
                if (size == 0) {
                    LiveNoticeFragment.this.mListView.setVisibility(8);
                    LiveNoticeFragment.this.mLiveNoticeNoData.setVisibility(0);
                }
            }

            @Override
            public void itemClick() {
                LiveNoticeFragment.this.removeFragment();
            }
        });
        this.mListView.setAdapter((ListAdapter)this.mAapter);
        this.mLoginView = view.findViewById(R.id.live_notice_login);
        View loginBtn = view.findViewById(R.id.live_notice_login_btn);
        RxViewExt.safelyClicks((View)loginBtn, (Consumer)new Consumer<Object>(){

            public void accept(Object o) throws Exception {
                LiveNoticeFragment.this.removeFragment();
                NavigationUtils.toLogin(LiveNoticeFragment.this.getContext(), true, false);
            }
        });
        this.mLiveNoticeNoData = view.findViewById(R.id.live_notice_head_none_care);
        if (this.getActivity() instanceof BackHandledDispatcher) {
            ((BackHandledDispatcher)this.getActivity()).pushBackPressedListener((BackHandledListener)this);
        }
        if (ImmersionBar.needHandleStatusBar()) {
            RelativeLayout.LayoutParams lp = (RelativeLayout.LayoutParams)mLiveNoticeBg1.getLayoutParams();
            lp.height += ScreenUtil.getStatusBarHeight();
        }
    }

    @BusEvent
    public void onQueryLivePushList(ILivePushClient_onQueryLivePushList_EventArgs busEventArgs) {
        int result = busEventArgs.getResult();
        List list = busEventArgs.getList();
        long uid = busEventArgs.getUid();
        if (uid != LoginUtil.getUid()) {
            return;
        }
        this.getHandler().removeCallbacks(this.mTimeOut);
        this.hideStatus();
        if (result == 0 && !FP.empty((Collection)list)) {
            MLog.info((String)TAG, (String)("[onQueryLivePushList] list.size=" + list.size()));
            this.showView(4);
            this.mLiveNoticeNumView.setVisibility(0);
            this.mLine.setVisibility(0);
            ViewGroup.LayoutParams layoutParams = this.mListView.getLayoutParams();
            layoutParams.height = list.size() > this.maxItemNum ? this.maxItemNum * this.mItemHeight + this.mItemHeight / 2 : list.size() * this.mItemHeight + DimenConverter.dip2px((Context)this.getContext(), (float)2.0f);
            this.mListView.setLayoutParams(layoutParams);
            this.mLiveNoticeNumView.setText((CharSequence)String.format("\u6b63\u5728\u76f4\u64ad(%d)", list.size()));
            this.mAapter.setData(list);
        } else {
            this.showView(3);
            MLog.warn((String)TAG, (String)("[onQueryLivePushList] result=" + result + ",list.size=" + (list == null ? "null" : Integer.valueOf(list.size()))));
        }
    }

    public void removeFragment() {
        if (!this.checkActivityValid()) {
            return;
        }
        YYStore.INSTANCE.dispatch((ReqAction)new ChangeViewInHomeActivityDirectionAction((Fragment)this, R.id.home_live_notice_fragment, false, 0, false));
        FRAGMENT_STATE = 2;
        View fView = this.getActivity().findViewById(R.id.home_live_notice_fragment);
        if (fView != null) {
            fView.setVisibility(8);
        }
    }

    @BusEvent
    public void onKickOff(IAuthClient_onKickOff_EventArgs busEventArgs) {
        this.removeFragment();
    }

    public void onDestroyView() {
        if (this.checkActivityValid() && this.getActivity() instanceof BackHandledDispatcher) {
            ((BackHandledDispatcher)this.getActivity()).popBackPressedListener(this.hashCode());
        }
        super.onDestroyView();
    }

    public void onBackPressed() {
        this.removeFragment();
    }

    public void onEventBind() {
        super.onEventBind();
        if (this.mEventBinder == null) {
            this.mEventBinder = new LiveNoticeFragment$$EventBinder();
        }
        this.mEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mEventBinder != null) {
            this.mEventBinder.unBindEvent();
        }
    }
}

