/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.home;

import android.app.Activity;
import android.content.Context;
import android.net.Uri;
import android.os.Looper;
import android.text.SpannableStringBuilder;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.fragment.app.FragmentActivity;
import com.example.configcenter.Publess;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.annotation.sneak.DartsRegister;
import com.yy.android.sniper.api.event.EmptyEventCompat;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.mobile.RxBus;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.http.BaseNetData;
import com.yy.mobile.http.CronetMain;
import com.yy.mobile.http.RequestError;
import com.yy.mobile.http.RequestManager;
import com.yy.mobile.http.ResponseErrorListener;
import com.yy.mobile.http.ResponseListener;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.plugin.main.events.IAuthClient_onKickOff_EventArgs;
import com.yy.mobile.plugin.main.events.IAuthClient_onLoginSucceed_EventArgs;
import com.yy.mobile.plugin.main.events.IAuthClient_onLogout_EventArgs;
import com.yy.mobile.plugin.main.events.ILiveClient_hideLiveNoticeViewTips_EventArgs;
import com.yy.mobile.plugin.main.events.ILiveClient_hideLiveNoticeView_EventArgs;
import com.yy.mobile.plugin.main.events.ILiveClient_updateLiveNoticeView_EventArgs;
import com.yy.mobile.plugin.main.events.ILivePushClient_onGetTimeConfig_EventArgs;
import com.yy.mobile.plugin.main.events.LiveNoticeLivingCountEvent;
import com.yy.mobile.plugin.main.events.NewUpdateLiveNoticeViewEventArgs;
import com.yy.mobile.ui.basicfunction.livenotice.model.SubscriptionInfo;
import com.yy.mobile.ui.home.FollowTab;
import com.yy.mobile.ui.home.LiveNoticeController$$EventBinder;
import com.yy.mobile.ui.home.LiveNoticeFragment;
import com.yy.mobile.ui.home.follow.FollowNoticeInfo;
import com.yy.mobile.ui.home.follow.FollowNoticeInfoKt;
import com.yy.mobile.util.DimenConverter;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.SafeDispatchHandler;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.CoreManager;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.UrlSettings;
import com.yymobile.core.base.ILiveNotice;
import com.yymobile.core.config.model.LiveNoticeData;
import com.yymobile.core.livepush.ILivePushCore;
import com.yymobile.core.statistic.IHiidoStatisticCore;
import com.yymobile.core.subscribe.ISubscribeCore;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@DartsRegister(dependent=ILiveNotice.class)
public class LiveNoticeController
extends EmptyEventCompat
implements ILiveNotice {
    private static final String TAG = "LiveNoticeController";
    private static final int TIME_UNIT = 60000;
    public static int SHOW_TIME = 5000;
    public static int TIME_INTERVAL = 120000;
    public static int CONFIG_TIME_INTERVAL = -1;
    private SpannableStringBuilder builder;
    private int mShowLiveNoticeRedHot = 0;
    private int mShowLiveNoticeTips = 0;
    private List<SubscriptionInfo> lastListData = new ArrayList<SubscriptionInfo>();
    private List<SubscriptionInfo> newestLiveList = new ArrayList<SubscriptionInfo>();
    private SafeDispatchHandler mHandler = new SafeDispatchHandler(Looper.getMainLooper());
    private Gson mGson = new Gson();
    private ResponseListener<String> mResponseListener = new ResponseListener<String>(){

        public void onResponse(String response) {
            MLog.debug((String)LiveNoticeController.TAG, (String)("[onResponse] response = " + response));
            Type jsonType = new TypeToken<BaseNetData<ArrayList<FollowNoticeInfo>>>(){}.getType();
            BaseNetData netData = (BaseNetData)LiveNoticeController.this.mGson.fromJson(response, jsonType);
            if (netData.getCode() != 0) {
                MLog.error((String)LiveNoticeController.TAG, (String)("[onResponse] code = " + netData.getCode() + ", message = " + netData.getMessage()));
                return;
            }
            ArrayList data = (ArrayList)netData.getData();
            if (data == null || data.isEmpty()) {
                MLog.info((String)LiveNoticeController.TAG, (String)"[onErrorResponse] data is empty");
                ((ILivePushCore)CoreFactory.getCore(ILivePushCore.class)).setDisplayStateFirst(false);
                if (!LiveNoticeController.this.lastListData.isEmpty()) {
                    LiveNoticeController.this.lastListData.clear();
                }
                return;
            }
            RxBus.getDefault().post((Object)new LiveNoticeLivingCountEvent(data.size()));
            List<SubscriptionInfo> list = FollowNoticeInfoKt.converToSubscription(data);
            if (((ILivePushCore)CoreFactory.getCore(ILivePushCore.class)).isDisplayedFirst()) {
                LiveNoticeController.this.lastListData.clear();
                LiveNoticeController.this.lastListData.addAll(list);
                LiveNoticeController.this.setLiveNoticeRedHotstate(1);
                LiveNoticeController.this.setLiveNoticeTips(1);
                ((ISubscribeCore)CoreFactory.getCore(ISubscribeCore.class)).updateBookAnchorLivingTipsShowState(true);
                LiveNoticeController.this.builder = FollowTab.INSTANCE.generateLiveNoticeSpannableBuilder(String.valueOf(list.size()), "", "\u4e2a\u5173\u6ce8\u4e3b\u64ad\u6b63\u5728\u76f4\u64ad");
                LiveNoticeController.this.notifyUIChange(false, null);
                MLog.debug((String)LiveNoticeController.TAG, (String)("[NewUpdateLiveNoticeViewEventArgs]" + list.get(0)));
                RxBus.getDefault().post((Object)new NewUpdateLiveNoticeViewEventArgs(list.get(0)));
                ((ILivePushCore)CoreFactory.getCore(ILivePushCore.class)).setDisplayStateFirst(false);
            } else {
                if (LiveNoticeController.this.newestLiveList == null) {
                    LiveNoticeController.this.newestLiveList = new ArrayList();
                }
                LiveNoticeController.this.newestLiveList.clear();
                LiveNoticeController.this.newestLiveList.addAll(list);
                for (int i = 0; i < list.size(); ++i) {
                    for (SubscriptionInfo info : LiveNoticeController.this.lastListData) {
                        if (!list.get(i).equals((Object)info)) continue;
                        LiveNoticeController.this.newestLiveList.remove(info);
                    }
                }
                if (!LiveNoticeController.this.newestLiveList.isEmpty()) {
                    if (!FollowTab.INSTANCE.isNeedShowNewLiveNotice()) {
                        return;
                    }
                    LiveNoticeController.this.setLiveNoticeRedHotstate(1);
                    LiveNoticeController.this.setLiveNoticeTips(1);
                    ((ISubscribeCore)CoreFactory.getCore(ISubscribeCore.class)).updateBookAnchorLivingTipsShowState(true);
                    SubscriptionInfo subscriptionInfo = (SubscriptionInfo)LiveNoticeController.this.newestLiveList.get(0);
                    LiveNoticeController.this.builder = FollowTab.INSTANCE.generateLiveNoticeSpannableBuilder(subscriptionInfo.getName(), "", "\u6b63\u5728\u5f00\u64ad");
                    MLog.debug((String)LiveNoticeController.TAG, (String)("[NewUpdateLiveNoticeViewEventArgs]" + subscriptionInfo));
                    RxBus.getDefault().post((Object)new NewUpdateLiveNoticeViewEventArgs(subscriptionInfo));
                    LiveNoticeController.this.notifyUIChange(true, subscriptionInfo);
                }
                if (!LiveNoticeController.this.lastListData.isEmpty()) {
                    LiveNoticeController.this.lastListData.clear();
                }
                LiveNoticeController.this.lastListData.addAll(list);
            }
        }
    };
    private ResponseErrorListener mResponseErrorListener = new ResponseErrorListener(){

        public void onErrorResponse(RequestError error) {
            MLog.error((Object)LiveNoticeController.TAG, (String)"[onErrorResponse] error = ", (Throwable)error, (Object[])new Object[0]);
            ((ILivePushCore)CoreFactory.getCore(ILivePushCore.class)).setDisplayStateFirst(false);
            if (!LiveNoticeController.this.lastListData.isEmpty()) {
                LiveNoticeController.this.lastListData.clear();
            }
        }
    };
    private Runnable runnable = new Runnable(){

        @Override
        public void run() {
            MLog.info((String)LiveNoticeController.TAG, (String)"onLivePushList");
            Uri uri = Uri.parse((String)UrlSettings.FOLLOW_HOST_URL).buildUpon().appendPath("notice").appendPath("list").appendQueryParameter("uid", String.valueOf(LoginUtil.getUid())).build();
            Map headers = CronetMain.INSTANCE.buildCronetHeaderHigh("main_page");
            RequestManager.instance().submitStringQueryRequest(uri.toString(), null, headers, LiveNoticeController.this.mResponseListener, LiveNoticeController.this.mResponseErrorListener, true);
            LiveNoticeController.this.mHandler.postDelayed(LiveNoticeController.this.runnable, (long)TIME_INTERVAL);
        }
    };
    private EventBinder mEventBinder;

    public LiveNoticeController() {
        CoreManager.addClient((Object)((Object)this));
        if (LoginUtil.isLogined() && ((ILivePushCore)CoreFactory.getCore(ILivePushCore.class)).isDisplayedFirst()) {
            ((ILivePushCore)ICoreManagerBase.getCore(ILivePushCore.class)).onLivePushList(LoginUtil.getUid(), 0, 0);
        }
        if (CONFIG_TIME_INTERVAL == -1) {
            ((ILivePushCore)CoreManager.getCore(ILivePushCore.class)).getTimeConfig();
        }
    }

    public static View createLiveNoticeView(Activity act) {
        if (act == null) {
            return null;
        }
        LiveNoticeController.init();
        View liveNoticeView = act.getLayoutInflater().inflate(R.layout.fragment_live_right_view, null);
        return liveNoticeView;
    }

    public static TextView createLiveNoticeTips(Activity act) {
        if (act == null) {
            return null;
        }
        LiveNoticeController.init();
        TextView tipsView = (TextView)act.getLayoutInflater().inflate(R.layout.layout_live_notice_tips, null);
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(-2, -2);
        lp.setMargins(0, DimenConverter.dip2px((Context)act, (float)40.0f), DimenConverter.dip2px((Context)act, (float)5.0f), 0);
        lp.addRule(11);
        tipsView.setLayoutParams((ViewGroup.LayoutParams)lp);
        return tipsView;
    }

    public static LiveNoticeController init() {
        return (LiveNoticeController)((Object)CoreFactory.getCore(ILiveNotice.class));
    }

    public static void showLiveNoticeList(FragmentActivity act) {
        if (act == null) {
            return;
        }
        LiveNoticeController.init();
        LiveNoticeFragment.attachToActivity(act);
        ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "50010", "0001");
    }

    public static LiveNoticeController getInstance() {
        return LiveNoticeController.init();
    }

    public SpannableStringBuilder getNeedShowString() {
        return this.builder;
    }

    public int getLiveNoticeRedHotState() {
        return this.mShowLiveNoticeRedHot;
    }

    public void setLiveNoticeRedHotstate(int state) {
        this.mShowLiveNoticeRedHot = state;
    }

    public int getLiveNoticeTips() {
        return this.mShowLiveNoticeTips;
    }

    public void setLiveNoticeTips(int state) {
        this.mShowLiveNoticeTips = state;
    }

    @BusEvent
    public void onLoginSucceed(IAuthClient_onLoginSucceed_EventArgs busEventArgs) {
        if (!((ISubscribeCore)CoreFactory.getCore(ISubscribeCore.class)).queryBookAnchorLivingTipsShowState()) {
            ((ILivePushCore)CoreManager.getCore(ILivePushCore.class)).onLivePushList(LoginUtil.getUid(), 0, 0);
        }
    }

    @BusEvent
    public void onLogout(IAuthClient_onLogout_EventArgs busEventArgs) {
        this.mShowLiveNoticeRedHot = 0;
        this.mShowLiveNoticeTips = 0;
        this.notifyHideUi();
        this.lastListData.clear();
        ((ILivePushCore)CoreFactory.getCore(ILivePushCore.class)).setDisplayStateFirst(true);
        this.removeRequest();
    }

    @BusEvent
    public void onKickOff(IAuthClient_onKickOff_EventArgs busEventArgs) {
        this.mShowLiveNoticeRedHot = 0;
        this.mShowLiveNoticeTips = 0;
        this.notifyHideUi();
        this.lastListData.clear();
        ((ILivePushCore)CoreFactory.getCore(ILivePushCore.class)).setDisplayStateFirst(true);
        this.removeRequest();
    }

    private void notifyUIChange(boolean isNewStartLive, SubscriptionInfo subscriptionInfo) {
        ILiveClient_updateLiveNoticeView_EventArgs event = new ILiveClient_updateLiveNoticeView_EventArgs(this.builder, isNewStartLive);
        event.subscriptionInfo = subscriptionInfo;
        RxBus.getDefault().post((Object)event);
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                RxBus.getDefault().post((Object)new ILiveClient_hideLiveNoticeViewTips_EventArgs());
            }
        }, (long)SHOW_TIME);
    }

    private void notifyHideUi() {
        RxBus.getDefault().post((Object)new ILiveClient_hideLiveNoticeView_EventArgs());
    }

    @BusEvent
    public void onGetTimeConfig(ILivePushClient_onGetTimeConfig_EventArgs busEventArgs) {
        MLog.info((String)TAG, (String)"onGetTimeConfig");
        LiveNoticeData data = (LiveNoticeData)Publess.of(LiveNoticeData.class).getData();
        if (data != null && !FP.empty((CharSequence)data.key1)) {
            MLog.info((String)TAG, (String)("onGetTimeConfig config = " + data.toString()));
            CONFIG_TIME_INTERVAL = TIME_INTERVAL = Integer.parseInt(data.key1) * 60000;
        }
    }

    public void requestNoticeData() {
        this.requestLiveNotice();
    }

    public void requestLiveNotice() {
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((String)TAG, (String)("[requestLiveNotice runnable]" + this.runnable));
        }
        this.mHandler.removeCallbacks(this.runnable);
        this.mHandler.postDelayed(this.runnable, (long)TIME_INTERVAL);
    }

    public void requestNoticeDataImmediately() {
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((String)TAG, (String)("[requestNoticeDataImmediately] runnable" + this.runnable));
        }
        this.mHandler.removeCallbacks(this.runnable);
        this.mHandler.post(this.runnable);
    }

    public void removeRequest() {
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((String)TAG, (String)"[removeRequest]");
        }
        this.mHandler.removeCallbacks(this.runnable);
    }

    public void onEventBind() {
        super.onEventBind();
        if (this.mEventBinder == null) {
            this.mEventBinder = new LiveNoticeController$$EventBinder();
        }
        this.mEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mEventBinder != null) {
            this.mEventBinder.unBindEvent();
        }
    }
}

