/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.home;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.PopupWindow;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.android.sniper.api.event.EventCompat;
import com.yy.hiidostatis.defs.obj.Property;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.plugin.main.PluginBus;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.plugin.main.events.ISocialCoreClient_onRequestPrvList_EventArgs;
import com.yy.mobile.plugin.main.events.ISocialCoreClient_onResetPageNo_EventArgs;
import com.yy.mobile.plugin.main.events.ISocialCoreClient_onUpdateProvList_EventArgs;
import com.yy.mobile.ui.home.LiveLocationController$$EventBinder;
import com.yy.mobile.ui.utils.DimensUtils;
import com.yy.mobile.util.DimenConverter;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.CoreManager;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.social.INearCore;
import com.yymobile.core.statistic.IHiidoStatisticCore;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class LiveLocationController
extends RelativeLayout
implements EventCompat,
View.OnClickListener {
    private View mBtnLocationView;
    private TextView mTvLocation;
    private PopupWindow mLocationPopup;
    private View mLocationView;
    private View mLocationLoading;
    private View mLocationContain;
    private ListView mLocationList;
    private View mLocationCancel;
    private Context mContext;
    private INearCore mCore;
    private PrvListAdapter mPrvListAdapter;
    private EventBinder mEventBinder;

    public void onEventBind() {
        if (this.mEventBinder == null) {
            this.mEventBinder = new LiveLocationController$$EventBinder();
        }
        this.mEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        if (this.mEventBinder != null) {
            this.mEventBinder.unBindEvent();
        }
    }

    public LiveLocationController(Context context, Bundle bundle) {
        super(context);
        this.mContext = context;
        this.mCore = (INearCore)CoreManager.getCore(INearCore.class);
        ICoreManagerBase.addClient((Object)((Object)this));
        this.mBtnLocationView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.fragment_live_location_view, (ViewGroup)this, true);
        if (bundle != null) {
            int w = bundle.getInt("LiveLocationController_Width", -2);
            int h = bundle.getInt("LiveLocationController_Height", -2);
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(w, h);
            this.mBtnLocationView.setLayoutParams((ViewGroup.LayoutParams)params);
        }
        this.mTvLocation = (TextView)this.mBtnLocationView.findViewById(R.id.tv_live_location);
        RelativeLayout.LayoutParams params4Tv = new RelativeLayout.LayoutParams(-2, -2);
        params4Tv.addRule(15, -1);
        this.mTvLocation.setLayoutParams((ViewGroup.LayoutParams)params4Tv);
        this.mTvLocation.setOnClickListener((View.OnClickListener)this);
    }

    public LiveLocationController(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.mCore = (INearCore)CoreManager.getCore(INearCore.class);
        ICoreManagerBase.addClient((Object)((Object)this));
        this.mBtnLocationView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.fragment_live_location_view, (ViewGroup)this, true);
        this.mBtnLocationView.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-2, -2));
        this.mTvLocation = (TextView)this.mBtnLocationView.findViewById(R.id.tv_live_location);
        this.mTvLocation.setOnClickListener((View.OnClickListener)this);
        this.mTvLocation.setGravity(16);
    }

    public void onDestroy() {
        ICoreManagerBase.removeClient((Object)((Object)this));
    }

    private void openLocationPopup() {
        if (this.mLocationPopup == null) {
            this.mLocationView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.layout_location_select_list, null);
            this.mLocationLoading = this.mLocationView.findViewById(R.id.tv_location_list_loading);
            this.mLocationContain = this.mLocationView.findViewById(R.id.ll_location_list_contain);
            this.mLocationList = (ListView)this.mLocationView.findViewById(R.id.lv_location_list);
            this.mPrvListAdapter = new PrvListAdapter();
            this.mLocationList.setAdapter((ListAdapter)this.mPrvListAdapter);
            this.mLocationCancel = this.mLocationView.findViewById(R.id.tv_location_cancel);
            this.mLocationCancel.setOnClickListener((View.OnClickListener)this);
            this.mLocationList.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                    LiveLocationController.this.mLocationPopup.dismiss();
                    String location = (String)LiveLocationController.this.mPrvListAdapter.getItem(position);
                    LiveLocationController.this.mTvLocation.setText((CharSequence)location);
                    LiveLocationController.this.mCore.setSelectedLocation(location);
                    LiveLocationController.this.mCore.requestNearByLive(1);
                    PluginBus.INSTANCE.get().post((Object)new ISocialCoreClient_onResetPageNo_EventArgs(1));
                    Property property = new Property();
                    property.putString("key1", location);
                    ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "52301", "0007", (Serializable)property);
                }
            });
        }
        this.mLocationPopup = new PopupWindow(this.mContext);
        this.mLocationPopup.setContentView(this.mLocationView);
        this.mLocationPopup.setBackgroundDrawable((Drawable)new BitmapDrawable());
        this.mLocationPopup.setOutsideTouchable(true);
        this.mLocationPopup.setFocusable(true);
        WindowManager.LayoutParams lp = ((Activity)this.mContext).getWindow().getAttributes();
        lp.alpha = 0.4f;
        ((Activity)this.mContext).getWindow().addFlags(2);
        ((Activity)this.mContext).getWindow().setAttributes(lp);
        this.mLocationPopup.setAnimationStyle(R.style.location_popupwindow_anim_style);
        this.mLocationPopup.setWidth(-1);
        this.mLocationPopup.setHeight(DimenConverter.dip2px((Context)this.mContext, (float)366.0f));
        this.mLocationPopup.showAtLocation((View)this, 80, 0, 0);
        this.mLocationPopup.setOnDismissListener(new PopupWindow.OnDismissListener(){

            public void onDismiss() {
                if (LiveLocationController.this.mContext != null && !((Activity)LiveLocationController.this.mContext).isFinishing()) {
                    WindowManager.LayoutParams lp = ((Activity)LiveLocationController.this.mContext).getWindow().getAttributes();
                    lp.alpha = 1.0f;
                    ((Activity)LiveLocationController.this.mContext).getWindow().setAttributes(lp);
                }
            }
        });
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.tv_location_cancel) {
            this.mLocationPopup.dismiss();
        } else if (id2 == R.id.tv_live_location) {
            if (this.mLocationPopup != null) {
                this.mLocationPopup.dismiss();
            }
            this.openLocationPopup();
            this.mCore.requestPrvList();
            ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "52301", "0006");
        }
    }

    @BusEvent(busType=1, busName="plugin_main")
    public void onRequestPrvList(ISocialCoreClient_onRequestPrvList_EventArgs busEventArgs) {
        List prvList = busEventArgs.getPrvList();
        if (null != prvList && prvList.size() > 0) {
            this.mLocationLoading.setVisibility(8);
            this.mLocationContain.setVisibility(0);
            this.mPrvListAdapter.setPrvDatas(prvList);
        }
    }

    @BusEvent(busType=1, busName="plugin_main")
    public void onUpdateProvList(ISocialCoreClient_onUpdateProvList_EventArgs busEventArgs) {
        List datas = busEventArgs.getDatas();
        if (this.mPrvListAdapter != null) {
            this.mPrvListAdapter.setPrvDatas(datas);
        }
    }

    static class ViewHolder {
        TextView tvDesp;
        TextView tvGps;
        ImageView ivSelected;

        ViewHolder() {
        }
    }

    class PrvListAdapter
    extends BaseAdapter {
        List<String> prvDatas = new ArrayList<String>();
        String gpsProvinde;
        float optTextSize;
        float defaultTextSize;

        PrvListAdapter() {
            this.gpsProvinde = LiveLocationController.this.mCore.getGpsProvince();
            this.optTextSize = DimensUtils.pixel2sp((Context)LiveLocationController.this.mContext, (float)LiveLocationController.this.mContext.getResources().getDimensionPixelOffset(R.dimen.location_list_item_opt_text_size));
            this.defaultTextSize = DimensUtils.pixel2sp((Context)LiveLocationController.this.mContext, (float)LiveLocationController.this.mContext.getResources().getDimensionPixelSize(R.dimen.location_list_item_text_size));
        }

        public void setPrvDatas(List<String> datas) {
            this.prvDatas.clear();
            this.prvDatas.addAll(datas);
            LiveLocationController.this.mCore.sortPrvList(this.prvDatas);
            this.notifyDataSetChanged();
        }

        public List getItems() {
            return this.prvDatas;
        }

        public int getCount() {
            return this.prvDatas.size();
        }

        public Object getItem(int position) {
            return this.prvDatas.get(position);
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            ViewHolder vh;
            if (convertView == null) {
                convertView = LayoutInflater.from((Context)LiveLocationController.this.mContext).inflate(R.layout.item_location_select_list, null);
                vh = new ViewHolder();
                vh.tvDesp = (TextView)convertView.findViewById(R.id.tv_location_description);
                vh.tvGps = (TextView)convertView.findViewById(R.id.tv_location_gps);
                vh.ivSelected = (ImageView)convertView.findViewById(R.id.iv_location_selected);
                convertView.setTag((Object)vh);
            } else {
                vh = (ViewHolder)convertView.getTag();
            }
            if (!TextUtils.isEmpty((CharSequence)this.gpsProvinde) && this.gpsProvinde.contains(this.prvDatas.get(position))) {
                vh.tvGps.setVisibility(0);
            } else {
                vh.tvGps.setVisibility(8);
            }
            if (LiveLocationController.this.mCore.getSelectedLocation().equals(this.prvDatas.get(position))) {
                vh.ivSelected.setVisibility(0);
                vh.tvDesp.setTextSize(this.optTextSize);
                vh.tvGps.setTextSize(this.optTextSize);
                this.setBold(vh.tvDesp, true);
                this.setBold(vh.tvGps, true);
            } else {
                vh.ivSelected.setVisibility(8);
                vh.tvDesp.setTextSize(this.defaultTextSize);
                vh.tvGps.setTextSize(this.defaultTextSize);
                this.setBold(vh.tvDesp, false);
                this.setBold(vh.tvGps, false);
            }
            vh.tvDesp.setText((CharSequence)this.prvDatas.get(position));
            return convertView;
        }

        private void setBold(TextView tv, boolean b) {
            TextPaint tp = tv.getPaint();
            tp.setFakeBoldText(b);
        }
    }
}

