/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.home;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import com.yy.hiidostatis.defs.obj.Property;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.image.CircleImageView;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.ui.basicfunction.livenotice.model.SubscriptionInfo;
import com.yy.mobile.util.FP;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.CoreManager;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.channel.slipchannel.ISlipChannelCore;
import com.yymobile.core.channel.slipchannel.SlipParam;
import com.yymobile.core.live.livecore.JoinChannelIntent;
import com.yymobile.core.statistic.IHiidoStatisticCore;
import com.yymobilecore.R;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class HomeLiveNoticeAdapter
extends BaseAdapter {
    protected List<SubscriptionInfo> mSubscripInfo = new ArrayList<SubscriptionInfo>();
    public OnClickCallBack mCallBack = null;
    private Set<Integer> alreadyReportPosition = new HashSet<Integer>();
    private Context mContext;

    public HomeLiveNoticeAdapter(Context mContext, OnClickCallBack callBack) {
        this.mContext = mContext;
        this.mCallBack = callBack;
    }

    public int getCount() {
        return this.mSubscripInfo.size();
    }

    public SubscriptionInfo getItem(int position) {
        if (position >= this.mSubscripInfo.size()) {
            position = this.mSubscripInfo.size() - 1;
        }
        return this.mSubscripInfo.get(position);
    }

    public long getItemId(int position) {
        if (position >= this.mSubscripInfo.size()) {
            position = this.mSubscripInfo.size() - 1;
        }
        return this.mSubscripInfo.get((int)position).liveId;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        if (convertView == null) {
            convertView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.layout_live_notice_item, parent, false);
            ViewHolder holder = new ViewHolder(convertView);
            convertView.setTag((Object)holder);
        }
        this.updateViewData(position, (ViewHolder)convertView.getTag(), convertView, position);
        return convertView;
    }

    private void updateViewData(final int position, ViewHolder viewHolder, View convertView, int pos) {
        final SubscriptionInfo item = this.getItem(position);
        ImageLoader.loadImage((RecycleImageView)viewHolder.portraitIv, (String)item.thumb, (int)R.drawable.default_portrait);
        viewHolder.tvLiveTime.setText((CharSequence)this.formatTime(item.liveTime));
        if (item.anchorAuthV != null && !item.anchorAuthV.isEmpty()) {
            if (item.anchorAuthV.equals("0")) {
                viewHolder.anchorAuthV.setVisibility(8);
            } else if (item.anchorAuthV.equals("1")) {
                viewHolder.anchorAuthV.setBackgroundResource(R.drawable.common_portrait_auth_v_1);
                viewHolder.anchorAuthV.setVisibility(0);
            } else if (item.anchorAuthV.equals("2")) {
                viewHolder.anchorAuthV.setBackgroundResource(R.drawable.common_portrait_auth_v_10);
                viewHolder.anchorAuthV.setVisibility(0);
            }
        } else {
            viewHolder.anchorAuthV.setVisibility(8);
        }
        viewHolder.name.setText((CharSequence)item.stageName);
        if (!FP.empty((CharSequence)item.liveDesc)) {
            viewHolder.tvDesc.setVisibility(0);
            if (item.liveDesc.length() > 15) {
                viewHolder.tvDesc.setText((CharSequence)(item.liveDesc.substring(0, 15) + "..."));
            } else {
                viewHolder.tvDesc.setText((CharSequence)item.liveDesc);
            }
        } else {
            viewHolder.tvDesc.setText((CharSequence)"\u6211\u5728YY\u76f4\u64ad\u7b49\u4f60...");
            viewHolder.tvDesc.setVisibility(0);
        }
        viewHolder.ivLove.setVisibility(item.isLove ? 0 : 8);
        convertView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (HomeLiveNoticeAdapter.this.mCallBack != null) {
                    HomeLiveNoticeAdapter.this.mCallBack.itemClick();
                }
                if (ICoreManagerBase.getCore(ISlipChannelCore.class) != null) {
                    ((ISlipChannelCore)ICoreManagerBase.getCore(ISlipChannelCore.class)).setSlipParam(16, new SlipParam());
                }
                JoinChannelIntent.instance((long)item.sid, (long)item.ssid).anchorUid(item.liveId).templateId(item.templateId).token(item.token).src(4).build().joinChannel(HomeLiveNoticeAdapter.this.mContext);
                Property p = new Property();
                p.putString("key1", String.valueOf(item.sid));
                p.putString("key2", String.valueOf(item.liveId));
                p.putString("key3", String.valueOf(position + 1));
                p.putString("key4", item.token);
                ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "50010", "0002", (Serializable)p);
            }
        });
        if (!this.alreadyReportPosition.contains(position)) {
            this.alreadyReportPosition.add(position);
            Property property = new Property();
            property.putString("key1", item.sid + "_" + item.liveId + "_" + (position + 1) + "_" + item.token);
            ((IHiidoStatisticCore)CoreManager.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "50010", "0003", (Serializable)property);
        }
    }

    private String formatTime(int time) {
        if (time <= 0) {
            return "\u5f00\u64ad0\u5206\u949f";
        }
        if (time < 60) {
            return "\u5f00\u64ad" + String.valueOf(time) + "\u5206\u949f";
        }
        int hours = time / 60;
        int minutes = time - hours * 60;
        return "\u5f00\u64ad" + hours + "\u5c0f\u65f6" + minutes + "\u5206\u949f";
    }

    public void setData(List<SubscriptionInfo> info) {
        if (!FP.empty(info)) {
            this.mSubscripInfo.clear();
            this.mSubscripInfo.addAll(info);
            this.notifyDataSetChanged();
        }
    }

    public static final class ViewHolder {
        public CircleImageView portraitIv;
        public CircleImageView anchorAuthV;
        public TextView name;
        public TextView tvDesc;
        public TextView tvLiveTime;
        public ImageView ivLove;

        public ViewHolder(View itemView) {
            this.portraitIv = (CircleImageView)itemView.findViewById(R.id.iv_portrait_headIcon);
            this.anchorAuthV = (CircleImageView)itemView.findViewById(R.id.iv_portrait_authVIcon);
            this.name = (TextView)itemView.findViewById(R.id.tv_name);
            this.tvLiveTime = (TextView)itemView.findViewById(R.id.tv_live_time);
            this.tvDesc = (TextView)itemView.findViewById(R.id.tv_desclive_name);
            this.ivLove = (ImageView)itemView.findViewById(R.id.iv_love);
        }
    }

    public static interface OnClickCallBack {
        public void cancelFollow(int var1);

        public void itemClick();
    }
}

