/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.gallery.barrag;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.text.Spannable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.RequestOptions;
import com.bumptech.glide.request.target.SimpleTarget;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.request.transition.Transition;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.image.CircleImageView;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.richtext.RichTextManager;
import com.yy.mobile.ui.gallery.barrag.BubbleBarragView;
import com.yy.mobile.ui.home.FaceHelperFactory;
import com.yy.mobile.ui.utils.SingleToastUtil;
import com.yy.mobile.util.FaceHelper;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.gallery.module.CommentInfo;
import java.util.ArrayList;
import java.util.List;

public class BubbleView
extends RelativeLayout {
    private static final String TAG = "BubbleView";
    public boolean touchable = true;
    public long anchorId = 0L;
    public long albumId = 0L;
    public long photoId = 0L;
    public long commentId = 0L;
    private View.OnClickListener clickListener;
    private List<RichTextManager.Feature> features = new ArrayList<RichTextManager.Feature>();
    private RelativeLayout.LayoutParams myBarragLp;
    private ImageView barragBg;
    private ImageView praiseIcon;
    private TextView contentTxt;
    private TextView praiseTxt;
    private CircleImageView head;
    private View praiseLayout;
    private Canvas barragCanvas = new Canvas();
    private AnimatorSet animatorSet;
    private AccelerateInterpolator lin;
    private String[] barragColors = new String[]{"#605f55", "#387E8D", "#4A5A8D", "#A84D6B"};
    private int screenWidth;
    private int screenHeight;
    private int viewWidth = 0;
    private int viewHeight = 0;
    private int lastX = 0;
    private int lastY = 0;
    private int mWidth = 0;
    private int mHeight = 0;
    private boolean headIsLeft = true;
    private boolean headIsTop = true;
    private int imlogoLoc = 1;
    private boolean hasPraise = false;

    public BubbleView(Context context, int sw, int sh, int vw, int vh) {
        super(context);
        this.screenWidth = sw;
        this.screenHeight = sh;
        this.viewWidth = vw;
        this.viewHeight = vh;
        this.init(context);
    }

    public BubbleView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    private void init(Context context) {
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        inflater.inflate(R.layout.layout_bubble_barrag, (ViewGroup)this);
        this.features.add(RichTextManager.Feature.EMOTICON);
        this.lin = new AccelerateInterpolator();
        this.contentTxt = (TextView)this.findViewById(R.id.contentTxt);
        this.barragBg = (ImageView)this.findViewById(R.id.barrag_bg);
        this.head = (CircleImageView)this.findViewById(R.id.bubble_barrag_head);
        this.praiseLayout = this.findViewById(R.id.praise_layout);
        this.praiseIcon = (ImageView)this.findViewById(R.id.praiseIcon);
        this.praiseTxt = (TextView)this.findViewById(R.id.praiseTxt);
    }

    public void loadHeadLogo(String url) {
        MLog.debug((Object)TAG, (String)"loadHeadLogo:%s", (Object[])new Object[]{url});
        this.loadHeadLogo(url, -1);
    }

    public void loadHeadLogo(String url, int iconIndex) {
        FaceHelper.loadFace((String)url, (int)iconIndex, (FaceHelperFactory.FaceType)FaceHelperFactory.FaceType.FriendFace, (RecycleImageView)this.head, (ImageConfig)ImageConfig.defaultImageConfig(), (int)R.drawable.default_portrait);
    }

    public void loadHeadLogo(final BubbleBarragView.BubbleInfo bubbleInfo, final boolean hasBorder) {
        Glide.with((View)this.head).load((Object)bubbleInfo.commentInfo.commentsMyLogo).apply(RequestOptions.placeholderOf((int)R.drawable.default_portrait)).into((Target)new SimpleTarget<Drawable>(){

            public void onResourceReady(@NonNull Drawable resource, @Nullable Transition<? super Drawable> transition) {
                MLog.info((String)BubbleView.TAG, (String)"loadHeadLogo onResourceReady");
                BubbleView.this.head.setImageDrawable(resource);
                bubbleInfo.bmp = BubbleView.this.getBitmap(bubbleInfo.commentInfo, hasBorder);
            }

            public void onLoadStarted(@Nullable Drawable placeholder) {
                super.onLoadStarted(placeholder);
                MLog.info((String)BubbleView.TAG, (String)"loadHeadLogo onLoadStarted");
                BubbleView.this.head.setImageDrawable(placeholder);
            }

            public void onLoadFailed(@Nullable Drawable errorDrawable) {
                super.onLoadFailed(errorDrawable);
                MLog.info((String)BubbleView.TAG, (String)"loadHeadLogo onLoadFailed");
                BubbleView.this.head.setImageDrawable(errorDrawable);
                bubbleInfo.bmp = BubbleView.this.getBitmap(bubbleInfo.commentInfo, hasBorder);
            }
        });
    }

    public Bitmap getBitmap(CommentInfo commentInfo, boolean hasBorder) {
        if (commentInfo == null) {
            return null;
        }
        this.imlogoLoc = commentInfo.imlogoLoc;
        this.setContent(commentInfo.content);
        String colorStr = this.barragColors[0];
        colorStr = commentInfo.praiseNum >= 2L && commentInfo.praiseNum < 20L ? this.barragColors[1] : (commentInfo.praiseNum >= 20L && commentInfo.praiseNum < 50L ? this.barragColors[2] : (commentInfo.praiseNum >= 50L ? this.barragColors[3] : this.barragColors[0]));
        if (hasBorder) {
            this.head.setBorderColor(this.getResources().getColor(R.color.common_color_1));
            this.barragBg.setImageResource(R.drawable.mybarrag_bg);
        } else {
            if (commentInfo.uid == LoginUtil.getUid()) {
                this.head.setBorderColor(this.getResources().getColor(R.color.common_color_1));
            } else if (commentInfo.isAnchor == 1) {
                this.head.setBorderColor(Color.parseColor((String)"#ff4d4d"));
            } else {
                this.head.setBorderColor(this.getResources().getColor(R.color.common_color_11));
            }
            this.barragBg.setImageResource(R.drawable.bubble_barrag_bg);
            this.barragBg.setColorFilter(Color.parseColor((String)colorStr), PorterDuff.Mode.SRC_IN);
        }
        this.praiseTxt.setText((CharSequence)this.wrapShowData(commentInfo.praiseNum));
        if (commentInfo.myPraiseNum > 0) {
            this.praiseIcon.setImageResource(R.drawable.praised_icon);
            this.praiseTxt.setTextColor(this.getResources().getColor(R.color.common_color_1));
        } else {
            this.praiseIcon.setImageResource(R.drawable.praise_icon);
            this.praiseIcon.setColorFilter(Color.parseColor((String)colorStr), PorterDuff.Mode.SRC_IN);
            this.praiseTxt.setTextColor(Color.parseColor((String)colorStr));
        }
        this.measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)0, (int)0x40000000));
        int w = this.contentTxt.getMeasuredWidth() + this.dp2Px(28.0f) + this.dp2Px(8.0f) + this.dp2Px(11.0f) + this.praiseLayout.getMeasuredWidth();
        int h = this.contentTxt.getMeasuredHeight() + this.dp2Px(6.0f) * 2;
        this.measure(View.MeasureSpec.makeMeasureSpec((int)w, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)h, (int)0x40000000));
        this.layout(0, 0, this.getMeasuredWidth(), this.getMeasuredHeight());
        if (this.imlogoLoc == 1) {
            this.praiseLayout.setBackgroundResource(R.drawable.barrag_label_right);
            this.head.setX(0.0f);
            this.barragBg.setX((float)this.dp2Px(20.0f));
            this.contentTxt.setX((float)(this.head.getMeasuredWidth() + this.dp2Px(8.0f)));
            this.praiseLayout.setX((float)(this.dp2Px(20.0f) + this.barragBg.getMeasuredWidth() - this.dp2Px(9.0f)));
            this.praiseIcon.setX((float)(this.dp2Px(9.0f) + this.dp2Px(2.0f)));
            this.praiseTxt.setX((float)(this.dp2Px(9.0f) + this.dp2Px(2.0f) + this.praiseIcon.getMeasuredWidth() + this.dp2Px(2.0f)));
            this.head.setY(0.0f);
        } else if (this.imlogoLoc == 2) {
            this.praiseLayout.setBackgroundResource(R.drawable.barrag_label_right);
            this.head.setX(0.0f);
            this.barragBg.setX((float)this.dp2Px(20.0f));
            this.contentTxt.setX((float)(this.head.getMeasuredWidth() + this.dp2Px(8.0f)));
            this.praiseLayout.setX((float)(this.dp2Px(20.0f) + this.barragBg.getMeasuredWidth() - this.dp2Px(9.0f)));
            this.praiseIcon.setX((float)(this.dp2Px(9.0f) + this.dp2Px(2.0f)));
            this.praiseTxt.setX((float)(this.dp2Px(9.0f) + this.dp2Px(2.0f) + this.praiseIcon.getMeasuredWidth() + this.dp2Px(2.0f)));
            this.head.setY((float)(this.barragBg.getMeasuredHeight() - this.head.getMeasuredHeight()));
        } else if (this.imlogoLoc == 3) {
            this.praiseLayout.setBackgroundResource(R.drawable.barrag_label_left);
            this.praiseLayout.setX(0.0f);
            this.praiseIcon.setX((float)this.dp2Px(2.0f));
            this.praiseTxt.setX((float)(this.dp2Px(2.0f) + this.praiseIcon.getMeasuredWidth() + this.dp2Px(2.0f)));
            this.barragBg.setX((float)(this.praiseLayout.getMeasuredWidth() - this.dp2Px(9.0f)));
            this.contentTxt.setX((float)(this.praiseLayout.getMeasuredWidth() + this.dp2Px(8.0f)));
            this.head.setX((float)(this.praiseLayout.getMeasuredWidth() + this.dp2Px(8.0f) + this.contentTxt.getMeasuredWidth() + this.dp2Px(8.0f)));
            this.head.setY(0.0f);
        } else if (this.imlogoLoc == 4) {
            this.praiseLayout.setBackgroundResource(R.drawable.barrag_label_left);
            this.praiseLayout.setX(0.0f);
            this.praiseIcon.setX((float)this.dp2Px(2.0f));
            this.praiseTxt.setX((float)(this.dp2Px(2.0f) + this.praiseIcon.getMeasuredWidth() + this.dp2Px(2.0f)));
            this.barragBg.setX((float)(this.praiseLayout.getMeasuredWidth() - this.dp2Px(9.0f)));
            this.contentTxt.setX((float)(this.praiseLayout.getMeasuredWidth() + this.dp2Px(8.0f)));
            this.head.setX((float)(this.praiseLayout.getMeasuredWidth() + this.dp2Px(8.0f) + this.contentTxt.getMeasuredWidth() + this.dp2Px(8.0f)));
            this.head.setY((float)(this.barragBg.getMeasuredHeight() - this.head.getMeasuredHeight()));
        }
        Bitmap barragBmp = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.barragCanvas.setBitmap(barragBmp);
        MLog.info((String)TAG, (String)"draw bitmap");
        this.draw(this.barragCanvas);
        this.barragBg.clearColorFilter();
        this.praiseIcon.clearColorFilter();
        return barragBmp;
    }

    public float getPraiseIconX() {
        if (this.praiseLayout == null || this.praiseIcon == null) {
            return 0.0f;
        }
        return this.praiseLayout.getX() + this.praiseIcon.getX() + (float)this.dp2Px(5.0f);
    }

    public float getPraiseIconY() {
        if (this.praiseLayout == null || this.praiseIcon == null) {
            return 0.0f;
        }
        return this.praiseLayout.getY() + this.praiseIcon.getY() + (float)this.dp2Px(5.0f);
    }

    public void setContent(String content) {
        Spannable spannable = null;
        if (!TextUtils.isEmpty((CharSequence)content)) {
            spannable = RichTextManager.getInstance().getSpannableString(this.getContext(), (CharSequence)content, this.features);
        }
        if (spannable != null) {
            try {
                this.contentTxt.setText(spannable);
            }
            catch (Throwable e) {
                if (!TextUtils.isEmpty((CharSequence)content)) {
                    this.contentTxt.setText((CharSequence)String.valueOf(content));
                }
                MLog.error((Object)TAG, (Throwable)e);
            }
        } else if (!TextUtils.isEmpty((CharSequence)content)) {
            this.contentTxt.setText((CharSequence)String.valueOf(content));
        }
    }

    public void setSelectStatus(boolean isSelect) {
        if (isSelect) {
            this.head.setBorderColor(this.getResources().getColor(R.color.common_color_1));
            this.barragBg.setImageResource(R.drawable.mybarrag_bg);
            this.praiseLayout.setVisibility(4);
        } else {
            this.head.setBorderColor(this.getResources().getColor(R.color.common_color_11));
            this.barragBg.setImageResource(R.drawable.bubble_barrag_bg);
            this.praiseLayout.setVisibility(0);
        }
    }

    public void setMyUnSelectStatus() {
        this.head.setBorderColor(this.getResources().getColor(R.color.common_color_1));
        this.barragBg.setImageResource(R.drawable.bubble_barrag_bg);
        this.praiseLayout.setVisibility(0);
    }

    public void setClickListener(View.OnClickListener listener2) {
        this.clickListener = listener2;
    }

    public void playPraiseAnimation() {
        this.animatorSet = new AnimatorSet();
        ObjectAnimator alphaAnimator = ObjectAnimator.ofFloat((Object)this.praiseIcon, (String)"alpha", (float[])new float[]{0.0f, 1.0f});
        alphaAnimator.setDuration(300L);
        DecelerateInterpolator lin = new DecelerateInterpolator();
        ObjectAnimator scaleXAnimator1 = ObjectAnimator.ofFloat((Object)this.praiseIcon, (String)"scaleX", (float[])new float[]{1.0f, 1.3f});
        scaleXAnimator1.setInterpolator((TimeInterpolator)lin);
        scaleXAnimator1.setStartDelay(0L);
        scaleXAnimator1.setDuration(300L);
        ObjectAnimator scaleYAnimator1 = ObjectAnimator.ofFloat((Object)this.praiseIcon, (String)"scaleY", (float[])new float[]{1.0f, 1.3f});
        scaleYAnimator1.setInterpolator((TimeInterpolator)lin);
        scaleYAnimator1.setStartDelay(0L);
        scaleYAnimator1.setDuration(300L);
        ObjectAnimator scaleXAnimator2 = ObjectAnimator.ofFloat((Object)this.praiseIcon, (String)"scaleX", (float[])new float[]{1.3f, 1.0f});
        scaleXAnimator2.setInterpolator((TimeInterpolator)lin);
        scaleXAnimator2.setStartDelay(300L);
        scaleXAnimator2.setDuration(300L);
        ObjectAnimator scaleYAnimator2 = ObjectAnimator.ofFloat((Object)this.praiseIcon, (String)"scaleY", (float[])new float[]{1.3f, 1.0f});
        scaleYAnimator2.setInterpolator((TimeInterpolator)lin);
        scaleYAnimator2.setStartDelay(300L);
        scaleYAnimator2.setDuration(300L);
        this.animatorSet.playTogether(new Animator[]{alphaAnimator, scaleXAnimator1, scaleYAnimator1, scaleXAnimator2, scaleYAnimator2});
        this.animatorSet.start();
        this.animatorSet.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                BubbleView.this.praiseIcon.setImageResource(R.drawable.praised_icon);
                BubbleView.this.praiseTxt.setText((CharSequence)"1");
                BubbleView.this.praiseTxt.setTextColor(BubbleView.this.getResources().getColor(R.color.common_color_1));
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
    }

    public int getLogoLoc() {
        return this.imlogoLoc;
    }

    public boolean onTouchEvent(MotionEvent event) {
        block25: {
            block24: {
                if (!this.touchable) break block24;
                switch (event.getAction()) {
                    case 0: {
                        this.lastX = (int)event.getRawX();
                        this.lastY = (int)event.getRawY();
                        if (this.mWidth == 0) {
                            this.mWidth = this.getWidth();
                            this.mHeight = this.getHeight();
                            break;
                        }
                        break block25;
                    }
                    case 2: {
                        int dx = (int)event.getRawX() - this.lastX;
                        int dy = (int)event.getRawY() - this.lastY;
                        int left = this.getLeft() + dx;
                        int top = this.getTop() + dy;
                        int right = this.getRight() + dx;
                        int bottom = this.getBottom() + dy;
                        if (left < 0) {
                            left = 0;
                            right = left + this.mWidth;
                            if (!this.headIsLeft) {
                                this.headIsLeft = true;
                                this.praiseLayout.setBackgroundResource(R.drawable.barrag_label_right);
                                this.moveViewX((View)this.head, this.mWidth - this.head.getWidth(), 0.0f);
                                this.moveViewX((View)this.barragBg, this.dp2Px(3.0f), 0.0f);
                                this.moveViewX(this.praiseLayout, -(this.contentTxt.getWidth() + this.dp2Px(8.0f) * 2 + this.head.getWidth() + this.dp2Px(3.0f)), 0.0f);
                            }
                        }
                        if (right > this.viewWidth) {
                            right = this.viewWidth;
                            left = right - this.mWidth;
                            if (this.headIsLeft) {
                                this.headIsLeft = false;
                                this.praiseLayout.setBackgroundResource(R.drawable.barrag_label_left);
                                this.moveViewX((View)this.head, 0.0f, this.mWidth - this.head.getWidth());
                                this.moveViewX((View)this.barragBg, 0.0f, this.dp2Px(3.0f));
                                this.moveViewX(this.praiseLayout, 0.0f, -(this.contentTxt.getWidth() + this.dp2Px(8.0f) * 2 + this.head.getWidth() + this.dp2Px(3.0f)));
                            }
                        }
                        if (top < 0) {
                            top = 0;
                            bottom = top + this.mHeight;
                            if (!this.headIsTop) {
                                this.headIsTop = true;
                                this.moveViewY((View)this.head, this.mHeight - this.head.getHeight(), 0.0f);
                            }
                        }
                        if (bottom > this.viewHeight) {
                            bottom = this.viewHeight;
                            top = bottom - this.mHeight;
                            if (this.headIsTop) {
                                this.headIsTop = false;
                                this.moveViewY((View)this.head, 0.0f, this.mHeight - this.head.getHeight());
                            }
                        }
                        if (this.headIsLeft && this.headIsTop) {
                            this.imlogoLoc = 1;
                        } else if (this.headIsLeft && !this.headIsTop) {
                            this.imlogoLoc = 2;
                        } else if (!this.headIsLeft && this.headIsTop) {
                            this.imlogoLoc = 3;
                        } else if (!this.headIsLeft && !this.headIsTop) {
                            this.imlogoLoc = 4;
                        }
                        this.myBarragLp = (RelativeLayout.LayoutParams)this.getLayoutParams();
                        this.myBarragLp.leftMargin = left;
                        this.myBarragLp.topMargin = top;
                        this.setLayoutParams((ViewGroup.LayoutParams)this.myBarragLp);
                        this.lastX = (int)event.getRawX();
                        this.lastY = (int)event.getRawY();
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                break block25;
            }
            if (event.getAction() == 1 && this.clickListener != null) {
                if (!this.hasPraise) {
                    this.clickListener.onClick((View)this);
                    this.hasPraise = true;
                } else {
                    SingleToastUtil.showToast((Context)this.getContext(), (String)"\u5df2\u7ecf\u70b9\u8fc7\u8d5e\u54af");
                }
            }
        }
        return true;
    }

    private void moveViewX(View view, float fromX, float toX) {
        ObjectAnimator xAnimator = ObjectAnimator.ofFloat((Object)view, (String)"translationX", (float[])new float[]{fromX, toX});
        xAnimator.setInterpolator((TimeInterpolator)this.lin);
        xAnimator.setStartDelay(0L);
        xAnimator.setDuration(300L);
        xAnimator.start();
    }

    private void moveViewY(View view, float fromY, float toY) {
        ObjectAnimator yAnimator = ObjectAnimator.ofFloat((Object)view, (String)"translationY", (float[])new float[]{fromY, toY});
        yAnimator.setInterpolator((TimeInterpolator)this.lin);
        yAnimator.setStartDelay(0L);
        yAnimator.setDuration(300L);
        yAnimator.start();
    }

    private int dp2Px(float dp) {
        if (this.getContext() == null) {
            return (int)dp;
        }
        float scale = this.getContext().getResources().getDisplayMetrics().density;
        return (int)(dp * scale + 0.5f);
    }

    private String wrapShowData(long hotDegree) {
        String resultStr = hotDegree + "";
        double temp = (double)hotDegree / 10000.0;
        if (temp >= 1.0) {
            resultStr = (temp = (double)Math.round(temp * 10.0) / 10.0) + "";
            if (resultStr.indexOf(".") > 0) {
                resultStr = resultStr.replaceAll("[10]$", "");
                resultStr = resultStr.replaceAll("[.]$", "");
            }
            resultStr = resultStr + "\u4e07";
        }
        return resultStr;
    }
}

