/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.gallery.barrag;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.ui.gallery.barrag.BubbleView;
import com.yy.mobile.ui.utils.NavigationUtils;
import com.yy.mobile.ui.utils.SingleToastUtil;
import com.yy.mobile.util.NetworkUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.CoreManager;
import com.yymobile.core.gallery.GalleryCoreImpl;
import com.yymobile.core.gallery.IGalleryCore;
import com.yymobile.core.gallery.module.CommentInfo;
import com.yymobile.core.gallery.module.CommentPraises;
import com.yymobile.core.statistic.IHiidoStatisticCore;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class BubbleBarragView
extends RecycleImageView {
    private static final String TAG = "BubbleBarragView";
    private Context mContext;
    private long anchorUid = 0L;
    private long albumId = 0L;
    private long pictrueId = 0L;
    private BubbleView barragView;
    private Bitmap praiseBmp;
    private Bitmap praiseBmpO;
    private Handler mHandler;
    public Vector<BubbleInfo> bubbleBmpArr = new Vector();
    private Vector<BubbleInfo> bubbleShowArr = new Vector();
    private Paint p = new Paint();
    private boolean isRun = false;
    private boolean isPause = true;
    private BubbleInfo selectedBubbleInfo;
    private Matrix matrix;
    private int pow = 0;
    private int maxBarragNum = 17;
    private View.OnClickListener clickListener;
    private int viewWidth = 0;
    private int viewHeight = 0;
    private int bubbleIndex = 0;
    private boolean canAdd = true;
    private CommentInfo msgComment;
    private BubbleInfo msgCommentInfo;
    private long downTime = 0L;
    public boolean touchable = true;
    Runnable runnable = new Runnable(){

        @Override
        public void run() {
            if (BubbleBarragView.this.isRun && BubbleBarragView.this.bubbleBmpArr.size() > 0) {
                if (BubbleBarragView.this.canAdd) {
                    BubbleBarragView.this.bubbleShowArr.add(BubbleBarragView.this.bubbleBmpArr.get(BubbleBarragView.this.bubbleIndex));
                    BubbleBarragView.this.canAdd = false;
                }
                if (BubbleBarragView.this.bubbleShowArr.size() < BubbleBarragView.this.maxBarragNum) {
                    for (int i = 0; i < BubbleBarragView.this.bubbleShowArr.size(); ++i) {
                        if (((BubbleInfo)((BubbleBarragView)BubbleBarragView.this).bubbleShowArr.get((int)i)).fadeInTime >= 700) continue;
                        ((BubbleInfo)((BubbleBarragView)BubbleBarragView.this).bubbleShowArr.get((int)i)).fadeInTime += 35;
                        ((BubbleInfo)BubbleBarragView.this.bubbleShowArr.get(i)).fadeIn();
                    }
                    if (BubbleBarragView.this.bubbleShowArr.size() > 0 && ((BubbleInfo)((BubbleBarragView)BubbleBarragView.this).bubbleShowArr.get((int)(((BubbleBarragView)BubbleBarragView.this).bubbleShowArr.size() - 1))).fadeInTime >= 700) {
                        BubbleBarragView.this.bubbleIndex++;
                        BubbleBarragView.this.canAdd = true;
                        if (BubbleBarragView.this.bubbleIndex > BubbleBarragView.this.bubbleBmpArr.size() - 1) {
                            if (BubbleBarragView.this.bubbleBmpArr.size() > BubbleBarragView.this.maxBarragNum) {
                                BubbleBarragView.this.bubbleIndex = 0;
                            } else {
                                BubbleBarragView.this.bubbleIndex = BubbleBarragView.this.bubbleBmpArr.size() - 1;
                                BubbleBarragView.this.canAdd = false;
                            }
                        }
                    }
                } else if (BubbleBarragView.this.bubbleShowArr.size() > 0) {
                    if (((BubbleInfo)((BubbleBarragView)BubbleBarragView.this).bubbleShowArr.get((int)(((BubbleBarragView)BubbleBarragView.this).bubbleShowArr.size() - 1))).fadeInTime < 700) {
                        ((BubbleInfo)((BubbleBarragView)BubbleBarragView.this).bubbleShowArr.get((int)(((BubbleBarragView)BubbleBarragView.this).bubbleShowArr.size() - 1))).fadeInTime += 35;
                        ((BubbleInfo)BubbleBarragView.this.bubbleShowArr.get(BubbleBarragView.this.bubbleShowArr.size() - 1)).fadeIn();
                    }
                    if (BubbleBarragView.this.bubbleBmpArr.size() > BubbleBarragView.this.maxBarragNum) {
                        if (((BubbleInfo)((BubbleBarragView)BubbleBarragView.this).bubbleShowArr.get((int)0)).fadeOutTime < 700) {
                            ((BubbleInfo)((BubbleBarragView)BubbleBarragView.this).bubbleShowArr.get((int)0)).fadeOutTime += 35;
                            ((BubbleInfo)BubbleBarragView.this.bubbleShowArr.get(0)).fadeOut();
                        } else if (((BubbleInfo)((BubbleBarragView)BubbleBarragView.this).bubbleShowArr.get((int)0)).fadeOutTime >= 700) {
                            ((BubbleInfo)BubbleBarragView.this.bubbleShowArr.get(0)).clearTime();
                            BubbleBarragView.this.bubbleShowArr.remove(0);
                            BubbleBarragView.this.bubbleIndex++;
                            if (BubbleBarragView.this.bubbleIndex > BubbleBarragView.this.bubbleBmpArr.size() - 1) {
                                BubbleBarragView.this.bubbleIndex = 0;
                            }
                            BubbleBarragView.this.bubbleShowArr.add(BubbleBarragView.this.bubbleBmpArr.get(BubbleBarragView.this.bubbleIndex));
                        }
                    }
                }
            }
            BubbleBarragView.this.invalidate();
        }
    };

    public BubbleBarragView(Context context) {
        super(context);
        this.mContext = context;
        this.init();
    }

    public BubbleBarragView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.init();
    }

    private void init() {
        if (this.mContext == null) {
            return;
        }
        this.praiseBmp = this.praiseBmpO = BitmapFactory.decodeResource((Resources)this.getResources(), (int)R.drawable.praise_icon);
        if (this.praiseBmp != null) {
            this.pow = this.praiseBmp.getWidth();
        }
        this.matrix = new Matrix();
        this.mHandler = new Handler();
    }

    public void setData(long anchorId, long alumId, long photoId, ArrayList<CommentInfo> comments, int viewWidth, int viewHeight, int picScaleWidth, int picScaleHeight) {
        this.setData(anchorId, alumId, photoId, comments, viewWidth, viewHeight, picScaleWidth, picScaleHeight, null);
    }

    public void setData(long anchorId, long alumId, long photoId, ArrayList<CommentInfo> comments, int viewWidth, int viewHeight, int picScaleWidth, int picScaleHeight, CommentInfo messgeComment) {
        this.anchorUid = anchorId;
        this.albumId = alumId;
        this.pictrueId = photoId;
        this.viewWidth = viewWidth;
        this.viewHeight = viewHeight;
        this.msgComment = messgeComment;
        if (comments != null && viewWidth > 0) {
            if (this.barragView == null) {
                this.barragView = new BubbleView(this.mContext, viewWidth, viewHeight, viewWidth, viewHeight);
            }
            this.stopBarrag();
            for (int i = 0; i < comments.size(); ++i) {
                CommentInfo commentInfo = comments.get(i);
                if (GalleryCoreImpl.myPraiseList.get(LoginUtil.getUid()) != null) {
                    List list = (List)GalleryCoreImpl.myPraiseList.get(LoginUtil.getUid());
                    for (int j = 0; j < list.size(); ++j) {
                        CommentPraises commentPraises = (CommentPraises)list.get(j);
                        if (commentPraises.anchorId != this.anchorUid || commentPraises.photoId != this.pictrueId || commentPraises.commentId != commentInfo.commentId) continue;
                        commentInfo.myPraiseNum = 1;
                        break;
                    }
                }
                BubbleInfo bubbleInfo = new BubbleInfo();
                bubbleInfo.x = Math.round((float)commentInfo.left * (float)picScaleWidth / 100.0f + (float)(viewWidth - picScaleWidth) * 0.5f);
                bubbleInfo.y = Math.round((float)commentInfo.top * (float)picScaleHeight / 100.0f + (float)(viewHeight - picScaleHeight) * 0.5f);
                bubbleInfo.commentInfo = commentInfo;
                bubbleInfo.praiseOw = this.pow;
                this.bubbleBmpArr.add(bubbleInfo);
            }
            if (this.msgComment != null) {
                if (GalleryCoreImpl.myPraiseList.get(LoginUtil.getUid()) != null) {
                    List myPraiseList = (List)GalleryCoreImpl.myPraiseList.get(LoginUtil.getUid());
                    for (int k = 0; k < myPraiseList.size(); ++k) {
                        CommentPraises commentPraises = (CommentPraises)myPraiseList.get(k);
                        if (commentPraises.anchorId != this.anchorUid || commentPraises.photoId != this.pictrueId || commentPraises.commentId != this.msgComment.commentId) continue;
                        this.msgComment.myPraiseNum = 1;
                        break;
                    }
                }
                this.msgCommentInfo = new BubbleInfo();
                this.msgCommentInfo.x = Math.round((float)this.msgComment.left * (float)picScaleWidth / 100.0f + (float)(viewWidth - picScaleWidth) * 0.5f);
                this.msgCommentInfo.y = Math.round((float)this.msgComment.top * (float)picScaleHeight / 100.0f + (float)(viewHeight - picScaleHeight) * 0.5f);
                this.msgCommentInfo.commentInfo = this.msgComment;
                this.msgCommentInfo.praiseOw = this.pow;
                this.barragView.loadHeadLogo(this.msgCommentInfo, false);
                this.msgCommentInfo.praiseIconX = this.barragView.getPraiseIconX();
                this.msgCommentInfo.praiseIconY = this.barragView.getPraiseIconY();
            }
            if (MLog.isLogLevelAboveDebug()) {
                MLog.debug((String)"hsj", (String)("bubbleBmpArr.size=" + this.bubbleBmpArr.size()));
            }
            this.startBarrag();
        }
    }

    public void clearData() {
        this.bubbleBmpArr.clear();
        this.bubbleShowArr.clear();
        this.canAdd = true;
        this.bubbleIndex = 0;
    }

    public void recycle() {
        try {
            Bitmap bmp;
            int i;
            for (i = 0; i < this.bubbleBmpArr.size(); ++i) {
                bmp = this.bubbleBmpArr.get((int)i).bmp;
                if (bmp == null || bmp.isRecycled()) continue;
                bmp.recycle();
            }
            for (i = 0; i < this.bubbleShowArr.size(); ++i) {
                bmp = this.bubbleShowArr.get((int)i).bmp;
                if (bmp == null || bmp.isRecycled()) continue;
                bmp.recycle();
            }
            if (this.praiseBmpO != null && !this.praiseBmpO.isRecycled()) {
                this.praiseBmpO.recycle();
            }
            if (this.praiseBmp != null && !this.praiseBmp.isRecycled()) {
                this.praiseBmp.recycle();
            }
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.isRun) {
            for (int i = 0; i < this.bubbleShowArr.size(); ++i) {
                BubbleInfo bubbleInfo = this.bubbleShowArr.get(i);
                this.p.setAlpha(Math.round(255.0f * bubbleInfo.alpha));
                if (bubbleInfo.bmp == null) {
                    this.barragView.loadHeadLogo(bubbleInfo, false);
                    bubbleInfo.praiseIconX = this.barragView.getPraiseIconX();
                    bubbleInfo.praiseIconY = this.barragView.getPraiseIconY();
                }
                if (this.msgCommentInfo != null && this.msgCommentInfo.commentInfo.commentId == bubbleInfo.commentInfo.commentId || bubbleInfo.bmp == null) continue;
                canvas.drawBitmap(bubbleInfo.bmp, (float)this.fixPosX(bubbleInfo.x, bubbleInfo.bmp.getWidth()), (float)this.fixPosY(bubbleInfo.y, bubbleInfo.bmp.getHeight()), this.p);
            }
            if (this.msgCommentInfo != null) {
                this.p.setAlpha(255);
                if (this.msgCommentInfo.bmp != null) {
                    canvas.drawBitmap(this.msgCommentInfo.bmp, (float)this.fixPosX(this.msgCommentInfo.x, this.msgCommentInfo.bmp.getWidth()), (float)this.fixPosY(this.msgCommentInfo.y, this.msgCommentInfo.bmp.getHeight()), this.p);
                }
            }
            if (this.selectedBubbleInfo != null) {
                this.p.setAlpha(Math.round(255.0f * this.selectedBubbleInfo.alpha));
                if (this.selectedBubbleInfo.bmp == null) {
                    this.barragView.loadHeadLogo(this.selectedBubbleInfo, false);
                    this.selectedBubbleInfo.praiseIconX = this.barragView.getPraiseIconX();
                    this.selectedBubbleInfo.praiseIconY = this.barragView.getPraiseIconY();
                }
                if (this.selectedBubbleInfo.bmp != null) {
                    canvas.drawBitmap(this.selectedBubbleInfo.bmp, (float)this.fixPosX(this.selectedBubbleInfo.x, this.selectedBubbleInfo.bmp.getWidth()), (float)this.fixPosY(this.selectedBubbleInfo.y, this.selectedBubbleInfo.bmp.getHeight()), this.p);
                }
                float px = 0.0f;
                float py = 0.0f;
                if ((double)this.praiseBmp.getWidth() < (double)this.selectedBubbleInfo.praiseOw * 1.3) {
                    this.matrix.postScale(1.01f, 1.01f);
                    px = (float)this.fixPosX(this.selectedBubbleInfo.x, this.selectedBubbleInfo.bmp.getWidth()) + this.selectedBubbleInfo.praiseIconX - (float)this.praiseBmp.getWidth() * 0.5f;
                    py = (float)this.fixPosY(this.selectedBubbleInfo.y, this.selectedBubbleInfo.bmp.getHeight()) + this.selectedBubbleInfo.praiseIconY - (float)this.praiseBmp.getHeight() * 0.5f - 2.0f;
                    this.matrix.postTranslate(px, py);
                    canvas.drawBitmap(this.praiseBmp, this.matrix, this.p);
                } else if (this.praiseBmp.getWidth() > this.pow) {
                    this.selectedBubbleInfo.praiseOw = 0;
                    this.matrix.postScale(0.99f, 0.99f);
                    px = (float)this.fixPosX(this.selectedBubbleInfo.x, this.selectedBubbleInfo.bmp.getWidth()) + this.selectedBubbleInfo.praiseIconX - (float)this.praiseBmp.getWidth() * 0.5f;
                    py = (float)this.fixPosY(this.selectedBubbleInfo.y, this.selectedBubbleInfo.bmp.getHeight()) + this.selectedBubbleInfo.praiseIconY - (float)this.praiseBmp.getHeight() * 0.5f - 2.0f;
                    this.matrix.postTranslate(px, py);
                    canvas.drawBitmap(this.praiseBmp, this.matrix, this.p);
                } else {
                    if (MLog.isLogLevelAboveDebug()) {
                        MLog.debug((String)"hsj", (String)"scale over!");
                    }
                    this.barragView.loadHeadLogo(this.selectedBubbleInfo.commentInfo.commentsMyLogo);
                    this.praiseBmp = this.praiseBmpO;
                    this.selectedBubbleInfo.praiseOw = this.pow;
                    this.selectedBubbleInfo.commentInfo.myPraiseNum = 1;
                    this.selectedBubbleInfo.bmp = this.barragView.getBitmap(this.selectedBubbleInfo.commentInfo, false);
                    this.selectedBubbleInfo.praiseIconX = this.barragView.getPraiseIconX();
                    this.selectedBubbleInfo.praiseIconY = this.barragView.getPraiseIconY();
                    this.selectedBubbleInfo = null;
                }
            }
        }
        if (!this.isPause) {
            this.mHandler.postDelayed(this.runnable, 35L);
        }
    }

    public void startBarrag() {
        try {
            this.isRun = true;
            this.isPause = false;
            this.invalidate();
        }
        catch (Exception e) {
            MLog.info((String)"hsj", (String)("bubbleBarragView startBarrag error:" + e));
        }
    }

    public void stopBarrag() {
        try {
            this.clearData();
            this.invalidate();
            this.isRun = false;
            this.isPause = true;
            this.mHandler.removeCallbacks(this.runnable);
        }
        catch (Exception e) {
            MLog.info((String)"hsj", (String)("bubbleBarragView stopBarrag error:" + e));
        }
    }

    public void resumeBarrag() {
        try {
            this.isPause = false;
            this.invalidate();
        }
        catch (Exception e) {
            MLog.info((String)"hsj", (String)("bubbleBarragView resumeBarrag error:" + e));
        }
    }

    public void pauseBarrag() {
        this.isPause = true;
    }

    public void setClickListener(View.OnClickListener listener2) {
        this.clickListener = listener2;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.touchable) {
            return false;
        }
        boolean isClick = false;
        if (event.getAction() == 0) {
            this.downTime = System.currentTimeMillis();
        }
        if (event.getAction() == 1) {
            long nowTime;
            int tx = (int)event.getX();
            int ty = (int)event.getY();
            if (this.msgCommentInfo != null && tx > this.fixPosX(this.msgCommentInfo.x, this.msgCommentInfo.bmp.getWidth()) && tx < this.fixPosX(this.msgCommentInfo.x, this.msgCommentInfo.bmp.getWidth()) + this.msgCommentInfo.bmp.getWidth() && ty > this.fixPosY(this.msgCommentInfo.y, this.msgCommentInfo.bmp.getHeight()) && ty < this.fixPosY(this.msgCommentInfo.y, this.msgCommentInfo.bmp.getHeight()) + this.msgCommentInfo.bmp.getHeight() && this.msgCommentInfo.bmp.getPixel(tx - this.fixPosX(this.msgCommentInfo.x, this.msgCommentInfo.bmp.getWidth()), ty - this.fixPosY(this.msgCommentInfo.y, this.msgCommentInfo.bmp.getHeight())) != 0) {
                ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "1002", "0006");
                isClick = true;
                if (NetworkUtils.isNetworkStrictlyAvailable((Context)this.mContext)) {
                    if (LoginUtil.isLogined()) {
                        if (this.msgCommentInfo.commentInfo.myPraiseNum < 1) {
                            if (this.selectedBubbleInfo != this.msgCommentInfo) {
                                if (this.selectedBubbleInfo != null) {
                                    this.barragView.loadHeadLogo(this.selectedBubbleInfo.commentInfo.commentsMyLogo);
                                    this.selectedBubbleInfo.praiseOw = this.pow;
                                    this.selectedBubbleInfo.commentInfo.myPraiseNum = 1;
                                    this.selectedBubbleInfo.bmp = this.barragView.getBitmap(this.selectedBubbleInfo.commentInfo, false);
                                    this.selectedBubbleInfo.praiseIconX = this.barragView.getPraiseIconX();
                                    this.selectedBubbleInfo.praiseIconY = this.barragView.getPraiseIconY();
                                }
                                this.matrix.setScale(1.0f, 1.0f);
                                this.praiseBmp = this.praiseBmpO;
                                this.msgCommentInfo.praiseOw = this.pow;
                                this.msgCommentInfo.commentInfo.myPraiseNum = 1;
                                ++this.msgCommentInfo.commentInfo.praiseNum;
                                this.selectedBubbleInfo = this.msgCommentInfo;
                                ((IGalleryCore)CoreManager.getCore(IGalleryCore.class)).commentPraise(this.anchorUid, this.albumId, this.pictrueId, this.msgCommentInfo.commentInfo.commentId);
                            }
                        } else {
                            SingleToastUtil.showToast((Context)this.getContext(), (String)"\u5df2\u7ecf\u70b9\u8fc7\u8d5e\u54af");
                        }
                    } else {
                        NavigationUtils.toLogin(this.mContext, true, false);
                    }
                } else {
                    SingleToastUtil.showToast((Context)this.getContext(), (int)R.string.str_network_not_capable);
                }
                return true;
            }
            for (int i = this.bubbleBmpArr.size() - 1; i >= 0; --i) {
                BubbleInfo bubbleInfo = this.bubbleBmpArr.get(i);
                if (bubbleInfo == null || bubbleInfo.bmp == null || tx <= this.fixPosX(bubbleInfo.x, bubbleInfo.bmp.getWidth()) || tx >= this.fixPosX(bubbleInfo.x, bubbleInfo.bmp.getWidth()) + bubbleInfo.bmp.getWidth() || ty <= this.fixPosY(bubbleInfo.y, bubbleInfo.bmp.getHeight()) || ty >= this.fixPosY(bubbleInfo.y, bubbleInfo.bmp.getHeight()) + bubbleInfo.bmp.getHeight() || bubbleInfo.bmp.getPixel(tx - this.fixPosX(bubbleInfo.x, bubbleInfo.bmp.getWidth()), ty - this.fixPosY(bubbleInfo.y, bubbleInfo.bmp.getHeight())) == 0) continue;
                ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "1002", "0006");
                isClick = true;
                if (NetworkUtils.isNetworkStrictlyAvailable((Context)this.mContext)) {
                    if (LoginUtil.isLogined()) {
                        if (bubbleInfo.commentInfo.myPraiseNum < 1) {
                            if (this.selectedBubbleInfo == bubbleInfo) break;
                            if (this.selectedBubbleInfo != null) {
                                this.barragView.loadHeadLogo(this.selectedBubbleInfo.commentInfo.commentsMyLogo);
                                this.selectedBubbleInfo.praiseOw = this.pow;
                                this.selectedBubbleInfo.commentInfo.myPraiseNum = 1;
                                this.selectedBubbleInfo.bmp = this.barragView.getBitmap(this.selectedBubbleInfo.commentInfo, false);
                                this.selectedBubbleInfo.praiseIconX = this.barragView.getPraiseIconX();
                                this.selectedBubbleInfo.praiseIconY = this.barragView.getPraiseIconY();
                            }
                            this.matrix.setScale(1.0f, 1.0f);
                            this.praiseBmp = this.praiseBmpO;
                            bubbleInfo.praiseOw = this.pow;
                            bubbleInfo.commentInfo.myPraiseNum = 1;
                            ++bubbleInfo.commentInfo.praiseNum;
                            this.selectedBubbleInfo = bubbleInfo;
                            ((IGalleryCore)CoreManager.getCore(IGalleryCore.class)).commentPraise(this.anchorUid, this.albumId, this.pictrueId, bubbleInfo.commentInfo.commentId);
                            break;
                        }
                        SingleToastUtil.showToast((Context)this.getContext(), (String)"\u5df2\u7ecf\u70b9\u8fc7\u8d5e\u54af");
                        break;
                    }
                    NavigationUtils.toLogin(this.mContext, true, false);
                    break;
                }
                SingleToastUtil.showToast((Context)this.getContext(), (int)R.string.str_network_not_capable);
                break;
            }
            if ((nowTime = System.currentTimeMillis()) - this.downTime > 50L && nowTime - this.downTime < 3000L && !isClick && this.clickListener != null) {
                this.clickListener.onClick((View)this);
            }
        }
        return true;
    }

    private int fixPosX(int px, int bubbleViewWith) {
        int posX = px;
        if (posX < 0) {
            posX = 0;
        }
        if (posX + bubbleViewWith > this.viewWidth) {
            posX = this.viewWidth - bubbleViewWith;
        }
        return posX;
    }

    private int fixPosY(int py, int bubbleViewHeight) {
        int posY = py;
        if (posY < 0) {
            posY = 0;
        }
        if (posY + bubbleViewHeight > this.viewHeight) {
            posY = this.viewHeight - bubbleViewHeight;
        }
        return posY;
    }

    public static class BubbleInfo {
        int x = 0;
        int y = 0;
        int offY = 30;
        float alpha = 0.0f;
        int fadeInTime = 0;
        int fadeOutTime = 0;
        int showTime = 0;
        float praiseIconX = 0.0f;
        float praiseIconY = 0.0f;
        Bitmap bmp;
        CommentInfo commentInfo;
        int praiseOw = 0;

        void moveUp() {
            if (this.fadeInTime == 0) {
                this.y += this.offY;
            }
            this.y -= 3;
        }

        void fadeIn() {
            if (this.alpha < 1.0f) {
                this.alpha = (float)((double)this.alpha + 0.05);
            }
        }

        void fadeOut() {
            if (this.alpha > 0.0f) {
                this.alpha = (float)((double)this.alpha - 0.05);
            }
        }

        void clearTime() {
            this.fadeInTime = 0;
            this.fadeOutTime = 0;
            this.showTime = 0;
            this.alpha = 0.0f;
        }
    }
}

