/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.gallery;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.handmark.pulltorefresh.library.extras_view.DynamicHeightImageView;
import com.handmark.pulltorefresh.library.extras_view.StaggeredGridView;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.image.CircleImageView;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.ui.home.FaceHelperFactory;
import com.yy.mobile.ui.utils.NavigationUtils;
import com.yy.mobile.util.FaceHelper;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.gallery.module.PhotoInfo;
import com.yymobile.core.statistic.IHiidoStatisticCore;
import java.util.ArrayList;
import java.util.List;

public class StaggeredGridAdapter
extends BaseAdapter {
    private Context mContext;
    private ArrayList<PhotoInfo> mInfos;
    private StaggeredGridView staggeredGridView;
    private boolean isShowInfo;

    public StaggeredGridAdapter(Context context, StaggeredGridView mGridView, boolean isShowInfo) {
        this.mContext = context;
        this.mInfos = new ArrayList();
        this.staggeredGridView = mGridView;
        this.isShowInfo = isShowInfo;
    }

    public void addDataItem(List<PhotoInfo> mPhotoInfo) {
        if (mPhotoInfo != null) {
            this.mInfos.addAll(mPhotoInfo);
        }
        this.notifyDataSetChanged();
    }

    public ArrayList<PhotoInfo> getData() {
        return this.mInfos;
    }

    public void changeDataItem(List<PhotoInfo> mPhotoInfo) {
        this.mInfos.clear();
        if (mPhotoInfo != null) {
            this.mInfos.addAll(mPhotoInfo);
        }
        this.notifyDataSetChanged();
    }

    public int getCount() {
        if (this.mInfos != null) {
            return this.mInfos.size();
        }
        return 0;
    }

    public PhotoInfo getItem(int i) {
        if (this.mInfos != null) {
            return this.mInfos.get(i);
        }
        return null;
    }

    public long getItemId(int i) {
        return i;
    }

    public View getView(int position, View convertView, ViewGroup viewGroup) {
        ViewHolder holder;
        final PhotoInfo photoInfo = this.mInfos.get(position);
        if (convertView == null) {
            LayoutInflater layoutInflator = LayoutInflater.from((Context)viewGroup.getContext());
            convertView = layoutInflator.inflate(R.layout.fragment_photo_staggeredgrid_item, null);
            holder = new ViewHolder();
            holder.thumb = (DynamicHeightImageView)convertView.findViewById(R.id.thumb1);
            holder.mDanmuNum = (TextView)convertView.findViewById(R.id.stagger_danmu_num);
            holder.infoLinearLayout = (RelativeLayout)convertView.findViewById(R.id.item_gallery_image_info);
            holder.userImage = (CircleImageView)convertView.findViewById(R.id.gallery_item_user_image);
            holder.userNameTv = (TextView)convertView.findViewById(R.id.gallery_item_username_tv);
            holder.timeTv = (TextView)convertView.findViewById(R.id.gallery_item_time_tv);
            convertView.setTag((Object)holder);
        } else {
            holder = (ViewHolder)convertView.getTag();
        }
        if (!MLog.isLogLevelAboveVerbose()) {
            MLog.verbose((Object)this.mContext, (String)("photoIndfo.photos.get(0).width " + photoInfo.width + " photoIndfo.photos.get(0).height " + photoInfo.height), (Object[])new Object[0]);
        }
        if (photoInfo.width == 0 || this.staggeredGridView == null || this.staggeredGridView.getColumnWidth() == 0 || photoInfo.height == 0) {
            if (!MLog.isLogLevelAboveVerbose()) {
                MLog.verbose((Object)this.mContext, (String)("ResolutionUtils.convertDpToPixel(20, mContext) " + ResolutionUtils.convertDpToPixel((float)180.0f, (Context)this.mContext)), (Object[])new Object[0]);
            }
            holder.thumb.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, (int)ResolutionUtils.convertDpToPixel((float)180.0f, (Context)this.mContext)));
        } else {
            float height = photoInfo.height;
            float width = photoInfo.width;
            double ret = width / height;
            double newWidth = this.staggeredGridView.getColumnWidth();
            double newHeight = newWidth / ret;
            if (newHeight > (double)((int)ResolutionUtils.convertDpToPixel((float)269.0f, (Context)this.mContext))) {
                newHeight = (int)ResolutionUtils.convertDpToPixel((float)269.0f, (Context)this.mContext);
            } else if (newHeight < (double)((int)ResolutionUtils.convertDpToPixel((float)105.0f, (Context)this.mContext))) {
                newHeight = (int)ResolutionUtils.convertDpToPixel((float)105.0f, (Context)this.mContext);
            }
            holder.thumb.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, (int)newHeight));
        }
        if (!MLog.isLogLevelAboveVerbose()) {
            MLog.verbose((Object)this.mContext, (String)("photoIndfo.photos.get(0).thumbsUrl " + photoInfo.thumbsUrl + " ImageManager.isGif(photoInfo.photoUrl) " + ImageLoader.isGif((String)photoInfo.photoUrl)), (Object[])new Object[0]);
        }
        if (ImageLoader.isGif((String)photoInfo.photoUrl)) {
            holder.thumb.setImageResource(R.color.gallery_loading_list);
            ImageLoader.loadImage((String)photoInfo.thumbsUrl, (RecycleImageView)holder.thumb, (ImageConfig)ImageConfig.defaultImageConfig(), (int)R.color.common_f1_color, (int)R.color.common_f1_color);
        } else {
            holder.thumb.setImageResource(R.color.gallery_loading_list);
            ImageLoader.loadImage((String)photoInfo.photoUrl, (RecycleImageView)holder.thumb, (ImageConfig)ImageConfig.defaultImageConfig(), (int)R.color.common_f1_color, (int)R.color.common_f1_color);
        }
        if (photoInfo.commentNum > 9999L) {
            holder.mDanmuNum.setText((CharSequence)this.wrapShowData((int)photoInfo.commentNum));
        } else {
            holder.mDanmuNum.setText((CharSequence)(photoInfo.commentNum + ""));
        }
        if (!MLog.isLogLevelAboveVerbose()) {
            MLog.verbose((Object)this.mContext, (String)("holder.thumb.getLayoutParams().width " + holder.thumb.getLayoutParams().width + " holder.thumb.getLayoutParams().height " + holder.thumb.getLayoutParams().height), (Object[])new Object[0]);
        }
        if (this.isShowInfo) {
            holder.infoLinearLayout.setVisibility(0);
            if (!TextUtils.isEmpty((CharSequence)photoInfo.photoAuthorName)) {
                holder.userNameTv.setText((CharSequence)photoInfo.photoAuthorName);
            }
            if (!TextUtils.isEmpty((CharSequence)photoInfo.createTime)) {
                holder.timeTv.setText((CharSequence)photoInfo.createTime);
            }
            FaceHelper.loadFace((String)photoInfo.photoAuthorLogo, (int)-1, (FaceHelperFactory.FaceType)FaceHelperFactory.FaceType.FriendFace, (RecycleImageView)holder.userImage, (ImageConfig)ImageConfig.defaultImageConfig(), (int)R.drawable.default_portrait);
            holder.infoLinearLayout.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "1003", "0004");
                    if (photoInfo.isAnchor == 1) {
                        NavigationUtils.toUserInfo(StaggeredGridAdapter.this.mContext, photoInfo.photoAnchorId);
                    } else if (photoInfo.isAnchor == 0) {
                        NavigationUtils.toPersonPage(StaggeredGridAdapter.this.mContext, photoInfo.photoAnchorId, 3);
                    }
                }
            });
        } else {
            holder.infoLinearLayout.setVisibility(8);
        }
        return convertView;
    }

    private String wrapShowData(int hotDegree) {
        String resultStr = hotDegree + "";
        double temp = (double)hotDegree / 10000.0;
        if (temp >= 1.0) {
            resultStr = (temp = (double)Math.round(temp * 10.0) / 10.0) + "";
            if (resultStr.indexOf(".") > 0) {
                resultStr = resultStr.replaceAll("[10]$", "");
                resultStr = resultStr.replaceAll("[.]$", "");
            }
            resultStr = resultStr + "\u4e07";
        }
        return resultStr;
    }

    static class ViewHolder {
        DynamicHeightImageView thumb;
        TextView mDanmuNum;
        RelativeLayout infoLinearLayout;
        CircleImageView userImage;
        TextView userNameTv;
        TextView timeTv;

        ViewHolder() {
        }
    }
}

