/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.gallery;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import android.view.View;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.ListAdapter;
import android.widget.TextView;
import com.google.gson.JsonObject;
import com.handmark.pulltorefresh.library.PullToRefreshBase;
import com.handmark.pulltorefresh.library.PullToRefreshStaggeredGridView;
import com.handmark.pulltorefresh.library.extras_view.StaggeredGridView;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.image.PauseOnScrollListener;
import com.yy.mobile.plugin.homepage.ui.utils.dialog.IBaseDialog;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.plugin.main.events.IGalleryClient_onBatchDetelePhoto_EventArgs;
import com.yy.mobile.plugin.main.events.IGalleryClient_onModifyAlbum_EventArgs;
import com.yy.mobile.plugin.main.events.IGalleryClient_onQueryStaggerList_EventArgs;
import com.yy.mobile.plugin.main.events.IGalleryClient_onUploadFinish_EventArgs;
import com.yy.mobile.plugin.main.events.IGalleryClient_onUploadProgress_EventArgs;
import com.yy.mobile.plugin.main.events.IGalleryClient_onUploadStart_EventArgs;
import com.yy.mobile.ui.BaseDarkModeActivity;
import com.yy.mobile.ui.dialog.ButtonItem;
import com.yy.mobile.ui.dialog.IDialogLinkManagerCore;
import com.yy.mobile.ui.gallery.PhotoUploadActivity;
import com.yy.mobile.ui.gallery.StaggeredGridActivity$$EventBinder;
import com.yy.mobile.ui.gallery.StaggeredGridAdapter;
import com.yy.mobile.ui.utils.NavigationUtils;
import com.yy.mobile.ui.utils.dialog.InputDialog;
import com.yy.mobile.ui.utils.dialog.InputDialogListener;
import com.yy.mobile.ui.widget.EndlessListScrollListener;
import com.yy.mobile.ui.widget.SimpleTitleBar;
import com.yy.mobile.ui.widget.StatusLayout;
import com.yy.mobile.ui.widget.extend.RxViewExt;
import com.yy.mobile.ui.widget.toast.Toast;
import com.yy.mobile.util.ObjectTimeslotTool;
import com.yy.mobile.util.PhotoUtils;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.TimeUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.CoreManager;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.gallery.IGalleryCore;
import com.yymobile.core.gallery.IPhotoWatchCountCore;
import com.yymobile.core.gallery.module.AlbumInfo;
import com.yymobile.core.gallery.module.StaggeredGridInfo;
import com.yymobile.core.gallery.module.UploadStatus;
import com.yymobile.core.statistic.IHiidoStatisticCore;
import io.reactivex.functions.Consumer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class StaggeredGridActivity
extends BaseDarkModeActivity {
    public static final String TAG = "StaggeredGridActivity";
    public static final String KEY_ANCHOR_ID = "key_anchor_id";
    public static final String KEY_ANCHOR_NAME = "key_anchor_name";
    public static final String KEY_ALUMBOR_ID = "key_alum_id";
    public static final String KEY_ALUMINFO = "key_alum_info";
    private int mPageNo = 1;
    public static final int PAGE_SIZE = 30;
    private boolean mIsLastPage = false;
    private boolean misPull = true;
    private PullToRefreshStaggeredGridView mGridView;
    private SimpleTitleBar simpleTitleBar;
    private StaggeredGridAdapter mGridAdapter;
    private StaggeredGridView staggeredGridView;
    private TextView mUploadProgress;
    private long anchorId;
    private long albumId;
    private String albumName;
    private EndlessListScrollListener mEndlessListScrollListener;
    private List<String> mlist = new ArrayList<String>();
    private List<ButtonItem> imageDialogItems = new ArrayList<ButtonItem>();
    private Button mBtnUploadPhoto;
    private TextView rightView;
    private ObjectTimeslotTool mTimeSlotTool = new ObjectTimeslotTool();
    private boolean isVisible = true;
    private Runnable checkRequestTimeoutTask = new Runnable(){

        @Override
        public void run() {
            StaggeredGridActivity.this.hideStatus();
            StaggeredGridActivity.this.mGridView.onRefreshComplete();
            if (StaggeredGridActivity.this.mGridAdapter.getCount() == 0) {
                StaggeredGridActivity.this.showReload();
            }
        }
    };
    private Runnable fixCompleteRefreshMsg = new Runnable(){

        @Override
        public void run() {
            if (StaggeredGridActivity.this.mGridView != null) {
                StaggeredGridActivity.this.mGridView.onRefreshComplete();
            }
            if (StaggeredGridActivity.this.mEndlessListScrollListener != null) {
                StaggeredGridActivity.this.mEndlessListScrollListener.onLoadComplete();
            }
        }
    };
    private EventBinder mEventBinder;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.fragment_photo_staggeredgrid);
        this.anchorId = this.getIntent().getLongExtra(KEY_ANCHOR_ID, 0L);
        this.albumId = this.getIntent().getLongExtra(KEY_ALUMBOR_ID, 0L);
        this.albumName = this.getIntent().getStringExtra(KEY_ANCHOR_NAME);
        this.initImageDialog();
        this.initTitleBar();
        this.initView();
        this.initData();
    }

    public void initTitleBar() {
        this.simpleTitleBar = (SimpleTitleBar)this.findViewById(R.id.title_bar);
        this.simpleTitleBar.setTitlte(this.albumName);
        this.simpleTitleBar.setLeftBtn(R.drawable.icon_nav_back, new View.OnClickListener(){

            public void onClick(View v) {
                StaggeredGridActivity.this.finish();
            }
        });
        this.mBtnUploadPhoto = (Button)this.findViewById(R.id.btn_status_upload);
        this.mlist = ((IGalleryCore)CoreManager.getCore(IGalleryCore.class)).getAuth(this.anchorId);
        AlbumInfo info = ((IGalleryCore)CoreManager.getCore(IGalleryCore.class)).getAlbumInfo(this.anchorId, this.albumId);
        this.rightView = (TextView)this.getLayoutInflater().inflate(R.layout.layout_titlebar_right_text_extra, null);
        this.simpleTitleBar.setRightView((View)this.rightView);
        this.rightView.setText((CharSequence)this.getString(R.string.str_maneger_stagger));
        this.rightView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (StaggeredGridActivity.this.mTimeSlotTool.isProcessing()) {
                    return;
                }
                StaggeredGridActivity.this.showImageDialog();
            }
        });
        this.rightView.setVisibility(8);
        if (info != null && info.photos != null && info.photos.size() > 0 && !this.checkNetToast()) {
            if (((IGalleryCore)CoreManager.getCore(IGalleryCore.class)).hasCreateRule(this.anchorId)) {
                this.rightView.setVisibility(0);
                if (info.photos == null || info.photos.size() == 0) {
                    this.showNoData(R.drawable.icon_neirongkong, R.string.str_nodata_gallery_rule2);
                    this.mBtnUploadPhoto.setVisibility(0);
                }
            } else if (info.photos == null || info.photos.size() == 0) {
                this.showNoData(R.drawable.icon_neirongkong, R.string.str_nodata_gallery_rule2);
                this.mBtnUploadPhoto.setVisibility(8);
            }
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if ((requestCode == 2010 || requestCode == 2011) && resultCode == -1 && data != null) {
            String[] clipPaths = data.getStringArrayExtra("portrait_clip_key");
            ArrayList<String> selected = null;
            if (clipPaths != null) {
                selected = new ArrayList<String>();
                selected.addAll(Arrays.asList(clipPaths));
            }
            PhotoUploadActivity.launchPhotoUpload(this.getContext(), this.anchorId, this.albumId, selected);
        }
    }

    private void initImageDialog() {
        ButtonItem btnItem1 = new ButtonItem(this.getString(R.string.str_upload_gallery_photo), new ButtonItem.OnClickListener(){

            public void onClick() {
                if (StaggeredGridActivity.this.mTimeSlotTool.isProcessing()) {
                    return;
                }
                PhotoUtils.choosePhoto((Activity)StaggeredGridActivity.this, null, null, (boolean)true);
            }
        });
        this.imageDialogItems.add(btnItem1);
        ButtonItem btnItem2 = new ButtonItem(this.getString(R.string.str_update_gallery_name), new ButtonItem.OnClickListener(){

            public void onClick() {
                if (StaggeredGridActivity.this.mTimeSlotTool.isProcessing()) {
                    return;
                }
                StaggeredGridActivity.this.getDialogLinkManager().showDialog((IBaseDialog)new InputDialog(StaggeredGridActivity.this.getContext(), (CharSequence)StaggeredGridActivity.this.getString(R.string.str_update_gallery_name), (CharSequence)"\u4e3a\u76f8\u518c\u8f93\u5165\u540d\u5b57", (CharSequence)StaggeredGridActivity.this.albumName, (CharSequence)"10\u4e2a\u5b57\u4ee5\u5185", null, true, true, true, new InputDialogListener(){

                    public void cancel() {
                    }

                    public boolean confirm(String input) {
                        if (TextUtils.isEmpty((CharSequence)(input = input.trim()))) {
                            Toast.makeText((Context)StaggeredGridActivity.this.getContext(), (int)R.string.str_create_gallery_null, (int)0).show();
                            return false;
                        }
                        if (input.length() > 10) {
                            Toast.makeText((Context)StaggeredGridActivity.this.getContext(), (int)R.string.str_create_gallery_over_limit, (int)0).show();
                            return false;
                        }
                        ((IGalleryCore)CoreManager.getCore(IGalleryCore.class)).modifyAlbum(StaggeredGridActivity.this.albumId, StaggeredGridActivity.this.anchorId, input, "");
                        return true;
                    }

                    public void onExit() {
                    }
                }, false));
            }
        });
        this.imageDialogItems.add(btnItem2);
        ButtonItem btnItem3 = new ButtonItem(this.getString(R.string.str_delete_gallery_photo), new ButtonItem.OnClickListener(){

            public void onClick() {
                if (StaggeredGridActivity.this.mTimeSlotTool.isProcessing()) {
                    return;
                }
                NavigationUtils.toGalleryPickPhotoActivity((Context)StaggeredGridActivity.this, StaggeredGridActivity.this.anchorId, StaggeredGridActivity.this.albumId, StaggeredGridActivity.this.mIsLastPage, StaggeredGridActivity.this.mPageNo);
            }
        });
        this.imageDialogItems.add(btnItem3);
    }

    private void showImageDialog() {
        ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "1001", "0008");
        ((IDialogLinkManagerCore)ICoreManagerBase.getCore(IDialogLinkManagerCore.class)).getDialogLinkManager().showCommonPopupDialog(this.imageDialogItems, this.getString(R.string.str_cancel), true, true);
    }

    public void initView() {
        this.mUploadProgress = (TextView)this.findViewById(R.id.staggered_upload_progress);
        this.mGridView = (PullToRefreshStaggeredGridView)this.findViewById(R.id.lv_amount_stagger);
        this.mGridView.setOnScrollListener((AbsListView.OnScrollListener)new PauseOnScrollListener(true, true));
        this.mGridView.setHeaderBackgroundColor(this.getResources().getColor(R.color.common_f1_color));
        this.mGridAdapter = new StaggeredGridAdapter((Context)this, (StaggeredGridView)this.mGridView.getRefreshableView(), false);
        this.mGridView.setOnRefreshListener((PullToRefreshBase.OnRefreshListener)new PullToRefreshBase.OnRefreshListener<StaggeredGridView>(){

            public void onRefresh(PullToRefreshBase<StaggeredGridView> refreshView) {
                if (!StaggeredGridActivity.this.checkNetToast()) {
                    StaggeredGridActivity.this.getHandler().removeCallbacks(StaggeredGridActivity.this.fixCompleteRefreshMsg);
                    StaggeredGridActivity.this.getHandler().postDelayed(StaggeredGridActivity.this.fixCompleteRefreshMsg, 300L);
                } else {
                    StaggeredGridActivity.this.misPull = true;
                    StaggeredGridActivity.this.refresh();
                    StaggeredGridActivity.this.getHandler().removeCallbacks(StaggeredGridActivity.this.checkRequestTimeoutTask);
                    StaggeredGridActivity.this.getHandler().postDelayed(StaggeredGridActivity.this.checkRequestTimeoutTask, TimeUtils.SECONDS.toMillis((long)10L));
                }
            }
        });
        this.mEndlessListScrollListener = new EndlessListScrollListener((StatusLayout)this.findViewById(R.id.status_container_stagger));
        this.mEndlessListScrollListener.setListener(new EndlessListScrollListener.EndlessListener(){

            public void onLoadData() {
                if (!StaggeredGridActivity.this.checkNetToast()) {
                    StaggeredGridActivity.this.getHandler().removeCallbacks(StaggeredGridActivity.this.fixCompleteRefreshMsg);
                    StaggeredGridActivity.this.getHandler().postDelayed(StaggeredGridActivity.this.fixCompleteRefreshMsg, 300L);
                } else {
                    StaggeredGridActivity.this.loadMore();
                }
            }

            public boolean shouldLoadData() {
                if (StaggeredGridActivity.this.mIsLastPage) {
                    new Handler().postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            StaggeredGridActivity.this.mEndlessListScrollListener.onLoadComplete();
                        }
                    }, 1000L);
                    return false;
                }
                return true;
            }
        });
        this.mEndlessListScrollListener.setParentOnScrollListener(new AbsListView.OnScrollListener(){

            public void onScrollStateChanged(AbsListView view, int scrollState) {
                if (scrollState == 0 && view != null && view.getLastVisiblePosition() == view.getCount() - 1 && StaggeredGridActivity.this.mIsLastPage && StaggeredGridActivity.this.misPull) {
                    StaggeredGridActivity.this.misPull = false;
                    Toast.makeText((Context)StaggeredGridActivity.this, (CharSequence)"\u5df2\u662f\u6700\u540e\u4e00\u9875", (int)0).show();
                }
            }

            public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
            }
        });
        this.mGridView.setOnScrollListener((AbsListView.OnScrollListener)this.mEndlessListScrollListener);
        this.staggeredGridView = (StaggeredGridView)this.mGridView.getRefreshableView();
        this.staggeredGridView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> adapterView, View view, int position, long id2) {
                if (StaggeredGridActivity.this.mTimeSlotTool.isProcessing()) {
                    return;
                }
                ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "1001", "0005");
                NavigationUtils.toGalleryNewDetailActivity((Context)StaggeredGridActivity.this, StaggeredGridActivity.this.anchorId, StaggeredGridActivity.this.albumId, StaggeredGridActivity.this.mGridAdapter.getItem(position), StaggeredGridActivity.this.mPageNo + 1, StaggeredGridActivity.this.mIsLastPage, 0, 100);
                ((IPhotoWatchCountCore)CoreManager.getCore(IPhotoWatchCountCore.class)).addGalleryStatics(StaggeredGridActivity.this.anchorId, ((StaggeredGridActivity)StaggeredGridActivity.this).mGridAdapter.getItem((int)position).photoId, 1);
            }
        });
        this.staggeredGridView.setAdapter((ListAdapter)this.mGridAdapter);
        RxViewExt.safelyClicks((View)this.mBtnUploadPhoto, (Consumer)new Consumer<Object>(){

            public void accept(Object o) throws Exception {
                PhotoUtils.choosePhoto((Activity)StaggeredGridActivity.this, null, null, (boolean)true);
            }
        });
        if (((IGalleryCore)CoreManager.getCore(IGalleryCore.class)).isUploading()) {
            UploadStatus us = ((IGalleryCore)CoreManager.getCore(IGalleryCore.class)).getUploadStatus();
            this.mUploadProgress.setText((CharSequence)String.format("\u6b63\u5728\u4e0a\u4f20 %d/%d", us.currentUploadingIndex + 1, us.uploadingCount));
            this.mUploadProgress.setVisibility(0);
        }
    }

    public void initData() {
        this.showLoading();
        this.misPull = true;
        this.refresh();
        this.getHandler().removeCallbacks(this.checkRequestTimeoutTask);
        this.getHandler().postDelayed(this.checkRequestTimeoutTask, TimeUtils.SECONDS.toMillis((long)10L));
    }

    protected void onResume() {
        super.onResume();
        this.isVisible = true;
        AlbumInfo albumInfo = ((IGalleryCore)CoreManager.getCore(IGalleryCore.class)).getAlbumInfo(this.anchorId, this.albumId);
        if (albumInfo != null && albumInfo.photos != null && albumInfo.photos.size() == 0) {
            for (String auth : this.mlist) {
                if (auth != null && ((IGalleryCore)CoreManager.getCore(IGalleryCore.class)).hasCreateRule(this.anchorId)) {
                    this.showNoData(R.drawable.icon_neirongkong, R.string.str_nodata_gallery_rule2);
                    this.mBtnUploadPhoto.setVisibility(0);
                    continue;
                }
                this.showNoData(R.drawable.icon_neirongkong, R.string.str_nodata_gallery_rule1);
                this.mBtnUploadPhoto.setVisibility(8);
            }
        }
    }

    protected void onPause() {
        super.onPause();
        this.isVisible = false;
    }

    public void initRequestData(int pageNo) {
        ((IGalleryCore)CoreManager.getCore(IGalleryCore.class)).queryGalleryStaggerdList(this.anchorId, this.albumId, pageNo, 30, 0);
    }

    public void fllushData(StaggeredGridInfo staggeredInfo) {
        if (staggeredInfo != null && this.albumName != null) {
            this.mGridAdapter.addDataItem(staggeredInfo.photos);
            this.simpleTitleBar.setTitlte(staggeredInfo.albumName);
        }
    }

    public void changeData(AlbumInfo staggeredInfo) {
        if (staggeredInfo != null && this.albumName != null) {
            this.mGridAdapter.changeDataItem(staggeredInfo.photos);
            this.simpleTitleBar.setTitlte(staggeredInfo.albumName);
        }
    }

    @BusEvent(busType=1, busName="plugin_main")
    public void onUploadStart(IGalleryClient_onUploadStart_EventArgs busEventArgs) {
        MLog.info((String)TAG, (String)"onUploadStart");
    }

    @BusEvent(busType=1, busName="plugin_main")
    public void onUploadProgress(IGalleryClient_onUploadProgress_EventArgs busEventArgs) {
        int currentUploadingIndex = busEventArgs.getCurrentUploadingIndex();
        int totalUploadCount = busEventArgs.getTotalUploadCount();
        MLog.info((Object)TAG, (String)"onUploadProgress: %d/%d", (Object[])new Object[]{currentUploadingIndex + 1, totalUploadCount});
        this.mUploadProgress.setText((CharSequence)String.format("\u6b63\u5728\u4e0a\u4f20 %d/%d", currentUploadingIndex + 1, totalUploadCount));
        this.mUploadProgress.setVisibility(0);
    }

    @BusEvent(busType=1, busName="plugin_main")
    public void onUploadFinish(IGalleryClient_onUploadFinish_EventArgs busEventArgs) {
        int failCount = busEventArgs.getFailCount();
        String errMsg = busEventArgs.getErrMsg();
        JsonObject data = busEventArgs.getData();
        MLog.info((String)TAG, (String)"onUploadFinish");
        if (failCount == 10000 && !StringUtils.isEmpty((String)errMsg).booleanValue()) {
            Toast.makeText((Context)this.getContext(), (CharSequence)errMsg, (int)0).show();
        }
        this.mUploadProgress.setVisibility(8);
        this.refresh();
    }

    @BusEvent(busType=1, busName="plugin_main")
    public void onModifyAlbum(IGalleryClient_onModifyAlbum_EventArgs busEventArgs) {
        boolean result = busEventArgs.getResult();
        String msg = busEventArgs.getMsg();
        long albumId = busEventArgs.getAlbumId();
        long anchorId = busEventArgs.getAnchorId();
        String newName = busEventArgs.getNewName();
        if (anchorId != this.anchorId || albumId != this.albumId) {
            return;
        }
        if (result) {
            this.simpleTitleBar.setTitlte(newName);
            this.albumName = newName;
            Toast.makeText((Context)this, (int)R.string.str_modify_gallery_success_tips, (int)0).show();
        } else {
            String tips = this.getString(R.string.str_modify_gallery_fail_tips);
            if (!TextUtils.isEmpty((CharSequence)msg)) {
                tips = tips + "\uff0c" + msg;
            }
            Toast.makeText((Context)this, (CharSequence)tips, (int)0).show();
        }
    }

    @BusEvent(busType=1, busName="plugin_main")
    public void onBatchDetelePhoto(IGalleryClient_onBatchDetelePhoto_EventArgs busEventArgs) {
        long anchorId = busEventArgs.getAnchorId();
        int succCount = busEventArgs.getSuccCount();
        int[] succPhotoIds = busEventArgs.getSuccPhotoIds();
        int resultCode = busEventArgs.getResultCode();
        if (!MLog.isLogLevelAboveVerbose()) {
            MLog.verbose((String)TAG, (String)("zs -- onBatchDetelePhoto " + succPhotoIds + " succCount " + succCount));
        }
        if (resultCode == 0 && succPhotoIds != null && succPhotoIds.length > 0) {
            this.changeData(((IGalleryCore)CoreManager.getCore(IGalleryCore.class)).getAlbumInfo(anchorId, this.albumId));
        }
    }

    @BusEvent(busType=1, busName="plugin_main")
    public void onQueryStaggerList(IGalleryClient_onQueryStaggerList_EventArgs busEventArgs) {
        StaggeredGridInfo staggeredInfo = busEventArgs.getStaggeredInfo();
        int pageNo = busEventArgs.getPage();
        this.hideStatus();
        if (this.mGridView != null) {
            this.mGridView.onRefreshComplete();
        }
        if (this.mEndlessListScrollListener != null) {
            this.mEndlessListScrollListener.onLoadComplete();
        }
        this.mBtnUploadPhoto.setVisibility(8);
        if (this.isVisible) {
            this.mPageNo = pageNo;
            if (staggeredInfo != null) {
                if (!MLog.isLogLevelAboveVerbose()) {
                    MLog.verbose((String)TAG, (String)("zs -- onQueryStaggerList  staggeredInfo.isEnd " + staggeredInfo.isEnd + " staggeredInfo.photos " + staggeredInfo.photos + " pageNo " + pageNo));
                }
                if (staggeredInfo.isEnd == 0) {
                    this.mIsLastPage = true;
                } else if (staggeredInfo.isEnd == 1) {
                    this.mIsLastPage = false;
                }
                if (staggeredInfo.photos != null) {
                    if (((IGalleryCore)CoreManager.getCore(IGalleryCore.class)).hasCreateRule(this.anchorId)) {
                        this.rightView.setVisibility(0);
                    } else {
                        this.rightView.setVisibility(8);
                    }
                    if (this.mPageNo == 1) {
                        if (staggeredInfo.photos.size() == 0) {
                            if (((IGalleryCore)CoreManager.getCore(IGalleryCore.class)).hasCreateRule(this.anchorId)) {
                                this.showNoData(R.drawable.icon_neirongkong, R.string.str_nodata_gallery_rule2);
                                this.mBtnUploadPhoto.setVisibility(0);
                            } else {
                                this.showNoData(R.drawable.icon_neirongkong, R.string.str_nodata_gallery_rule1);
                            }
                        }
                        this.changeData((AlbumInfo)staggeredInfo);
                    } else {
                        this.fllushData(staggeredInfo);
                    }
                } else if (((IGalleryCore)CoreManager.getCore(IGalleryCore.class)).hasCreateRule(this.anchorId)) {
                    this.showNoData(R.drawable.icon_neirongkong, R.string.str_nodata_gallery_rule2);
                    this.mBtnUploadPhoto.setVisibility(0);
                } else {
                    this.showNoData(R.drawable.icon_neirongkong, R.string.str_nodata_gallery_rule1);
                }
            } else {
                this.mBtnUploadPhoto.setVisibility(8);
                this.rightView.setVisibility(8);
                if (this.mPageNo == 1) {
                    this.showReload();
                } else {
                    this.showPageError(0);
                    this.checkNetToast();
                }
            }
        }
    }

    public View.OnClickListener getLoadListener() {
        return new View.OnClickListener(){

            public void onClick(View view) {
                StaggeredGridActivity.this.showLoading();
                StaggeredGridActivity.this.refresh();
            }
        };
    }

    private void refresh() {
        this.mPageNo = 1;
        this.initRequestData(this.mPageNo);
    }

    private void loadMore() {
        ++this.mPageNo;
        this.initRequestData(this.mPageNo);
    }

    protected void onDestroy() {
        super.onDestroy();
        ((IPhotoWatchCountCore)CoreManager.getCore(IPhotoWatchCountCore.class)).sendGalleryStatics();
    }

    public void onEventBind() {
        super.onEventBind();
        if (this.mEventBinder == null) {
            this.mEventBinder = new StaggeredGridActivity$$EventBinder();
        }
        this.mEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mEventBinder != null) {
            this.mEventBinder.unBindEvent();
        }
    }
}

