/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.gallery;

import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.ui.BaseDarkModeActivity;
import com.yy.mobile.ui.widget.SimpleTitleBar;
import com.yymobile.core.gallery.module.GalleryConst;

public class QualitySelectActivity
extends BaseDarkModeActivity
implements View.OnClickListener {
    int mSelectedPosition;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.layout_quality_select);
        this.initData();
        this.initLayout();
    }

    private void initData() {
        int code = this.getIntent().getIntExtra("params_selected_quality_code", 0);
        this.mSelectedPosition = QualitySelectActivity.indexOfCode(code);
    }

    public static int indexOfCode(int code) {
        for (int i = 0; i < GalleryConst.QUALITY_CODE.length; ++i) {
            if (code != GalleryConst.QUALITY_CODE[i]) continue;
            return i;
        }
        return -1;
    }

    private void initLayout() {
        SimpleTitleBar titleBar = (SimpleTitleBar)this.findViewById(R.id.title_bar);
        titleBar.setTitlte(this.getResources().getString(R.string.str_photo_quality));
        TextView leftView = (TextView)this.getLayoutInflater().inflate(R.layout.layout_titlebar_right_text_extra, null);
        leftView.setId(R.id.tv_left_button);
        leftView.setOnClickListener((View.OnClickListener)this);
        leftView.setText((CharSequence)this.getString(R.string.str_upload_photo));
        titleBar.setLeftView((View)leftView);
        View item1 = this.findViewById(R.id.quality_select_item1);
        item1.setOnClickListener((View.OnClickListener)this);
        View item2 = this.findViewById(R.id.quality_select_item2);
        item2.setOnClickListener((View.OnClickListener)this);
        this.updateItem(item1, 0);
        this.updateItem(item2, 1);
    }

    private void updateItem(View itemView, int position) {
        TextView name = (TextView)itemView.findViewById(R.id.quality_select_name);
        name.setText((CharSequence)GalleryConst.QUALITY_NAME[position]);
        TextView desc = (TextView)itemView.findViewById(R.id.quality_select_desc);
        desc.setText((CharSequence)GalleryConst.QUALITY_DESC[position]);
        ImageView selected = (ImageView)itemView.findViewById(R.id.quality_select_selected);
        if (this.mSelectedPosition == position) {
            selected.setVisibility(0);
            itemView.setSelected(true);
        } else {
            selected.setVisibility(4);
            itemView.setSelected(false);
        }
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.tv_left_button) {
            this.setResult(0);
            this.finish();
        } else if (id2 == R.id.quality_select_item1) {
            Intent intent = new Intent();
            this.mSelectedPosition = 0;
            intent.putExtra("result_params_quality_code", GalleryConst.QUALITY_CODE[this.mSelectedPosition]);
            this.setResult(-1, intent);
            this.finish();
        } else if (id2 == R.id.quality_select_item2) {
            Intent intent2 = new Intent();
            this.mSelectedPosition = 1;
            intent2.putExtra("result_params_quality_code", GalleryConst.QUALITY_CODE[this.mSelectedPosition]);
            this.setResult(-1, intent2);
            this.finish();
        }
    }
}

