/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.gallery;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.fragment.app.Fragment;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.facade.annotation.RouteDoc;
import com.yy.immersion.ImmersionBar;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.ui.BaseActivity;
import com.yy.mobile.ui.dialog.ButtonItem;
import com.yy.mobile.ui.dialog.DialogLinkManager;
import com.yy.mobile.ui.gallery.GalleryImageDetailFragment;
import com.yy.mobile.ui.gallery.ImagePagerFragment;
import com.yy.mobile.util.log.MLog;
import java.util.ArrayList;
import java.util.List;

@Route(path="/gallery/PhotoUploadPreviewActivity", name="\u56fe\u7247\u4e0a\u4f20\u9884\u89c8")
@RouteDoc(desc="\u56fe\u7247\u4e0a\u4f20\u9884\u89c8", minVer="7.16.0", eg=" yymobile://gallery/PhotoUploadPreviewActivity")
public class PhotoUploadPreviewActivity
extends BaseActivity
implements CompoundButton.OnCheckedChangeListener,
ImagePagerFragment.OnImageChangeListener,
GalleryImageDetailFragment.OnImageClickListener,
View.OnClickListener {
    private static final String TAG = "PhotoUploadPreviewActivity";
    private ArrayList<String> mData = new ArrayList();
    private ArrayList<String> mSelectedData;
    private int mCurrentPosition;
    private ImagePagerFragment mImagePager;
    private CheckBox mCurrentImageCheckbox;
    private ImageView mDelImageView;
    private TextView mTxtPhotoNumber;
    private TextView mTxtCancel;
    private View navBack;
    private String mFlagOfJump;
    private DialogLinkManager mDialogManager;
    private List<ButtonItem> mButtonItemList;
    private ButtonItem.OnClickListener mDelListener = new ButtonItem.OnClickListener(){

        public void onClick() {
            String path = (String)PhotoUploadPreviewActivity.this.mData.get(PhotoUploadPreviewActivity.this.mCurrentPosition);
            PhotoUploadPreviewActivity.this.mSelectedData.remove(path);
            PhotoUploadPreviewActivity.this.exit();
        }
    };

    @SuppressLint(value={"SetTextI18n"})
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.photo_upload_preview);
        Bundle data = savedInstanceState != null ? savedInstanceState : this.getIntent().getExtras();
        if (data == null) {
            MLog.error((String)TAG, (String)"data object can not null");
            return;
        }
        this.mFlagOfJump = data.getString("params_picture_flag_of_jump", "");
        this.mCurrentImageCheckbox = (CheckBox)this.findViewById(R.id.photo_pick_preview_check);
        this.mDelImageView = (ImageView)this.findViewById(R.id.photo_pick_preview_delete);
        this.mTxtPhotoNumber = (TextView)this.findViewById(R.id.txt_photo_number);
        this.mTxtCancel = (TextView)this.findViewById(R.id.txt_cancel);
        this.mDialogManager = new DialogLinkManager((Context)this);
        this.mButtonItemList = new ArrayList<ButtonItem>();
        this.mButtonItemList.add(new ButtonItem("\u5220\u9664", 2, this.mDelListener));
        this.mButtonItemList.add(new ButtonItem("\u53d6\u6d88", new ButtonItem.OnClickListener(){

            public void onClick() {
            }
        }));
        this.mDelImageView.setOnClickListener((View.OnClickListener)this);
        if ("comment".equals(this.mFlagOfJump)) {
            this.mCurrentImageCheckbox.setVisibility(8);
            this.mDelImageView.setVisibility(0);
            this.mTxtPhotoNumber.setVisibility(0);
            this.mTxtCancel.setVisibility(0);
        } else {
            this.mCurrentImageCheckbox.setVisibility(0);
            this.mDelImageView.setVisibility(8);
            this.mTxtPhotoNumber.setVisibility(8);
            this.mTxtCancel.setVisibility(8);
        }
        this.navBack = this.findViewById(R.id.sub_nav_back);
        this.navBack.setVisibility(data.getBoolean("params_with_back_nav", false) ? 0 : 8);
        this.navBack.setOnClickListener((View.OnClickListener)this);
        this.mData = data.getStringArrayList("params_preview_photos");
        this.mSelectedData = new ArrayList<String>(this.mData);
        this.mCurrentPosition = data.getInt("params_preview_position");
        if (this.mData != null && !this.mData.isEmpty() && this.mData.size() > this.mCurrentPosition) {
            this.mCurrentImageCheckbox.setChecked(this.mSelectedData.contains(this.mData.get(this.mCurrentPosition)));
        }
        this.mCurrentImageCheckbox.setOnCheckedChangeListener((CompoundButton.OnCheckedChangeListener)this);
        this.mTxtCancel.setText((CharSequence)"\u53d6\u6d88");
        this.mTxtCancel.setOnClickListener((View.OnClickListener)this);
        this.mTxtPhotoNumber.setText((CharSequence)(this.mCurrentPosition + 1 + "/" + this.mSelectedData.size()));
        this.showGallery();
    }

    private void showGallery() {
        this.mImagePager = ImagePagerFragment.newInstance(this.mData, (int)this.mCurrentPosition);
        this.mImagePager.setOnImageChangeListener((ImagePagerFragment.OnImageChangeListener)this);
        this.mImagePager.setImageClickListener((GalleryImageDetailFragment.OnImageClickListener)this);
        this.getSupportFragmentManager().beginTransaction().replace(R.id.photo_pick_preview_gallery, (Fragment)this.mImagePager).commitAllowingStateLoss();
    }

    public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
        if (this.mData.isEmpty() || this.mData.size() <= this.mCurrentPosition || this.mCurrentPosition < 0) {
            return;
        }
        String path = this.mData.get(this.mCurrentPosition);
        if (isChecked) {
            this.mSelectedData.add(path);
        } else {
            this.mSelectedData.remove(path);
        }
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.sub_nav_back) {
            this.exit();
        } else if (id2 == R.id.photo_pick_preview_back) {
            this.setResult(0);
            this.finish();
        } else if (id2 == R.id.photo_pick_preview_finish) {
            Intent data2 = new Intent();
            data2.putStringArrayListExtra("result_preview_photos", this.mSelectedData);
            this.setResult(-1, data2);
            this.finish();
        } else if (id2 == R.id.photo_pick_preview_delete) {
            this.mDialogManager.showCommonPopupDialog("\u786e\u8ba4\u5220\u9664\u8be5\u56fe\u7247\u5417", this.mButtonItemList, true, true);
        } else if (id2 == R.id.txt_cancel) {
            this.finish();
        }
    }

    @SuppressLint(value={"SetTextI18n"})
    public void onImageChange(int currentPosition, int totalCount, String currentUrl) {
        this.mCurrentImageCheckbox.setOnCheckedChangeListener(null);
        this.mCurrentImageCheckbox.setChecked(this.mSelectedData.contains(this.mData.get(currentPosition)));
        this.mCurrentImageCheckbox.setOnCheckedChangeListener((CompoundButton.OnCheckedChangeListener)this);
        this.mCurrentPosition = currentPosition;
        this.mTxtPhotoNumber.setText((CharSequence)(this.mCurrentPosition + 1 + "/" + this.mSelectedData.size()));
    }

    public void onNextRequest() {
    }

    public void onPrevRequest() {
    }

    public void onImageClick() {
        this.exit();
    }

    public void onImageLongClick() {
    }

    public void onBackPressed() {
        this.exit();
    }

    private void exit() {
        Intent data2 = new Intent();
        data2.putStringArrayListExtra("result_preview_photos", this.mSelectedData);
        this.setResult(-1, data2);
        this.finish();
    }

    protected boolean handleStatusBar() {
        this.immersionBar = ImmersionBar.with((Activity)this).fitsSystemWindows(true).statusBarColor(17170444).navigationBarColor(17170444).init();
        return true;
    }
}

