/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.gallery;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.os.AsyncTask;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.plugin.homepage.ui.utils.dialog.IBaseDialog;
import com.yy.mobile.plugin.homepage.ui.utils.dialog.ProgressDialog;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.ui.BaseDarkModeActivity;
import com.yy.mobile.ui.dialog.ButtonItem;
import com.yy.mobile.ui.dialog.IDialogLinkManagerCore;
import com.yy.mobile.ui.gallery.AlbumSelectActivity;
import com.yy.mobile.ui.gallery.PhotoUploadPreviewActivity;
import com.yy.mobile.ui.gallery.QualitySelectActivity;
import com.yy.mobile.ui.utils.NavigationUtils;
import com.yy.mobile.ui.widget.ImageManageGridLayout;
import com.yy.mobile.ui.widget.SimpleTitleBar;
import com.yy.mobile.ui.widget.toast.Toast;
import com.yy.mobile.util.MD5Utils;
import com.yy.mobile.util.ObjectTimeslotTool;
import com.yy.mobile.util.PhotoUtils;
import com.yy.mobile.util.YYFileUtils;
import com.yy.mobile.util.YYImageUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.CoreManager;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.gallery.IGalleryCore;
import com.yymobile.core.gallery.module.AlbumInfo;
import com.yymobile.core.gallery.module.GalleryConst;
import com.yymobile.core.gallery.module.UploadPhotoInfo;
import com.yymobile.core.statistic.IHiidoStatisticCore;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class PhotoUploadActivity
extends BaseDarkModeActivity
implements View.OnClickListener,
ImageManageGridLayout.OnItemClickListener {
    private static final String SP_KEY_LAST_UPLOAD_ALBUM = "sp_key_last_upload_album";
    private static final String TAG = "PhotoUploadActivity";
    private static int uploadType = -1;
    ImageManageGridLayout mChosenPhotos;
    private int mUploadQualityCode = 0;
    private long mAnchorId;
    private long mAlbumId;
    private String isComposed = "";
    private ArrayList<String> mUploadPhotoPaths = new ArrayList();
    private RecycleImageView mUploadAlbumCover;
    private TextView mUploadAlbumAlbumName;
    private TextView mUploadQualityName;
    private TextView mDescriptionText;
    private ObjectTimeslotTool mTimeSlotTool = new ObjectTimeslotTool();

    public static void launchPhotoUpload(Context context, long anchorId, long albumId, ArrayList<String> selected) {
        Intent intent = new Intent(context, PhotoUploadActivity.class);
        intent.putExtra("params_anchor_id", anchorId);
        intent.putExtra("params_album_id", albumId);
        if (selected != null) {
            intent.putExtra("params_selected_paths", selected);
        }
        context.startActivity(intent);
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.photo_upload);
        this.initLayout();
        this.initData();
    }

    private void initData() {
        AlbumInfo albumInfo;
        long albumId = this.getIntent().getLongExtra("params_album_id", 0L);
        this.mAnchorId = this.getIntent().getLongExtra("params_anchor_id", 0L);
        ArrayList selected = this.getIntent().getStringArrayListExtra("params_selected_paths");
        if (selected != null) {
            this.mUploadPhotoPaths.addAll(selected);
            this.mChosenPhotos.setImageFilePathList(this.mUploadPhotoPaths);
        }
        if ((albumInfo = ((IGalleryCore)CoreManager.getCore(IGalleryCore.class)).getAlbumInfo(this.mAnchorId, albumId)) == null) {
            SharedPreferences sp = this.getPreferences(0);
            long lastUploadAlbumId = sp.getLong(SP_KEY_LAST_UPLOAD_ALBUM + this.mAnchorId, 0L);
            albumInfo = ((IGalleryCore)CoreManager.getCore(IGalleryCore.class)).getAlbumInfo(this.mAnchorId, lastUploadAlbumId);
            if (albumInfo == null) {
                albumInfo = ((IGalleryCore)CoreManager.getCore(IGalleryCore.class)).getDefaultAlbum(this.mAnchorId);
            }
        }
        this.updateAlbumInfo(albumInfo);
        this.updateQuality(this.mUploadQualityCode, GalleryConst.QUALITY_NAME[QualitySelectActivity.indexOfCode(this.mUploadQualityCode)]);
    }

    private void initLayout() {
        SimpleTitleBar titleBar = (SimpleTitleBar)this.findViewById(R.id.title_bar);
        titleBar.setTitlte(this.getResources().getString(R.string.str_upload_picture));
        TextView leftView = (TextView)this.getLayoutInflater().inflate(R.layout.layout_titlebar_right_text_extra, null);
        leftView.setId(R.id.tv_left_button);
        leftView.setText((CharSequence)this.getString(R.string.str_my_message_cancel));
        titleBar.setLeftView((View)leftView);
        TextView rightView = (TextView)this.getLayoutInflater().inflate(R.layout.layout_titlebar_right_text_extra, null);
        rightView.setText((CharSequence)this.getString(R.string.str_upload2));
        titleBar.setRightView((View)rightView);
        this.mUploadAlbumAlbumName = (TextView)this.findViewById(R.id.photo_upload_gallery_name);
        this.mUploadAlbumCover = (RecycleImageView)this.findViewById(R.id.photo_upload_gallery_cover);
        this.mDescriptionText = (TextView)this.findViewById(R.id.photo_upload_gallery_description);
        this.mUploadQualityName = (TextView)this.findViewById(R.id.photo_upload_gallery_quality);
        View albumSelectItem = this.findViewById(R.id.photo_upload_album_select_item);
        View qualitySelectItem = this.findViewById(R.id.photo_upload_quality_select_item);
        ImageView addBtn = new ImageView((Context)this);
        addBtn.setId(R.id.photo_upload_gallery_add);
        addBtn.setImageResource(R.drawable.icon_add_more_selector);
        addBtn.setScaleType(ImageView.ScaleType.FIT_XY);
        this.mChosenPhotos = (ImageManageGridLayout)this.findViewById(R.id.photo_upload_chosen_photos);
        this.mChosenPhotos.setMaxCount(9);
        this.mChosenPhotos.setItemMargin(4);
        this.mChosenPhotos.setOperationBtn((View)addBtn, -1);
        this.mChosenPhotos.setOnItemClickListener((ImageManageGridLayout.OnItemClickListener)this);
        leftView.setOnClickListener((View.OnClickListener)this);
        rightView.setOnClickListener((View.OnClickListener)this);
        albumSelectItem.setOnClickListener((View.OnClickListener)this);
        qualitySelectItem.setOnClickListener((View.OnClickListener)this);
        addBtn.setOnClickListener((View.OnClickListener)this);
    }

    private void updateAlbumInfo(AlbumInfo albumInfo) {
        if (albumInfo != null) {
            this.mAlbumId = albumInfo.albumId;
            this.isComposed = albumInfo.isComposed;
            this.mUploadAlbumAlbumName.setVisibility(0);
            this.mUploadAlbumCover.setVisibility(0);
            this.mUploadAlbumAlbumName.setText((CharSequence)albumInfo.albumName);
            if (albumInfo.cover == null) {
                this.mUploadAlbumCover.setImageResource(R.drawable.icon_no_photo);
            } else {
                ImageLoader.loadImage((String)albumInfo.cover.thumbsUrl, (RecycleImageView)this.mUploadAlbumCover, (ImageConfig)ImageConfig.smallImageConfig(), (int)R.drawable.icon_loading);
            }
        } else {
            this.mAlbumId = 0L;
            this.mUploadAlbumAlbumName.setVisibility(4);
            this.mUploadAlbumCover.setVisibility(4);
        }
    }

    private void updateQuality(int qualityCode, String qualityName) {
        this.mUploadQualityName.setText((CharSequence)qualityName);
        this.mUploadQualityCode = qualityCode;
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        switch (requestCode) {
            case 1000: {
                if (resultCode != -1 || data == null) break;
                long selectedAlbumId = data.getLongExtra("result_params_selected_album", 0L);
                AlbumInfo albumInfo = ((IGalleryCore)CoreManager.getCore(IGalleryCore.class)).getAlbumInfo(this.mAnchorId, selectedAlbumId);
                this.updateAlbumInfo(albumInfo);
                break;
            }
            case 2000: {
                if (resultCode != -1 || data == null) break;
                int qualityCode = data.getIntExtra("result_params_quality_code", 0);
                String qualityName = GalleryConst.QUALITY_NAME[QualitySelectActivity.indexOfCode(qualityCode)];
                this.updateQuality(qualityCode, qualityName);
                break;
            }
            case 3000: {
                if (resultCode != -1 || data == null) break;
                ArrayList paths = data.getStringArrayListExtra("result_preview_photos");
                this.mUploadPhotoPaths.clear();
                if (paths != null) {
                    this.mUploadPhotoPaths.addAll(paths);
                }
                this.mChosenPhotos.setImageFilePathList(this.mUploadPhotoPaths);
                break;
            }
            case 2010: {
                if (resultCode != -1 || data == null) break;
                this.mUploadPhotoPaths.clear();
                break;
            }
            case 2011: {
                if (resultCode != -1 || data == null) break;
                String[] clipPaths = data.getStringArrayExtra("portrait_clip_key");
                if (clipPaths != null) {
                    this.mUploadPhotoPaths.addAll(Arrays.asList(clipPaths));
                }
                this.mChosenPhotos.setImageFilePathList(this.mUploadPhotoPaths);
                break;
            }
        }
    }

    public void onBackPressed() {
        this.showCancelUpload();
    }

    private void showCancelUpload() {
        ButtonItem item = new ButtonItem(this.getResources().getString(R.string.str_give_up_upload), new ButtonItem.OnClickListener(){

            public void onClick() {
                PhotoUploadActivity.this.finish();
            }
        });
        LinkedList<ButtonItem> list = new LinkedList<ButtonItem>();
        list.add(item);
        ((IDialogLinkManagerCore)ICoreManagerBase.getCore(IDialogLinkManagerCore.class)).getDialogLinkManager().showCommonPopupDialog(list, this.getResources().getString(R.string.str_cancel), true, true);
    }

    public void onClick(View v) {
        if (this.mTimeSlotTool.isProcessing()) {
            return;
        }
        int id2 = v.getId();
        if (id2 == R.id.photo_upload_gallery_add) {
            PhotoUtils.choosePhoto((Activity)this, null, this.mUploadPhotoPaths, (boolean)true);
        } else if (id2 == R.id.tv_left_button) {
            this.showCancelUpload();
        } else if (id2 == R.id.tv_right_button) {
            this.doUpload();
        } else if (id2 == R.id.photo_upload_album_select_item) {
            Intent intent = new Intent(v.getContext(), AlbumSelectActivity.class);
            intent.putExtra("params_requested_anchor_id", this.mAnchorId);
            this.startActivityForResult(intent, 1000);
            ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "1001", "0013");
        } else if (id2 == R.id.photo_upload_quality_select_item) {
            Intent intent1 = new Intent(v.getContext(), QualitySelectActivity.class);
            intent1.putExtra("params_selected_quality_code", this.mUploadQualityCode);
            this.startActivityForResult(intent1, 2000);
            ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "1001", "0014");
        }
    }

    public void onItemClick(ViewGroup parent, View view, int position) {
        if (this.mTimeSlotTool.isProcessing()) {
            return;
        }
        Intent intent = new Intent((Context)this, PhotoUploadPreviewActivity.class);
        intent.putExtra("params_preview_photos", this.mUploadPhotoPaths);
        intent.putExtra("params_preview_position", position);
        NavigationUtils.slideStartActivityForResult((Context)this, intent, 3000);
    }

    private void doUpload() {
        ArrayList<String> paths;
        long anchorId = this.mAnchorId;
        long albumId = this.mAlbumId;
        String desc = this.mDescriptionText.getText().toString().trim();
        if (!this.validate(anchorId, albumId, desc, paths = this.mUploadPhotoPaths)) {
            return;
        }
        CompressImageAsyncTask asyncTask = new CompressImageAsyncTask();
        if (this.mUploadQualityCode == 1) {
            asyncTask.mQuality = GalleryConst.PhotoQuality.HD;
        }
        asyncTask.anchorId = anchorId;
        asyncTask.albumId = albumId;
        asyncTask.desc = desc;
        asyncTask.uploadUserType = uploadType;
        asyncTask.execute(new List[]{paths});
        SharedPreferences sp = this.getPreferences(0);
        sp.edit().putLong(SP_KEY_LAST_UPLOAD_ALBUM + this.mAnchorId, albumId).apply();
    }

    private boolean validate(long anchorId, long albumId, String desc, List<String> paths) {
        if (paths == null || paths.isEmpty()) {
            Toast.makeText((Context)this, (CharSequence)"\u8bf7\u9009\u62e9\u7167\u7247", (int)0).show();
            return false;
        }
        if (albumId == 0L) {
            Toast.makeText((Context)this, (CharSequence)"\u8bf7\u9009\u62e9\u76f8\u518c", (int)0).show();
            return false;
        }
        if (desc.length() > 150) {
            Toast.makeText((Context)this, (CharSequence)"\u7167\u7247\u63cf\u8ff0\u4e0d\u8d85\u8fc7150\u5b57", (int)0).show();
            return false;
        }
        return true;
    }

    protected void configView() {
        ((SimpleTitleBar)this.findViewById(R.id.title_bar)).setConsiderStatusBar(true);
    }

    private class CompressImageAsyncTask
    extends AsyncTask<List<String>, Integer, List<UploadPhotoInfo>> {
        GalleryConst.PhotoQuality mQuality = GalleryConst.PhotoQuality.STANDER;
        long anchorId;
        long albumId;
        String desc;
        int uploadUserType;

        private CompressImageAsyncTask() {
        }

        protected void onPreExecute() {
            PhotoUploadActivity.this.getDialogLinkManager().showDialog((IBaseDialog)new ProgressDialog(PhotoUploadActivity.this.getString(R.string.str_tips_processing), false, true, 0, null));
        }

        protected List<UploadPhotoInfo> doInBackground(List<String> ... params) {
            List<String> paths = params[0];
            ArrayList<UploadPhotoInfo> compressedPaths = new ArrayList<UploadPhotoInfo>(paths.size());
            for (String bmpPath : paths) {
                int rotate = YYImageUtils.getCameraPhotoOrientation((String)bmpPath);
                Rect r = YYImageUtils.decodeBmpSize((String)bmpPath);
                File bmpFile = new File(bmpPath);
                String suffix = YYFileUtils.getFileExtension((String)bmpPath);
                File tmpFile = YYFileUtils.getTempFile((Context)PhotoUploadActivity.this, (String)("photo" + System.currentTimeMillis() + suffix));
                if (tmpFile.exists()) {
                    tmpFile.delete();
                }
                try {
                    tmpFile.createNewFile();
                }
                catch (IOException e) {
                    MLog.error((Object)PhotoUploadActivity.TAG, (Throwable)e);
                }
                String extension = YYFileUtils.getFileExtension((String)bmpPath);
                boolean isGif = false;
                if (extension != null && extension.equalsIgnoreCase(".gif")) {
                    isGif = true;
                }
                if (r.width() * r.height() < this.mQuality.width * this.mQuality.height || isGif) {
                    try {
                        YYFileUtils.copyFile((File)bmpFile, (File)tmpFile);
                        UploadPhotoInfo uploadPhotoInfo = new UploadPhotoInfo();
                        uploadPhotoInfo.path = tmpFile.getAbsolutePath();
                        uploadPhotoInfo.md5 = MD5Utils.getFileMD5String((File)tmpFile);
                        compressedPaths.add(uploadPhotoInfo);
                    }
                    catch (IOException e) {
                        MLog.error((Object)PhotoUploadActivity.TAG, (Throwable)e);
                    }
                    continue;
                }
                Matrix matrix = null;
                if (rotate > 0) {
                    matrix = new Matrix();
                    matrix.postRotate((float)rotate);
                }
                if (!YYImageUtils.resizeAndRotateImage((String)bmpPath, (String)tmpFile.getAbsolutePath(), (int)this.mQuality.width, (int)this.mQuality.height, (Matrix)matrix, (int)this.mQuality.quality)) continue;
                try {
                    UploadPhotoInfo uploadPhotoInfo = new UploadPhotoInfo();
                    uploadPhotoInfo.path = tmpFile.getAbsolutePath();
                    uploadPhotoInfo.md5 = MD5Utils.getFileMD5String((File)tmpFile);
                    compressedPaths.add(uploadPhotoInfo);
                }
                catch (IOException e) {
                    MLog.error((Object)PhotoUploadActivity.TAG, (Throwable)e);
                }
            }
            return compressedPaths;
        }

        protected void onPostExecute(List<UploadPhotoInfo> result) {
            if (PhotoUploadActivity.this.getContext() != null) {
                PhotoUploadActivity.this.getDialogLinkManager().dismissDialog();
            }
            ((IGalleryCore)CoreManager.getCore(IGalleryCore.class)).uploadPhoto(result, this.anchorId, this.albumId, this.desc, 0);
            if (this.uploadUserType == 1) {
                if (PhotoUploadActivity.this.isLogined()) {
                    NavigationUtils.toUserGallery(PhotoUploadActivity.this.getContext(), this.anchorId, true);
                    this.uploadUserType = -1;
                    uploadType = -1;
                    PhotoUploadActivity.this.finish();
                } else {
                    NavigationUtils.toLogin(PhotoUploadActivity.this.getContext(), true, false);
                }
            } else {
                PhotoUploadActivity.this.finish();
            }
        }
    }
}

