/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.gallery;

import android.app.Activity;
import android.os.Bundle;
import android.widget.TextView;
import androidx.fragment.app.Fragment;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.facade.annotation.RouteDoc;
import com.yy.immersion.ImmersionBar;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.ui.BaseActivity;
import com.yy.mobile.ui.gallery.GalleryImageDetailFragment;
import com.yy.mobile.ui.gallery.ImagePagerFragment;
import com.yy.mobile.ui.gallery.statistic.GalleryStatistic;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.moment.request.MomentFrom;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;

@Route(path="/Gallary/Preview", name="\u56fe\u7247\u5217\u8868")
@RouteDoc(desc="\u56fe\u7247\u9884\u89c8\u9875\uff0c\u80fd\u6a2a\u6ed1\u5207\u6362\u56fe\u7247\u5217\u8868", eg="\u53c2\u6570\u6709\u4e24\u4e2a\uff1apreview_photo_urls\u662f\u56fe\u7247url\u7684List<String>\uff0cpreview_photo_index\u662f\u5f53\u524d\u56fe\u7247\u7684\u7d22\u5f15\uff0c\u5982\u679c\u4ece\u52a8\u6001\u8df3\u8fc7\u6765\uff0c\u4f1a\u5e26\u4e0amid\uff0c\u5e26\u4e0afrom\u6807\u5fd7\u54ea\u4e2a\u52a8\u6001\u6765", minVer="7.7")
public class ImageListPreviewActivity
extends BaseActivity {
    private static final String TAG = "ImageListPreviewActivity";
    private List<String> urls;
    private int mCurrentPosition;
    private TextView imagePos;
    private ImagePagerFragment mImagePager;
    private String mid = "";
    private int from = MomentFrom.Other.getStatistic();

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_moment_image_preview);
        this.initIntent(savedInstanceState);
        if (this.urls != null && this.urls.size() > 0) {
            this.showGallery();
        }
        this.imagePos = (TextView)this.findViewById(R.id.image_position);
    }

    private void showGallery() {
        ArrayList<String> mImagePaths = new ArrayList<String>(this.urls.size());
        for (String info : this.urls) {
            try {
                String url = URLDecoder.decode(info, "utf-8");
                mImagePaths.add(url);
            }
            catch (UnsupportedEncodingException e) {
                MLog.error((Object)TAG, (Throwable)e);
            }
        }
        this.mImagePager = ImagePagerFragment.newInstance(mImagePaths, (int)this.mCurrentPosition, (int)1);
        this.mImagePager.setImageClickListener(new GalleryImageDetailFragment.OnImageClickListener(){

            public void onImageClick() {
                ImageListPreviewActivity.this.finish();
            }

            public void onImageLongClick() {
            }
        });
        this.mImagePager.setOnImageChangeListener(new ImagePagerFragment.OnImageChangeListener(){

            public void onImageChange(int currentPosition, int totalCount, String currentUrl) {
                GalleryStatistic.momentStatistic(ImageListPreviewActivity.this.mid, MomentFrom.Companion.invoke(ImageListPreviewActivity.this.from));
                String posStr = ++currentPosition + "/" + totalCount;
                ImageListPreviewActivity.this.imagePos.setText((CharSequence)posStr);
            }

            public void onNextRequest() {
            }

            public void onPrevRequest() {
            }
        });
        this.getSupportFragmentManager().beginTransaction().replace(R.id.moment_iamge_preview_area, (Fragment)this.mImagePager).commitAllowingStateLoss();
    }

    private void initIntent(Bundle savedInstanceState) {
        Bundle data = savedInstanceState != null ? savedInstanceState : this.getIntent().getExtras();
        if (data != null) {
            this.urls = data.getStringArrayList("preview_photo_urls");
            this.mCurrentPosition = data.getInt("preview_photo_index");
            this.mid = data.getString("mid", "");
            this.from = data.getInt("from", 0);
        }
        if (this.urls == null || this.urls.isEmpty()) {
            this.finish();
        }
    }

    protected void onDestroy() {
        super.onDestroy();
    }

    protected boolean handleStatusBar() {
        this.immersionBar = ImmersionBar.with((Activity)this).fitsSystemWindows(true).statusBarColor(17170444).init();
        return true;
    }
}

