/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.gallery;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.RelativeLayout;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.CoreManager;
import com.yymobile.core.gallery.IGalleryCore;
import com.yymobile.core.gallery.module.PhotoInfo;
import java.util.ArrayList;
import java.util.List;

public class GalleryPickPhotoAdapter
extends BaseAdapter {
    private static final String TAG = "GalleryPickPhotoAdapter";
    private LayoutInflater mInflater;
    public Context mContext;
    public ArrayList<PhotoInfo> mData;
    private DataChangedListener mDataChanged;
    public long mAnchorId;
    private View.OnClickListener mItemClick = new View.OnClickListener(){

        public void onClick(View v) {
            PhotoInfo info = (PhotoInfo)v.getTag();
            if (info != null && ((IGalleryCore)CoreManager.getCore(IGalleryCore.class)).compareRule(GalleryPickPhotoAdapter.this.mAnchorId, info.permission)) {
                if (info.selected) {
                    info.selected = false;
                    if (GalleryPickPhotoAdapter.this.mDataChanged != null) {
                        GalleryPickPhotoAdapter.this.mDataChanged.dataChanged();
                    }
                } else {
                    info.selected = true;
                    if (GalleryPickPhotoAdapter.this.mDataChanged != null) {
                        GalleryPickPhotoAdapter.this.mDataChanged.dataChanged();
                    }
                }
                GalleryPickPhotoAdapter.this.notifyDataSetChanged();
            }
        }
    };
    private CompoundButton.OnCheckedChangeListener mChecked = new CompoundButton.OnCheckedChangeListener(){

        public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
            try {
                PhotoInfo info = (PhotoInfo)buttonView.getTag();
                if (info != null && info.selected != isChecked) {
                    info.selected = isChecked;
                    if (GalleryPickPhotoAdapter.this.mDataChanged != null) {
                        GalleryPickPhotoAdapter.this.mDataChanged.dataChanged();
                    }
                }
            }
            catch (Exception e) {
                MLog.error((String)GalleryPickPhotoAdapter.TAG, (String)("xuwakao, exception occurs, e = " + e));
            }
        }
    };

    public GalleryPickPhotoAdapter(Context context, long anchorId) {
        this.mContext = context;
        this.mInflater = LayoutInflater.from((Context)context);
        this.mAnchorId = anchorId;
        if (this.mData == null) {
            this.mData = new ArrayList();
        }
    }

    public void addItemPhoto(List<PhotoInfo> data) {
        if (data != null && data.size() > 0) {
            this.mData.addAll(data);
        }
        this.notifyDataSetChanged();
    }

    public void changeDataItem(List<PhotoInfo> mPhotoInfo) {
        this.mData.clear();
        if (mPhotoInfo != null) {
            this.mData.addAll(mPhotoInfo);
            this.setOnSelected();
        }
        this.notifyDataSetChanged();
    }

    public int getRealSize() {
        if (this.mData != null && this.mData.size() > 0) {
            return this.mData.size();
        }
        return 0;
    }

    public int getCount() {
        if (this.mData.size() % 3 == 0) {
            return this.mData.size() / 3;
        }
        return this.mData.size() / 3 + 1;
    }

    public PhotoInfo getItem(int position) {
        return null;
    }

    public long getItemId(int position) {
        return 0L;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        String url;
        PhotoInfo info;
        ViewHolder holder;
        if (convertView == null) {
            convertView = this.mInflater.inflate(R.layout.item_photo_new_pick, parent, false);
            holder = new ViewHolder();
            holder.container1 = convertView.findViewById(R.id.container1);
            holder.container1.setOnClickListener(this.mItemClick);
            holder.hideView1 = convertView.findViewById(R.id.android_container_gray1);
            holder.select1 = (CheckBox)holder.container1.findViewById(R.id.selected1);
            holder.select1.setOnCheckedChangeListener(this.mChecked);
            holder.thumb1 = (RecycleImageView)convertView.findViewById(R.id.thumb1);
            holder.container2 = convertView.findViewById(R.id.container2);
            holder.container2.setOnClickListener(this.mItemClick);
            holder.hideView2 = convertView.findViewById(R.id.android_container_gray2);
            holder.select2 = (CheckBox)holder.container2.findViewById(R.id.selected2);
            holder.select2.setOnCheckedChangeListener(this.mChecked);
            holder.thumb2 = (RecycleImageView)convertView.findViewById(R.id.thumb2);
            holder.container3 = convertView.findViewById(R.id.container3);
            holder.container3.setOnClickListener(this.mItemClick);
            holder.hideView3 = convertView.findViewById(R.id.android_container_gray3);
            holder.select3 = (CheckBox)holder.container3.findViewById(R.id.selected3);
            holder.select3.setOnCheckedChangeListener(this.mChecked);
            holder.thumb3 = (RecycleImageView)convertView.findViewById(R.id.thumb3);
            int height = (int)(((float)ResolutionUtils.getScreenWidth((Context)this.mContext) - ResolutionUtils.convertDpToPixel((float)10.0f, (Context)this.mContext)) / 3.0f);
            holder.thumb1.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, height));
            holder.thumb2.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, height));
            holder.thumb3.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, height));
            convertView.setTag((Object)holder);
        } else {
            holder = (ViewHolder)convertView.getTag();
        }
        int index = position * 3;
        if (index < this.mData.size()) {
            holder.container1.setVisibility(0);
            info = this.mData.get(index);
            holder.container1.setTag((Object)info);
            if (((IGalleryCore)CoreManager.getCore(IGalleryCore.class)).compareRule(this.mAnchorId, info.permission)) {
                holder.hideView1.setVisibility(8);
                holder.select1.setVisibility(0);
                holder.select1.setTag((Object)info);
                holder.select1.setChecked(info.selected);
            } else {
                holder.hideView1.setVisibility(0);
                holder.select1.setVisibility(8);
            }
            url = FP.empty((CharSequence)info.thumbsUrl) ? "" : info.thumbsUrl;
            ImageLoader.loadImage((String)url, (RecycleImageView)holder.thumb1, (ImageConfig)ImageConfig.smallImageConfig(), (int)R.drawable.hp_living_default_bg, (int)0);
        } else {
            holder.container1.setVisibility(4);
        }
        if (index + 1 < this.mData.size()) {
            holder.container2.setVisibility(0);
            info = this.mData.get(index + 1);
            holder.container2.setTag((Object)info);
            if (((IGalleryCore)CoreManager.getCore(IGalleryCore.class)).compareRule(this.mAnchorId, info.permission)) {
                holder.hideView2.setVisibility(8);
                holder.select2.setVisibility(0);
                holder.select2.setTag((Object)info);
                holder.select2.setChecked(info.selected);
            } else {
                holder.hideView2.setVisibility(0);
                holder.select2.setVisibility(8);
            }
            url = FP.empty((CharSequence)info.thumbsUrl) ? "" : info.thumbsUrl;
            ImageLoader.loadImage((String)url, (RecycleImageView)holder.thumb2, (ImageConfig)ImageConfig.smallImageConfig(), (int)R.drawable.hp_living_default_bg, (int)0);
        } else {
            holder.container2.setVisibility(4);
        }
        if (index + 2 < this.mData.size()) {
            holder.container3.setVisibility(0);
            info = this.mData.get(index + 2);
            holder.container3.setTag((Object)info);
            if (((IGalleryCore)CoreManager.getCore(IGalleryCore.class)).compareRule(this.mAnchorId, info.permission)) {
                holder.hideView3.setVisibility(8);
                holder.select3.setVisibility(0);
                holder.select3.setTag((Object)info);
                holder.select3.setChecked(info.selected);
            } else {
                holder.hideView3.setVisibility(0);
                holder.select3.setVisibility(8);
            }
            url = FP.empty((CharSequence)info.thumbsUrl) ? "" : info.thumbsUrl;
            ImageLoader.loadImage((String)url, (RecycleImageView)holder.thumb3, (ImageConfig)ImageConfig.smallImageConfig(), (int)R.drawable.hp_living_default_bg, (int)0);
        } else {
            holder.container3.setVisibility(4);
        }
        return convertView;
    }

    public ArrayList<PhotoInfo> getSelectedData() {
        ArrayList<PhotoInfo> selected = new ArrayList<PhotoInfo>();
        selected.clear();
        for (PhotoInfo info : this.mData) {
            if (!info.selected) continue;
            selected.add(info);
        }
        return selected;
    }

    public void setOnSelected() {
        if (this.mData != null && this.mData.size() > 0) {
            for (PhotoInfo info : this.mData) {
                if (!info.selected) continue;
                info.selected = false;
            }
        }
    }

    public void setDataChanged(DataChangedListener dataChanged) {
        this.mDataChanged = dataChanged;
    }

    public DataChangedListener getDataChanged() {
        return this.mDataChanged;
    }

    public static interface DataChangedListener {
        public void dataChanged();
    }

    private static class ViewHolder {
        public View container1;
        public View hideView1;
        public RecycleImageView thumb1;
        public CheckBox select1;
        public View container2;
        public View hideView2;
        public RecycleImageView thumb2;
        public CheckBox select2;
        public View container3;
        public View hideView3;
        public RecycleImageView thumb3;
        public CheckBox select3;

        private ViewHolder() {
        }
    }
}

