/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.gallery;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import android.view.View;
import android.widget.AbsListView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.handmark.pulltorefresh.library.PullToRefreshBase;
import com.handmark.pulltorefresh.library.PullToRefreshListView;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.mobile.plugin.homepage.ui.utils.dialog.IBaseDialog;
import com.yy.mobile.plugin.homepage.ui.utils.dialog.ProgressDialog;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.plugin.main.events.IGalleryClient_onBatchDetelePhoto_EventArgs;
import com.yy.mobile.plugin.main.events.IGalleryClient_onQueryStaggerList_EventArgs;
import com.yy.mobile.ui.BaseDarkModeActivity;
import com.yy.mobile.ui.dialog.ButtonItem;
import com.yy.mobile.ui.dialog.IDialogLinkManagerCore;
import com.yy.mobile.ui.gallery.GalleryPickPhotoActivity$$EventBinder;
import com.yy.mobile.ui.gallery.GalleryPickPhotoAdapter;
import com.yy.mobile.ui.widget.EndlessListScrollListener;
import com.yy.mobile.ui.widget.SimpleTitleBar;
import com.yy.mobile.ui.widget.StatusLayout;
import com.yy.mobile.ui.widget.toast.Toast;
import com.yy.mobile.util.TimeUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.CoreManager;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.gallery.IGalleryCore;
import com.yymobile.core.gallery.module.AlbumInfo;
import com.yymobile.core.gallery.module.PhotoInfo;
import com.yymobile.core.gallery.module.StaggeredGridInfo;
import java.util.ArrayList;
import java.util.List;

public class GalleryPickPhotoActivity
extends BaseDarkModeActivity {
    public static final String TAG = "GalleryPickPhotoActivity";
    private GalleryPickPhotoAdapter mAdapter;
    private SimpleTitleBar simpleTitleBar;
    private List<PhotoInfo> albumInfos = new ArrayList<PhotoInfo>();
    public static final String GALLERY_PHOTO_ANCHORID = "gallery_photo_anchorid";
    public static final String GALLERY_PHOTO_ALUMID = "gallery_photo_alumid";
    public static final String GALLERY_ISEND = "gallery_isend";
    public static final String GALLERT_PAGENO = "gallery_pageno";
    private long alumId;
    private long anchorId;
    private PullToRefreshListView mListView;
    private TextView mDelete;
    private TextView mCount;
    private EndlessListScrollListener mEndlessListScrollListener;
    private List<PhotoInfo> mDeteInfos = new ArrayList<PhotoInfo>();
    private boolean mIsLastPage = false;
    private boolean isEnd;
    private int mPageNo = 1;
    public static final int PAGE_SIZE = 30;
    private List<ButtonItem> imageDialogItems = new ArrayList<ButtonItem>();
    private ButtonItem btnItem1;
    public GalleryPickPhotoAdapter.DataChangedListener mChanged = new GalleryPickPhotoAdapter.DataChangedListener(){

        @Override
        public void dataChanged() {
            int count = GalleryPickPhotoActivity.this.mAdapter.getSelectedData().size();
            if (!MLog.isLogLevelAboveVerbose()) {
                MLog.verbose((String)GalleryPickPhotoActivity.TAG, (String)("zs, count = " + count));
            }
            String text = count + "/" + GalleryPickPhotoActivity.this.mAdapter.getRealSize();
            if (GalleryPickPhotoActivity.this.mDeteInfos != null) {
                GalleryPickPhotoActivity.this.mDeteInfos.clear();
                GalleryPickPhotoActivity.this.mDeteInfos.addAll(GalleryPickPhotoActivity.this.mAdapter.getSelectedData());
            }
            GalleryPickPhotoActivity.this.mCount.setText((CharSequence)text);
            GalleryPickPhotoActivity.this.mDelete.setEnabled(count > 0);
        }
    };
    private Runnable fixCompleteRefreshMsg = new Runnable(){

        @Override
        public void run() {
            if (GalleryPickPhotoActivity.this.mListView != null) {
                GalleryPickPhotoActivity.this.mListView.onRefreshComplete();
            }
            if (GalleryPickPhotoActivity.this.mEndlessListScrollListener != null) {
                GalleryPickPhotoActivity.this.mEndlessListScrollListener.onLoadComplete();
            }
        }
    };
    private Runnable checkRequestTimeoutTask = new Runnable(){

        @Override
        public void run() {
            GalleryPickPhotoActivity.this.hideStatus();
            GalleryPickPhotoActivity.this.mListView.onRefreshComplete();
            if (GalleryPickPhotoActivity.this.mAdapter.getCount() == 0) {
                GalleryPickPhotoActivity.this.showReload();
            }
        }
    };
    private EventBinder mEventBinder;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.layout_grallery_pick_photos);
        this.anchorId = this.getIntent().getLongExtra(GALLERY_PHOTO_ANCHORID, 0L);
        this.alumId = this.getIntent().getLongExtra(GALLERY_PHOTO_ALUMID, 0L);
        this.isEnd = this.getIntent().getBooleanExtra(GALLERY_ISEND, false);
        this.mPageNo = this.getIntent().getIntExtra(GALLERT_PAGENO, 1);
        this.initTitle();
        this.initView();
        this.initListener();
        this.initImageDialog();
    }

    public void initTitle() {
        this.simpleTitleBar = (SimpleTitleBar)this.findViewById(R.id.title_bar);
        TextView rightView = (TextView)this.getLayoutInflater().inflate(R.layout.layout_titlebar_right_text_extra, null);
        rightView.setText((CharSequence)this.getString(R.string.str_maneger_cancel));
        this.simpleTitleBar.setRightView((View)rightView);
        rightView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                GalleryPickPhotoActivity.this.mAdapter.setOnSelected();
                GalleryPickPhotoActivity.this.finish();
            }
        });
    }

    public void initView() {
        this.mListView = (PullToRefreshListView)this.findViewById(R.id.select_gralley_listview);
        this.mListView.setMode(PullToRefreshBase.Mode.PULL_FROM_START);
        this.mListView.setOnRefreshListener((PullToRefreshBase.OnRefreshListener)new PullToRefreshBase.OnRefreshListener<ListView>(){

            public void onRefresh(PullToRefreshBase<ListView> refreshView) {
                if (!GalleryPickPhotoActivity.this.checkNetToast()) {
                    GalleryPickPhotoActivity.this.getHandler().removeCallbacks(GalleryPickPhotoActivity.this.fixCompleteRefreshMsg);
                    GalleryPickPhotoActivity.this.getHandler().postDelayed(GalleryPickPhotoActivity.this.fixCompleteRefreshMsg, 300L);
                } else {
                    GalleryPickPhotoActivity.this.refresh();
                    GalleryPickPhotoActivity.this.getHandler().removeCallbacks(GalleryPickPhotoActivity.this.checkRequestTimeoutTask);
                    GalleryPickPhotoActivity.this.getHandler().postDelayed(GalleryPickPhotoActivity.this.checkRequestTimeoutTask, TimeUtils.SECONDS.toMillis((long)10L));
                }
            }
        });
        this.mEndlessListScrollListener = new EndlessListScrollListener((StatusLayout)this.findViewById(R.id.status_container_gallery));
        this.mEndlessListScrollListener.setListener(new EndlessListScrollListener.EndlessListener(){

            public void onLoadData() {
                if (!GalleryPickPhotoActivity.this.checkNetToast()) {
                    GalleryPickPhotoActivity.this.getHandler().removeCallbacks(GalleryPickPhotoActivity.this.fixCompleteRefreshMsg);
                    GalleryPickPhotoActivity.this.getHandler().postDelayed(GalleryPickPhotoActivity.this.fixCompleteRefreshMsg, 300L);
                } else {
                    if (!MLog.isLogLevelAboveVerbose()) {
                        MLog.verbose((String)GalleryPickPhotoActivity.TAG, (String)("zs-- " + GalleryPickPhotoActivity.this.isEnd + " mIsLastPage " + GalleryPickPhotoActivity.this.mIsLastPage));
                    }
                    if (GalleryPickPhotoActivity.this.isEnd) {
                        new Handler().postDelayed(new Runnable(){

                            @Override
                            public void run() {
                                GalleryPickPhotoActivity.this.mEndlessListScrollListener.onLoadComplete();
                            }
                        }, 1000L);
                    }
                    if (!GalleryPickPhotoActivity.this.isEnd && !GalleryPickPhotoActivity.this.mIsLastPage) {
                        GalleryPickPhotoActivity.this.loadMore();
                    }
                }
            }

            public boolean shouldLoadData() {
                if (GalleryPickPhotoActivity.this.mIsLastPage) {
                    new Handler().postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            GalleryPickPhotoActivity.this.mEndlessListScrollListener.onLoadComplete();
                        }
                    }, 500L);
                    return false;
                }
                return true;
            }
        });
        this.mListView.setOnScrollListener((AbsListView.OnScrollListener)this.mEndlessListScrollListener);
        this.mAdapter = new GalleryPickPhotoAdapter((Context)this, this.anchorId);
        this.mAdapter.setDataChanged(this.mChanged);
        this.mListView.setAdapter((ListAdapter)this.mAdapter);
        this.initData();
    }

    public void initListener() {
        this.mCount = (TextView)this.findViewById(R.id.count_test);
        if (this.albumInfos != null) {
            this.mCount.setText((CharSequence)("0/" + this.albumInfos.size()));
        }
        this.mDelete = (TextView)this.findViewById(R.id.complete_test);
        this.mDelete.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                GalleryPickPhotoActivity.this.btnItem1 = (ButtonItem)GalleryPickPhotoActivity.this.imageDialogItems.get(0);
                GalleryPickPhotoActivity.this.btnItem1.setText("\u5220\u9664" + GalleryPickPhotoActivity.this.mDeteInfos.size() + "\u5f20\u56fe\u7247");
                GalleryPickPhotoActivity.this.showImageDialog();
            }
        });
    }

    public void initData() {
        AlbumInfo info = ((IGalleryCore)CoreManager.getCore(IGalleryCore.class)).getAlbumInfo(this.anchorId, this.alumId);
        if (info != null) {
            this.albumInfos = info.photos;
            this.simpleTitleBar.setTitlte(info.albumName);
            this.mAdapter.addItemPhoto(this.albumInfos);
        }
    }

    public void changeData() {
        AlbumInfo info = ((IGalleryCore)CoreManager.getCore(IGalleryCore.class)).getAlbumInfo(this.anchorId, this.alumId);
        if (info != null) {
            Toast.makeText((Context)this, (CharSequence)"\u5220\u9664\u6210\u529f", (int)0).show();
            this.albumInfos = info.photos;
            this.simpleTitleBar.setTitlte(info.albumName);
            this.mAdapter.changeDataItem(this.albumInfos);
            this.mCount.setText((CharSequence)(this.mAdapter.getSelectedData().size() + "/" + this.mAdapter.getRealSize()));
            if (this.albumInfos.size() == 0) {
                this.showNoData(R.drawable.icon_neirongkong, R.string.str_nodata_gallery_rule2);
            }
        }
    }

    public void changeFailData() {
        AlbumInfo info = ((IGalleryCore)CoreManager.getCore(IGalleryCore.class)).getAlbumInfo(this.anchorId, this.alumId);
        if (info != null) {
            this.albumInfos = info.photos;
            this.simpleTitleBar.setTitlte(info.albumName);
            this.mAdapter.setOnSelected();
            this.mAdapter.notifyDataSetChanged();
            this.mCount.setText((CharSequence)(this.mAdapter.getSelectedData().size() + "/" + this.mAdapter.getRealSize()));
        }
    }

    private void refresh() {
        this.mPageNo = 1;
        this.initRequestData(this.mPageNo);
    }

    private void loadMore() {
        ++this.mPageNo;
        this.initRequestData(this.mPageNo);
    }

    public void initRequestData(int pageNo) {
        ((IGalleryCore)CoreManager.getCore(IGalleryCore.class)).queryGalleryStaggerdList(this.anchorId, this.alumId, pageNo, 30, 0);
    }

    public void fllushData(StaggeredGridInfo staggeredInfo) {
        if (staggeredInfo != null) {
            this.mAdapter.addItemPhoto(staggeredInfo.photos);
            this.mCount.setText((CharSequence)(this.mAdapter.getSelectedData().size() + "/" + this.mAdapter.getRealSize()));
        }
    }

    public void changeData(StaggeredGridInfo staggeredInfo) {
        this.mDelete.setEnabled(false);
        if (staggeredInfo != null) {
            this.mAdapter.changeDataItem(staggeredInfo.photos);
            this.mCount.setText((CharSequence)(this.mAdapter.getSelectedData().size() + "/" + this.mAdapter.getRealSize()));
        }
    }

    @BusEvent(busType=1, busName="plugin_main")
    public void onBatchDetelePhoto(IGalleryClient_onBatchDetelePhoto_EventArgs busEventArgs) {
        int succCount = busEventArgs.getSuccCount();
        int[] succPhotoIds = busEventArgs.getSuccPhotoIds();
        int resultCode = busEventArgs.getResultCode();
        String errorMsg = busEventArgs.getErrorMsg();
        if (!MLog.isLogLevelAboveVerbose()) {
            MLog.verbose((String)TAG, (String)("zs -- onBatchDetelePhoto " + succPhotoIds + " succCount " + succCount));
        }
        this.getDialogLinkManager().dismissDialog();
        this.mDelete.setEnabled(false);
        if (resultCode == 0) {
            if (succPhotoIds != null && succPhotoIds.length > 0) {
                this.changeData();
            }
        } else {
            this.changeFailData();
            if (this.checkNetToast()) {
                String tips = this.getString(R.string.str_delete_photo_fail);
                if (!TextUtils.isEmpty((CharSequence)errorMsg)) {
                    tips = tips + "\uff0c" + errorMsg;
                }
                Toast.makeText((Context)this, (CharSequence)tips, (int)0).show();
            }
        }
    }

    @BusEvent(busType=1, busName="plugin_main")
    public void onQueryStaggerList(IGalleryClient_onQueryStaggerList_EventArgs busEventArgs) {
        StaggeredGridInfo staggeredInfo = busEventArgs.getStaggeredInfo();
        int pageNo = busEventArgs.getPage();
        if (!MLog.isLogLevelAboveVerbose()) {
            MLog.verbose((String)TAG, (String)("zs -- onQueryStaggerList " + staggeredInfo + " pageNo " + pageNo));
        }
        this.hideStatus();
        if (this.mListView != null) {
            this.mListView.onRefreshComplete();
        }
        if (this.mEndlessListScrollListener != null) {
            this.mEndlessListScrollListener.onLoadComplete();
        }
        this.mPageNo = pageNo;
        if (staggeredInfo != null) {
            if (staggeredInfo.isEnd == 0) {
                this.mIsLastPage = true;
                this.isEnd = true;
            } else if (staggeredInfo.isEnd == 1) {
                this.mIsLastPage = false;
                this.isEnd = false;
            }
            if (staggeredInfo.photos != null && staggeredInfo.photos.size() > 0) {
                if (this.mPageNo == 1) {
                    this.changeData(staggeredInfo);
                } else {
                    this.fllushData(staggeredInfo);
                }
            }
        } else if (this.mPageNo == 1) {
            this.showReload();
        } else {
            this.showPageError(0);
            this.checkNetToast();
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
    }

    private void initImageDialog() {
        ButtonItem btnItem1 = new ButtonItem("", new ButtonItem.OnClickListener(){

            public void onClick() {
                if (GalleryPickPhotoActivity.this.mDeteInfos != null && GalleryPickPhotoActivity.this.mDeteInfos.size() > 0 && GalleryPickPhotoActivity.this.checkNetToast()) {
                    GalleryPickPhotoActivity.this.getDialogLinkManager().showDialog((IBaseDialog)new ProgressDialog("", true, true, 0, null));
                    ((IGalleryCore)CoreManager.getCore(IGalleryCore.class)).batchDeleteStaggerPhoto(GalleryPickPhotoActivity.this.anchorId, GalleryPickPhotoActivity.this.alumId, 0L, GalleryPickPhotoActivity.this.mDeteInfos);
                }
            }
        });
        this.imageDialogItems.add(btnItem1);
    }

    private void showImageDialog() {
        ((IDialogLinkManagerCore)ICoreManagerBase.getCore(IDialogLinkManagerCore.class)).getDialogLinkManager().showCommonPopupDialog(this.imageDialogItems, this.getString(R.string.str_cancel), true, true);
    }

    public void onEventBind() {
        super.onEventBind();
        if (this.mEventBinder == null) {
            this.mEventBinder = new GalleryPickPhotoActivity$$EventBinder();
        }
        this.mEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mEventBinder != null) {
            this.mEventBinder.unBindEvent();
        }
    }
}

