/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.gallery;

import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.plugin.main.events.IGalleryClient_onNewQueryPhotoDec_EventArgs;
import com.yy.mobile.ui.BaseLinkFragment;
import com.yy.mobile.ui.gallery.GalleryAnchorDetailAdapter;
import com.yy.mobile.ui.gallery.GalleryPagerFragment$$EventBinder;
import com.yy.mobile.ui.widget.FixedTouchViewPager;
import com.yy.mobile.ui.widget.toast.Toast;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.CoreManager;
import com.yymobile.core.gallery.IGalleryCore;
import com.yymobile.core.gallery.module.PhotoInfo;
import java.util.ArrayList;

public class GalleryPagerFragment
extends BaseLinkFragment {
    private static final String TAG = "GalleryPagerFragment";
    private long anchorId;
    private long alumId;
    private long photoId;
    private int currentPosition;
    private static final String ANCHORID_KEY = "anchorId";
    private static final String ALUMID_KEY = "alumId";
    private static final String POSITION_KEY = "position";
    private static final String PHOTOINFO_KEY = "photoinfo";
    private static final String PHOTOINFOS_KEY = "photoinfos";
    FixedTouchViewPager viewPager;
    OnNewImageChangeListener mListener;
    private PhotoInfo photoInfo;
    private GalleryAnchorDetailAdapter gallerDetailAdapter;
    private ArrayList<PhotoInfo> mListInfos = new ArrayList();
    private int isDanmu = 0;
    private EventBinder mEventBinder;

    public static GalleryPagerFragment newInstance(long anchorId, long alumId, PhotoInfo photoInfo, ArrayList<PhotoInfo> photoInfos) {
        GalleryPagerFragment f = new GalleryPagerFragment();
        Bundle args = new Bundle();
        args.putLong(ANCHORID_KEY, anchorId);
        args.putLong(ALUMID_KEY, alumId);
        args.putParcelable(PHOTOINFO_KEY, (Parcelable)photoInfo);
        args.putParcelableArrayList(PHOTOINFOS_KEY, photoInfos);
        f.setArguments(args);
        return f;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View root = inflater.inflate(R.layout.mn_im_image_pager_layout, container, false);
        this.viewPager = (FixedTouchViewPager)root.findViewById(R.id.pager);
        this.anchorId = this.getArguments().getLong(ANCHORID_KEY);
        this.alumId = this.getArguments().getLong(ALUMID_KEY);
        this.photoInfo = (PhotoInfo)this.getArguments().getParcelable(PHOTOINFO_KEY);
        this.mListInfos = this.getArguments().getParcelableArrayList(PHOTOINFOS_KEY);
        this.initViewPager();
        this.initReult();
        return root;
    }

    public void initViewPager() {
        this.gallerDetailAdapter = new GalleryAnchorDetailAdapter(this.getChildFragmentManager(), this.anchorId, this.alumId, 100, null);
        this.gallerDetailAdapter.addData(this.mListInfos);
        this.viewPager.setAdapter((PagerAdapter)this.gallerDetailAdapter);
        this.viewPager.setCurrentItem(this.currentPosition);
    }

    public void onSaveInstanceState(Bundle outState) {
        if (this.viewPager != null) {
            outState.putInt(POSITION_KEY, this.viewPager.getCurrentItem());
        }
    }

    public void initReult() {
        this.viewPager.setOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrollStateChanged(int arg0) {
            }

            public void onPageScrolled(int a, float arg1, int arg2) {
            }

            public void onPageSelected(int arg0) {
                if (MLog.isLogLevelAboveDebug()) {
                    MLog.debug((String)GalleryPagerFragment.TAG, (String)("zs ---GalleryPagerFragment onPageSelected  arg0 " + arg0));
                }
                GalleryPagerFragment.this.initNewQueryPhotoDec(100, GalleryPagerFragment.this.anchorId, GalleryPagerFragment.this.alumId, ((PhotoInfo)((GalleryPagerFragment)GalleryPagerFragment.this).mListInfos.get((int)arg0)).photoId, GalleryPagerFragment.this.isDanmu);
                if (GalleryPagerFragment.this.mListener != null) {
                    GalleryPagerFragment.this.mListener.onImageChange(arg0, GalleryPagerFragment.this.requestImgNum(), (PhotoInfo)GalleryPagerFragment.this.mListInfos.get(arg0));
                }
                if (GalleryPagerFragment.this.isNextMoreThanTwo(arg0)) {
                    GalleryPagerFragment.this.viewPager.post(new Runnable(){

                        @Override
                        public void run() {
                            if (GalleryPagerFragment.this.mListener != null) {
                                GalleryPagerFragment.this.mListener.onNextRequest();
                            }
                        }
                    });
                }
                if (GalleryPagerFragment.this.isPreMoreThanTwo(arg0)) {
                    GalleryPagerFragment.this.viewPager.post(new Runnable(){

                        @Override
                        public void run() {
                            if (GalleryPagerFragment.this.mListener != null) {
                                GalleryPagerFragment.this.mListener.onPrevRequest();
                            }
                        }
                    });
                }
            }
        });
    }

    @BusEvent(busType=1, busName="plugin_main")
    public void onNewQueryPhotoDec(IGalleryClient_onNewQueryPhotoDec_EventArgs busEventArgs) {
        int resultCode = busEventArgs.getResultCode();
        String errorMsg = busEventArgs.getErrorMsg();
        PhotoInfo photoinfo = busEventArgs.getPhotoinfo();
        if (resultCode == 0) {
            if (photoinfo != null) {
                for (int i = 0; i < this.mListInfos.size(); ++i) {
                    this.mListInfos.set(1, photoinfo);
                }
                this.gallerDetailAdapter.updateData(this.mListInfos);
            }
        } else {
            String tips = this.getString(R.string.str_query_photodel_fail);
            if (!TextUtils.isEmpty((CharSequence)errorMsg)) {
                tips = tips + "\uff0c" + errorMsg;
            }
            Toast.makeText((Context)BasicConfig.getInstance().getAppContext(), (CharSequence)tips, (int)0).show();
        }
    }

    public void initNewQueryPhotoDec(int photoType, long anchorID, long albumId, long photoId, int withcomments) {
        ((IGalleryCore)CoreManager.getCore(IGalleryCore.class)).queryPhotoDetailDanMu(photoType, anchorID, albumId, photoId, withcomments, 1);
    }

    private int requestImgNum() {
        if (this.viewPager.getAdapter() == null) {
            return 0;
        }
        return this.viewPager.getAdapter().getCount();
    }

    private boolean isNextMoreThanTwo(int arg0) {
        if (this.viewPager.getAdapter() == null) {
            return false;
        }
        return this.viewPager.getAdapter().getCount() > 2 && arg0 == this.viewPager.getAdapter().getCount() - 2;
    }

    private boolean isPreMoreThanTwo(int arg0) {
        if (this.viewPager.getAdapter() == null) {
            return false;
        }
        if (this.viewPager.getAdapter().getCount() > 2 && arg0 == 2) {
            return true;
        }
        return this.viewPager.getAdapter().getCount() == 2 || this.viewPager.getAdapter().getCount() == 1;
    }

    public void setOnNewImageChangeListener(OnNewImageChangeListener l) {
        this.mListener = l;
    }

    public void onEventBind() {
        super.onEventBind();
        if (this.mEventBinder == null) {
            this.mEventBinder = new GalleryPagerFragment$$EventBinder();
        }
        this.mEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mEventBinder != null) {
            this.mEventBinder.unBindEvent();
        }
    }

    public static interface OnNewImageChangeListener {
        public void onImageChange(int var1, int var2, PhotoInfo var3);

        public void onNextRequest();

        public void onPrevRequest();
    }
}

