/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.gallery;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import com.handmark.pulltorefresh.library.PullToRefreshBase;
import com.handmark.pulltorefresh.library.PullToRefreshStaggeredGridView;
import com.handmark.pulltorefresh.library.extras_view.StaggeredGridView;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.image.PauseOnScrollListener;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.plugin.main.events.IGalleryClient_onBatchHotPhotoList_EventArgs;
import com.yy.mobile.plugin.main.events.IGalleryClient_onBatchRecentPhotoList_EventArgs;
import com.yy.mobile.ui.common.IBaseMethod;
import com.yy.mobile.ui.gallery.GalleryLivingPagerFragment$$EventBinder;
import com.yy.mobile.ui.gallery.StaggeredGridAdapter;
import com.yy.mobile.ui.utils.NavigationUtils;
import com.yy.mobile.ui.widget.EndlessListScrollListener;
import com.yy.mobile.ui.widget.StatusLayout;
import com.yy.mobile.ui.widget.pager.PagerFragment;
import com.yy.mobile.ui.widget.toast.Toast;
import com.yy.mobile.util.ObjectTimeslotTool;
import com.yy.mobile.util.TimeUtils;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.CoreManager;
import com.yymobile.core.gallery.IGalleryCore;
import com.yymobile.core.gallery.IPhotoWatchCountCore;
import com.yymobile.core.gallery.module.PhotoInfo;
import com.yymobile.core.statistic.IHiidoStatisticCore;
import java.util.List;

public class GalleryLivingPagerFragment
extends PagerFragment
implements IBaseMethod {
    private int mTabIndex;
    private View view;
    private StatusLayout statusLayout;
    private PullToRefreshStaggeredGridView mGridView;
    private StaggeredGridAdapter mGridAdapter;
    private StaggeredGridView staggeredGridView;
    private EndlessListScrollListener mEndlessListScrollListener;
    private int mPageNo = 1;
    private boolean mIsLastPage = false;
    private boolean misPull = true;
    private ObjectTimeslotTool mTimeSlotTool = new ObjectTimeslotTool();
    private Runnable checkRequestTimeoutTask = new Runnable(){

        @Override
        public void run() {
            GalleryLivingPagerFragment.this.hideStatus();
            GalleryLivingPagerFragment.this.mGridView.onRefreshComplete();
            if (GalleryLivingPagerFragment.this.mGridAdapter.getCount() == 0) {
                GalleryLivingPagerFragment.this.showReload();
            }
        }
    };
    private Runnable fixCompleteRefreshMsg = new Runnable(){

        @Override
        public void run() {
            if (GalleryLivingPagerFragment.this.mGridView != null) {
                GalleryLivingPagerFragment.this.mGridView.onRefreshComplete();
            }
            if (GalleryLivingPagerFragment.this.mEndlessListScrollListener != null) {
                GalleryLivingPagerFragment.this.mEndlessListScrollListener.onLoadComplete();
            }
        }
    };
    private EventBinder mEventBinder;

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.view = LayoutInflater.from((Context)this.getActivity()).inflate(R.layout.fragment_gallery_living_pager, container, false);
        this.mTabIndex = this.getArguments().getInt("galleryType");
        return this.view;
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.injectView();
        this.init();
        this.setListener();
    }

    public void injectView() {
        this.mGridView = (PullToRefreshStaggeredGridView)this.view.findViewById(R.id.gallery_living_list_stagger);
        this.mGridView.setOnScrollListener((AbsListView.OnScrollListener)new PauseOnScrollListener(true, true));
        this.statusLayout = (StatusLayout)this.view.findViewById(R.id.gallery_living_status_container_stagger);
    }

    public void init() {
        this.mEndlessListScrollListener = new EndlessListScrollListener(this.statusLayout);
        this.mGridAdapter = new StaggeredGridAdapter((Context)this.getActivity(), (StaggeredGridView)this.mGridView.getRefreshableView(), true);
        this.initData();
    }

    public void setListener() {
        this.mGridView.setOnRefreshListener((PullToRefreshBase.OnRefreshListener)new PullToRefreshBase.OnRefreshListener<StaggeredGridView>(){

            public void onRefresh(PullToRefreshBase<StaggeredGridView> refreshView) {
                if (!GalleryLivingPagerFragment.this.checkNetToast()) {
                    GalleryLivingPagerFragment.this.getHandler().removeCallbacks(GalleryLivingPagerFragment.this.fixCompleteRefreshMsg);
                    GalleryLivingPagerFragment.this.getHandler().postDelayed(GalleryLivingPagerFragment.this.fixCompleteRefreshMsg, 300L);
                } else {
                    GalleryLivingPagerFragment.this.misPull = true;
                    GalleryLivingPagerFragment.this.refresh();
                    GalleryLivingPagerFragment.this.getHandler().removeCallbacks(GalleryLivingPagerFragment.this.checkRequestTimeoutTask);
                    GalleryLivingPagerFragment.this.getHandler().postDelayed(GalleryLivingPagerFragment.this.checkRequestTimeoutTask, TimeUtils.SECONDS.toMillis((long)10L));
                }
            }
        });
        this.mEndlessListScrollListener.setListener(new EndlessListScrollListener.EndlessListener(){

            public void onLoadData() {
                if (!GalleryLivingPagerFragment.this.checkNetToast()) {
                    GalleryLivingPagerFragment.this.getHandler().removeCallbacks(GalleryLivingPagerFragment.this.fixCompleteRefreshMsg);
                    GalleryLivingPagerFragment.this.getHandler().postDelayed(GalleryLivingPagerFragment.this.fixCompleteRefreshMsg, 300L);
                } else {
                    GalleryLivingPagerFragment.this.loadMore();
                }
            }

            public boolean shouldLoadData() {
                if (GalleryLivingPagerFragment.this.mIsLastPage) {
                    new Handler().postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            GalleryLivingPagerFragment.this.mEndlessListScrollListener.onLoadComplete();
                        }
                    }, 1000L);
                    return false;
                }
                return true;
            }
        });
        this.mEndlessListScrollListener.setParentOnScrollListener(new AbsListView.OnScrollListener(){

            public void onScrollStateChanged(AbsListView view, int scrollState) {
                if (scrollState == 0 && view != null && view.getLastVisiblePosition() == view.getCount() - 1 && GalleryLivingPagerFragment.this.mIsLastPage && GalleryLivingPagerFragment.this.misPull) {
                    GalleryLivingPagerFragment.this.misPull = false;
                    Toast.makeText((Context)BasicConfig.getInstance().getAppContext(), (CharSequence)"\u5df2\u662f\u6700\u540e\u4e00\u9875", (int)0).show();
                }
            }

            public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
            }
        });
        this.mGridView.setOnScrollListener((AbsListView.OnScrollListener)this.mEndlessListScrollListener);
        this.staggeredGridView = (StaggeredGridView)this.mGridView.getRefreshableView();
        this.staggeredGridView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> adapterView, View view, int position, long id2) {
                if (GalleryLivingPagerFragment.this.mTimeSlotTool.isProcessing()) {
                    return;
                }
                PhotoInfo photoInfo = GalleryLivingPagerFragment.this.mGridAdapter.getItem(position);
                ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "1003", "0003");
                NavigationUtils.toGalleryNewDetailActivity(GalleryLivingPagerFragment.this.getContext(), photoInfo.photoAnchorId, photoInfo.photoAlumId, photoInfo, GalleryLivingPagerFragment.this.mPageNo + 1, GalleryLivingPagerFragment.this.mIsLastPage, 1, GalleryLivingPagerFragment.this.mTabIndex);
                ((IPhotoWatchCountCore)CoreManager.getCore(IPhotoWatchCountCore.class)).addGalleryStatics(photoInfo.photoAnchorId, (long)((int)photoInfo.photoId), 1);
            }
        });
        this.staggeredGridView.setAdapter((ListAdapter)this.mGridAdapter);
    }

    public void initData() {
        this.showLoading();
        this.misPull = true;
        this.refresh();
        this.getHandler().removeCallbacks(this.checkRequestTimeoutTask);
        this.getHandler().postDelayed(this.checkRequestTimeoutTask, TimeUtils.SECONDS.toMillis((long)10L));
    }

    private void refresh() {
        this.mPageNo = 1;
        if (this.mTabIndex == 101) {
            this.requesHotPhotoData(this.mPageNo);
        }
        if (this.mTabIndex == 102) {
            this.requesRecentPhotoData(this.mPageNo);
        }
    }

    private void loadMore() {
        ++this.mPageNo;
        if (this.mTabIndex == 101) {
            this.requesHotPhotoData(this.mPageNo);
        }
        if (this.mTabIndex == 102) {
            this.requesRecentPhotoData(this.mPageNo);
        }
    }

    public void requesHotPhotoData(int pageNo) {
        ((IGalleryCore)CoreManager.getCore(IGalleryCore.class)).queryHotPhotos(pageNo, 0L);
    }

    public void requesRecentPhotoData(int pageNo) {
        ((IGalleryCore)CoreManager.getCore(IGalleryCore.class)).queryRecentPhotos(pageNo);
    }

    @BusEvent(busType=1, busName="plugin_main")
    public void onBatchHotPhotoList(IGalleryClient_onBatchHotPhotoList_EventArgs busEventArgs) {
        List photoList = busEventArgs.getPhotoList();
        int pageNo = busEventArgs.getPageNo();
        boolean isEnd = busEventArgs.getIsEnd();
        if (this.mTabIndex != 101) {
            return;
        }
        this.hideStatus();
        if (this.mGridView != null) {
            this.mGridView.onRefreshComplete();
        }
        if (this.mEndlessListScrollListener != null) {
            this.mEndlessListScrollListener.onLoadComplete();
        }
        this.mIsLastPage = isEnd;
        this.mPageNo = pageNo;
        if (photoList != null) {
            if (this.mPageNo == 1) {
                this.changeData(photoList);
            } else {
                this.fllushData(photoList);
            }
        } else {
            this.showReload();
            this.checkNetToast();
        }
    }

    @BusEvent(busType=1, busName="plugin_main")
    public void onBatchRecentPhotoList(IGalleryClient_onBatchRecentPhotoList_EventArgs busEventArgs) {
        List photoList = busEventArgs.getPhotoList();
        int pageNo = busEventArgs.getPageNo();
        boolean isEnd = busEventArgs.getIsEnd();
        if (this.mTabIndex != 102) {
            return;
        }
        this.hideStatus();
        if (this.mGridView != null) {
            this.mGridView.onRefreshComplete();
        }
        if (this.mEndlessListScrollListener != null) {
            this.mEndlessListScrollListener.onLoadComplete();
        }
        this.mIsLastPage = isEnd;
        this.mPageNo = pageNo;
        if (photoList != null && this.mTabIndex == 102) {
            if (this.mPageNo == 1) {
                this.changeData(photoList);
            } else {
                this.fllushData(photoList);
            }
        } else {
            this.showReload();
            this.checkNetToast();
        }
    }

    public View.OnClickListener getLoadListener() {
        return new View.OnClickListener(){

            public void onClick(View view) {
                GalleryLivingPagerFragment.this.showLoading();
                GalleryLivingPagerFragment.this.refresh();
            }
        };
    }

    public void fllushData(List<PhotoInfo> photoList) {
        if (photoList != null && photoList.size() > 0) {
            this.mGridAdapter.addDataItem(photoList);
        }
    }

    public void changeData(List<PhotoInfo> photoList) {
        if (photoList != null && photoList.size() > 0) {
            this.mGridAdapter.changeDataItem(photoList);
        }
    }

    public void onDestroy() {
        super.onDestroy();
        ((IPhotoWatchCountCore)CoreManager.getCore(IPhotoWatchCountCore.class)).sendGalleryStatics();
    }

    public void onEventBind() {
        super.onEventBind();
        if (this.mEventBinder == null) {
            this.mEventBinder = new GalleryLivingPagerFragment$$EventBinder();
        }
        this.mEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mEventBinder != null) {
            this.mEventBinder.unBindEvent();
        }
    }
}

