/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.gallery;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.widget.ImageView;
import com.yy.immersion.ImmersionBar;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.file.FileRequest;
import com.yy.mobile.file.FileRequestException;
import com.yy.mobile.file.FileRequestManager;
import com.yy.mobile.file.FileResponseErrorListener;
import com.yy.mobile.file.FileResponseListener;
import com.yy.mobile.file.data.DefaultFileDataParam;
import com.yy.mobile.file.data.FileDataParam;
import com.yy.mobile.file.data.FilePutResult;
import com.yy.mobile.file.data.SavePhotoWithUrlRequest;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.policy.dialog.IPerConstantKt;
import com.yy.mobile.ui.BaseActivity;
import com.yy.mobile.ui.widget.photoView.PhotoView;
import com.yy.mobile.ui.widget.photoView.PhotoViewAttacher;
import com.yy.mobile.ui.widget.toast.Toast;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.media.MediaStoreUtils;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.CoreManager;
import com.yymobile.core.gallery.IGalleryCore;
import com.yymobile.core.statistic.IHiidoStatisticCore;
import java.io.File;

public class GalleryDisplayActivity
extends BaseActivity
implements View.OnClickListener {
    public static final String TAG = "GalleryDisplayActivity";
    public static final String PHOTO_URL = "photoUrl";
    public static final String PHOTO_DIR = "yymobile" + File.separator + "saved";
    private PhotoView mPhotoView;
    private ImageView mUpload;
    private String mPhotoUrl = "";

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.layout_gallery_big_simple_display);
        this.mPhotoUrl = this.getIntent().getStringExtra(PHOTO_URL);
        this.initView();
    }

    public void initView() {
        this.mPhotoView = (PhotoView)this.findViewById(R.id.photo_container);
        this.mUpload = (ImageView)this.findViewById(R.id.photo_download);
        this.mUpload.setOnClickListener((View.OnClickListener)this);
        ImageLoader.loadImage((RecycleImageView)this.mPhotoView, (String)this.mPhotoUrl, (int)R.drawable.hp_living_default_bg, (int)R.drawable.hp_living_default_bg);
        this.mPhotoView.setOnViewTapListener(new PhotoViewAttacher.OnViewTapListener(){

            public void onViewTap(View view, float x, float y) {
                GalleryDisplayActivity.this.finish();
            }
        });
        this.mPhotoView.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View view) {
                GalleryDisplayActivity.this.savePhoto();
                ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "1002", "0009");
                return false;
            }
        });
    }

    public void onClick(View view) {
        IPerConstantKt.showStoragePermissionDialog((Activity)this, (Runnable)new Runnable(){

            @Override
            public void run() {
                GalleryDisplayActivity.this.savePhoto();
            }
        });
    }

    private void savePhoto() {
        String surfix = "";
        surfix = ImageLoader.isGif((String)this.mPhotoUrl) ? ".gif" : (ImageLoader.isJpg((String)this.mPhotoUrl) ? ".jpg" : ".png");
        final String photoFileName = System.currentTimeMillis() + surfix;
        DefaultFileDataParam param = new DefaultFileDataParam(PHOTO_DIR, photoFileName);
        try {
            SavePhotoWithUrlRequest request2 = new SavePhotoWithUrlRequest((Context)this, (FileDataParam)param, this.mPhotoUrl);
            request2.setSuccessListener((FileResponseListener)new FileResponseListener<FilePutResult>(){

                public void onResponse(FilePutResult response) {
                    ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "1002", "0009");
                    if (!MLog.isLogLevelAboveVerbose()) {
                        MLog.verbose((String)GalleryDisplayActivity.TAG, (String)("SavePhotoRequest " + response));
                    }
                    MediaStoreUtils.insertImage((Context)GalleryDisplayActivity.this, (String)response.getSavedPath().getAbsolutePath(), (String)photoFileName, null);
                    MLog.info((String)GalleryDisplayActivity.TAG, (String)("DownloadPicTask destFile=" + response.getSavedPath().getAbsolutePath()));
                    Toast.makeText((Context)GalleryDisplayActivity.this, (int)R.string.save_photo_success, (int)1).show();
                }
            });
            request2.setErrorListener(new FileResponseErrorListener(){

                public void onErrorResponse(FileRequestException error) {
                    Toast.makeText((Context)GalleryDisplayActivity.this, (CharSequence)"\u4fdd\u5b58\u5931\u8d25!", (int)0).show();
                    MLog.error((String)GalleryDisplayActivity.TAG, (String)("save pic error:" + error.getMessage()));
                }
            });
            FileRequestManager.instance().submitFileRequest((FileRequest)request2);
        }
        catch (FileRequestException e) {
            MLog.error((Object)TAG, (String)"Save photo error.", (Throwable)e, (Object[])new Object[0]);
        }
    }

    public void onLoginSucceed(long userId) {
        super.onLoginSucceed(userId);
        ((IGalleryCore)CoreManager.getCore(IGalleryCore.class)).getMyCommentPraise();
    }

    protected boolean handleStatusBar() {
        this.immersionBar = ImmersionBar.with((Activity)this).statusBarColor(17170444);
        this.immersionBar.init();
        return true;
    }
}

