/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.gallery;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.BitmapFactory;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.fragment.app.Fragment;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.file.FileRequest;
import com.yy.mobile.file.FileRequestException;
import com.yy.mobile.file.FileRequestManager;
import com.yy.mobile.file.FileResponseErrorListener;
import com.yy.mobile.file.FileResponseListener;
import com.yy.mobile.file.data.DefaultFileDataParam;
import com.yy.mobile.file.data.FileDataParam;
import com.yy.mobile.file.data.FilePutResult;
import com.yy.mobile.file.data.SavePhotoWithUrlRequest;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.plugin.homepage.ui.utils.dialog.IBaseDialog;
import com.yy.mobile.plugin.homepage.ui.utils.dialog.ProgressDialog;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.plugin.main.events.IGalleryClient_onBatchDetelePhoto_EventArgs;
import com.yy.mobile.plugin.main.events.IGalleryClient_onQueryPhotoDec_EventArgs;
import com.yy.mobile.plugin.main.events.IGalleryClient_onQueryStaggerList_EventArgs;
import com.yy.mobile.share.BaseCopyClickListener;
import com.yy.mobile.share.BasePlatform;
import com.yy.mobile.share.BasePlatformActionListener;
import com.yy.mobile.share.BaseShareContentCustomizeCallback;
import com.yy.mobile.share.ShareApi;
import com.yy.mobile.share.ShareRequest;
import com.yy.mobile.ui.BaseActivity;
import com.yy.mobile.ui.dialog.ButtonItem;
import com.yy.mobile.ui.dialog.IDialogLinkManagerCore;
import com.yy.mobile.ui.gallery.GalleryBigPhotoDisplayActivity$$EventBinder;
import com.yy.mobile.ui.gallery.GalleryImageDetailFragment;
import com.yy.mobile.ui.gallery.ImagePagerFragment;
import com.yy.mobile.ui.widget.SimpleTitleBar;
import com.yy.mobile.ui.widget.toast.Toast;
import com.yy.mobile.util.NetworkUtils;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.media.MediaStoreUtils;
import com.yy.mobile.ylink.bridge.CoreApiManager;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.CoreManager;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.gallery.IGalleryCore;
import com.yymobile.core.gallery.module.AlbumInfo;
import com.yymobile.core.gallery.module.PhotoInfo;
import com.yymobile.core.gallery.module.StaggeredGridInfo;
import com.yymobile.core.statistic.IHiidoStatisticCore;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class GalleryBigPhotoDisplayActivity
extends BaseActivity {
    public static final String TAG = "GalleryBigPhotoDisplayActivity";
    public static final String LOG_TAG = "GalleryBigPhotoDisplayActivity";
    public static final String GALLERY_LIST_PHOTO = "gallery_list_photo";
    public static final String SIGLE_LIST_PHOTO = "sigle_list_photo";
    public static final String GALLERY_BIG_ANCHOID = "gallery_big_anchoid";
    public static final String GALLERY_BIG_AUMBID = "gallery_big_aumbid";
    public static final String GALLERT_PAGENO = "gallery_pageno";
    public static final String GALLERY_ISEND = "gallery_isend";
    private ImagePagerFragment mImagePagerFragment;
    private SimpleTitleBar mTitleBar;
    private LinearLayout hideView;
    private TextView mThumurl;
    private TextView mthumDec;
    private List<PhotoInfo> photoInfos = new ArrayList<PhotoInfo>();
    private PhotoInfo photoInfo;
    private long anchoid;
    private long aumbid;
    public static final int PAGE_SIZE = 30;
    public int pageNo;
    private boolean mIsLastPage = false;
    private boolean staggerdEnd = false;
    public static final String PHOTO_DIR = "yymobile" + File.separator + "saved";
    private List<ButtonItem> imageDialogItemsCommon = new ArrayList<ButtonItem>();
    private List<ButtonItem> imageDialogAuthItems = new ArrayList<ButtonItem>();
    private String mPhotoUrl = "";
    private boolean isViewPagerData = false;
    private List<PhotoInfo> allUrl = new ArrayList<PhotoInfo>();
    private Animation mBottomAnimaiton;
    private Animation mTopAnimation;
    private boolean enter;
    private EventBinder mEventBinder;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.layout_gallery_big_display);
        if (this.photoInfos.size() > 0) {
            this.photoInfos.clear();
        }
        this.photoInfos = this.getIntent().getParcelableArrayListExtra(GALLERY_LIST_PHOTO);
        this.photoInfo = (PhotoInfo)this.getIntent().getParcelableExtra(SIGLE_LIST_PHOTO);
        this.anchoid = this.getIntent().getLongExtra(GALLERY_BIG_ANCHOID, 0L);
        this.aumbid = this.getIntent().getLongExtra(GALLERY_BIG_AUMBID, 0L);
        this.pageNo = this.getIntent().getIntExtra(GALLERT_PAGENO, 0);
        this.staggerdEnd = this.getIntent().getBooleanExtra(GALLERY_ISEND, false);
        if (this.photoInfo != null) {
            this.mPhotoUrl = this.photoInfo.photoUrl;
        }
        this.initView();
        this.initImageDialog1();
        this.initImageDialog2();
        this.initPager();
    }

    public void initView() {
        this.mTitleBar = (SimpleTitleBar)this.findViewById(R.id.title_bar);
        this.mTitleBar.setLeftBtn(R.drawable.icon_nav_back, new View.OnClickListener(){

            public void onClick(View v) {
                GalleryBigPhotoDisplayActivity.this.finish();
            }
        });
        LinearLayout rightView = (LinearLayout)this.getLayoutInflater().inflate(R.layout.layout_title_bar_right_anchor_info, null);
        this.mTitleBar.setRightView((View)rightView);
        rightView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "1001", "0009");
                if (((IGalleryCore)CoreManager.getCore(IGalleryCore.class)).compareRule(GalleryBigPhotoDisplayActivity.this.anchoid, ((GalleryBigPhotoDisplayActivity)GalleryBigPhotoDisplayActivity.this).photoInfo.permission)) {
                    GalleryBigPhotoDisplayActivity.this.showImageDialogAuth();
                } else {
                    GalleryBigPhotoDisplayActivity.this.showImageDialogCommon();
                }
            }
        });
        this.hideView = (LinearLayout)this.findViewById(R.id.hide_view);
        this.mThumurl = (TextView)this.findViewById(R.id.container_thumurl);
        this.mthumDec = (TextView)this.findViewById(R.id.contaner_dec);
        this.initQueryPhotoDec(this.anchoid, this.aumbid, this.photoInfo.photoId);
    }

    public ArrayList<String> getListUrl() {
        ArrayList<String> mlist = new ArrayList<String>();
        for (PhotoInfo info : this.photoInfos) {
            mlist.add(info.photoUrl);
        }
        return mlist;
    }

    public void initPager() {
        this.mTitleBar.setTitlte(this.photoInfos.indexOf(this.photoInfo) + 1 + "/" + this.photoInfos.size());
        this.mImagePagerFragment = ImagePagerFragment.newInstance(this.getListUrl(), (int)this.photoInfos.indexOf(this.photoInfo));
        this.mImagePagerFragment.setImageClickListener(new GalleryImageDetailFragment.OnImageClickListener(){

            public void onImageClick() {
                if (GalleryBigPhotoDisplayActivity.this.enter) {
                    GalleryBigPhotoDisplayActivity.this.mBottomAnimaiton = AnimationUtils.loadAnimation((Context)GalleryBigPhotoDisplayActivity.this, (int)R.anim.slide_out_to_bottom);
                    GalleryBigPhotoDisplayActivity.this.mTopAnimation = AnimationUtils.loadAnimation((Context)GalleryBigPhotoDisplayActivity.this, (int)R.anim.slide_out_to_top);
                    GalleryBigPhotoDisplayActivity.this.hideView.setVisibility(8);
                    GalleryBigPhotoDisplayActivity.this.mTitleBar.setVisibility(8);
                    GalleryBigPhotoDisplayActivity.this.enter = false;
                } else {
                    GalleryBigPhotoDisplayActivity.this.mBottomAnimaiton = AnimationUtils.loadAnimation((Context)GalleryBigPhotoDisplayActivity.this, (int)R.anim.slide_in_from_bottom);
                    GalleryBigPhotoDisplayActivity.this.mTopAnimation = AnimationUtils.loadAnimation((Context)GalleryBigPhotoDisplayActivity.this, (int)R.anim.slide_in_from_top);
                    GalleryBigPhotoDisplayActivity.this.hideView.setVisibility(0);
                    GalleryBigPhotoDisplayActivity.this.mTitleBar.setVisibility(0);
                    GalleryBigPhotoDisplayActivity.this.enter = true;
                }
                GalleryBigPhotoDisplayActivity.this.mTitleBar.setAnimation(GalleryBigPhotoDisplayActivity.this.mTopAnimation);
                GalleryBigPhotoDisplayActivity.this.hideView.setAnimation(GalleryBigPhotoDisplayActivity.this.mBottomAnimaiton);
            }

            public void onImageLongClick() {
                GalleryBigPhotoDisplayActivity.this.savePhoto();
            }
        });
        this.getSupportFragmentManager().beginTransaction().replace(R.id.pager, (Fragment)this.mImagePagerFragment).commitAllowingStateLoss();
        this.mImagePagerFragment.setOnImageChangeListener(new ImagePagerFragment.OnImageChangeListener(){

            public void onImageChange(int currentPosition, int totalCount, String currentUrl) {
                if (GalleryBigPhotoDisplayActivity.this.photoInfos != null && GalleryBigPhotoDisplayActivity.this.photoInfos.size() > 0) {
                    GalleryBigPhotoDisplayActivity.this.mTitleBar.setTitlte(currentPosition + 1 + "/" + totalCount);
                    GalleryBigPhotoDisplayActivity.this.mPhotoUrl = currentUrl;
                    if (currentPosition >= GalleryBigPhotoDisplayActivity.this.photoInfos.size()) {
                        currentPosition = GalleryBigPhotoDisplayActivity.this.photoInfos.size() - 1;
                    }
                    GalleryBigPhotoDisplayActivity.this.photoInfo = (PhotoInfo)GalleryBigPhotoDisplayActivity.this.photoInfos.get(currentPosition);
                    GalleryBigPhotoDisplayActivity.this.initQueryPhotoDec(GalleryBigPhotoDisplayActivity.this.anchoid, GalleryBigPhotoDisplayActivity.this.aumbid, ((GalleryBigPhotoDisplayActivity)GalleryBigPhotoDisplayActivity.this).photoInfo.photoId);
                }
            }

            public void onNextRequest() {
                if (!MLog.isLogLevelAboveVerbose()) {
                    MLog.verbose((String)"GalleryBigPhotoDisplayActivity", (String)("zs -- staggerdEnd " + GalleryBigPhotoDisplayActivity.this.staggerdEnd + " mIsLastPage " + GalleryBigPhotoDisplayActivity.this.mIsLastPage));
                }
                if (!(GalleryBigPhotoDisplayActivity.this.staggerdEnd || GalleryBigPhotoDisplayActivity.this.mIsLastPage || GalleryBigPhotoDisplayActivity.this.isViewPagerData)) {
                    GalleryBigPhotoDisplayActivity.this.isViewPagerData = true;
                    new Handler().postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            GalleryBigPhotoDisplayActivity.this.isViewPagerData = false;
                        }
                    }, 6000L);
                    GalleryBigPhotoDisplayActivity.this.initQuertStaggerPhotoList(GalleryBigPhotoDisplayActivity.this.anchoid, GalleryBigPhotoDisplayActivity.this.aumbid, GalleryBigPhotoDisplayActivity.this.pageNo);
                }
            }

            public void onPrevRequest() {
            }
        });
    }

    @BusEvent(busType=1, busName="plugin_main")
    public void onQueryPhotoDec(IGalleryClient_onQueryPhotoDec_EventArgs busEventArgs) {
        int resultCode = busEventArgs.getResultCode();
        String errorMsg = busEventArgs.getErrorMsg();
        AlbumInfo info = busEventArgs.getInfo();
        if (resultCode == 0) {
            if (!MLog.isLogLevelAboveVerbose()) {
                MLog.verbose((String)"GalleryBigPhotoDisplayActivity", (String)("onQueryPhotoDec " + resultCode + " errorMsg " + errorMsg + " info " + info));
            }
            if (info != null && info.photos != null && info.photos.size() > 0) {
                for (PhotoInfo photo : info.photos) {
                    if (this.photoInfo.photoId != photo.photoId) continue;
                    this.photoInfo = photo;
                    this.mThumurl.setText((CharSequence)(photo.photoName != null ? photo.photoName : ""));
                    this.mthumDec.setVisibility(0);
                    for (int i : photo.permission) {
                        if (i == 4) {
                            this.mthumDec.setVisibility(0);
                            this.mthumDec.setText((CharSequence)("\u6765\u81ea" + photo.photoCreator + "\u4e0a\u4f20"));
                        }
                        if (i != 3) continue;
                        this.mthumDec.setVisibility(8);
                    }
                }
            }
        } else {
            String tips = this.getString(R.string.str_query_photodel_fail);
            if (!TextUtils.isEmpty((CharSequence)errorMsg)) {
                tips = tips + "\uff0c" + errorMsg;
            }
            Toast.makeText((Context)this, (CharSequence)tips, (int)0).show();
        }
    }

    @BusEvent(busType=1, busName="plugin_main")
    public void onQueryStaggerList(IGalleryClient_onQueryStaggerList_EventArgs busEventArgs) {
        StaggeredGridInfo staggeredInfo = busEventArgs.getStaggeredInfo();
        int page = busEventArgs.getPage();
        if (!MLog.isLogLevelAboveVerbose()) {
            MLog.verbose((String)"GalleryBigPhotoDisplayActivity", (String)("zs --staggeredInfo " + staggeredInfo.photos + " page " + page));
        }
        this.pageNo = page;
        this.isViewPagerData = false;
        if (staggeredInfo != null) {
            if (staggeredInfo.isEnd == 0) {
                this.mIsLastPage = true;
            } else if (staggeredInfo.isEnd == 1) {
                this.mIsLastPage = false;
            }
            if (staggeredInfo.photos != null && staggeredInfo.photos.size() > 0) {
                if (this.pageNo == 1) {
                    this.changeData(staggeredInfo);
                } else {
                    this.updateData(staggeredInfo);
                }
                ++this.pageNo;
            }
        }
    }

    @BusEvent(busType=1, busName="plugin_main")
    public void onBatchDetelePhoto(IGalleryClient_onBatchDetelePhoto_EventArgs busEventArgs) {
        int succCount = busEventArgs.getSuccCount();
        int[] succPhotoIds = busEventArgs.getSuccPhotoIds();
        int resultCode = busEventArgs.getResultCode();
        String errorMsg = busEventArgs.getErrorMsg();
        if (!MLog.isLogLevelAboveVerbose()) {
            MLog.verbose((String)"GalleryBigPhotoDisplayActivity", (String)("zs -- onBatchDetelePhoto " + succPhotoIds + " succCount " + succCount));
        }
        this.getDialogLinkManager().dismissDialog();
        if (resultCode == 0) {
            if (succPhotoIds != null && succPhotoIds.length > 0) {
                this.changeData();
            }
        } else {
            String tips = this.getString(R.string.str_delete_photo_fail);
            if (!TextUtils.isEmpty((CharSequence)errorMsg)) {
                tips = tips + "\uff0c" + errorMsg;
            }
            Toast.makeText((Context)this, (CharSequence)tips, (int)0).show();
        }
    }

    public void initQueryPhotoDec(long anchoid, long alumid, long photoid) {
        ((IGalleryCore)CoreManager.getCore(IGalleryCore.class)).queryPhotoDec(anchoid, alumid, photoid);
    }

    public void initQuertStaggerPhotoList(long anchoid, long alumid, int pageNo) {
        ((IGalleryCore)CoreManager.getCore(IGalleryCore.class)).queryGalleryStaggerdList(anchoid, alumid, pageNo, 30, 0);
    }

    public void changeData(StaggeredGridInfo staggeredInfo) {
        if (this.photoInfos != null && this.photoInfos.size() > 0) {
            this.photoInfos.clear();
            this.photoInfos.addAll(staggeredInfo.photos);
        }
        this.initPager();
    }

    public void updateData(StaggeredGridInfo staggeredInfo) {
        if (this.photoInfos != null && this.photoInfos.size() > 0) {
            this.photoInfos.addAll(staggeredInfo.photos);
        }
        this.initPager();
    }

    public void changeData() {
        AlbumInfo albumInfo = ((IGalleryCore)CoreManager.getCore(IGalleryCore.class)).getAlbumInfo(this.anchoid, this.aumbid);
        Toast.makeText((Context)this, (CharSequence)"\u5220\u9664\u6210\u529f", (int)0).show();
        if (albumInfo != null && albumInfo.photos != null && albumInfo.photos.size() >= 1) {
            int position = this.photoInfos.indexOf(this.photoInfo);
            this.photoInfos.clear();
            this.photoInfos.addAll(albumInfo.photos);
            if (position >= this.photoInfos.size()) {
                position = this.photoInfos.size() - 1;
            }
            this.photoInfo = this.photoInfos.get(position);
            this.initPager();
        } else {
            this.finish();
        }
    }

    private void initImageDialog1() {
        ButtonItem btnItem1 = new ButtonItem(this.getString(R.string.str_save_gallery_photo), new ButtonItem.OnClickListener(){

            public void onClick() {
                GalleryBigPhotoDisplayActivity.this.savePhoto();
            }
        });
        this.imageDialogItemsCommon.add(btnItem1);
        ButtonItem btnItem2 = new ButtonItem(this.getString(R.string.str_channelideo_menu_share), new ButtonItem.OnClickListener(){

            public void onClick() {
                if (((GalleryBigPhotoDisplayActivity)GalleryBigPhotoDisplayActivity.this).photoInfo.shareTitle != null) {
                    GalleryBigPhotoDisplayActivity.this.share(((GalleryBigPhotoDisplayActivity)GalleryBigPhotoDisplayActivity.this).photoInfo.shareContent, ((GalleryBigPhotoDisplayActivity)GalleryBigPhotoDisplayActivity.this).photoInfo.shareTitle);
                } else {
                    GalleryBigPhotoDisplayActivity.this.share(((GalleryBigPhotoDisplayActivity)GalleryBigPhotoDisplayActivity.this).photoInfo.shareContent, ((GalleryBigPhotoDisplayActivity)GalleryBigPhotoDisplayActivity.this).photoInfo.shareContent);
                }
            }
        });
        this.imageDialogItemsCommon.add(btnItem2);
        ButtonItem btnItem3 = new ButtonItem(this.getString(R.string.str_channelideo_menu_tip), new ButtonItem.OnClickListener(){

            public void onClick() {
                GalleryBigPhotoDisplayActivity.this.showReportDialog();
            }
        });
        this.imageDialogItemsCommon.add(btnItem3);
    }

    private void initImageDialog2() {
        ButtonItem btnItem1 = new ButtonItem(this.getString(R.string.str_save_gallery_photo), new ButtonItem.OnClickListener(){

            public void onClick() {
                GalleryBigPhotoDisplayActivity.this.savePhoto();
            }
        });
        this.imageDialogAuthItems.add(btnItem1);
        ButtonItem btnItem2 = new ButtonItem(this.getString(R.string.str_channelideo_menu_share), new ButtonItem.OnClickListener(){

            public void onClick() {
                if (((GalleryBigPhotoDisplayActivity)GalleryBigPhotoDisplayActivity.this).photoInfo.shareTitle != null) {
                    GalleryBigPhotoDisplayActivity.this.share(((GalleryBigPhotoDisplayActivity)GalleryBigPhotoDisplayActivity.this).photoInfo.shareContent, ((GalleryBigPhotoDisplayActivity)GalleryBigPhotoDisplayActivity.this).photoInfo.shareTitle);
                } else {
                    GalleryBigPhotoDisplayActivity.this.share(((GalleryBigPhotoDisplayActivity)GalleryBigPhotoDisplayActivity.this).photoInfo.shareContent, ((GalleryBigPhotoDisplayActivity)GalleryBigPhotoDisplayActivity.this).photoInfo.shareContent);
                }
            }
        });
        this.imageDialogAuthItems.add(btnItem2);
        ButtonItem btnItem3 = new ButtonItem(this.getString(R.string.str_delete_gallery_photo_auth), new ButtonItem.OnClickListener(){

            public void onClick() {
                ArrayList<PhotoInfo> list = new ArrayList<PhotoInfo>();
                list.add(GalleryBigPhotoDisplayActivity.this.photoInfo);
                GalleryBigPhotoDisplayActivity.this.getDialogLinkManager().showDialog((IBaseDialog)new ProgressDialog("", true, true, 0, null));
                ((IGalleryCore)CoreManager.getCore(IGalleryCore.class)).batchDeleteStaggerPhoto(GalleryBigPhotoDisplayActivity.this.anchoid, GalleryBigPhotoDisplayActivity.this.aumbid, ((GalleryBigPhotoDisplayActivity)GalleryBigPhotoDisplayActivity.this).photoInfo.photoId, list);
            }
        });
        this.imageDialogAuthItems.add(btnItem3);
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.mTopAnimation != null && this.mBottomAnimaiton != null) {
            this.mTopAnimation.cancel();
            this.mBottomAnimaiton.cancel();
        }
    }

    private void showImageDialogCommon() {
        ((IDialogLinkManagerCore)ICoreManagerBase.getCore(IDialogLinkManagerCore.class)).getDialogLinkManager().showCommonPopupDialog(this.imageDialogItemsCommon, this.getString(R.string.str_cancel), true, true);
    }

    private void showImageDialogAuth() {
        ((IDialogLinkManagerCore)ICoreManagerBase.getCore(IDialogLinkManagerCore.class)).getDialogLinkManager().showCommonPopupDialog(this.imageDialogAuthItems, this.getString(R.string.str_cancel), true, true);
    }

    private void savePhoto() {
        String surfix = "";
        surfix = ImageLoader.isGif((String)this.mPhotoUrl) ? ".gif" : (ImageLoader.isJpg((String)this.mPhotoUrl) ? ".jpg" : ".png");
        final String photoFileName = System.currentTimeMillis() + surfix;
        DefaultFileDataParam param = new DefaultFileDataParam(PHOTO_DIR, photoFileName);
        try {
            SavePhotoWithUrlRequest request2 = new SavePhotoWithUrlRequest((Context)this, (FileDataParam)param, this.mPhotoUrl);
            request2.setSuccessListener((FileResponseListener)new FileResponseListener<FilePutResult>(){

                public void onResponse(FilePutResult response) {
                    ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "1001", "0011");
                    if (!MLog.isLogLevelAboveVerbose()) {
                        MLog.verbose((String)"GalleryBigPhotoDisplayActivity", (String)("SavePhotoRequest " + response));
                    }
                    MediaStoreUtils.insertImage((Context)GalleryBigPhotoDisplayActivity.this, (String)response.getSavedPath().getAbsolutePath(), (String)photoFileName, null);
                    MLog.info((String)"GalleryBigPhotoDisplayActivity", (String)("DownloadPicTask destFile=" + response.getSavedPath().getAbsolutePath()));
                    Toast.makeText((Context)GalleryBigPhotoDisplayActivity.this, (int)R.string.save_photo_success, (int)1).show();
                }
            });
            request2.setErrorListener(new FileResponseErrorListener(){

                public void onErrorResponse(FileRequestException error) {
                    Toast.makeText((Context)GalleryBigPhotoDisplayActivity.this, (CharSequence)"\u4fdd\u5b58\u5931\u8d25!", (int)0).show();
                    MLog.error((String)"GalleryBigPhotoDisplayActivity", (String)("save pic error:" + error.getMessage()));
                }
            });
            FileRequestManager.instance().submitFileRequest((FileRequest)request2);
        }
        catch (FileRequestException e) {
            MLog.error((Object)"GalleryBigPhotoDisplayActivity", (String)"Save photo error.", (Throwable)e, (Object[])new Object[0]);
        }
    }

    private void showReportDialog() {
        ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "1001", "0012");
        ButtonItem btnItem1 = new ButtonItem(this.getString(R.string.str_report_button_illegal), new ButtonItem.OnClickListener(){

            public void onClick() {
                Toast.makeText((Context)GalleryBigPhotoDisplayActivity.this, (CharSequence)GalleryBigPhotoDisplayActivity.this.getReportTipString(), (int)0).show();
            }
        });
        ButtonItem btnItem2 = new ButtonItem(this.getString(R.string.str_report_button_vulgar), new ButtonItem.OnClickListener(){

            public void onClick() {
                Toast.makeText((Context)GalleryBigPhotoDisplayActivity.this, (CharSequence)GalleryBigPhotoDisplayActivity.this.getReportTipString(), (int)0).show();
            }
        });
        ArrayList<ButtonItem> btnItems = new ArrayList<ButtonItem>();
        btnItems.add(btnItem1);
        btnItems.add(btnItem2);
        ((IDialogLinkManagerCore)ICoreManagerBase.getCore(IDialogLinkManagerCore.class)).getDialogLinkManager().showCommonPopupDialog(this.getString(R.string.str_report_title), btnItems, this.getString(R.string.str_report_button_cancel), true, true);
    }

    private String getReportTipString() {
        return NetworkUtils.isNetworkStrictlyAvailable((Context)this) ? this.getString(R.string.str_report_success) : this.getString(R.string.str_network_not_capable);
    }

    private void share(String shareText, String shareTitle) {
        ShareApi shareApi = (ShareApi)CoreApiManager.getInstance().getApi(ShareApi.class);
        if (shareApi == null) {
            MLog.error((String)"share", (String)"shareapi is null");
            return;
        }
        ShareRequest request2 = new ShareRequest();
        final String url = this.photoInfo.photoUrl;
        request2.title = shareTitle;
        request2.titleUrl = url;
        request2.url = url;
        request2.text = shareText;
        request2.context = this.getContext();
        request2.showText = true;
        request2.notificationIcon = R.drawable.ic_launcher_yy;
        request2.imageUrl = url;
        if (TextUtils.isEmpty((CharSequence)url)) {
            request2.imageData = BitmapFactory.decodeResource((Resources)this.getResources(), (int)R.drawable.mn_yy_bear_logo);
        } else {
            request2.imageUrl = url;
        }
        request2.copyClickListener = new BaseCopyClickListener(){

            public String makeCopyText() {
                return String.format(url, new Object[0]);
            }
        };
        BaseShareContentCustomizeCallback shareContentCustomizeCallback = new BaseShareContentCustomizeCallback(){

            public boolean onShare(BasePlatform platform, BasePlatform.ShareParams paramsToShare) {
                return false;
            }
        };
        shareApi.showShare((Context)this, request2, shareContentCustomizeCallback, new BasePlatformActionListener(){

            public void onComplete(BasePlatform platform, int i, HashMap<String, Object> stringObjectHashMap) {
                MLog.info((String)"GalleryBigPhotoDisplayActivity", (String)"share ok!");
                ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "1001", "0010");
            }

            public void onError(BasePlatform platform, int i, Throwable throwable) {
                MLog.error((Object)"GalleryBigPhotoDisplayActivity", (String)"share error=%s", (Throwable)throwable, (Object[])new Object[0]);
            }

            public void onCancel(BasePlatform platform, int i) {
                if (MLog.isLogLevelAboveDebug()) {
                    MLog.debug((String)"GalleryBigPhotoDisplayActivity", (String)"cancel share");
                }
            }
        });
    }

    public void onEventBind() {
        super.onEventBind();
        if (this.mEventBinder == null) {
            this.mEventBinder = new GalleryBigPhotoDisplayActivity$$EventBinder();
        }
        this.mEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mEventBinder != null) {
            this.mEventBinder.unBindEvent();
        }
    }
}

