/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.gallery;

import android.content.Context;
import android.graphics.Color;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.SpannableStringBuilder;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.method.LinkMovementMethod;
import android.text.style.ClickableSpan;
import android.text.style.ForegroundColorSpan;
import android.util.DisplayMetrics;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.image.CircleImageView;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.plugin.main.events.IAttentionFriendClient_onQueryBookAnchorBatchResult_EventArgs;
import com.yy.mobile.plugin.main.events.IGalleryClient_onAddPhotoComment_EventArgs;
import com.yy.mobile.plugin.main.events.IGalleryClient_onBatchDetelePhoto_EventArgs;
import com.yy.mobile.plugin.main.events.IGalleryClient_onCancelSendComment_EventArgs;
import com.yy.mobile.plugin.main.events.IGalleryClient_onClearComment_EventArgs;
import com.yy.mobile.plugin.main.events.IGalleryClient_onCloseComment_EventArgs;
import com.yy.mobile.plugin.main.events.IGalleryClient_onCommentPraise_EventArgs;
import com.yy.mobile.plugin.main.events.IGalleryClient_onGalleryCombineAuth_EventArgs;
import com.yy.mobile.plugin.main.events.IGalleryClient_onNewQueryPhotoDec_EventArgs;
import com.yy.mobile.plugin.main.events.IGalleryClient_onOpenComment_EventArgs;
import com.yy.mobile.plugin.main.events.IGalleryClient_onPhotoPrase_EventArgs;
import com.yy.mobile.plugin.main.events.IGalleryClient_onPublishComment_EventArgs;
import com.yy.mobile.plugin.main.events.IGalleryClient_onSendComment_EventArgs;
import com.yy.mobile.plugin.main.events.IProfileClient_onRequestProfile_EventArgs;
import com.yy.mobile.plugin.main.events.ISubscribeClient_onSubscribeResult_EventArgs;
import com.yy.mobile.ui.BaseLinkFragment;
import com.yy.mobile.ui.gallery.GalleryBigDetailFragment$$EventBinder;
import com.yy.mobile.ui.gallery.GalleryPagerFragment;
import com.yy.mobile.ui.gallery.barrag.BubbleBarragView;
import com.yy.mobile.ui.gallery.barrag.BubbleView;
import com.yy.mobile.ui.home.FaceHelperFactory;
import com.yy.mobile.ui.utils.NavigationUtils;
import com.yy.mobile.ui.utils.SingleToastUtil;
import com.yy.mobile.ui.widget.CanDisableScrollView;
import com.yy.mobile.ui.widget.extend.RxViewExt;
import com.yy.mobile.ui.widget.toast.Toast;
import com.yy.mobile.util.FaceHelper;
import com.yy.mobile.util.ObjectTimeslotTool;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.ylink.bridge.coreapi.BaseFragmentApi;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.CoreManager;
import com.yymobile.core.gallery.GalleryConfig;
import com.yymobile.core.gallery.GalleryCoreImpl;
import com.yymobile.core.gallery.IGalleryCore;
import com.yymobile.core.gallery.module.CommentInfo;
import com.yymobile.core.gallery.module.CommentPraises;
import com.yymobile.core.gallery.module.PhotoInfo;
import com.yymobile.core.profile.EntUserInfo;
import com.yymobile.core.profile.IProfileCore;
import com.yymobile.core.statistic.IHiidoStatisticCore;
import com.yymobile.core.subscribe.ISubscribeCore;
import com.yymobile.core.user.UserInfo;
import io.reactivex.functions.Consumer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class GalleryBigDetailFragment
extends BaseLinkFragment
implements View.OnClickListener {
    public static final String BUBBLEVIEW = "bubbleview";
    private static final String TAG = "GalleryBigDetailFragment";
    private static final String GRALLERYPHOTOINFO = "photoinfo";
    public boolean shouldHandleData = true;
    GalleryPagerFragment.OnNewImageChangeListener listener;
    private long anchorId;
    private long alumId;
    private long photoId;
    private int currentPosition;
    private int phototype = 100;
    private int screenWidth;
    private int screenHeight;
    private int picScaleWidth = 0;
    private int picScaleHeight = 0;
    private int viewWidth = 0;
    private int viewHeight = 0;
    private CanDisableScrollView canDisableScrollView;
    private BubbleBarragView bubbleBarragView;
    private BubbleView barragView;
    private View maskLayout;
    private ViewGroup myBarragPublishedLayout;
    private ViewGroup myBarragLayout;
    private RecycleImageView bigImageView;
    private RecycleImageView combineImageView;
    private TextView danmuNum;
    private TextView likeNum;
    private TextView imageDetailName;
    private TextView imageDetailAuthor;
    private PhotoInfo mPhotoInfo;
    private int isDanmu = 0;
    private RelativeLayout.LayoutParams myBarragLp;
    private String commentContent = "";
    private int withTotalNum = 1;
    private long limitTime = 0L;
    private CommentInfo msgCommentInfo;
    private boolean galleryCombineLockFlag = false;
    private CircleImageView mCirleImg;
    private View anchorTitleItem;
    private View mNameLayout;
    private TextView mAnchorName;
    private TextView mPhotoCount;
    private TextView mPhotoGunzhu;
    private TextView mPhotoGuanzhued;
    private ImageView mGuanzhuImg;
    private boolean isAnchor = false;
    private long loginUserId = 0L;
    private ObjectTimeslotTool mTimeSlotTool = new ObjectTimeslotTool();
    private View.OnClickListener clickListener = new View.OnClickListener(){

        public void onClick(View view) {
            if (GalleryBigDetailFragment.this.mTimeSlotTool.isProcessing()) {
                return;
            }
            if (((GalleryBigDetailFragment)GalleryBigDetailFragment.this).bubbleBarragView.touchable) {
                ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "1002", "0008");
                NavigationUtils.toBigGalleryDisplayActivity((Context)GalleryBigDetailFragment.this.getActivity(), GalleryBigDetailFragment.this.mPhotoInfo);
            }
        }
    };
    private View.OnClickListener barragClickListener = new View.OnClickListener(){

        public void onClick(View view) {
            if (GalleryBigDetailFragment.this.mTimeSlotTool.isProcessing()) {
                return;
            }
            BubbleView bubbleView = (BubbleView)view;
            bubbleView.playPraiseAnimation();
            ((IGalleryCore)CoreManager.getCore(IGalleryCore.class)).commentPraise(bubbleView.anchorId, bubbleView.albumId, bubbleView.photoId, bubbleView.commentId);
        }
    };
    private EventBinder mEventBinder;

    public static GalleryBigDetailFragment newInstance() {
        GalleryBigDetailFragment f = new GalleryBigDetailFragment();
        Bundle args = new Bundle();
        f.setArguments(args);
        return f;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.loginUserId = LoginUtil.getUid();
        EntUserInfo userInfo = ((IProfileCore)CoreManager.getCore(IProfileCore.class)).getCachedProfileInfo(this.loginUserId);
        if (userInfo == null) {
            ((IProfileCore)CoreManager.getCore(IProfileCore.class)).requestProfile(this.loginUserId);
        } else {
            this.isAnchor = userInfo.userType == 1;
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View root = inflater.inflate(R.layout.layout_viewpager_gallery_photo, container, false);
        if (savedInstanceState != null) {
            this.mPhotoInfo = (PhotoInfo)savedInstanceState.getParcelable("gallery_click_photo");
            this.photoId = savedInstanceState.getLong("gallery_photo_id", 0L);
            this.phototype = savedInstanceState.getInt("gallery_photo_type", 0);
            this.msgCommentInfo = (CommentInfo)savedInstanceState.getParcelable("gallery_anchor_commentinfo");
            this.anchorId = savedInstanceState.getLong("gallery_anthor_id", 0L);
            this.alumId = savedInstanceState.getLong("gallery_alum_id", 0L);
            this.withTotalNum = savedInstanceState.getInt("gallery_anthor_withtotalnum", 0);
            this.galleryCombineLockFlag = savedInstanceState.getBoolean("gallery_combine_lock");
        }
        this.initView(root);
        return root;
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (this.mPhotoInfo != null) {
            outState.putParcelable("gallery_click_photo", (Parcelable)this.mPhotoInfo);
            outState.putLong("gallery_photo_id", this.mPhotoInfo.photoId);
        }
        outState.putInt("gallery_photo_type", this.phototype);
        outState.putLong("gallery_alum_id", this.alumId);
        outState.putLong("gallery_anthor_id", this.anchorId);
        outState.putInt("gallery_anthor_withtotalnum", this.withTotalNum);
        outState.putParcelable("gallery_anchor_commentinfo", (Parcelable)this.msgCommentInfo);
        outState.putBoolean("gallery_combine_lock", GalleryConfig.getInstance().galleryCombineKey);
    }

    public void onDestroyView() {
        super.onDestroyView();
        if (this.bubbleBarragView != null) {
            this.bubbleBarragView.recycle();
            this.bubbleBarragView.stopBarrag();
        }
        if (this.myBarragPublishedLayout != null) {
            this.myBarragPublishedLayout = null;
        }
        if (this.myBarragLayout != null) {
            this.myBarragLayout = null;
        }
    }

    public void onResume() {
        super.onResume();
        this.setBubbleViewResume();
    }

    public void onPause() {
        super.onPause();
        this.setBubbleViewPause();
    }

    public void setBubbleViewPause() {
        this.shouldHandleData = false;
        if (this.bubbleBarragView != null) {
            this.bubbleBarragView.pauseBarrag();
        }
    }

    public void setBubbleViewResume() {
        this.shouldHandleData = true;
        if (this.bubbleBarragView != null && GalleryCoreImpl.isOpenTanmu) {
            this.bubbleBarragView.resumeBarrag();
        }
    }

    public void initNewQueryPhotoDec(int phototype, long anchorID, long albumId, long photoId, int withcomments, int withTotalNum) {
        if (!MLog.isLogLevelAboveVerbose()) {
            MLog.verbose((String)"zs---", (String)"zs initNewQueryPhotoDec");
        }
        ((IGalleryCore)CoreManager.getCore(IGalleryCore.class)).queryPhotoDetailDanMu(phototype, anchorID, albumId, photoId, withcomments, withTotalNum);
    }

    public void initView(View view) {
        if (!MLog.isLogLevelAboveVerbose()) {
            MLog.verbose((String)"zs---", (String)" GalleryBigDetailFragment initView ");
        }
        this.danmuNum = (TextView)view.findViewById(R.id.danmu_num);
        this.likeNum = (TextView)view.findViewById(R.id.like_num);
        this.canDisableScrollView = (CanDisableScrollView)view.findViewById(R.id.gallery_detail_scroll);
        this.imageDetailName = (TextView)view.findViewById(R.id.gallery_image_detail);
        this.imageDetailAuthor = (TextView)view.findViewById(R.id.gallery_image_name);
        this.bigImageView = (RecycleImageView)view.findViewById(R.id.gallery_image_big);
        this.bubbleBarragView = (BubbleBarragView)view.findViewById(R.id.bubble_barrag_view);
        this.myBarragPublishedLayout = (ViewGroup)view.findViewById(R.id.my_barrag_published_layout);
        this.maskLayout = view.findViewById(R.id.mask_barrag_layout);
        this.myBarragLayout = (ViewGroup)view.findViewById(R.id.my_barrag_layout);
        this.combineImageView = (RecycleImageView)view.findViewById(R.id.gallery_image_combine);
        this.mCirleImg = (CircleImageView)view.findViewById(R.id.portrait);
        this.anchorTitleItem = view.findViewById(R.id.anchor_title_item);
        this.mNameLayout = view.findViewById(R.id.name_layout);
        this.mAnchorName = (TextView)view.findViewById(R.id.name);
        this.mPhotoCount = (TextView)view.findViewById(R.id.image_count);
        this.mPhotoGunzhu = (TextView)view.findViewById(R.id.tx_no_guanzhu);
        this.mPhotoGuanzhued = (TextView)view.findViewById(R.id.tx_yes_guanzhu);
        this.mGuanzhuImg = (ImageView)view.findViewById(R.id.img_guanzhu_no);
        if (this.phototype == 103 || this.phototype == 101 || this.phototype == 102) {
            this.anchorTitleItem.setVisibility(0);
            if (this.mPhotoInfo != null) {
                FaceHelper.loadFace((String)this.mPhotoInfo.photoAuthorLogo, (int)-1, (FaceHelperFactory.FaceType)FaceHelperFactory.FaceType.FriendFace, (RecycleImageView)this.mCirleImg, (ImageConfig)ImageConfig.defaultImageConfig(), (int)R.drawable.default_portrait);
                if (!StringUtils.isEmpty((String)this.mPhotoInfo.photoAuthorName).booleanValue()) {
                    this.mAnchorName.setText((CharSequence)this.mPhotoInfo.photoAuthorName);
                }
                this.mPhotoCount.setText((CharSequence)("\u5171" + this.mPhotoInfo.totalNum + "\u5f20\u56fe\u7247"));
            }
        } else {
            this.anchorTitleItem.setVisibility(8);
        }
        DisplayMetrics dm = this.getResources().getDisplayMetrics();
        this.screenWidth = dm.widthPixels;
        this.screenHeight = dm.heightPixels - 50;
        this.bigImageView.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, this.screenWidth));
        this.addData();
        this.bigImageView.setOnClickListener(this.clickListener);
        this.bubbleBarragView.setClickListener(this.clickListener);
        this.initCombineBtn();
        this.mCirleImg.setOnClickListener((View.OnClickListener)this);
        this.mNameLayout.setOnClickListener((View.OnClickListener)this);
        this.mPhotoGunzhu.setOnClickListener((View.OnClickListener)this);
        this.mGuanzhuImg.setOnClickListener((View.OnClickListener)this);
    }

    public void updateData(PhotoInfo photoInfo, long anchorId, long alumId, int type, CommentInfo info) {
        if (!MLog.isLogLevelAboveVerbose()) {
            MLog.verbose((String)"zs--- ", (String)" GalleryBigDetailFragment updateData ");
        }
        if (photoInfo != null) {
            this.mPhotoInfo = photoInfo;
        }
        this.photoId = this.mPhotoInfo.photoId;
        this.phototype = type;
        this.msgCommentInfo = info;
        if (photoInfo != null && (this.phototype == 101 || this.phototype == 102)) {
            this.anchorId = photoInfo.photoAnchorId;
            this.alumId = photoInfo.photoAlumId;
            this.withTotalNum = 0;
        } else {
            this.anchorId = anchorId;
            this.alumId = alumId;
            this.withTotalNum = 1;
        }
    }

    public void addData() {
        if (this.mPhotoInfo != null) {
            if (this.mPhotoInfo.photoName != null && !this.mPhotoInfo.photoName.equals("") && this.mPhotoInfo.category != null && !"dynamic".equals(this.mPhotoInfo.category)) {
                this.imageDetailName.setText((CharSequence)this.mPhotoInfo.photoName);
                this.imageDetailName.setVisibility(0);
            } else {
                this.imageDetailName.setVisibility(8);
            }
            if (this.mPhotoInfo.photoCreator != null) {
                SpannableStringBuilder builder;
                ForegroundColorSpan graySpan = new ForegroundColorSpan(Color.parseColor((String)"#fffac200"));
                if (this.mPhotoInfo.createTime != null) {
                    builder = new SpannableStringBuilder((CharSequence)("\u7531" + this.mPhotoInfo.photoCreator + this.mPhotoInfo.createTime));
                    if ("dynamic".equals(this.mPhotoInfo.category)) {
                        builder = new SpannableStringBuilder((CharSequence)("\u7531" + this.mPhotoInfo.photoCreator + this.getString(R.string.function_details_info)));
                    }
                } else {
                    builder = new SpannableStringBuilder((CharSequence)("\u7531" + this.mPhotoInfo.photoCreator));
                }
                ClickableSpan onClickName = new ClickableSpan(){

                    public void onClick(View widget) {
                        if (GalleryBigDetailFragment.this.mTimeSlotTool.isProcessing()) {
                            return;
                        }
                        ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "1002", "0010");
                        if (((GalleryBigDetailFragment)GalleryBigDetailFragment.this).mPhotoInfo.isCreatorAnchor == 0) {
                            NavigationUtils.toPersonPage((Context)GalleryBigDetailFragment.this.getActivity(), ((GalleryBigDetailFragment)GalleryBigDetailFragment.this).mPhotoInfo.createUid, 3);
                        } else {
                            NavigationUtils.toUserInfo((Context)GalleryBigDetailFragment.this.getActivity(), ((GalleryBigDetailFragment)GalleryBigDetailFragment.this).mPhotoInfo.createUid);
                        }
                    }

                    public void updateDrawState(TextPaint ds) {
                    }
                };
                builder.setSpan((Object)graySpan, 1, 1 + String.valueOf(this.mPhotoInfo.photoCreator).length(), 33);
                builder.setSpan((Object)onClickName, 1, 1 + String.valueOf(this.mPhotoInfo.photoCreator).length(), 33);
                this.imageDetailAuthor.setText((CharSequence)builder);
                this.imageDetailAuthor.setMovementMethod(LinkMovementMethod.getInstance());
            }
            if (this.mPhotoInfo.commentNum > 9999L) {
                this.danmuNum.setText((CharSequence)this.wrapShowData((int)this.mPhotoInfo.commentNum));
            } else {
                this.danmuNum.setText((CharSequence)(this.mPhotoInfo.commentNum + ""));
            }
            if (this.mPhotoInfo.praiseNum > 9999L) {
                this.likeNum.setText((CharSequence)this.wrapShowData((int)this.mPhotoInfo.praiseNum));
            } else {
                this.likeNum.setText((CharSequence)(this.mPhotoInfo.praiseNum + ""));
            }
            if (!MLog.isLogLevelAboveVerbose()) {
                MLog.verbose((String)TAG, (String)("comments size=" + this.mPhotoInfo.comments.size() + " comments=" + this.mPhotoInfo.comments));
            }
            if (ImageLoader.isGif((String)this.mPhotoInfo.photoUrl)) {
                ImageLoader.loadImage((RecycleImageView)this.bigImageView, (String)this.mPhotoInfo.photoUrl, (int)R.drawable.hp_living_default_bg);
            } else {
                ImageLoader.loadImage((RecycleImageView)this.bigImageView, (String)this.mPhotoInfo.photoUrl, (int)R.drawable.hp_living_default_bg, (int)R.drawable.hp_living_default_bg, (ImageLoader.ImageLoadListener)new ImageLoader.ImageLoadListener(){

                    public void onLoadFailed(Exception e) {
                        if (!MLog.isLogLevelAboveVerbose()) {
                            MLog.verbose((String)GalleryBigDetailFragment.TAG, (String)(" GalleryBigDetailFragment RequestError" + e));
                        }
                    }

                    public void onResourceReady(Object resource) {
                        if (!MLog.isLogLevelAboveVerbose()) {
                            MLog.verbose((String)GalleryBigDetailFragment.TAG, (String)" GalleryBigDetailFragment response");
                        }
                        if (GalleryCoreImpl.isOpenTanmu) {
                            GalleryBigDetailFragment.this.bubbleBarragView.setVisibility(0);
                            if (GalleryBigDetailFragment.this.myBarragPublishedLayout != null) {
                                GalleryBigDetailFragment.this.myBarragPublishedLayout.setVisibility(0);
                            }
                            if (GalleryBigDetailFragment.this.myBarragLayout != null) {
                                GalleryBigDetailFragment.this.myBarragLayout.setVisibility(0);
                            }
                        }
                        if (GalleryBigDetailFragment.this.bigImageView.getDrawable() != null) {
                            if (!MLog.isLogLevelAboveVerbose()) {
                                MLog.verbose((String)GalleryBigDetailFragment.TAG, (String)("bigImageView drawable rect=" + GalleryBigDetailFragment.this.bigImageView.getDrawable().getBounds()));
                            }
                            GalleryBigDetailFragment.this.calculateWidthAndHeight(GalleryBigDetailFragment.this.bigImageView.getDrawable().getBounds().width(), GalleryBigDetailFragment.this.bigImageView.getDrawable().getBounds().height());
                            if (GalleryCoreImpl.isOpenTanmu) {
                                if (GalleryBigDetailFragment.this.phototype == 103 && GalleryBigDetailFragment.this.msgCommentInfo != null) {
                                    GalleryBigDetailFragment.this.bubbleBarragView.setData(GalleryBigDetailFragment.this.anchorId, GalleryBigDetailFragment.this.alumId, GalleryBigDetailFragment.this.photoId, ((GalleryBigDetailFragment)GalleryBigDetailFragment.this).mPhotoInfo.comments, GalleryBigDetailFragment.this.viewWidth, GalleryBigDetailFragment.this.viewHeight, GalleryBigDetailFragment.this.picScaleWidth, GalleryBigDetailFragment.this.picScaleHeight, GalleryBigDetailFragment.this.msgCommentInfo);
                                } else {
                                    GalleryBigDetailFragment.this.bubbleBarragView.setData(GalleryBigDetailFragment.this.anchorId, GalleryBigDetailFragment.this.alumId, GalleryBigDetailFragment.this.photoId, ((GalleryBigDetailFragment)GalleryBigDetailFragment.this).mPhotoInfo.comments, GalleryBigDetailFragment.this.viewWidth, GalleryBigDetailFragment.this.viewHeight, GalleryBigDetailFragment.this.picScaleWidth, GalleryBigDetailFragment.this.picScaleHeight);
                                }
                            }
                        }
                    }
                });
            }
            if (GalleryCoreImpl.isOpenTanmu) {
                this.bubbleBarragView.setVisibility(0);
                if (this.myBarragPublishedLayout != null) {
                    this.myBarragPublishedLayout.setVisibility(0);
                }
                if (this.myBarragLayout != null) {
                    this.myBarragLayout.setVisibility(0);
                }
            }
            if (this.bigImageView.getDrawable() != null) {
                this.calculateWidthAndHeight(this.bigImageView.getDrawable().getBounds().width(), this.bigImageView.getDrawable().getBounds().height());
                if (GalleryCoreImpl.isOpenTanmu) {
                    if (this.phototype == 103 && this.msgCommentInfo != null) {
                        this.bubbleBarragView.setData(this.anchorId, this.alumId, this.photoId, this.mPhotoInfo.comments, this.viewWidth, this.viewHeight, this.picScaleWidth, this.picScaleHeight, this.msgCommentInfo);
                    } else {
                        this.bubbleBarragView.setData(this.anchorId, this.alumId, this.photoId, this.mPhotoInfo.comments, this.viewWidth, this.viewHeight, this.picScaleWidth, this.picScaleHeight);
                    }
                }
            }
        }
    }

    private void calculateWidthAndHeight(int drawableWidth, int drawableHeight) {
        if (!MLog.isLogLevelAboveVerbose()) {
            MLog.verbose((String)TAG, (String)("bigImageView drawable rect width=" + drawableWidth + " height=" + drawableHeight));
        }
        this.viewWidth = this.screenWidth;
        if (drawableWidth == 0 || drawableHeight == 0) {
            return;
        }
        if (drawableWidth > drawableHeight) {
            this.bigImageView.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, this.screenWidth));
            this.viewHeight = this.screenWidth;
        } else {
            int w = this.screenWidth;
            int h = w * drawableHeight / drawableWidth;
            if (h > this.screenHeight - this.dp2Px(48.0f) - this.dp2Px(40.0f) - this.dp2Px(20.0f)) {
                if (this.phototype == 101 || this.phototype == 102) {
                    this.bigImageView.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, this.screenHeight - this.dp2Px(48.0f) - this.dp2Px(40.0f) - this.dp2Px(61.0f) - this.dp2Px(20.0f)));
                    this.viewHeight = this.screenHeight - this.dp2Px(48.0f) - this.dp2Px(40.0f) - this.dp2Px(61.0f) - this.dp2Px(20.0f);
                } else {
                    this.bigImageView.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, this.screenHeight - this.dp2Px(48.0f) - this.dp2Px(40.0f) - this.dp2Px(20.0f)));
                    this.viewHeight = this.screenHeight - this.dp2Px(48.0f) - this.dp2Px(40.0f) - this.dp2Px(20.0f);
                }
            } else {
                this.bigImageView.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, h));
                this.viewHeight = h;
            }
        }
        if (this.viewWidth == 0 || this.viewHeight == 0) {
            return;
        }
        if ((float)drawableWidth / (float)drawableHeight < (float)this.viewWidth / (float)this.viewHeight) {
            this.picScaleHeight = this.viewHeight;
            this.picScaleWidth = Math.round((float)drawableWidth / (float)drawableHeight * (float)this.picScaleHeight);
        } else {
            this.picScaleWidth = this.viewWidth;
            this.picScaleHeight = Math.round((float)drawableHeight / (float)drawableWidth * (float)this.picScaleWidth);
        }
        if (!MLog.isLogLevelAboveVerbose()) {
            MLog.verbose((String)TAG, (String)("bigImageView scale: " + this.picScaleWidth + "," + this.picScaleHeight));
        }
    }

    @BusEvent(busType=1, busName="plugin_main")
    public void onNewQueryPhotoDec(IGalleryClient_onNewQueryPhotoDec_EventArgs busEventArgs) {
        int resultCode = busEventArgs.getResultCode();
        String errorMsg = busEventArgs.getErrorMsg();
        PhotoInfo photoinfo = busEventArgs.getPhotoinfo();
        if (!this.shouldHandleData) {
            return;
        }
        if (resultCode == 0) {
            if (photoinfo != null && this.mPhotoInfo != null && photoinfo.photoId == this.mPhotoInfo.photoId) {
                this.mPhotoInfo.photoAuthorLogo = photoinfo.photoAuthorLogo;
                this.mPhotoInfo.praiseNum = photoinfo.praiseNum;
                this.mPhotoInfo.myPraiseNum = photoinfo.myPraiseNum;
                this.mPhotoInfo.commentNum = photoinfo.commentNum;
                this.mPhotoInfo.permission = photoinfo.permission;
                this.mPhotoInfo.photoName = photoinfo.photoName;
                this.mPhotoInfo.createTime = photoinfo.createTime;
                this.mPhotoInfo.isCreatorAnchor = photoinfo.isCreatorAnchor;
                this.mPhotoInfo.createUid = photoinfo.createUid;
                this.mPhotoInfo.photoCreator = photoinfo.photoCreator;
                this.mPhotoInfo.totalNum = photoinfo.totalNum;
                this.mPhotoInfo.category = photoinfo.category;
                if (this.phototype == 101) {
                    this.mPhotoInfo.photoAuthorName = photoinfo.photoAuthorName;
                }
                if (this.mPhotoInfo.comments != null) {
                    this.mPhotoInfo.comments.clear();
                    this.mPhotoInfo.comments.addAll(photoinfo.comments);
                    RecycleImageView riv = new RecycleImageView(this.getContext());
                    for (int i = 0; i < this.mPhotoInfo.comments.size(); ++i) {
                        ImageLoader.loadImage((String)((CommentInfo)this.mPhotoInfo.comments.get((int)i)).commentsMyLogo, (RecycleImageView)riv, (ImageConfig)ImageConfig.defaultImageConfig(), (int)R.drawable.default_portrait);
                    }
                }
                if (this.phototype == 101) {
                    this.anchorTitleItem.setVisibility(0);
                    FaceHelper.loadFace((String)this.mPhotoInfo.photoAuthorLogo, (int)-1, (FaceHelperFactory.FaceType)FaceHelperFactory.FaceType.FriendFace, (RecycleImageView)this.mCirleImg, (ImageConfig)ImageConfig.defaultImageConfig(), (int)R.drawable.default_portrait);
                    if (!StringUtils.isEmpty((String)this.mPhotoInfo.photoAuthorName).booleanValue()) {
                        this.mAnchorName.setText((CharSequence)this.mPhotoInfo.photoAuthorName);
                    }
                    this.mPhotoCount.setText((CharSequence)("\u5171" + this.mPhotoInfo.totalNum + "\u5f20\u56fe\u7247"));
                }
                if (MLog.isLogLevelAboveDebug()) {
                    MLog.debug((String)TAG, (String)("onNewQueryPhotoDec addData comments=" + this.mPhotoInfo.comments));
                }
                this.addData();
            }
        } else {
            String tips = this.getString(R.string.str_query_photodel_fail);
            if (!TextUtils.isEmpty((CharSequence)errorMsg)) {
                tips = tips + "\uff0c" + errorMsg;
            }
            this.toast(tips, 0);
        }
    }

    @BusEvent(busType=1, busName="plugin_main")
    public void onOpenComment(IGalleryClient_onOpenComment_EventArgs busEventArgs) {
        int result = busEventArgs.getResult();
        long anchorId = busEventArgs.getAnchorId();
        long photoId = busEventArgs.getPhotoId();
        this.onOpenComment(result, anchorId, photoId);
    }

    public void onOpenComment(int result, long anchorId, long photoId) {
        if (!this.shouldHandleData) {
            return;
        }
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((String)TAG, (String)("anchorId=" + anchorId + " this.photoId=" + this.photoId + " photoId=" + photoId + " mPhotoInfo=" + this.mPhotoInfo.photoId));
        }
        if (this.photoId == photoId) {
            if (this.bubbleBarragView != null) {
                if (this.bubbleBarragView.bubbleBmpArr.size() > 0) {
                    this.bubbleBarragView.startBarrag();
                    if (!MLog.isLogLevelAboveVerbose()) {
                        MLog.verbose((String)TAG, (String)"startBarrag");
                    }
                } else if (this.mPhotoInfo != null && this.mPhotoInfo.comments != null && this.mPhotoInfo.comments.size() > 0) {
                    if (!MLog.isLogLevelAboveVerbose()) {
                        MLog.verbose((String)TAG, (String)("anchorId=" + anchorId + " viewWidth=" + this.viewWidth + " viewHeight=" + this.viewHeight + " picScaleWidth" + this.picScaleWidth + " picScaleHeight=" + this.picScaleHeight));
                    }
                    this.addData();
                } else {
                    PhotoInfo photoInfo = ((IGalleryCore)CoreManager.getCore(IGalleryCore.class)).getPhotoInfo(this.phototype, this.anchorId, this.alumId, this.photoId);
                    if (photoInfo != null && !StringUtils.isEmpty((String)photoInfo.photoUrl).booleanValue()) {
                        this.mPhotoInfo.photoId = photoInfo.photoId;
                        this.mPhotoInfo.photoName = photoInfo.photoName;
                        this.mPhotoInfo.comments = photoInfo.comments;
                        this.mPhotoInfo.commentNum = photoInfo.commentNum;
                        this.mPhotoInfo.createTime = photoInfo.createTime;
                        this.mPhotoInfo.createUid = photoInfo.createUid;
                        this.mPhotoInfo.photoCreator = photoInfo.photoCreator;
                        this.mPhotoInfo.isComposed = photoInfo.isComposed;
                        this.mPhotoInfo.isCreatorAnchor = photoInfo.isCreatorAnchor;
                        this.mPhotoInfo.myPraiseNum = photoInfo.myPraiseNum;
                        this.mPhotoInfo.photoAnchorId = photoInfo.photoAnchorId;
                        this.mPhotoInfo.photoAlumId = photoInfo.photoAlumId;
                        this.mPhotoInfo.totalNum = photoInfo.totalNum;
                        this.mPhotoInfo.photoAuthorName = photoInfo.photoAuthorName;
                        this.mPhotoInfo.photoAuthorLogo = photoInfo.photoAuthorLogo;
                        this.mPhotoInfo.thumbsUrl = photoInfo.thumbsUrl;
                        this.mPhotoInfo.shareContent = photoInfo.shareContent;
                        this.mPhotoInfo.shareTitle = photoInfo.shareTitle;
                        this.mPhotoInfo.selected = photoInfo.selected;
                        this.mPhotoInfo.permission = photoInfo.permission;
                        this.mPhotoInfo.height = photoInfo.height;
                        this.mPhotoInfo.width = photoInfo.width;
                        this.mPhotoInfo.praiseNum = photoInfo.praiseNum;
                        this.mPhotoInfo.sysPhoto = photoInfo.sysPhoto;
                        this.mPhotoInfo.photoUrl = photoInfo.photoUrl;
                        this.mPhotoInfo.category = photoInfo.category;
                    }
                    this.addData();
                    if (!MLog.isLogLevelAboveVerbose()) {
                        MLog.verbose((String)TAG, (String)("initNewQueryPhotoDec photoId=" + photoId + " mPhotoInfo.comments=" + this.mPhotoInfo.comments));
                    }
                }
                this.bubbleBarragView.setVisibility(0);
            }
            if (this.myBarragPublishedLayout != null) {
                this.myBarragPublishedLayout.setVisibility(0);
            }
            if (this.myBarragLayout != null) {
                this.myBarragLayout.setVisibility(0);
            }
        }
    }

    @BusEvent(busType=1, busName="plugin_main")
    public void onCloseComment(IGalleryClient_onCloseComment_EventArgs busEventArgs) {
        if (!this.shouldHandleData) {
            return;
        }
        if (this.bubbleBarragView != null) {
            this.bubbleBarragView.pauseBarrag();
            this.bubbleBarragView.setVisibility(8);
        }
        if (this.myBarragPublishedLayout != null) {
            this.myBarragPublishedLayout.setVisibility(8);
        }
        if (this.myBarragLayout != null) {
            this.myBarragLayout.setVisibility(8);
        }
    }

    @BusEvent(busType=1, busName="plugin_main")
    public void onCancelSendComment(IGalleryClient_onCancelSendComment_EventArgs busEventArgs) {
        int result = busEventArgs.getResult();
        long anchorId = busEventArgs.getAnchorId();
        long photoId = busEventArgs.getPhotoId();
        if (!this.shouldHandleData) {
            return;
        }
        if (this.anchorId == anchorId && this.photoId == photoId && result == 0 && this.myBarragLayout != null && this.myBarragLayout.getChildCount() > 0) {
            this.myBarragLayout.removeViewAt(this.myBarragLayout.getChildCount() - 1);
            this.bubbleBarragView.resumeBarrag();
            this.bubbleBarragView.touchable = true;
            this.canDisableScrollView.setCanScroll(true);
            this.maskLayout.setVisibility(8);
        }
    }

    @BusEvent(busType=1, busName="plugin_main")
    public void onSendComment(IGalleryClient_onSendComment_EventArgs busEventArgs) {
        String content = busEventArgs.getContent();
        long anchorId = busEventArgs.getAnchorId();
        long photoId = busEventArgs.getPhotoId();
        if (!this.shouldHandleData) {
            return;
        }
        if (!MLog.isLogLevelAboveVerbose()) {
            MLog.verbose((String)TAG, (String)("onSendComment anchorId=" + anchorId + " photoId=" + photoId));
        }
        if (this.anchorId == anchorId && this.photoId == photoId && this.myBarragLayout != null && this.bubbleBarragView != null && !StringUtils.isEmpty((String)content).booleanValue()) {
            this.commentContent = content;
            this.barragView = new BubbleView(this.getContext(), this.screenWidth, this.screenHeight, this.viewWidth, this.viewHeight);
            UserInfo uInfo = CoreManager.getUserCore().getCacheLoginUserInfo();
            if (uInfo != null && uInfo.userId > 0L) {
                this.barragView.loadHeadLogo(uInfo.iconUrl_100_100);
            }
            this.barragView.setContent(content);
            this.barragView.setSelectStatus(true);
            this.myBarragLayout.addView((View)this.barragView);
            this.myBarragLayout.setVisibility(0);
            this.myBarragLp = new RelativeLayout.LayoutParams(-2, -2);
            this.myBarragLp.leftMargin = this.screenWidth / 4 + (int)(Math.random() * (double)this.screenWidth / 4.0);
            this.myBarragLp.topMargin = this.myBarragLayout.getHeight() / 4 + (int)(Math.random() * (double)this.myBarragLayout.getHeight() / 4.0);
            this.barragView.setLayoutParams((ViewGroup.LayoutParams)this.myBarragLp);
            this.bubbleBarragView.pauseBarrag();
            this.bubbleBarragView.touchable = false;
            this.canDisableScrollView.setCanScroll(false);
            this.maskLayout.setVisibility(0);
        }
    }

    @BusEvent(busType=1, busName="plugin_main")
    public void onPublishComment(IGalleryClient_onPublishComment_EventArgs busEventArgs) {
        int result = busEventArgs.getResult();
        long anchorId = busEventArgs.getAnchorId();
        long photoId = busEventArgs.getPhotoId();
        if (!this.shouldHandleData) {
            return;
        }
        if (this.anchorId == anchorId && this.photoId == photoId) {
            long nowTime;
            if (!MLog.isLogLevelAboveVerbose()) {
                MLog.verbose((String)TAG, (String)("onPublishComment result=" + result + " anchorId=" + anchorId + " photoId=" + photoId));
            }
            if ((nowTime = System.currentTimeMillis()) - this.limitTime > 5000L) {
                if (!MLog.isLogLevelAboveVerbose()) {
                    MLog.verbose((String)TAG, (String)("bigImageView picScaleWidth=" + this.picScaleWidth + " picScaleHeight=" + this.picScaleHeight + " vw=" + this.viewWidth + " vh=" + this.viewHeight + " mPhotoInfo.width=" + this.mPhotoInfo.width + " mPhotoInfo.height=" + this.mPhotoInfo.height));
                }
                int leftScale = this.calculateLeftScale(this.myBarragLp.leftMargin);
                int topScale = this.calculateTopScale(this.myBarragLp.topMargin);
                if (!MLog.isLogLevelAboveVerbose()) {
                    MLog.verbose((String)TAG, (String)("bigImageView leftMargin=" + this.myBarragLp.leftMargin + " topMargin=" + this.myBarragLp.topMargin + " leftScale=" + leftScale + " topScale=" + topScale + " imLogoLoc=" + this.barragView.getLogoLoc()));
                }
                if (!MLog.isLogLevelAboveVerbose()) {
                    MLog.verbose((String)TAG, (String)("anchorId=" + anchorId + " photoId=" + photoId));
                }
                ((IGalleryCore)CoreManager.getCore(IGalleryCore.class)).addPhotoComment(anchorId, this.alumId, photoId, this.commentContent, leftScale, topScale, this.barragView.getLogoLoc());
                this.limitTime = System.currentTimeMillis();
            } else if (nowTime - this.limitTime > 500L) {
                SingleToastUtil.showToast((Context)this.getContext(), (String)"\u53d1\u5f39\u5e55\u8fc7\u5feb\uff0c\u4f11\u606f\u4e00\u4e0b\u5427!");
            }
        }
    }

    @BusEvent(busType=1, busName="plugin_main")
    public void onAddPhotoComment(IGalleryClient_onAddPhotoComment_EventArgs busEventArgs) {
        int result = busEventArgs.getResult();
        String errorMsg = busEventArgs.getErrorMsg();
        CommentInfo commentInfo = busEventArgs.getCommentInfo();
        long anchorId = busEventArgs.getAnchorId();
        long photoId = busEventArgs.getPhotoId();
        this.onAddPhotoComment(result, errorMsg, commentInfo, anchorId, photoId);
    }

    public void onAddPhotoComment(int result, String errorMsg, CommentInfo commentInfo, long anchorId, long photoId) {
        if (!this.shouldHandleData) {
            return;
        }
        if (!MLog.isLogLevelAboveVerbose()) {
            MLog.verbose((String)TAG, (String)("onAddPhotoComment result=" + result + " anchorId=" + anchorId + " photoId=" + photoId));
        }
        if (this.anchorId == anchorId && this.photoId == photoId) {
            if (result == 0) {
                if (this.myBarragLayout != null) {
                    this.myBarragLayout.removeAllViews();
                    this.myBarragLayout.setVisibility(0);
                }
                if (this.myBarragPublishedLayout != null) {
                    UserInfo uInfo = CoreManager.getUserCore().getCacheLoginUserInfo();
                    if (uInfo != null && uInfo.userId > 0L) {
                        this.barragView.loadHeadLogo(uInfo.iconUrl_100_100);
                    }
                    this.barragView.setMyUnSelectStatus();
                    this.myBarragPublishedLayout.addView((View)this.barragView);
                    this.barragView.touchable = false;
                    this.barragView.anchorId = anchorId;
                    this.barragView.albumId = this.alumId;
                    this.barragView.photoId = photoId;
                    this.barragView.commentId = commentInfo.commentId;
                    this.barragView.setClickListener(this.barragClickListener);
                    this.myBarragPublishedLayout.setVisibility(0);
                }
                if (this.bubbleBarragView != null) {
                    this.bubbleBarragView.resumeBarrag();
                    this.bubbleBarragView.setVisibility(0);
                }
                ++this.mPhotoInfo.commentNum;
                if (this.mPhotoInfo.commentNum > 9999L) {
                    this.danmuNum.setText((CharSequence)this.wrapShowData((int)this.mPhotoInfo.commentNum));
                } else {
                    this.danmuNum.setText((CharSequence)(this.mPhotoInfo.commentNum + ""));
                }
                if (this.bubbleBarragView != null) {
                    this.bubbleBarragView.resumeBarrag();
                    this.bubbleBarragView.touchable = true;
                }
                this.canDisableScrollView.setCanScroll(true);
                this.maskLayout.setVisibility(8);
                Toast.makeText((Context)this.getContext(), (CharSequence)"\u53d1\u5e03\u6210\u529f", (int)0).show();
            } else if (result == 10203) {
                Toast.makeText((Context)this.getContext(), (CharSequence)"\u53d1\u5f39\u5e55\u8fc7\u5feb\uff0c\u4f11\u606f\u4e00\u4e0b\u5427!", (int)0).show();
            } else if (result == 10205) {
                Toast.makeText((Context)this.getContext(), (CharSequence)"\u53d1\u592a\u591a\u5566\uff0c\u7559\u70b9\u673a\u4f1a\u7ed9\u5176\u4ed6\u5c0f\u4f19\u4f34\u5427!", (int)0).show();
            } else if (result == 10014) {
                Toast.makeText((Context)this.getContext(), (CharSequence)errorMsg, (int)0).show();
            } else {
                Toast.makeText((Context)this.getContext(), (CharSequence)(StringUtils.isEmptyString((String)errorMsg) ? "\u53d1\u5e03\u5931\u8d25" : errorMsg), (int)0).show();
            }
        }
    }

    @BusEvent(busType=1, busName="plugin_main")
    public void onPhotoPrase(IGalleryClient_onPhotoPrase_EventArgs busEventArgs) {
        int result = busEventArgs.getResult();
        String errorMsg = busEventArgs.getErrorMsg();
        long photoId = busEventArgs.getPhotoId();
        if (!this.shouldHandleData) {
            return;
        }
        if (result == 0) {
            if (!MLog.isLogLevelAboveVerbose()) {
                MLog.verbose((String)"zs", (String)(" onPhotoPrase " + this.mPhotoInfo.praiseNum));
            }
            if (this.mPhotoInfo.photoId == photoId) {
                if (this.mPhotoInfo.commentNum > 9999L) {
                    this.likeNum.setText((CharSequence)this.wrapShowData((int)this.mPhotoInfo.praiseNum));
                } else {
                    ++this.mPhotoInfo.praiseNum;
                    this.likeNum.setText((CharSequence)(this.mPhotoInfo.praiseNum + ""));
                }
            }
        }
    }

    @BusEvent(busType=1, busName="plugin_main")
    public void onBatchDetelePhoto(IGalleryClient_onBatchDetelePhoto_EventArgs busEventArgs) {
        long anchorId = busEventArgs.getAnchorId();
        long photoId = busEventArgs.getPhotoId();
        if (!this.shouldHandleData) {
            return;
        }
        if (this.anchorId == anchorId && this.photoId == photoId && this.bubbleBarragView != null) {
            this.bubbleBarragView.stopBarrag();
        }
    }

    @BusEvent(busType=1, busName="plugin_main")
    public void onCommentPraise(IGalleryClient_onCommentPraise_EventArgs busEventArgs) {
        int result = busEventArgs.getResult();
        long uid = busEventArgs.getUid();
        long anchorId = busEventArgs.getAnchorId();
        long photoId = busEventArgs.getPhotoId();
        long commentId = busEventArgs.getCommentId();
        if (!this.shouldHandleData) {
            return;
        }
        if (!MLog.isLogLevelAboveVerbose()) {
            MLog.verbose((String)TAG, (String)("onCommentPraise uid=" + uid + "anchorUid=" + anchorId + " pictrueId=" + photoId + " commentId=" + commentId));
        }
        if (LoginUtil.getUid() == uid && this.anchorId == anchorId && this.photoId == photoId) {
            if (MLog.isLogLevelAboveDebug()) {
                MLog.debug((String)TAG, (String)("onCommentPraise uid=" + uid + "anchorUid=" + this.anchorId + " pictrueId=" + this.photoId + " commentId=" + commentId));
            }
            if (result == 0 || result == 10202) {
                CommentPraises commentPraises = new CommentPraises();
                commentPraises.anchorId = anchorId;
                commentPraises.photoId = photoId;
                commentPraises.commentId = commentId;
                if (GalleryCoreImpl.myPraiseList.get(LoginUtil.getUid()) != null) {
                    ((List)GalleryCoreImpl.myPraiseList.get(LoginUtil.getUid())).add(commentPraises);
                } else {
                    ArrayList<CommentPraises> list = new ArrayList<CommentPraises>();
                    list.add(commentPraises);
                    GalleryCoreImpl.myPraiseList.put(LoginUtil.getUid(), list);
                }
            }
        }
    }

    @BusEvent(busType=1, busName="plugin_main")
    public void onClearComment(IGalleryClient_onClearComment_EventArgs busEventArgs) {
        int result = busEventArgs.getResult();
        if (!this.shouldHandleData) {
            return;
        }
        if (result == 0) {
            if (this.bubbleBarragView != null) {
                this.bubbleBarragView.stopBarrag();
            }
            if (this.myBarragPublishedLayout != null) {
                this.myBarragPublishedLayout.removeAllViews();
            }
            if (this.myBarragLayout != null) {
                this.myBarragLayout.removeAllViews();
            }
        }
    }

    private int calculateLeftScale(int left) {
        if (this.picScaleWidth == 0) {
            return 0;
        }
        return Math.round(100.0f * ((float)left - (float)(this.viewWidth - this.picScaleWidth) * 0.5f) / (float)this.picScaleWidth);
    }

    private int calculateTopScale(int top) {
        if (this.picScaleHeight == 0) {
            return 0;
        }
        return Math.round(100.0f * ((float)top - (float)(this.viewHeight - this.picScaleHeight) * 0.5f) / (float)this.picScaleHeight);
    }

    private int dp2Px(float dp) {
        if (this.getContext() == null) {
            return (int)dp;
        }
        float scale = this.getContext().getResources().getDisplayMetrics().density;
        return (int)(dp * scale + 0.5f);
    }

    public void onClick(View v) {
        if (this.mTimeSlotTool.isProcessing()) {
            return;
        }
        int id2 = v.getId();
        if (id2 == R.id.portrait || id2 == R.id.name_layout) {
            ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "1003", "0005");
            if (this.mPhotoInfo.isAnchor == 1) {
                NavigationUtils.toUserInfo(this.getContext(), this.anchorId);
            } else if (this.mPhotoInfo.isAnchor == 0) {
                NavigationUtils.toPersonPage(this.getContext(), this.anchorId, 3);
            }
        } else if (id2 == R.id.tx_no_guanzhu || id2 == R.id.img_guanzhu_no) {
            if (LoginUtil.isLogined()) {
                if (!this.isAnchor) {
                    ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "1005", "0003");
                }
                ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "1003", "0006");
                if (this.phototype == 101 || this.phototype == 102 || this.phototype == 103) {
                    if (LoginUtil.getUid() == this.anchorId) {
                        Toast.makeText((Context)this.getContext(), (CharSequence)"\u81ea\u5df1\u4e0d\u80fd\u5173\u6ce8\u81ea\u5df1\u54e6\uff01", (int)0).show();
                    } else {
                        ((ISubscribeCore)CoreManager.getCore(ISubscribeCore.class)).subscribe(this.anchorId);
                    }
                }
            } else {
                BaseFragmentApi.LoginFragmentBuilder.create((Context)this.getActivity()).setAutoFollowTargetUid(this.anchorId).show();
            }
        }
    }

    private String wrapShowData(int hotDegree) {
        String resultStr = hotDegree + "";
        double temp = (double)hotDegree / 10000.0;
        if (temp >= 1.0) {
            resultStr = (temp = (double)Math.round(temp * 10.0) / 10.0) + "";
            if (resultStr.indexOf(".") > 0) {
                resultStr = resultStr.replaceAll("[10]$", "");
                resultStr = resultStr.replaceAll("[.]$", "");
            }
            resultStr = resultStr + "\u4e07";
        }
        return resultStr;
    }

    @BusEvent(busType=1, busName="plugin_main")
    public void onGalleryCombineAuth(IGalleryClient_onGalleryCombineAuth_EventArgs busEventArgs) {
        boolean combineAuth = busEventArgs.getCombineAuth();
        if (!this.shouldHandleData) {
            return;
        }
        if (combineAuth) {
            this.initCombineBtn();
        }
    }

    private void initCombineBtn() {
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((String)TAG, (String)"GalleryBigDetailFragment initCombineBtnstart");
        }
        if (this.galleryCombineLockFlag || GalleryConfig.getInstance().galleryCombineKey) {
            if (MLog.isLogLevelAboveDebug()) {
                MLog.debug((String)TAG, (String)"GalleryBigDetailFragment initCombineBtnsure");
            }
            if (this.mPhotoInfo != null && !StringUtils.isEmpty((String)this.mPhotoInfo.photoUrl).booleanValue() && (StringUtils.isEmpty((String)this.mPhotoInfo.isComposed).booleanValue() || !StringUtils.isEmpty((String)this.mPhotoInfo.isComposed).booleanValue() && "1".equals(this.mPhotoInfo.isComposed))) {
                this.combineImageView.setVisibility(0);
            }
        }
        RxViewExt.safelyClicks((View)this.combineImageView, (Consumer)new Consumer<Object>(){

            public void accept(Object o) throws Exception {
                ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "1004", "0001");
                if (LoginUtil.isDisconnectButHaveLogined()) {
                    NavigationUtils.toGalleryCombineActivity((Context)GalleryBigDetailFragment.this.getActivity(), GalleryBigDetailFragment.this.mPhotoInfo, GalleryBigDetailFragment.this.anchorId, GalleryBigDetailFragment.this.alumId);
                } else {
                    NavigationUtils.toLogin((Context)GalleryBigDetailFragment.this.getActivity(), true, false);
                }
            }
        });
    }

    @BusEvent
    public void onSubscribeResult(ISubscribeClient_onSubscribeResult_EventArgs eventArgs) {
        long anchorUid = eventArgs.getAnchorUid();
        boolean success = eventArgs.getSuccess();
        String errorMsg = eventArgs.getErrorMsg();
        this.onSubscribeResult(anchorUid, success, errorMsg);
    }

    public void onSubscribeResult(long anchorUid, boolean success, String errorMsg) {
        if (success) {
            if ((this.phototype == 103 || this.phototype == 101 || this.phototype == 102) && this.anchorId == anchorUid) {
                Toast.makeText((Context)this.getContext(), (CharSequence)this.getContext().getString(R.string.str_subscribe_succed), (int)0).show();
                this.mPhotoGuanzhued.setVisibility(0);
                this.mPhotoGunzhu.setVisibility(8);
                this.mGuanzhuImg.setVisibility(8);
            }
        } else if ((this.phototype == 103 || this.phototype == 101 || this.phototype == 102) && this.anchorId == anchorUid) {
            if (!StringUtils.isEmpty((String)errorMsg).booleanValue()) {
                this.toast(errorMsg);
            } else {
                Toast.makeText((Context)this.getContext(), (CharSequence)this.getContext().getString(R.string.str_subscribe_failed), (int)0).show();
            }
        }
    }

    @BusEvent
    public void onQueryBookAnchorBatchResult(IAttentionFriendClient_onQueryBookAnchorBatchResult_EventArgs busEventArgs) {
        long anchorUid = busEventArgs.getAnchorUid();
        Map friendList = busEventArgs.getFriendList();
        MLog.info((String)TAG, (String)("onQueryBookAnchorBatchResult anchorUid=" + anchorUid + ",friendList=" + friendList));
        if (anchorUid != LoginUtil.getUid()) {
            return;
        }
        if (friendList != null && friendList.size() > 0 && friendList.containsKey(anchorUid)) {
            if (((Boolean)friendList.get(anchorUid)).booleanValue()) {
                if ((this.phototype == 103 || this.phototype == 101 || this.phototype == 102) && anchorUid == this.anchorId) {
                    this.mPhotoGuanzhued.setVisibility(0);
                    this.mPhotoGunzhu.setVisibility(8);
                    this.mGuanzhuImg.setVisibility(8);
                }
            } else if ((this.phototype == 103 || this.phototype == 101 || this.phototype == 102) && anchorUid == this.anchorId) {
                this.mPhotoGuanzhued.setVisibility(8);
                this.mPhotoGunzhu.setVisibility(0);
                this.mGuanzhuImg.setVisibility(0);
            }
        }
    }

    @BusEvent
    public void onRequestProfile(IProfileClient_onRequestProfile_EventArgs busEventArgs) {
        EntUserInfo info = busEventArgs.getInfo();
        if (info == null) {
            return;
        }
        this.isAnchor = info.userType == 1;
    }

    public void onEventBind() {
        super.onEventBind();
        if (this.mEventBinder == null) {
            this.mEventBinder = new GalleryBigDetailFragment$$EventBinder();
        }
        this.mEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mEventBinder != null) {
            this.mEventBinder.unBindEvent();
        }
    }
}

