/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.gallery;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.plugin.homepage.ui.utils.dialog.IBaseDialog;
import com.yy.mobile.plugin.homepage.ui.utils.dialog.ProgressDialog;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.plugin.main.events.IGalleryClient_onCreateAlbum_EventArgs;
import com.yy.mobile.plugin.main.events.IGalleryClient_onQueryAlbumInfos_EventArgs;
import com.yy.mobile.ui.BaseDarkModeActivity;
import com.yy.mobile.ui.gallery.AlbumSelectActivity$$EventBinder;
import com.yy.mobile.ui.utils.dialog.InputDialog;
import com.yy.mobile.ui.utils.dialog.InputDialogListener;
import com.yy.mobile.ui.widget.SimpleTitleBar;
import com.yy.mobile.ui.widget.toast.Toast;
import com.yymobile.core.CoreManager;
import com.yymobile.core.gallery.IGalleryCore;
import com.yymobile.core.gallery.module.AlbumInfo;
import java.util.ArrayList;
import java.util.List;

public class AlbumSelectActivity
extends BaseDarkModeActivity
implements View.OnClickListener,
AdapterView.OnItemClickListener {
    private AlbumAdapter mAdapter;
    private long mAnchorId;
    private EventBinder mEventBinder;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.layout_album_select);
        this.initData();
        this.initLayout();
    }

    private void initData() {
        long anchorId = this.getIntent().getLongExtra("params_requested_anchor_id", 0L);
        this.mAdapter = new AlbumAdapter();
        this.mAnchorId = anchorId;
        ((IGalleryCore)CoreManager.getCore(IGalleryCore.class)).queryAlbumInfos(this.mAnchorId);
        this.getDialogLinkManager().showDialog((IBaseDialog)new ProgressDialog("\u8bf7\u7a0d\u5019", true, true, 0, null));
    }

    private void initLayout() {
        SimpleTitleBar titleBar = (SimpleTitleBar)this.findViewById(R.id.title_bar);
        titleBar.setTitlte(this.getResources().getString(R.string.str_select_gallery));
        TextView leftView = (TextView)this.getLayoutInflater().inflate(R.layout.layout_titlebar_right_text_extra, null);
        leftView.setId(R.id.tv_left_button);
        leftView.setOnClickListener((View.OnClickListener)this);
        leftView.setText((CharSequence)this.getString(R.string.str_upload_photo));
        titleBar.setLeftView((View)leftView);
        TextView rightView = (TextView)this.getLayoutInflater().inflate(R.layout.layout_titlebar_right_text_extra, null);
        rightView.setOnClickListener((View.OnClickListener)this);
        rightView.setText((CharSequence)this.getString(R.string.str_create_gallery));
        titleBar.setRightView((View)rightView);
        ListView listView = (ListView)this.findViewById(R.id.album_select_list);
        listView.setOnItemClickListener((AdapterView.OnItemClickListener)this);
        listView.setAdapter((ListAdapter)this.mAdapter);
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.tv_left_button) {
            this.setResult(0);
            this.finish();
        } else if (id2 == R.id.tv_right_button) {
            this.getDialogLinkManager().showDialog((IBaseDialog)new InputDialog(this.getContext(), (CharSequence)"\u65b0\u5efa\u76f8\u518c", (CharSequence)"\u4e3a\u65b0\u76f8\u518c\u8f93\u5165\u540d\u5b57", (CharSequence)"10\u4e2a\u5b57\u4ee5\u5185", null, null, true, true, true, new InputDialogListener(){

                public void cancel() {
                }

                public boolean confirm(String input) {
                    if (TextUtils.isEmpty((CharSequence)(input = input.trim()))) {
                        Toast.makeText((Context)AlbumSelectActivity.this.getContext(), (int)R.string.str_create_gallery_null, (int)0).show();
                        return false;
                    }
                    if (input.length() > 10) {
                        Toast.makeText((Context)AlbumSelectActivity.this.getContext(), (int)R.string.str_create_gallery_over_limit, (int)0).show();
                        return false;
                    }
                    ((IGalleryCore)CoreManager.getCore(IGalleryCore.class)).createAlbum(AlbumSelectActivity.this.mAnchorId, input, "", 2);
                    return true;
                }

                public void onExit() {
                }
            }, false));
        }
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        AlbumInfo albumInfo = (AlbumInfo)parent.getAdapter().getItem(position);
        Intent intent = new Intent();
        intent.putExtra("result_params_selected_album", albumInfo.albumId);
        this.setResult(-1, intent);
        this.finish();
    }

    @BusEvent(busType=1, busName="plugin_main")
    public void onCreateAlbum(IGalleryClient_onCreateAlbum_EventArgs busEventArgs) {
        boolean result = busEventArgs.getResult();
        String msg = busEventArgs.getMsg();
        AlbumInfo albumInfo = busEventArgs.getAlbumInfo();
        int identify = busEventArgs.getIdentify();
        if (result) {
            this.mAdapter.insertData(albumInfo);
            if (identify == 2) {
                Toast.makeText((Context)this, (int)R.string.str_create_gallery_success_tips, (int)0).show();
            }
        } else if (identify == 2) {
            String tips = this.getString(R.string.str_create_gallery_fail_tips);
            if (!TextUtils.isEmpty((CharSequence)msg)) {
                tips = tips + "\uff0c" + msg;
            }
            Toast.makeText((Context)this, (CharSequence)tips, (int)0).show();
        }
    }

    @BusEvent(busType=1, busName="plugin_main")
    public void onQueryAlbumInfos(IGalleryClient_onQueryAlbumInfos_EventArgs busEventArgs) {
        boolean result = busEventArgs.getResult();
        List albumInfos = busEventArgs.getAlbumInfos();
        this.getDialogLinkManager().dismissDialog();
        if (result && albumInfos != null && !albumInfos.isEmpty()) {
            this.mAdapter.setData(albumInfos);
        } else {
            this.mAdapter.setData(((IGalleryCore)CoreManager.getCore(IGalleryCore.class)).getAlbumInfos(this.mAnchorId));
        }
    }

    public void onEventBind() {
        super.onEventBind();
        if (this.mEventBinder == null) {
            this.mEventBinder = new AlbumSelectActivity$$EventBinder();
        }
        this.mEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mEventBinder != null) {
            this.mEventBinder.unBindEvent();
        }
    }

    private static class AlbumAdapter
    extends BaseAdapter {
        private ArrayList<AlbumInfo> mAlbumInfos = new ArrayList();

        private AlbumAdapter() {
        }

        public void setData(List<AlbumInfo> albumInfos) {
            this.mAlbumInfos.clear();
            if (albumInfos == null) {
                this.notifyDataSetChanged();
            } else {
                this.addData(albumInfos);
            }
        }

        public void addData(List<AlbumInfo> albumInfos) {
            if (albumInfos == null) {
                return;
            }
            this.mAlbumInfos.addAll(albumInfos);
            this.notifyDataSetChanged();
        }

        public void insertData(AlbumInfo albumInfo) {
            if (albumInfo == null) {
                return;
            }
            this.mAlbumInfos.add(0, albumInfo);
            this.notifyDataSetChanged();
        }

        public int getCount() {
            return this.mAlbumInfos.size();
        }

        public Object getItem(int position) {
            return this.mAlbumInfos.get(position);
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            ViewHolder viewHolder;
            if (convertView == null) {
                convertView = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.album_select_item, null);
                viewHolder = new ViewHolder();
                viewHolder.cover = (RecycleImageView)convertView.findViewById(R.id.album_select_item_cover);
                viewHolder.albumName = (TextView)convertView.findViewById(R.id.album_select_item_album_name);
                viewHolder.totalCount = (TextView)convertView.findViewById(R.id.album_select_item_album_total);
                convertView.setTag((Object)viewHolder);
            }
            viewHolder = (ViewHolder)convertView.getTag();
            AlbumInfo albumInfo = this.mAlbumInfos.get(position);
            if (albumInfo.cover == null) {
                viewHolder.cover.setImageResource(R.drawable.icon_no_photo);
            } else {
                ImageLoader.loadImage((String)albumInfo.cover.thumbsUrl, (RecycleImageView)viewHolder.cover, (ImageConfig)ImageConfig.smallImageConfig(), (int)R.drawable.icon_no_photo);
            }
            viewHolder.albumName.setText((CharSequence)albumInfo.albumName);
            viewHolder.totalCount.setText((CharSequence)String.format("%d\u5f20", albumInfo.totalNum));
            return convertView;
        }

        private static class ViewHolder {
            RecycleImageView cover;
            TextView albumName;
            TextView totalCount;

            private ViewHolder() {
            }
        }
    }
}

