/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.facevalue.dialog;

import android.app.Activity;
import android.app.Dialog;
import android.text.TextUtils;
import android.text.method.LinkMovementMethod;
import android.view.View;
import android.view.Window;
import android.widget.TextView;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.OnLifecycleEvent;
import com.yy.mobile.plugin.homeapi.R;
import com.yy.mobile.plugin.homepage.ui.utils.dialog.IBaseDialog;
import com.yy.mobile.plugin.homepage.ui.utils.dialog.OkCancelDialogListener;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.util.log.MLog;
import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Action;
import io.reactivex.functions.Consumer;
import java.util.concurrent.TimeUnit;

public class CountdownOkCancelDialog
implements IBaseDialog {
    protected CharSequence message;
    protected CharSequence okLabel;
    protected int okLabelColor = 0;
    protected CharSequence cancelLabel;
    protected int cancelLabelColor = 0;
    protected float lineSpacingExtra = -1.0f;
    protected float lineSpacingMultiplier = -1.0f;
    protected boolean cancelable;
    protected boolean outSideCancelable;
    protected boolean isNeedCenter = true;
    protected OkCancelDialogListener listener;
    private Disposable mCountDownDis;
    private static final String TAG = "CountdownOkCancelDialog";
    private TextView mOkTv;
    private int mTime = 0;

    public CountdownOkCancelDialog(CharSequence message, CharSequence okLabel, int okLabelColor, CharSequence cancelLabel, int cancelLabelColor, float lineSpacingExtra, float lineSpacingMultiplier, boolean cancelable, boolean outSideCancelable, boolean isNeedCenter, OkCancelDialogListener listener2, int time) {
        this.message = message;
        this.okLabel = okLabel;
        this.okLabelColor = okLabelColor;
        this.cancelLabel = cancelLabel;
        this.cancelLabelColor = cancelLabelColor;
        this.lineSpacingExtra = lineSpacingExtra;
        this.lineSpacingMultiplier = lineSpacingMultiplier;
        this.cancelable = cancelable;
        this.outSideCancelable = outSideCancelable;
        this.isNeedCenter = isNeedCenter;
        this.listener = listener2;
        this.mTime = time;
    }

    public CountdownOkCancelDialog(CharSequence message, CharSequence okLabel, int okLabelColor, CharSequence cancelLabel, int cancelLabelColor, boolean cancelable, boolean outSideCancelable, OkCancelDialogListener listener2, int time) {
        this(message, okLabel, okLabelColor, cancelLabel, cancelLabelColor, -1.0f, -1.0f, cancelable, outSideCancelable, true, listener2, time);
    }

    public CountdownOkCancelDialog(CharSequence message, CharSequence okLabel, int okLabelColor, CharSequence cancelLabel, int cancelLabelColor, boolean cancelable, boolean outSideCancelable, OkCancelDialogListener listener2) {
        this(message, okLabel, okLabelColor, cancelLabel, cancelLabelColor, -1.0f, -1.0f, cancelable, outSideCancelable, true, listener2, 0);
    }

    public CountdownOkCancelDialog(CharSequence message, CharSequence okLabel, CharSequence cancelLabel, float lineSpacingExtra, float lineSpacingMultiplier, boolean cancelable, boolean outSideCancelable, boolean isNeedCenter, OkCancelDialogListener listener2) {
        this(message, okLabel, 0, cancelLabel, 0, lineSpacingExtra, lineSpacingMultiplier, cancelable, outSideCancelable, isNeedCenter, listener2, 0);
    }

    public CountdownOkCancelDialog(CharSequence message, CharSequence okLabel, CharSequence cancelLabel, float lineSpacingExtra, float lineSpacingMultiplier, boolean cancelable, OkCancelDialogListener listener2) {
        this(message, okLabel, 0, cancelLabel, 0, lineSpacingExtra, lineSpacingMultiplier, cancelable, cancelable, true, listener2, 0);
    }

    public CountdownOkCancelDialog(CharSequence message, CharSequence okLabel, CharSequence cancelLabel, boolean cancelable, boolean outSideCancelable, OkCancelDialogListener listener2) {
        this(message, okLabel, 0, cancelLabel, 0, -1.0f, -1.0f, cancelable, outSideCancelable, true, listener2, 0);
    }

    public CountdownOkCancelDialog(CharSequence message, CharSequence okLabel, CharSequence cancelLabel, boolean cancelable, boolean outSideCancelable, boolean isNeedCenter, OkCancelDialogListener listener2) {
        this(message, okLabel, 0, cancelLabel, 0, -1.0f, -1.0f, cancelable, outSideCancelable, isNeedCenter, listener2, 0);
    }

    public CountdownOkCancelDialog(CharSequence message, CharSequence okLabel, CharSequence cancelLabel, boolean cancelable, OkCancelDialogListener listener2) {
        this(message, okLabel, 0, cancelLabel, 0, -1.0f, -1.0f, cancelable, cancelable, true, listener2, 0);
    }

    public CountdownOkCancelDialog(CharSequence message, CharSequence okLabel, CharSequence cancelLabel, OkCancelDialogListener listener2) {
        this(message, okLabel, 0, cancelLabel, 0, -1.0f, -1.0f, true, true, true, listener2, 0);
    }

    public CountdownOkCancelDialog(CharSequence message, boolean cancelable, OkCancelDialogListener listener2) {
        this(message, "\u786e\u5b9a", 0, "\u53d6\u6d88", 0, -1.0f, -1.0f, cancelable, cancelable, true, listener2, 0);
    }

    public void init(final Dialog dialog) {
        dialog.setCancelable(this.cancelable);
        dialog.setCanceledOnTouchOutside(this.outSideCancelable);
        Window window = dialog.getWindow();
        window.setContentView(this.getLayoutResId());
        TextView tip = (TextView)window.findViewById(R.id.message);
        tip.setMovementMethod(LinkMovementMethod.getInstance());
        tip.setHighlightColor(0);
        if (this.lineSpacingExtra != -1.0f && this.lineSpacingMultiplier != -1.0f) {
            tip.setLineSpacing(this.lineSpacingExtra, this.lineSpacingMultiplier);
        }
        if (!TextUtils.isEmpty((CharSequence)this.message)) {
            tip.setText(this.message);
        }
        if (this.isNeedCenter) {
            tip.setGravity(17);
        } else {
            tip.setGravity(19);
        }
        this.mOkTv = (TextView)window.findViewById(R.id.btn_ok);
        if (this.okLabelColor != 0) {
            this.mOkTv.setTextColor(this.okLabelColor);
        }
        if (!TextUtils.isEmpty((CharSequence)this.okLabel)) {
            this.mOkTv.setText(this.okLabel);
        }
        this.mOkTv.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CountdownOkCancelDialog.this.dispose();
                dialog.dismiss();
                if (CountdownOkCancelDialog.this.listener != null) {
                    CountdownOkCancelDialog.this.listener.onOk();
                }
            }
        });
        TextView cancel = (TextView)window.findViewById(R.id.btn_cancel);
        if (this.cancelLabelColor != 0) {
            cancel.setTextColor(this.cancelLabelColor);
        }
        if (!TextUtils.isEmpty((CharSequence)this.cancelLabel)) {
            cancel.setText(this.cancelLabel);
        }
        cancel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CountdownOkCancelDialog.this.dispose();
                dialog.dismiss();
                if (CountdownOkCancelDialog.this.listener != null) {
                    CountdownOkCancelDialog.this.listener.onCancel();
                }
            }
        });
        if (this.mTime > 0) {
            this.interval(this.mTime);
        }
    }

    public int getLayoutResId() {
        return R.layout.hp_layout_ok_cancel_color_link_dialog_newstyle;
    }

    private void dispose() {
        if (this.mCountDownDis != null) {
            this.mCountDownDis.dispose();
        }
    }

    private void interval(final int time) {
        this.dispose();
        this.mCountDownDis = Observable.interval((long)0L, (long)1L, (TimeUnit)TimeUnit.SECONDS).take((long)(time + 1)).observeOn(AndroidSchedulers.mainThread()).doOnComplete(new Action(){

            public void run() throws Exception {
                if (CountdownOkCancelDialog.this.mOkTv != null) {
                    CountdownOkCancelDialog.this.mOkTv.setText(CountdownOkCancelDialog.this.okLabel);
                    CountdownOkCancelDialog.this.listener.onOk();
                }
            }
        }).subscribe((Consumer)new Consumer<Long>(){

            public void accept(Long aLong) throws Exception {
                MLog.info((Object)CountdownOkCancelDialog.TAG, (String)"aLong:%s time:%s", (Object[])new Object[]{aLong, time});
                if (CountdownOkCancelDialog.this.mOkTv != null) {
                    CountdownOkCancelDialog.this.mOkTv.setText((CharSequence)(CountdownOkCancelDialog.this.okLabel + " " + ((long)time - aLong) + "s"));
                }
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable throwable) throws Exception {
                MLog.error((Object)CountdownOkCancelDialog.TAG, (Throwable)throwable);
            }
        });
        if (this.mOkTv != null && this.mOkTv.getContext() instanceof Activity) {
            this.bindLifecycle((Activity)this.mOkTv.getContext());
        }
    }

    private void bindLifecycle(Activity context) {
        MLog.info((String)TAG, (String)"bindLifecycle");
        if (null == context) {
            return;
        }
        if (context instanceof FragmentActivity) {
            ((FragmentActivity)context).getLifecycle().addObserver(new LifecycleObserver(){

                @OnLifecycleEvent(value=Lifecycle.Event.ON_DESTROY)
                private void onDestory() {
                    MLog.info((String)CountdownOkCancelDialog.TAG, (String)"bindLifecycle onDestory");
                    if (CountdownOkCancelDialog.this.mCountDownDis != null) {
                        CountdownOkCancelDialog.this.mCountDownDis.dispose();
                    }
                    CountdownOkCancelDialog.this.mCountDownDis = null;
                }
            });
        }
    }
}

