/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.community;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.mobile.RxBus;
import com.yy.mobile.perf.PerfSDK;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.plugin.main.events.IDiscoveryClient_onGetDiscoveryInfo_EventArgs;
import com.yy.mobile.small.SmallProxy;
import com.yy.mobile.statistic.StatisticService;
import com.yy.mobile.ui.BaseLinkFragment;
import com.yy.mobile.ui.community.DiscoveryAdapter;
import com.yy.mobile.ui.community.DiscoveryFragment$$EventBinder;
import com.yy.mobile.ui.widget.toast.Toast;
import com.yy.mobile.util.NetworkUtils;
import com.yy.mobile.util.RxUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.community.DiscoveryCoreImpl;
import com.yymobile.core.community.entity.Modules;
import com.yymobile.core.plugincenter.CommunityItemInfo;
import com.yymobile.core.statistic.CommunityPageLoadCostSampling;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.annotations.NonNull;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import java.util.ArrayList;
import java.util.List;

public class DiscoveryFragment
extends BaseLinkFragment {
    private static final String TAG = "DiscoveryFragment";
    public final boolean refresh = true;
    private List<Disposable> mDisposableList = new ArrayList<Disposable>();
    private View view;
    private ListView mListView;
    private DiscoveryAdapter mAdapter;
    private boolean mHasData;
    private EventBinder mEventBinder;

    public static DiscoveryFragment newInstance() {
        DiscoveryFragment fragment = new DiscoveryFragment();
        return fragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        ((CommunityPageLoadCostSampling)StatisticService.instance().get(CommunityPageLoadCostSampling.class)).begin();
        PerfSDK.instance().start(50021, "community_page_load_timecost");
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.view = inflater.inflate(R.layout.fragment_discovery, container, false);
        return this.view;
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.injectView();
        this.requestDisvoveryData();
        Disposable disposableItem = RxBus.getDefault().register(CommunityItemInfo.class).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<CommunityItemInfo>(){

            public void accept(@NonNull CommunityItemInfo communityItemInfo) throws Exception {
                DiscoveryFragment.this.addItem(communityItemInfo);
            }
        }, RxUtils.errorConsumer((String)TAG));
        this.mDisposableList.add(disposableItem);
    }

    public void injectView() {
        this.mListView = (ListView)this.view.findViewById(R.id.list_discovery);
        this.mAdapter = new DiscoveryAdapter((Context)this.getActivity());
        this.mListView.setAdapter((ListAdapter)this.mAdapter);
    }

    private void requestDisvoveryData() {
        MLog.info((String)TAG, (String)"dexian requestDisvoveryData start");
        DiscoveryCoreImpl.get().getDiscoveryInfo(true);
        this.showLoading();
    }

    public View.OnClickListener getLoadListener() {
        return new View.OnClickListener(){

            public void onClick(View v) {
                DiscoveryFragment.this.requestDisvoveryData();
            }
        };
    }

    @BusEvent(busType=1, busName="plugin_main")
    public void onGetDiscoveryInfo(IDiscoveryClient_onGetDiscoveryInfo_EventArgs busEventArgs) {
        int code = busEventArgs.getCode();
        List data = busEventArgs.getData();
        boolean refresh = busEventArgs.getRefresh();
        ((CommunityPageLoadCostSampling)StatisticService.instance().get(CommunityPageLoadCostSampling.class)).end();
        PerfSDK.instance().end(50021, "community_page_load_timecost");
        if (this.checkActivityValid() && code == 0 && data != null) {
            if (data != null && data.size() > 0 && this.mAdapter != null) {
                MLog.info((String)TAG, (String)("dexian, onGetDiscoveryInfo code = " + code + " data.size = " + (data != null ? Integer.valueOf(data.size()) : "0")));
                this.mAdapter.setDataSource(data, refresh);
                SmallProxy.startAction((Intent)new Intent("COMMUNITY_MENU_ADD"), (Activity)this.getActivity(), (ViewGroup)((ViewGroup)this.view));
            }
            if (!this.mHasData) {
                this.mHasData = true;
            }
            this.hideStatus();
        } else if (!this.mHasData) {
            if (!NetworkUtils.isNetworkStrictlyAvailable((Context)this.getContext())) {
                this.showNetworkErr();
            } else {
                this.showNoData(R.drawable.no_message_bg, R.string.str_no_data_mesaage);
            }
        } else if (!NetworkUtils.isNetworkStrictlyAvailable((Context)this.getContext())) {
            Toast.makeText((Context)this.getContext(), (CharSequence)this.getContext().getResources().getString(R.string.nonetwork), (int)0).show();
        }
    }

    public void onDestroyView() {
        for (Disposable d2 : this.mDisposableList) {
            d2.dispose();
        }
        super.onDestroyView();
    }

    public void addItem(CommunityItemInfo moduleInfo) {
        this.mAdapter.addData(new Modules(moduleInfo), moduleInfo.getPosition(), false);
    }

    public void onEventBind() {
        super.onEventBind();
        if (this.mEventBinder == null) {
            this.mEventBinder = new DiscoveryFragment$$EventBinder();
        }
        this.mEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mEventBinder != null) {
            this.mEventBinder.unBindEvent();
        }
    }
}

