/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.community;

import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import com.alibaba.android.arouter.launcher.ARouter;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.main.gamecenter.IGameCenterCore;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.ui.community.DiscoveryNewDotUtil;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.ObjectTimeslotTool;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.pref.CommonPref;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.community.entity.Modules;
import com.yymobile.core.statistic.IHiidoStatisticCore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class DiscoveryAdapter
extends BaseAdapter {
    public static final int HAS_NO_DATA = 0;
    public static final int HAS_DATA = 1;
    private static final String TAG = "DiscoveryAdapter";
    private static String DISCOVERY_FIRST_USE = "discovery_first_use";
    protected LayoutInflater mInflater;
    protected List<Modules> mDataSource = new ArrayList<Modules>();
    private Context mContext;
    private boolean discoveryFirstUse;
    private OnClickItemListener mOnClickItemListener;
    private ObjectTimeslotTool mTimeSlotTool = new ObjectTimeslotTool();

    public DiscoveryAdapter(Context context) {
        this.mContext = context;
        this.mInflater = LayoutInflater.from((Context)context);
        this.discoveryFirstUse = CommonPref.instance().getBoolean(DISCOVERY_FIRST_USE, true);
    }

    public void setDataSource(List<Modules> dataSource, boolean refresh) {
        if (this.mDataSource != null) {
            MLog.info((String)TAG, (String)(dataSource + " " + refresh));
            if (refresh) {
                this.mDataSource.clear();
            }
            if (this.discoveryFirstUse) {
                CommonPref.instance().putBoolean(DISCOVERY_FIRST_USE, false);
                for (int i = 0; i < dataSource.size(); ++i) {
                    DiscoveryNewDotUtil.saveLastTime("discovery_new_times", dataSource.get(i).getId(), dataSource.get(i).getRedNew());
                    DiscoveryNewDotUtil.saveLastTime("discovery_dot_times", dataSource.get(i).getId(), dataSource.get(i).getRedStar());
                }
                this.discoveryFirstUse = false;
            }
            this.mDataSource.addAll(dataSource);
            this.notifyDataSetChanged();
        }
    }

    public void addData(Modules data, int position, boolean clear) {
        if (data != null) {
            if (clear) {
                this.mDataSource.clear();
                this.mDataSource.add(data);
            } else {
                this.mDataSource.add(position, data);
            }
            this.notifyDataSetChanged();
        }
    }

    public int getCount() {
        return this.mDataSource != null ? this.mDataSource.size() : 0;
    }

    public Object getItem(int position) {
        return this.mDataSource != null ? this.mDataSource.get(position) : null;
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        switch (this.getItemViewType(position)) {
            case 1: {
                convertView = this.getTypeOneView(convertView, position);
                break;
            }
            case 0: {
                convertView = this.getTypeTwoView(convertView, position);
                break;
            }
        }
        return convertView;
    }

    private View getTypeOneView(View convertView, final int position) {
        ViewHolder viewHolder = null;
        if (convertView == null) {
            viewHolder = new ViewHolder();
            convertView = this.mInflater.inflate(R.layout.discovery_item_layout, null);
            viewHolder.item = convertView.findViewById(R.id.discovery_item);
            viewHolder.image = (RecycleImageView)convertView.findViewById(R.id.discovery_item_icon);
            viewHolder.title = (TextView)convertView.findViewById(R.id.discovery_item_title);
            viewHolder.logo = (ImageView)convertView.findViewById(R.id.discovery_item_dot);
            viewHolder.desc = (TextView)convertView.findViewById(R.id.discovery_desc);
            viewHolder.lineHalf = convertView.findViewById(R.id.disconvery_half_line);
            viewHolder.line = convertView.findViewById(R.id.disconvery_line);
            convertView.setTag((Object)viewHolder);
        } else {
            viewHolder = (ViewHolder)convertView.getTag();
        }
        final Modules modules = (Modules)this.getItem(position);
        final ViewHolder finalViewHolder = viewHolder;
        viewHolder.item.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (DiscoveryAdapter.this.mTimeSlotTool.isProcessing()) {
                    return;
                }
                MLog.info((String)DiscoveryAdapter.TAG, (String)("onClick " + modules));
                if (modules.getId() == 9) {
                    if (CoreFactory.getCore(IGameCenterCore.class) != null) {
                        ((IGameCenterCore)CoreFactory.getCore(IGameCenterCore.class)).startPlugin(DiscoveryAdapter.this.mContext);
                    }
                } else if (modules.getId() == 19 || modules.getId() == 20) {
                    Uri uri;
                    List segments;
                    String strUrl = modules.getActionUrl();
                    if (strUrl != null && (segments = (uri = Uri.parse((String)strUrl)).getPathSegments()).size() >= 4) {
                        String subTitle = modules.getSubTitle();
                        String url = String.valueOf(segments.get(3));
                        if (CoreFactory.getCore(IGameCenterCore.class) != null) {
                            ((IGameCenterCore)CoreFactory.getCore(IGameCenterCore.class)).startPlugin(DiscoveryAdapter.this.mContext, subTitle, url);
                        }
                    }
                } else if (modules.getActionUrl().contains("/VoiceRoom/Home")) {
                    if (DiscoveryAdapter.this.mOnClickItemListener != null) {
                        DiscoveryAdapter.this.mOnClickItemListener.onClickItem(position, modules);
                    }
                } else {
                    ARouter.getInstance().build(Uri.parse((String)modules.getActionUrl())).navigation(DiscoveryAdapter.this.mContext);
                }
                DiscoveryNewDotUtil.saveLastTime("discovery_new_times", modules.getId(), modules.getRedNew());
                DiscoveryNewDotUtil.saveLastTime("discovery_dot_times", modules.getId(), modules.getRedStar());
                finalViewHolder.logo.setVisibility(8);
                DiscoveryAdapter.this.sendEventStatistic(modules);
            }
        });
        if (!TextUtils.isEmpty((CharSequence)modules.getThumb())) {
            ImageLoader.loadImage((String)modules.getThumb(), (RecycleImageView)viewHolder.image, (ImageConfig)ImageConfig.smallImageConfig(), (int)R.drawable.disconvery_default);
        } else {
            viewHolder.image.setImageResource(R.drawable.disconvery_default);
        }
        if (!FP.empty((CharSequence)modules.getName())) {
            viewHolder.title.setText((CharSequence)modules.getName());
        } else {
            viewHolder.title.setText((CharSequence)"");
        }
        if (!FP.empty((CharSequence)modules.getSubTitle())) {
            viewHolder.desc.setVisibility(0);
            viewHolder.desc.setText((CharSequence)modules.getSubTitle());
        } else {
            viewHolder.desc.setVisibility(8);
        }
        switch (modules.getLineType()) {
            case 17: {
                viewHolder.line.setVisibility(0);
                viewHolder.lineHalf.setVisibility(8);
                break;
            }
            case 16: {
                viewHolder.line.setVisibility(8);
                viewHolder.lineHalf.setVisibility(0);
                break;
            }
            case 18: {
                viewHolder.line.setVisibility(8);
                viewHolder.lineHalf.setVisibility(8);
                break;
            }
        }
        if (DiscoveryNewDotUtil.getLastTime("discovery_new_times", modules.getId()) < modules.getRedNew()) {
            viewHolder.logo.setVisibility(0);
            viewHolder.logo.setImageResource(R.drawable.discovery_new_icon);
        } else if (DiscoveryNewDotUtil.getLastTime("discovery_dot_times", modules.getId()) < modules.getRedStar()) {
            viewHolder.logo.setVisibility(0);
            viewHolder.logo.setImageResource(R.drawable.discovery_red_dot);
        } else {
            viewHolder.logo.setVisibility(8);
        }
        return convertView;
    }

    private View getTypeTwoView(View convertView, int position) {
        ViewHolder viewHolder = null;
        if (convertView == null) {
            viewHolder = new ViewHolder();
            convertView = this.mInflater.inflate(R.layout.discovery_empty_item_layout, null);
            viewHolder.item = convertView.findViewById(R.id.discovery_item);
            convertView.setTag((Object)viewHolder);
        } else {
            viewHolder = (ViewHolder)convertView.getTag();
        }
        return convertView;
    }

    public void sendEventStatistic(Modules modules) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("key1", String.valueOf(modules.getId()));
        ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "52902", "0001", map);
    }

    public int getItemViewType(int position) {
        switch (((Modules)this.getItem(position)).getType()) {
            case 1: {
                return 1;
            }
            case 0: {
                return 0;
            }
        }
        return -1;
    }

    public int getViewTypeCount() {
        return 2;
    }

    public void setOnClickListener(OnClickItemListener onClickListener) {
        this.mOnClickItemListener = onClickListener;
    }

    public static interface OnClickItemListener {
        public void onClickItem(int var1, Modules var2);
    }

    private static class ViewHolder {
        View item;
        RecycleImageView image;
        TextView title;
        ImageView logo;
        TextView desc;
        View lineHalf;
        View line;

        private ViewHolder() {
        }
    }
}

