/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.common;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.facade.annotation.RouteDoc;
import com.yy.immersion.ImmersionBar;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.file.FileRequest;
import com.yy.mobile.file.FileRequestException;
import com.yy.mobile.file.FileRequestManager;
import com.yy.mobile.file.FileResponseErrorListener;
import com.yy.mobile.file.FileResponseListener;
import com.yy.mobile.file.data.DefaultFileDataParam;
import com.yy.mobile.file.data.FileDataParam;
import com.yy.mobile.file.data.FilePutResult;
import com.yy.mobile.file.data.SavePhotoWithUrlRequest;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.ui.BaseActivity;
import com.yy.mobile.ui.utils.FixRootViewUtil;
import com.yy.mobile.ui.widget.SimpleTitleBar;
import com.yy.mobile.ui.widget.photoView.PhotoView;
import com.yy.mobile.ui.widget.photoView.PhotoViewAttacher;
import com.yy.mobile.ui.widget.toast.Toast;
import com.yy.mobile.util.InspectViewUtil;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.YYSchedulers;
import com.yy.mobile.util.log.MLog;
import java.io.File;

@Route(path="/common/PhotoDisplayActivity", name="\u56fe\u7247\u5c55\u793a")
@RouteDoc(desc="\u67e5\u770b\u5927\u56fe", minVer="7.16", eg="yymobile://common/PhotoDisplayActivity")
public class PhotoDisplayActivity
extends BaseActivity {
    private static final String TAG = "PhotoDisplayActivity";
    public static final String PHOTO_URL = "photoUrl";
    public static final String PHOTO_DEFAULT_DRAWABLE_ID = "DEFAULT_ID";
    public static final String LOG_TAG = "PhotoDisplayActivity";
    private String mPhotoUrl;
    private SimpleTitleBar mTitleBar;
    private PhotoView mPhoto;
    private FrameLayout mContainer;
    private boolean isVisible;
    private Bitmap mBitmap;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.layout_photo_display);
        FixRootViewUtil.setContentView((Activity)this, (int)R.layout.layout_photo_display, (boolean)true);
        InspectViewUtil.INSTANCE.printViewLog(this.getWindow().peekDecorView(), "PhotoDisplay");
        this.mPhoto = (PhotoView)this.findViewById(R.id.photo_container);
        this.mTitleBar = (SimpleTitleBar)this.findViewById(R.id.title_bar);
        this.mContainer = (FrameLayout)this.findViewById(R.id.photo_display);
        this.isVisible = false;
        this.mPhotoUrl = this.getIntent().getStringExtra(PHOTO_URL);
        this.mTitleBar.setBottomLineVisibility(false);
        int defaultDrawableId = this.getIntent().getIntExtra(PHOTO_DEFAULT_DRAWABLE_ID, -1);
        if (TextUtils.isEmpty((CharSequence)this.mPhotoUrl)) {
            if (defaultDrawableId != -1) {
                this.mPhoto.setImageDrawable(this.getResources().getDrawable(defaultDrawableId));
                MLog.debug((String)"PhotoDisplayActivity", (String)"use default drawable");
            }
        } else if (!ImageLoader.isGif((String)this.mPhotoUrl)) {
            this.loadImage();
        } else {
            ImageLoader.loadImage((RecycleImageView)this.mPhoto, (String)this.mPhotoUrl, (int)R.drawable.hp_living_default_bg);
        }
        this.initListener();
    }

    public void initView() {
        int screenWidth = ResolutionUtils.getScreenWidth((Context)this);
        int screenHeight = ResolutionUtils.getScreenHeight((Context)this);
        int w = this.mBitmap.getWidth();
        int h = this.mBitmap.getHeight();
        if (w < screenWidth / 2 && h < screenHeight / 2) {
            this.mPhoto.setScaleType(ImageView.ScaleType.CENTER);
            this.mPhoto.setMaximumScale(this.mPhoto.getMaximumScale() + 2.0f);
            this.mPhoto.setMediumScale(this.mPhoto.getMediumScale() + 2.0f);
        }
    }

    public void loadImage() {
        ImageLoader.loadImage((RecycleImageView)this.mPhoto, (String)this.mPhotoUrl, (int)R.drawable.hp_living_default_bg);
    }

    public void initListener() {
        final Runnable downloadPicTask = new Runnable(){

            @Override
            public void run() {
                File dirFile = new File(BasicConfig.getInstance().getRootDir().getAbsolutePath() + "/saved/");
                if (!dirFile.exists()) {
                    if (dirFile.mkdirs()) {
                        this.save(dirFile);
                    }
                } else {
                    this.save(dirFile);
                }
            }

            private void save(File dirFile) {
                try {
                    String surfix = "";
                    surfix = ImageLoader.isGif((String)PhotoDisplayActivity.this.mPhotoUrl) ? ".gif" : (ImageLoader.isJpg((String)PhotoDisplayActivity.this.mPhotoUrl) ? ".jpg" : ".png");
                    String photoFileName = System.currentTimeMillis() + surfix;
                    final File destFile = new File(dirFile, photoFileName);
                    if (destFile.exists()) {
                        destFile.delete();
                    }
                    destFile.createNewFile();
                    DefaultFileDataParam param = new DefaultFileDataParam("yymobile" + File.separator + "saved", photoFileName);
                    try {
                        MySavePhotoWithUrlRequest request2 = new MySavePhotoWithUrlRequest((Context)PhotoDisplayActivity.this, (FileDataParam)param, PhotoDisplayActivity.this.mPhotoUrl, destFile);
                        request2.setSuccessListener((FileResponseListener)new FileResponseListener<FilePutResult>((FileRequest)request2){
                            final /* synthetic */ FileRequest val$request;
                            {
                                this.val$request = fileRequest;
                            }

                            public void onResponse(FilePutResult response) {
                                MLog.info((String)"PhotoDisplayActivity", (String)("DownloadPicTask destFile=" + destFile.getAbsolutePath()));
                                Toast.makeText((Context)PhotoDisplayActivity.this, (int)R.string.save_photo_success, (int)1).show();
                                this.val$request.finish("");
                            }
                        });
                        request2.setErrorListener(new FileResponseErrorListener((FileRequest)request2){
                            final /* synthetic */ FileRequest val$request;
                            {
                                this.val$request = fileRequest;
                            }

                            public void onErrorResponse(FileRequestException error) {
                                Toast.makeText((Context)PhotoDisplayActivity.this, (CharSequence)"\u4fdd\u5b58\u5931\u8d25!", (int)0).show();
                                MLog.error((String)"PhotoDisplayActivity", (String)("save pic error:" + error.getMessage()));
                                this.val$request.finish("");
                            }
                        });
                        FileRequestManager.instance().submitFileRequest((FileRequest)request2);
                    }
                    catch (FileRequestException e) {
                        MLog.error((Object)"PhotoDisplayActivity", (String)"Save photo error.", (Throwable)e, (Object[])new Object[0]);
                    }
                }
                catch (Exception e) {
                    Toast.makeText((Context)PhotoDisplayActivity.this, (CharSequence)"\u4fdd\u5b58\u5931\u8d25!", (int)0).show();
                    MLog.error((String)"PhotoDisplayActivity", (String)("save pic error:" + e.getMessage()));
                }
            }
        };
        this.mTitleBar.setLeftBtn(R.drawable.shortvideo_back_normal_selector, new View.OnClickListener(){

            public void onClick(View v) {
                PhotoDisplayActivity.this.finish();
            }
        });
        this.mTitleBar.setRightBtn(R.drawable.xiazaitupian_icon, new View.OnClickListener(){

            public void onClick(View view) {
                YYSchedulers.io.scheduleDirect(downloadPicTask);
            }
        });
        this.mPhoto.setOnPhotoTapListener(new PhotoViewAttacher.OnPhotoTapListener(){

            public void onPhotoTap(View view, float x, float y) {
                if (PhotoDisplayActivity.this.mPhoto.getScale() == 1.0f) {
                    PhotoDisplayActivity.this.finish();
                }
            }
        });
    }

    protected boolean handleStatusBar() {
        this.immersionBar = ImmersionBar.with((Activity)this).fitsSystemWindows(true).statusBarColor(17170444).statusBarDarkFont(false);
        this.immersionBar.init();
        return true;
    }

    public static class MySavePhotoWithUrlRequest
    extends SavePhotoWithUrlRequest {
        private File mDestFile;

        public MySavePhotoWithUrlRequest(Context context, FileDataParam config, String url, File destFile) throws FileRequestException {
            super(context, config, url);
            this.mDestFile = destFile;
        }

        public File getDataFile(String name) throws FileRequestException {
            return this.mDestFile;
        }
    }
}

