/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.common;

import android.app.Activity;
import android.graphics.Color;
import android.os.Bundle;
import android.view.View;
import android.widget.TextView;
import androidx.fragment.app.Fragment;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.ui.BaseActivity;
import com.yy.mobile.ui.gallery.GalleryImageDetailFragment;
import com.yy.mobile.ui.gallery.ImagePagerFragment;
import com.yy.mobile.ui.utils.FixRootViewUtil;
import com.yy.mobile.ui.widget.SimpleTitleBar;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.InspectViewUtil;
import com.yy.mobile.util.log.MLog;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONObject;

public class MultiPhotoDisplayActivity
extends BaseActivity {
    private static final String TAG = "MultiPhotoDisplayActivity";
    public static final String LOG_TAG = "MultiPhotoDisplayActivity";
    private String mPhotoUrl;
    private TextView indicator;
    private SimpleTitleBar mTitleBar;
    ImagePagerFragment mImagePagerFragment;
    private ArrayList<String> allUrl = new ArrayList();
    public static final String EXTRA_JSON_STR = "img_json_str";
    private int showIndex = 0;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.layout_multi_photo_display);
        FixRootViewUtil.setContentView((Activity)this, (int)R.layout.layout_multi_photo_display, (boolean)true);
        InspectViewUtil.INSTANCE.printViewLog(this.getWindow().peekDecorView(), "MultiPhotoDisplay");
        this.initData();
        this.initView();
        this.initListener();
        this.initPager(this.allUrl, this.showIndex);
    }

    private void initData() {
        try {
            String jsonStr = this.getIntent().getStringExtra(EXTRA_JSON_STR);
            if (!FP.empty((CharSequence)jsonStr)) {
                JSONObject jsonObject = new JSONObject(jsonStr);
                this.showIndex = jsonObject.optInt("defaultIndex");
                if (this.showIndex < 0) {
                    this.showIndex = 0;
                }
                JSONArray jsonArray = jsonObject.getJSONArray("photos");
                this.allUrl.clear();
                for (int i = 0; i < jsonArray.length(); ++i) {
                    this.allUrl.add(jsonArray.getJSONObject(i).optString("imgUrl"));
                }
            }
        }
        catch (Throwable e) {
            MLog.error((String)"MultiPhotoDisplayActivity", (String)("[MultiPhotoDisplayActivity].e=" + e));
        }
    }

    private void initView() {
        this.mTitleBar = (SimpleTitleBar)this.findViewById(R.id.title_bar);
    }

    private void initListener() {
        this.mTitleBar.setLeftBtn(R.drawable.icon_back_white, new View.OnClickListener(){

            public void onClick(View v) {
                MultiPhotoDisplayActivity.this.finish();
            }
        });
    }

    private void initPager(ArrayList<String> list, int position) {
        this.mImagePagerFragment = ImagePagerFragment.newInstance(list, (int)position);
        this.mImagePagerFragment.setImageClickListener(new GalleryImageDetailFragment.OnImageClickListener(){

            public void onImageClick() {
                MultiPhotoDisplayActivity.this.finish();
            }

            public void onImageLongClick() {
            }
        });
        this.getSupportFragmentManager().beginTransaction().replace(R.id.pager, (Fragment)this.mImagePagerFragment).commitAllowingStateLoss();
        this.initReult();
    }

    private void initReult() {
        this.mImagePagerFragment.setOnImageChangeListener(new ImagePagerFragment.OnImageChangeListener(){

            public void onImageChange(int currentPosition, int totalCount, String currentUrl) {
                if (MultiPhotoDisplayActivity.this.allUrl != null && MultiPhotoDisplayActivity.this.allUrl.size() > 0) {
                    String text = MultiPhotoDisplayActivity.this.getString(R.string.viewpager_indicator, new Object[]{currentPosition + 1, totalCount});
                    MultiPhotoDisplayActivity.this.indicator = MultiPhotoDisplayActivity.this.mTitleBar.setViewTitle(text.toString());
                    MultiPhotoDisplayActivity.this.indicator.setText((CharSequence)text);
                    MultiPhotoDisplayActivity.this.indicator.setTextColor(Color.parseColor((String)"#ffffff"));
                    if (currentPosition >= MultiPhotoDisplayActivity.this.allUrl.size()) {
                        currentPosition = MultiPhotoDisplayActivity.this.allUrl.size() - 1;
                    }
                    MultiPhotoDisplayActivity.this.mPhotoUrl = (String)MultiPhotoDisplayActivity.this.allUrl.get(currentPosition);
                }
            }

            public void onNextRequest() {
            }

            public void onPrevRequest() {
            }
        });
    }
}

