/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.cityselect.view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.TextView;
import com.yy.mobile.plugin.main.R;
import java.util.Arrays;
import java.util.List;

public class SideLetterBar
extends View {
    private static final String[] b = new String[]{"\u2605", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
    private int choose = -1;
    private Paint paint = new Paint();
    private boolean showBg = false;
    private OnLetterChangedListener onLetterChangedListener;
    private TextView overlay;
    private Context context;
    private int textColor = Color.parseColor((String)"#fac200");
    private int touchTextColor = Color.parseColor((String)"#FAD500");
    private List<String> indicators = Arrays.asList(b);

    public SideLetterBar(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.context = context;
    }

    public SideLetterBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.context = context;
    }

    public SideLetterBar(Context context) {
        super(context);
        this.context = context;
    }

    public void setTextColor(int textColor, int touch) {
        this.textColor = textColor;
        this.touchTextColor = touch;
    }

    public void setIndicators(List<String> indicators) {
        this.indicators = indicators;
        this.invalidate();
    }

    public void setOverlay(TextView overlay) {
        this.overlay = overlay;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.showBg) {
            canvas.drawColor(0);
        }
        int height = this.getHeight();
        int width = this.getWidth();
        int singleHeight = height / this.indicators.size();
        for (int i = 0; i < this.indicators.size(); ++i) {
            this.paint.setTextSize(this.getResources().getDimension(R.dimen.side_letter_bar_letter_size));
            this.paint.setColor(this.textColor);
            this.paint.setAntiAlias(true);
            if (i == this.choose) {
                this.paint.setColor(this.touchTextColor);
                this.paint.setFakeBoldText(true);
            }
            float xPos = (float)(width / 2) - this.paint.measureText(this.indicators.get(i)) / 2.0f;
            float yPos = singleHeight * i + singleHeight;
            canvas.drawText(this.indicators.get(i), xPos, yPos, this.paint);
            this.paint.reset();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = this.context.getResources().getDimensionPixelSize(R.dimen.width);
        int height = this.context.getResources().getDimensionPixelSize(R.dimen.height);
        this.setMeasuredDimension(width, height);
    }

    public boolean dispatchTouchEvent(MotionEvent event) {
        int action = event.getAction();
        float y = event.getY();
        int oldChoose = this.choose;
        OnLetterChangedListener listener2 = this.onLetterChangedListener;
        int c = (int)(y / (float)this.getHeight() * (float)this.indicators.size());
        switch (action) {
            case 0: {
                this.showBg = true;
                if (oldChoose == c || listener2 == null || c < 0 || c >= this.indicators.size()) break;
                listener2.onLetterChanged(this.indicators.get(c));
                this.choose = c;
                this.invalidate();
                if (this.overlay == null) break;
                this.overlay.setVisibility(0);
                this.overlay.setText((CharSequence)this.indicators.get(c));
                break;
            }
            case 2: {
                if (oldChoose == c || listener2 == null || c < 0 || c >= this.indicators.size()) break;
                listener2.onLetterChanged(this.indicators.get(c));
                this.choose = c;
                this.invalidate();
                if (this.overlay == null) break;
                this.overlay.setVisibility(0);
                this.overlay.setText((CharSequence)this.indicators.get(c));
                break;
            }
            case 1: {
                this.showBg = false;
                this.choose = -1;
                this.invalidate();
                if (this.overlay == null) break;
                this.overlay.setVisibility(8);
                break;
            }
        }
        return true;
    }

    public void setOnLetterChangedListener(OnLetterChangedListener onLetterChangedListener) {
        this.onLetterChangedListener = onLetterChangedListener;
    }

    public static interface OnLetterChangedListener {
        public void onLetterChanged(String var1);
    }
}

