/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.cityselect.db;

import com.yy.mobile.http.RequestError;
import com.yy.mobile.http.RequestManager;
import com.yy.mobile.http.RequestParam;
import com.yy.mobile.http.ResponseErrorListener;
import com.yy.mobile.http.ResponseListener;
import com.yy.mobile.ui.cityselect.bean.City;
import com.yy.mobile.ui.cityselect.bean.CityListEntity;
import com.yy.mobile.util.json.JsonParser;
import com.yymobile.core.UrlSettings;
import com.yymobile.core.utils.CommonParamUtil;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.functions.Function;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.json.JSONObject;

public class CityDataManager {
    public static Observable<CityListEntity> getAllCities() {
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<String>(){

            public void subscribe(final ObservableEmitter<String> e) throws Exception {
                String url = UrlSettings.LOLLIPOP_MOBILE_LIVE + "/switchLocate/list";
                RequestParam params = CommonParamUtil.fillCommonParam();
                RequestManager.instance().submitStringQueryRequest(url, params, (ResponseListener)new ResponseListener<String>(){

                    public void onResponse(String response) {
                        e.onNext((Object)response);
                    }
                }, new ResponseErrorListener(){

                    public void onErrorResponse(RequestError error) {
                        e.onError((Throwable)error);
                    }
                });
            }
        }).map((Function)new Function<String, CityListEntity>(){

            public CityListEntity apply(String s) throws Exception {
                JSONObject json = new JSONObject(s);
                int code = json.optInt("code");
                if (code != 0) {
                    throw new IllegalArgumentException(json.getString("message"));
                }
                JSONObject data = json.optJSONObject("data");
                if (data == null) {
                    throw new IllegalArgumentException(json.getString("message"));
                }
                CityListEntity entity = (CityListEntity)JsonParser.parseJsonObject((String)data.toString(), CityListEntity.class);
                if (entity.hot != null && entity.hot.size() > 9) {
                    entity.hot = entity.hot.subList(0, 9);
                }
                Collections.sort(entity.all, new CityComparator());
                return entity;
            }
        });
    }

    public List<City> searchCity(String keyword) {
        ArrayList<City> result = new ArrayList<City>();
        Collections.sort(result, new CityComparator());
        return result;
    }

    private static class CityComparator
    implements Comparator<City> {
        private CityComparator() {
        }

        @Override
        public int compare(City lhs, City rhs) {
            String a = lhs.getPinyin().substring(0, 1);
            String b = rhs.getPinyin().substring(0, 1);
            return a.compareTo(b);
        }
    }
}

