/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.cityselect.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.ui.cityselect.bean.City;
import com.yy.mobile.ui.cityselect.helper.OnCityClickListener;
import java.util.ArrayList;
import java.util.List;

class HotCityAdapter
extends RecyclerView.Adapter<HotCityViewHolder> {
    private Context mContext;
    private List<City> mCities;
    private LayoutInflater mInflater;
    private OnCityClickListener mOnCityClickListener;

    HotCityAdapter(Context context) {
        this.mContext = context;
        this.mCities = new ArrayList<City>();
        this.mInflater = LayoutInflater.from((Context)this.mContext);
    }

    public void setOnCityClickListener(OnCityClickListener onCityClickListener) {
        this.mOnCityClickListener = onCityClickListener;
    }

    public void setCities(List<City> cities) {
        this.mCities = cities;
        this.notifyDataSetChanged();
    }

    public HotCityViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        return new HotCityViewHolder(this.mInflater.inflate(R.layout.item_hot_city_gridview_new, parent, false));
    }

    public void onBindViewHolder(HotCityViewHolder holder, final int position) {
        holder.mTvHotCityName.setText((CharSequence)this.mCities.get(position).getName());
        holder.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (HotCityAdapter.this.mOnCityClickListener != null) {
                    HotCityAdapter.this.mOnCityClickListener.onCityClick((City)HotCityAdapter.this.mCities.get(position));
                }
            }
        });
    }

    public int getItemCount() {
        return this.mCities.size();
    }

    static class HotCityViewHolder
    extends RecyclerView.ViewHolder {
        TextView mTvHotCityName;

        HotCityViewHolder(View itemView) {
            super(itemView);
            this.mTvHotCityName = (TextView)itemView.findViewById(R.id.tv_hot_city_name);
        }
    }
}

