/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.cityselect.adapter;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.ui.cityselect.adapter.HotCityAdapter;
import com.yy.mobile.ui.cityselect.bean.City;
import com.yy.mobile.ui.cityselect.helper.OnCityClickListener;
import com.yy.mobile.ui.cityselect.helper.PinyinUtils;
import com.yy.mobile.ylink.bridge.CoreApiManager;
import com.yy.mobile.ylink.bridge.coreapi.LocationApi;
import com.yymobile.core.foundation.LocationCache;
import com.yymobile.core.social.NearCoreImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CityShowAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private static final int VIEW_TYPE_FIRST = 111;
    private static final int VIEW_TYPE_SECOND = 222;
    private static final int VIEW_TYPE_THREAD = 333;
    private Context mContext;
    private LayoutInflater mInflater;
    private List<City> mCities;
    private List<City> mHotCities;
    private List<String> mLetterIndicators;
    private Map<City, Integer> mViewTypeMap;
    private HashMap<String, Integer> mLetter2PosIndexes;
    private OnCityClickListener mOnCityClickListener;

    public CityShowAdapter(Context context, @NonNull List<City> cities, List<City> hotCities) {
        this.mContext = context;
        this.mCities = cities;
        this.mInflater = LayoutInflater.from((Context)this.mContext);
        this.mViewTypeMap = new HashMap<City, Integer>();
        this.mLetter2PosIndexes = new HashMap();
        this.mLetterIndicators = new ArrayList<String>();
        for (int i = 0; i < this.mCities.size(); ++i) {
            String previousLetter;
            City city = this.mCities.get(i);
            this.mViewTypeMap.put(city, 333);
            String currentLetter = PinyinUtils.getFirstLetter(city.getPinyin());
            String string2 = previousLetter = i >= 1 ? PinyinUtils.getFirstLetter(this.mCities.get(i - 1).getPinyin()) : "";
            if (TextUtils.equals((CharSequence)currentLetter, (CharSequence)previousLetter)) continue;
            this.mLetter2PosIndexes.put(currentLetter, i);
            this.mLetterIndicators.add(currentLetter);
        }
        this.addLocateCity();
        this.addHotCities(hotCities);
    }

    private void addLocateCity() {
        City obj = new City("\u5b9a\u4f4d", "0", "0");
        this.mViewTypeMap.put(obj, 111);
        this.mCities.add(0, obj);
    }

    private void addHotCities(List<City> hotCities) {
        this.mHotCities = hotCities;
        if (hotCities != null && !hotCities.isEmpty()) {
            City object = new City("\u70ed\u95e8", "1", "1");
            this.mCities.add(1, object);
            this.mViewTypeMap.put(object, 222);
            this.mLetter2PosIndexes.put("\u2605", 1);
            this.mLetterIndicators.add(0, "\u2605");
        }
    }

    public List<String> getLetterIndicators() {
        return this.mLetterIndicators;
    }

    public int getLetterPosition(String letter) {
        Integer integer = this.mLetter2PosIndexes.get(letter);
        return integer == null ? -1 : integer;
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (viewType == 111) {
            View view = this.mInflater.inflate(R.layout.view_locate_city_new, parent, false);
            return new LocateCityHolder(view);
        }
        if (viewType == 222) {
            View view = this.mInflater.inflate(R.layout.view_hot_city_new, parent, false);
            return new HotCityHolder(view);
        }
        View view = this.mInflater.inflate(R.layout.item_city_listview_new, parent, false);
        return new CityShowHolder(view);
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        if (111 == this.getItemViewType(position)) {
            String location = NearCoreImpl.get().getHomeLiveNearBySelectedLocationName();
            if (TextUtils.isEmpty((CharSequence)location)) {
                LocationCache cacheBDLocation = ((LocationApi)CoreApiManager.getInstance().getApi(LocationApi.class)).getPersistCacheLocation();
                if (location == null) {
                    location = cacheBDLocation.city;
                }
            }
            if (!TextUtils.isEmpty((CharSequence)location)) {
                ((LocateCityHolder)holder).mCityName.setText((CharSequence)location);
            }
        } else if (222 == this.getItemViewType(position)) {
            HotCityAdapter adapter = new HotCityAdapter(this.mContext);
            adapter.setCities(this.mHotCities);
            ((HotCityHolder)holder).mGridviewHotCity.setLayoutManager((RecyclerView.LayoutManager)new GridLayoutManager(this.mContext, 3));
            ((HotCityHolder)holder).mGridviewHotCity.setAdapter((RecyclerView.Adapter)adapter);
            ((HotCityHolder)holder).mGridviewHotCity.setNestedScrollingEnabled(false);
            adapter.setOnCityClickListener(this.mOnCityClickListener);
        } else if (position >= 1) {
            String previousLetter;
            final City city = this.mCities.get(position);
            ((CityShowHolder)holder).mTvItemCityListviewName.setText((CharSequence)city.getName());
            String currentLetter = PinyinUtils.getFirstLetter(city.getPinyin());
            String string2 = previousLetter = position >= 1 ? PinyinUtils.getFirstLetter(this.mCities.get(position - 1).getPinyin()) : "";
            if (!TextUtils.equals((CharSequence)currentLetter, (CharSequence)previousLetter)) {
                ((CityShowHolder)holder).mTvItemCityListviewLetter.setVisibility(0);
                ((CityShowHolder)holder).mTvItemCityListviewLetter.setText((CharSequence)currentLetter);
            } else {
                ((CityShowHolder)holder).mTvItemCityListviewLetter.setVisibility(8);
            }
            ((CityShowHolder)holder).mTvItemCityListviewName.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (CityShowAdapter.this.mOnCityClickListener != null) {
                        CityShowAdapter.this.mOnCityClickListener.onCityClick(city);
                    }
                }
            });
        }
    }

    public int getItemViewType(int position) {
        return this.mViewTypeMap.get(this.mCities.get(position));
    }

    public int getItemCount() {
        return this.mCities.size();
    }

    public void setOnCityClickListener(OnCityClickListener onCityClickListener) {
        this.mOnCityClickListener = onCityClickListener;
    }

    static class CityShowHolder
    extends RecyclerView.ViewHolder {
        TextView mTvItemCityListviewLetter;
        TextView mTvItemCityListviewName;

        CityShowHolder(View itemView) {
            super(itemView);
            this.mTvItemCityListviewName = (TextView)itemView.findViewById(R.id.tv_item_city_listview_name);
            this.mTvItemCityListviewLetter = (TextView)itemView.findViewById(R.id.tv_item_city_listview_letter);
        }
    }

    static class HotCityHolder
    extends RecyclerView.ViewHolder {
        RecyclerView mGridviewHotCity;

        HotCityHolder(View itemView) {
            super(itemView);
            this.mGridviewHotCity = (RecyclerView)itemView.findViewById(R.id.gridview_hot_city);
        }
    }

    static class LocateCityHolder
    extends RecyclerView.ViewHolder {
        TextView mCityName;

        LocateCityHolder(View itemView) {
            super(itemView);
            this.mCityName = (TextView)itemView.findViewById(R.id.city_name);
        }
    }
}

