/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.cityselect;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.widget.TextView;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.hiidostatis.defs.obj.Property;
import com.yy.mobile.RxBus;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.plugin.main.R;
import com.yy.mobile.ui.BaseDarkModeActivity;
import com.yy.mobile.ui.cityselect.ChangeHomeNearByCityEvent;
import com.yy.mobile.ui.cityselect.adapter.CityShowAdapter;
import com.yy.mobile.ui.cityselect.bean.City;
import com.yy.mobile.ui.cityselect.bean.CityListEntity;
import com.yy.mobile.ui.cityselect.db.CityDataManager;
import com.yy.mobile.ui.cityselect.helper.OnCityClickListener;
import com.yy.mobile.ui.cityselect.view.SideLetterBar;
import com.yy.mobile.ui.widget.SimpleTitleBar;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.social.NearCoreImpl;
import com.yymobile.core.statistic.IHiidoStatisticCore;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.functions.Consumer;
import io.reactivex.schedulers.Schedulers;
import java.io.Serializable;

public class CitySelectActivity
extends BaseDarkModeActivity {
    private static final String TAG = "CitySelectActivity";
    private CityListEntity mCityListEntity;
    private CityDataManager mCityDataManager;
    private CityShowAdapter mCityShowAdapter;
    private RecyclerView mRecyclerAllCity;
    private TextView mTvLetterOverlay;
    private SideLetterBar mSideLetterBar;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_city_list);
        this.requestData();
        this.initView();
    }

    private void initView() {
        SimpleTitleBar mTitleBar = (SimpleTitleBar)this.findViewById(R.id.title_bar);
        mTitleBar.setTitlte("\u5207\u6362\u57ce\u5e02");
        mTitleBar.setLeftBtn(R.drawable.icon_nav_back, new View.OnClickListener(){

            public void onClick(View v) {
                CitySelectActivity.this.finish();
            }
        });
        this.mRecyclerAllCity = (RecyclerView)this.findViewById(R.id.recycler_all_city);
        this.mTvLetterOverlay = (TextView)this.findViewById(R.id.tv_letter_overlay);
        this.mSideLetterBar = (SideLetterBar)this.findViewById(R.id.side_letter_bar);
        this.mRecyclerAllCity.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this));
        this.mSideLetterBar.setOverlay(this.mTvLetterOverlay);
        this.mSideLetterBar.setOnLetterChangedListener(new SideLetterBar.OnLetterChangedListener(){

            @Override
            public void onLetterChanged(String letter) {
                if (CitySelectActivity.this.mCityShowAdapter == null) {
                    return;
                }
                int position = CitySelectActivity.this.mCityShowAdapter.getLetterPosition(letter);
                LinearLayoutManager llm = (LinearLayoutManager)CitySelectActivity.this.mRecyclerAllCity.getLayoutManager();
                llm.scrollToPositionWithOffset(position, 0);
            }
        });
    }

    private void requestData() {
        this.showLoading();
        this.mCityDataManager = new CityDataManager();
        CitySelectActivity citySelectActivity = this;
        citySelectActivity.mCityDataManager.getAllCities().subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<CityListEntity>(){

            public void accept(CityListEntity cityListEntity) throws Exception {
                CitySelectActivity.this.mCityListEntity = cityListEntity;
                CitySelectActivity.this.initWithData();
                CitySelectActivity.this.hideStatus();
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable throwable) throws Exception {
                CitySelectActivity.this.showNetworkErr();
                MLog.error((Object)"CitySelect", (Throwable)throwable);
            }
        });
    }

    private void initWithData() {
        this.mCityShowAdapter = new CityShowAdapter((Context)this, this.mCityListEntity.all, this.mCityListEntity.hot);
        this.mCityShowAdapter.setOnCityClickListener(new OnCityClickListener(){

            @Override
            public void onCityClick(City city) {
                Property property = new Property();
                property.putString("key1", city.code);
                ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "50013", "0004", (Serializable)property);
                if (TextUtils.isEmpty((CharSequence)city.getCode())) {
                    CitySelectActivity.this.finish();
                    return;
                }
                NearCoreImpl.get().setHomeLiveNearBySelectedLocation(city.getCode(), city.getName());
                ChangeHomeNearByCityEvent e = new ChangeHomeNearByCityEvent();
                e.desCity = city;
                RxBus.getDefault().post((Object)e);
                CitySelectActivity.this.finish();
            }
        });
        this.mRecyclerAllCity.setAdapter((RecyclerView.Adapter)this.mCityShowAdapter);
        this.mSideLetterBar.setIndicators(this.mCityShowAdapter.getLetterIndicators());
    }
}

