/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.activity;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EmptyEventCompat;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.plugin.homepage.ui.utils.dialog.IBaseDialog;
import com.yy.mobile.plugin.homepage.ui.utils.dialog.OkCancelDialog;
import com.yy.mobile.plugin.homepage.ui.utils.dialog.OkCancelDialogListener;
import com.yy.mobile.plugin.main.events.INotifyClient_onNotify_EventArgs;
import com.yy.mobile.ui.BaseActivity;
import com.yy.mobile.ui.activity.NotifyBroadcastReceiver$$EventBinder;
import com.yy.mobile.ui.dialog.DialogLinkManager;
import com.yy.mobile.ui.notify.NotifyInfo;
import com.yy.mobile.ui.utils.NavigationUtils;
import com.yy.mobile.ui.utils.SingleToastUtil;
import com.yy.mobile.util.NetworkUtils;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.activity.ActLifecycleCallbacksEx;
import com.yy.mobile.util.activity.YYActivityLifeCallbackWrapper;
import com.yy.mobile.util.activity.YYActivityManager;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.ylink.bridge.CoreApiManager;
import com.yy.mobile.ylink.bridge.coreapi.BaseFragmentApi;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.mobilelive.IMobileLiveCore;

public class NotifyBroadcastReceiver
extends EmptyEventCompat {
    private static final String TAG = "GlobalActivityManager";
    private Handler mMainHandler;
    private Runnable mDismissDialogTask;
    private boolean mIsResumed = false;
    private static NotifyBroadcastReceiver mInstance = new NotifyBroadcastReceiver();
    private long mPreviewId;
    private EventBinder mEventBinder;

    private NotifyBroadcastReceiver() {
        this.onEventBind();
    }

    public static NotifyBroadcastReceiver getInstance() {
        return mInstance;
    }

    public void init(Application application) {
        YYActivityLifeCallbackWrapper.INSTANCE.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new ActLifecycleCallbacksEx(){

            public void onActivityCreatedEx(Activity activity2, Bundle savedInstanceState) {
                NotifyBroadcastReceiver.this.setCurrentActivity(activity2);
            }

            public void onActivityStartedEx(Activity activity2) {
            }

            public void onActivityResumedEx(Activity activity2) {
                NotifyBroadcastReceiver.this.setCurrentActivity(activity2);
                NotifyBroadcastReceiver.this.mIsResumed = true;
            }

            public void onActivityPausedEx(Activity activity2) {
                if (NotifyBroadcastReceiver.this.isCurrentActivity(activity2)) {
                    NotifyBroadcastReceiver.this.mIsResumed = false;
                }
            }

            public void onActivityStoppedEx(Activity activity2) {
            }

            public void onActivitySaveInstanceStateEx(Activity activity2, Bundle outState) {
            }

            public void onActivityDestroyedEx(Activity activity2) {
                if (NotifyBroadcastReceiver.this.isCurrentActivity(activity2)) {
                    NotifyBroadcastReceiver.this.setCurrentActivity(null);
                }
            }
        });
        if (YYActivityManager.INSTANCE.getCurrentActivity() != null) {
            this.mIsResumed = true;
        }
    }

    @BusEvent
    public void onNotify(INotifyClient_onNotify_EventArgs busEventArgs) {
        NotifyInfo info = busEventArgs.getInfo();
        this.onNotify(info);
    }

    private void onNotify(NotifyInfo info) {
        if (info.type == 1 && info.skiptype == 8 && this.isResumed()) {
            try {
                int index = info.skiplink.lastIndexOf("/");
                String previewID = info.skiplink.substring(index + 1);
                this.handlerMobileLive(StringUtils.safeParseLong((String)previewID));
                MLog.info((String)TAG, (String)("onNotify/ start previewID=" + previewID));
            }
            catch (Exception ex) {
                MLog.error((Object)TAG, (Throwable)ex);
            }
        }
        if (info.type == 0) {
            MLog.info((String)"YYPushTest", (String)("photourl:" + info.photourl + " anchornick:" + info.anchornick));
        }
    }

    private synchronized void handlerMobileLive(final long previewId) {
        this.mPreviewId = previewId;
        MLog.info((String)TAG, (String)("handlerMobileLive/ previewId= " + previewId));
        if (NotifyBroadcastReceiver.getCurrentActivity() instanceof BaseActivity) {
            final DialogLinkManager dialogLinkManager = ((BaseActivity)NotifyBroadcastReceiver.getCurrentActivity()).getDialogLinkManager();
            this.removeDismissDialogCall();
            this.mDismissDialogTask = new Runnable(){

                @Override
                public void run() {
                    if (NotifyBroadcastReceiver.this.checkActivityValid() && NotifyBroadcastReceiver.this.isResumed()) {
                        dialogLinkManager.dismissDialog();
                    }
                    SingleToastUtil.showToast((String)"\u5df2\u9ed8\u8ba4\u653e\u5f03\u9884\u544a\u5f00\u64ad");
                    MLog.info((String)NotifyBroadcastReceiver.TAG, (String)("removeDismissDialogCall.timeout.mPreviewId=" + NotifyBroadcastReceiver.this.mPreviewId));
                    ((IMobileLiveCore)CoreFactory.getCore(IMobileLiveCore.class)).anchorAbandonPredict(NotifyBroadcastReceiver.this.mPreviewId);
                }
            };
            dialogLinkManager.showDialog((IBaseDialog)new OkCancelDialog((CharSequence)"\u60a8\u7684\u9884\u5f00\u64ad\u65f6\u95f4\u5df2\u5230\uff0c\u662f\u5426\u73b0\u5728\u5f00\u64ad\uff1f", (CharSequence)"\u73b0\u5728\u5f00\u64ad", (CharSequence)"\u653e\u5f03\u9884\u544a", false, new OkCancelDialogListener(){

                public void onCancel() {
                    NotifyBroadcastReceiver.this.removeDismissDialogCall();
                    dialogLinkManager.dismissDialog();
                    ((IMobileLiveCore)CoreFactory.getCore(IMobileLiveCore.class)).anchorAbandonPredict(previewId);
                }

                public void onOk() {
                    NotifyBroadcastReceiver.this.removeDismissDialogCall();
                    dialogLinkManager.dismissDialog();
                    if (!NotifyBroadcastReceiver.this.checkNetToast()) {
                        return;
                    }
                    if (!LoginUtil.isLogined()) {
                        NotifyBroadcastReceiver.this.showLoginDialog();
                    } else {
                        NavigationUtils.toCameraPerviewActivity((Context)NotifyBroadcastReceiver.getCurrentActivity());
                    }
                }
            }));
            this.getHandler().postDelayed(this.mDismissDialogTask, 60000L);
        }
    }

    private boolean checkNetToast() {
        boolean flag = NetworkUtils.isNetworkStrictlyAvailable((Context)NotifyBroadcastReceiver.getCurrentActivity());
        if (!flag) {
            SingleToastUtil.showToast((Context)NotifyBroadcastReceiver.getCurrentActivity(), (String)"\u7f51\u7edc\u4e0d\u7ed9\u529b");
        }
        return flag;
    }

    private void removeDismissDialogCall() {
        if (this.mDismissDialogTask != null) {
            MLog.info((Object)TAG, (String)"removeDismissDialogCall: %s", (Object[])new Object[]{this.mDismissDialogTask});
            this.getHandler().removeCallbacks(this.mDismissDialogTask);
            this.mDismissDialogTask = null;
        }
    }

    private Handler getHandler() {
        if (this.mMainHandler == null) {
            this.mMainHandler = new Handler(Looper.getMainLooper());
        }
        return this.mMainHandler;
    }

    private boolean isCurrentActivity(Activity activity2) {
        return activity2 == NotifyBroadcastReceiver.getCurrentActivity();
    }

    private void setCurrentActivity(Activity activity2) {
        if (!this.isCurrentActivity(activity2)) {
            this.release();
        }
    }

    private void release() {
        MLog.info((Object)TAG, (String)"release, activity: %s", (Object[])new Object[]{NotifyBroadcastReceiver.getCurrentActivity()});
        this.removeDismissDialogCall();
    }

    public void showLoginDialog() {
        if (this.checkActivityValid()) {
            ((BaseFragmentApi)CoreApiManager.getInstance().getApi(BaseFragmentApi.class)).showLoginDialog(NotifyBroadcastReceiver.getCurrentActivity());
        }
    }

    private static Activity getCurrentActivity() {
        return YYActivityManager.INSTANCE.getCurrentActivity();
    }

    @TargetApi(value=17)
    private boolean checkActivityValid() {
        if (NotifyBroadcastReceiver.getCurrentActivity().isFinishing()) {
            return false;
        }
        return Build.VERSION.SDK_INT < 17 || !NotifyBroadcastReceiver.getCurrentActivity().isDestroyed();
    }

    private boolean isResumed() {
        return this.mIsResumed;
    }

    public void onEventBind() {
        super.onEventBind();
        if (this.mEventBinder == null) {
            this.mEventBinder = new NotifyBroadcastReceiver$$EventBinder();
        }
        this.mEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mEventBinder != null) {
            this.mEventBinder.unBindEvent();
        }
    }
}

