/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.activity;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.fragment.app.DialogFragment;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import com.alibaba.android.arouter.launcher.ARouter;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EmptyEventCompat;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.mobile.plugin.main.events.ICameraClient_alertCameraUploadMsg_EventArgs;
import com.yy.mobile.plugin.main.events.IMobileLiveClient_onDismissWebDialog_EventArgs;
import com.yy.mobile.plugin.main.events.IMobileLiveClient_onShowWebDialog_EventArgs;
import com.yy.mobile.plugin.main.events.IPushClient_onHandlePush_EventArgs;
import com.yy.mobile.plugin.main.events.IUpdateVersionClient_onUpdateVersionActive_EventArgs;
import com.yy.mobile.ui.BaseActivity;
import com.yy.mobile.ui.activity.LoginBroadcastReceiver$$EventBinder;
import com.yy.mobile.ui.dialog.AnswerCardDialogComponent;
import com.yy.mobile.ui.dialog.DialogLinkManager;
import com.yy.mobile.ui.notify.NotifyInfo;
import com.yy.mobile.ui.utils.NavigationUtils;
import com.yy.mobile.ui.utils.SingleToastUtil;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.activity.ActLifecycleCallbacksEx;
import com.yy.mobile.util.activity.YYActivityLifeCallbackWrapper;
import com.yy.mobile.util.activity.YYActivityManager;
import com.yy.mobile.util.log.MLog;

public class LoginBroadcastReceiver
extends EmptyEventCompat {
    private static final String TAG = "LoginBroadcastReceiver";
    private static LoginBroadcastReceiver mInstance = new LoginBroadcastReceiver();
    private boolean mIsResumed = false;
    private EventBinder mEventBinder;

    private LoginBroadcastReceiver() {
        this.onEventBind();
    }

    public static LoginBroadcastReceiver getInstance() {
        return mInstance;
    }

    public void init(Application application) {
        YYActivityLifeCallbackWrapper.INSTANCE.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new ActLifecycleCallbacksEx(){

            public void onActivityCreatedEx(Activity activity2, Bundle savedInstanceState) {
            }

            public void onActivityStartedEx(Activity activity2) {
            }

            public void onActivityResumedEx(Activity activity2) {
                LoginBroadcastReceiver.this.mIsResumed = true;
            }

            public void onActivityPausedEx(Activity activity2) {
                if (LoginBroadcastReceiver.this.isCurrentActivity(activity2)) {
                    LoginBroadcastReceiver.this.mIsResumed = false;
                }
            }

            public void onActivityStoppedEx(Activity activity2) {
            }

            public void onActivitySaveInstanceStateEx(Activity activity2, Bundle outState) {
            }

            public void onActivityDestroyedEx(Activity activity2) {
            }
        });
        if (YYActivityManager.INSTANCE.getCurrentActivity() != null) {
            this.mIsResumed = true;
        }
    }

    @BusEvent(busType=1, busName="plugin_main")
    public void onUpdateVersionActive(IUpdateVersionClient_onUpdateVersionActive_EventArgs busEventArgs) {
        Activity activity2;
        int result = busEventArgs.getResult();
        String currentVersion = busEventArgs.getCurrentVersion();
        boolean needUpdate = busEventArgs.getNeedUpdate();
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((String)TAG, (String)("onUpdateVersionActive-result " + result + " ---- currentVersion - " + currentVersion + " needUpdate----- " + needUpdate));
        }
        Activity activity3 = activity2 = LoginBroadcastReceiver.getCurrentActivity() != null ? LoginBroadcastReceiver.getCurrentActivity() : YYActivityManager.INSTANCE.getMainActivity();
        if (needUpdate && activity2 != null) {
            NavigationUtils.toMainUpdate(activity2, true);
        }
    }

    @BusEvent(busType=1, busName="plugin_main")
    public void onHandlePush(IPushClient_onHandlePush_EventArgs busEventArgs) {
        Intent intent = busEventArgs.getIntent();
        this.onHandlePush(intent);
    }

    private void onHandlePush(Intent intent) {
        Bundle extras;
        Activity mActivity = LoginBroadcastReceiver.getCurrentActivity();
        if (this.isResumed() && (extras = intent.getExtras()) != null) {
            NotifyInfo info = (NotifyInfo)extras.get("info");
            MLog.info((String)"YYPushTest", (String)("info:" + info));
            if (info != null) {
                MLog.info((String)"YYPushTest", (String)(FP.empty((CharSequence)info.action) ? info.skiplink : info.action));
                Boolean jumpMain = Boolean.TRUE;
                ARouter.getInstance().build(Uri.parse((String)(FP.empty((CharSequence)info.action) || !info.action.startsWith("yymobile://") ? info.skiplink : info.action))).navigation((Context)mActivity);
            }
        }
    }

    public void dismissDialog() {
        DialogLinkManager dialogLinkManager = this.getDialogLinkManager();
        boolean isActivityValid = LoginBroadcastReceiver.checkActivityValid();
        MLog.info((Object)TAG, (String)"dismissDialog, isActivityValid: %b, isResumed: %b, activity: %s, dialogManager: %s", (Object[])new Object[]{isActivityValid, this.isResumed(), LoginBroadcastReceiver.getCurrentActivity(), dialogLinkManager});
        if (dialogLinkManager != null && isActivityValid && this.isResumed()) {
            dialogLinkManager.dismissDialog();
        }
    }

    @BusEvent
    public void onDismissWebDialog(IMobileLiveClient_onDismissWebDialog_EventArgs eventArgs) {
        this.dismissWebDialog();
    }

    @BusEvent
    public void alertCameraUploadMsg(ICameraClient_alertCameraUploadMsg_EventArgs busEventArgs) {
        String msg = busEventArgs.getMsg();
        if (!TextUtils.isEmpty((CharSequence)msg)) {
            SingleToastUtil.showToast((String)msg);
        }
    }

    @BusEvent
    public void onShowWebDialog(IMobileLiveClient_onShowWebDialog_EventArgs eventArgs) {
        String url = eventArgs.getUrl();
        int width = eventArgs.getWidth();
        int height = eventArgs.getHeight();
        int lWidth = eventArgs.getLWidth();
        int lHeight = eventArgs.getLHeight();
        if (LoginBroadcastReceiver.getCurrentActivity().getResources().getConfiguration().orientation == 2) {
            this.showWebDialog(url, lWidth, lHeight);
        } else {
            this.showWebDialog(url, width, height);
        }
    }

    private static Activity getCurrentActivity() {
        return YYActivityManager.INSTANCE.getCurrentActivity();
    }

    private Context getContext() {
        return LoginBroadcastReceiver.getCurrentActivity();
    }

    private DialogLinkManager getDialogLinkManager() {
        if (LoginBroadcastReceiver.getCurrentActivity() instanceof BaseActivity) {
            return ((BaseActivity)LoginBroadcastReceiver.getCurrentActivity()).getDialogLinkManager();
        }
        MLog.error((Object)TAG, (String)"activity does not implement IDialogBaseActivity: %s", (Object[])new Object[]{LoginBroadcastReceiver.getCurrentActivity()});
        return null;
    }

    public void showWebDialog(String url, int width, int height) {
        if (LoginBroadcastReceiver.getCurrentActivity() instanceof FragmentActivity) {
            AnswerCardDialogComponent cardDialogComponent = AnswerCardDialogComponent.newInstance(url, width, height);
            cardDialogComponent.show(((FragmentActivity)LoginBroadcastReceiver.getCurrentActivity()).getSupportFragmentManager(), "show_web_dialog");
        }
    }

    public void dismissWebDialog() {
        Fragment dialogFragment;
        if (LoginBroadcastReceiver.getCurrentActivity() instanceof FragmentActivity && (dialogFragment = ((FragmentActivity)LoginBroadcastReceiver.getCurrentActivity()).getSupportFragmentManager().findFragmentByTag("show_web_dialog")) != null && dialogFragment instanceof DialogFragment) {
            ((DialogFragment)dialogFragment).dismissAllowingStateLoss();
        }
    }

    private boolean isCurrentActivity(Activity activity2) {
        return activity2 == LoginBroadcastReceiver.getCurrentActivity();
    }

    private boolean isResumed() {
        return this.mIsResumed;
    }

    @TargetApi(value=17)
    private static boolean checkActivityValid() {
        if (LoginBroadcastReceiver.getCurrentActivity().isFinishing()) {
            return false;
        }
        return Build.VERSION.SDK_INT < 17 || !LoginBroadcastReceiver.getCurrentActivity().isDestroyed();
    }

    public void onEventBind() {
        super.onEventBind();
        if (this.mEventBinder == null) {
            this.mEventBinder = new LoginBroadcastReceiver$$EventBinder();
        }
        this.mEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mEventBinder != null) {
            this.mEventBinder.unBindEvent();
        }
    }
}

