/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.task;

import android.annotation.SuppressLint;
import android.app.Application;
import android.net.Uri;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Log;
import android.util.SparseArray;
import androidx.annotation.NonNull;
import com.duowan.mobile.main.kinds.Kinds;
import com.example.configcenter.ILog;
import com.example.configcenter.Publess;
import com.yy.mobile.RxBus;
import com.yy.mobile.abtest.ABTestConfigInitializer;
import com.yy.mobile.abtest.wxchannel.WXChannelABtest;
import com.yy.mobile.baseapi.event.EntLiveGetCoreEvent;
import com.yy.mobile.baseapi.event.StartUpFinishEvent;
import com.yy.mobile.baseapi.model.store.StartUpState;
import com.yy.mobile.baseapi.model.store.YYState;
import com.yy.mobile.baseapi.model.store.YYStore;
import com.yy.mobile.baseapi.model.store.action.YYState_StartUpStateAction;
import com.yy.mobile.bizmodel.login.ILoginCore;
import com.yy.mobile.bizmodel.login.LoginType;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.common.YYThreadTracer;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.config.NetCollectionSamlingRatePubless;
import com.yy.mobile.config.NetPerformanceCollectionJava;
import com.yy.mobile.config.WebPConfigData;
import com.yy.mobile.file.FileRequestManager;
import com.yy.mobile.guid.GuidFactory;
import com.yy.mobile.http.MonitorEventListenerFactoryKt;
import com.yy.mobile.http.Request;
import com.yy.mobile.http.RequestError;
import com.yy.mobile.http.RequestManager;
import com.yy.mobile.http.ResponseErrorListener;
import com.yy.mobile.http.ResponseListener;
import com.yy.mobile.http.StringQueryRequest;
import com.yy.mobile.main.client.ICrashDeversityCore;
import com.yy.mobile.main.fbstetho.IStethoAction;
import com.yy.mobile.main.yycommand.IYYCommandAction;
import com.yy.mobile.model.Action;
import com.yy.mobile.model.Processor;
import com.yy.mobile.model.middleware.AddDataModuleApiMethodMiddleware;
import com.yy.mobile.model.middleware.AddUiModuleApiMethodMiddleware;
import com.yy.mobile.model.middleware.UpdatePresenceMiddleware;
import com.yy.mobile.model.store.HostStore;
import com.yy.mobile.plugin.SmallInitializer;
import com.yy.mobile.plugin.main.PluginBus;
import com.yy.mobile.pref2.SharedPreferencesUtils;
import com.yy.mobile.rapidboot.RapidBoot;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audio.AudioMutexManager;
import com.yy.mobile.task.LazyRun;
import com.yy.mobile.task.StepMsgDef;
import com.yy.mobile.ui.activity.GlobalActivityManager;
import com.yy.mobile.ui.activity.LoginBroadcastReceiver;
import com.yy.mobile.ui.activity.NotifyBroadcastReceiver;
import com.yy.mobile.ui.activityentrance.abtest.ActivityEntranceShowTimeABTest;
import com.yy.mobile.ui.activityentrance.config.ScrollIntervalConfigData;
import com.yy.mobile.ui.home.dummymsg.DummyMsgTriggerProcessor;
import com.yy.mobile.ui.messagenotifycenter.MessageNotifyMgr;
import com.yy.mobile.ui.officialactivity.OfficialActivityMsgManager;
import com.yy.mobile.ui.setting.FeatureManager;
import com.yy.mobile.ui.utils.rest.AggregationPageApiList;
import com.yy.mobile.ui.utils.rest.AnchorGalleryApiList;
import com.yy.mobile.ui.utils.rest.CommonApiList;
import com.yy.mobile.ui.utils.rest.DiamondApiList;
import com.yy.mobile.ui.utils.rest.ImApiList;
import com.yy.mobile.ui.utils.rest.LiveCenterApiList;
import com.yy.mobile.ui.utils.rest.LivePreviewApiList;
import com.yy.mobile.ui.utils.rest.LivingApiList;
import com.yy.mobile.ui.utils.rest.LoginApiList;
import com.yy.mobile.ui.utils.rest.MessageCenterApiList;
import com.yy.mobile.ui.utils.rest.PersonalCenterApiList;
import com.yy.mobile.ui.utils.rest.PopwebApiList;
import com.yy.mobile.ui.utils.rest.ToastApiList;
import com.yy.mobile.ui.utils.rest.UnicomWspxApiList;
import com.yy.mobile.ui.utils.rest.UserInfoApiList;
import com.yy.mobile.ui.utils.rest.VoiceRoomApiList;
import com.yy.mobile.ui.utils.rest.WebCtrlApiList;
import com.yy.mobile.ui.utils.rest.base.INavRestCore;
import com.yy.mobile.ui.utils.rest.base.IRestApiList;
import com.yy.mobile.ui.webviewutil.WebConfig;
import com.yy.mobile.ui.ylink.YLink;
import com.yy.mobile.util.RxUtils;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.pref.CommonPref;
import com.yy.mobile.util.taskexecutor.YYTaskExecutor;
import com.yy.mobile.webp.BS2CovertManager;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.CoreManager;
import com.yymobile.core.Env;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.config.model.PublessCore;
import com.yymobile.core.config.model.PublessLog;
import com.yymobile.core.dynamicload.datacollecter.DownloadCenterHelper;
import com.yymobile.core.forebackground.ISdkBackgroundCore;
import com.yymobile.core.foundation.IDnsHookConfigCore;
import com.yymobile.core.foundation.IHttpDnsConfigCore;
import com.yymobile.core.foundation.IOKHttpConfigCore;
import com.yymobile.core.notificationbar.INotifyBarCore;
import com.yymobile.core.performancemonitor.PerformanceMonitorSwitchController;
import com.yymobile.core.performancemonitor.StartUpStatHelper;
import com.yymobile.core.resources.YYResourcesConfigData;
import com.yymobile.core.resources.YYResourcesManagerImpl;
import com.yymobile.core.updateversion.IUpdateVersionCore;
import com.yymobile.core.user.UserInfo;
import downloader.DownloadClient;
import downloader.client.IBasicParamsProvider;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import io.reactivex.schedulers.Schedulers;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReference;

public class StartupManager {
    public static final String TAG = "StartupManager";
    public static boolean DEBUG = BasicConfig.getInstance().isDebuggable();
    private static volatile StartupManager sInstance;
    private static volatile SparseArray<Step> mStepPool;
    private static long sStartupComsumeTime;
    private AtomicReference<Boolean> startRef = new AtomicReference<Boolean>(false);

    private StartupManager() {
        if (mStepPool.size() > 0) {
            return;
        }
        RapidBoot.sTicker.start("StartupManager#init");
        mStepPool.clear();
        mStepPool.put(StepMsgDef.MSG_STEP_INIT_CRASH_SDK, (Object)new StepInitCrashSdk());
        mStepPool.put(StepMsgDef.MSG_STEP_INIT_PUBLESS, (Object)new StepInitPubless());
        mStepPool.put(StepMsgDef.MSG_STEP_INIT_IMAGE_AND_REQUEST_MANAGER, (Object)new StepInitImageAndRequestManager());
        mStepPool.put(StepMsgDef.MSG_STEP_SMALL_INIT_SETUPSMALL, (Object)new StepSmallInitializerSetup());
        mStepPool.put(StepMsgDef.MSG_STEP_REQUEST_BASE_DATA, (Object)new StepRequestBaseData());
        mStepPool.put(StepMsgDef.MSG_STEP_YLINK_INIT, (Object)new StepYLinkInit());
        mStepPool.put(StepMsgDef.MSG_STEP_COREMANAGER_INIT, (Object)new StepCoreManagerInit());
        mStepPool.put(StepMsgDef.MSG_STEP_NAV_REST, (Object)new StepNavRest());
        mStepPool.put(StepMsgDef.MSG_STEP_GLOBAL_ACTIVITY_MANAGER, (Object)new StepGlobalActivityManager());
        mStepPool.put(StepMsgDef.MSG_STEP_DBMANAGER_INIT, (Object)new StepDbManagerInit());
        mStepPool.put(StepMsgDef.MSG_STEP_COREMANAGER_POST_INIT, (Object)new StepCoreManagerDelayInit());
        mStepPool.put(StepMsgDef.MSG_STEP_REPORT_UNCATCH_CRASH, (Object)new ReportUnCatchCrash());
        mStepPool.put(StepMsgDef.MSG_STEP_WEB_REDIRECT_CONFIG, (Object)new WebRedirectConfigQuery());
        mStepPool.put(StepMsgDef.MSG_STEP_HOST_STORE_INIT, (Object)new StepHostStoreInit());
        mStepPool.put(StepMsgDef.MSG_STEP_ABTEST_CONFIG_UPDATE, (Object)new ABTestUpdateConfig());
        mStepPool.put(StepMsgDef.MSG_STEP_YCLOUD_INIT_PUBLESS_CONFIG, (Object)new StepYCloudInitPublessConfig());
        mStepPool.put(StepMsgDef.MSG_STEP_MONKEY_INIT_TEST_CONFIG, (Object)new StepMoneyTestInitConfig());
        RapidBoot.sTicker.stop("StartupManager#init");
    }

    public static void onMainFirstFrame() {
        long curTime = System.currentTimeMillis();
        if (sStartupComsumeTime == -1L) {
            sStartupComsumeTime = curTime - ((YYState)YYStore.INSTANCE.getState()).getStartTime();
        }
        int startType = ((YYState)YYStore.INSTANCE.getState()).getStartType();
        int startSubType = ((YYState)YYStore.INSTANCE.getState()).getStartSubType();
        if (startType == 1 && startSubType == 0) {
            long comsumeTimeFromSplash = curTime - ((YYState)YYStore.INSTANCE.getState()).getSplashTime();
            StartUpStatHelper.onStartUpFinished((long)StartupManager.getStartupComsumeTime(), (long)comsumeTimeFromSplash);
        }
    }

    public static long getStartupComsumeTime() {
        return sStartupComsumeTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StartupManager instance() {
        if (sInstance == null) {
            Class<StartupManager> clazz = StartupManager.class;
            synchronized (StartupManager.class) {
                if (sInstance == null) {
                    sInstance = new StartupManager();
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return sInstance;
            }
        }
        return sInstance;
    }

    public void start() {
        if (!this.startRef.getAndSet(true).booleanValue()) {
            this.run();
        }
    }

    private void run() {
        Application app = (Application)BasicConfig.getInstance().getAppContext();
        long time = SystemClock.currentThreadTimeMillis();
        PluginBus.INSTANCE.get();
        ((Step)mStepPool.get(StepMsgDef.MSG_STEP_HOST_STORE_INIT)).run();
        ((Step)mStepPool.get(StepMsgDef.MSG_STEP_INIT_CRASH_SDK)).run();
        ((Step)mStepPool.get(StepMsgDef.MSG_STEP_INIT_PUBLESS)).run();
        ((Step)mStepPool.get(StepMsgDef.MSG_STEP_COREMANAGER_INIT)).run();
        ((Step)mStepPool.get(StepMsgDef.MSG_STEP_YLINK_INIT)).run();
        ((Step)mStepPool.get(StepMsgDef.MSG_STEP_NAV_REST)).run();
        ((Step)mStepPool.get(StepMsgDef.MSG_STEP_GLOBAL_ACTIVITY_MANAGER)).run();
        ((Step)mStepPool.get(StepMsgDef.MSG_STEP_ABTEST_CONFIG_UPDATE)).run();
        ((Step)mStepPool.get(StepMsgDef.MSG_STEP_YCLOUD_INIT_PUBLESS_CONFIG)).run();
        ((Step)mStepPool.get(StepMsgDef.MSG_STEP_MONKEY_INIT_TEST_CONFIG)).run();
        Log.d((String)TAG, (String)("ticker ensure:" + (SystemClock.currentThreadTimeMillis() - time)));
        RxBus.getDefault().register(EntLiveGetCoreEvent.class).observeOn(Schedulers.io()).subscribe((Consumer)new Consumer<EntLiveGetCoreEvent>(){

            public void accept(@io.reactivex.annotations.NonNull EntLiveGetCoreEvent event) throws Exception {
                StartupManager.this.handelEntLiveGetCore();
            }
        }, RxUtils.errorConsumer((String)TAG));
        RapidBoot.sTicker.start("@Env.instance().init()");
        Env.instance().init();
        RapidBoot.sTicker.stop("@Env.instance().init()");
        RapidBoot.sTicker.start("YYMobileApp#misc");
        if (CoreFactory.getCore(IYYCommandAction.class) != null) {
            YYStore.INSTANCE.registerProcessor(((IYYCommandAction)CoreFactory.getCore(IYYCommandAction.class)).getYYCommandProcessor());
            ((IYYCommandAction)CoreFactory.getCore(IYYCommandAction.class)).yyCommandCheck(app);
        }
        FeatureManager.init();
        RapidBoot.sTicker.start("@LoginUtilSynchronizer");
        RapidBoot.sTicker.stop("@LoginUtilSynchronizer");
        RapidBoot.sTicker.stop("YYMobileApp#misc");
        MessageNotifyMgr.INSTANCE.initManager();
        RapidBoot.sTicker.start("@IUpdateVersionCore");
        CoreFactory.getCore(IUpdateVersionCore.class);
        RapidBoot.sTicker.stop("@IUpdateVersionCore");
        RapidBoot.sTicker.start("@FileRequestManager");
        FileRequestManager.instance().init(BasicConfig.getInstance().getAppContext());
        RapidBoot.sTicker.stop("@FileRequestManager");
        RapidBoot.sTicker.start("@GuidFactory");
        GuidFactory.getInstance().init();
        RapidBoot.sTicker.stop("@GuidFactory");
        RapidBoot.sTicker.start("@DownloadClient");
        DownloadClient.instance().setBasicParamsProvider((IBasicParamsProvider)new DownloadCenterHelper());
        RapidBoot.sTicker.stop("@DownloadClient");
        CoreFactory.getCore(INotifyBarCore.class);
        this.getWebpConfig();
        OfficialActivityMsgManager.INSTANCE.requestOfficialAtyMsg();
        this.testIpv6Performance();
        this.getNetCollectionSamlingRate();
        this.requestYYResourcesConfig();
        this.monitorWxChannelTest();
        YYStore.INSTANCE.registerProcessor((Processor)new DummyMsgTriggerProcessor());
        YYThreadTracer.INSTANCE.doInit();
    }

    @SuppressLint(value={"CheckResult"})
    private void requestYYResourcesConfig() {
        MLog.info((String)TAG, (String)"requestYYResourcesConfig()");
        Publess.of(YYResourcesConfigData.class).pull().subscribe((Consumer)new Consumer<YYResourcesConfigData>(){

            public void accept(YYResourcesConfigData configData) throws Exception {
                YYResourcesManagerImpl.INSTANCE.requestYYResourcesConfig(configData.getResourcesData().getConfigs());
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable throwable) throws Exception {
                MLog.error((String)StartupManager.TAG, (String)"requestYYResourcesConfig() $it");
            }
        });
    }

    @SuppressLint(value={"CheckResult"})
    private void getNetCollectionSamlingRate() {
        Publess.of(NetCollectionSamlingRatePubless.class).pull().subscribe((Consumer)new Consumer<NetCollectionSamlingRatePubless>(){

            public void accept(NetCollectionSamlingRatePubless it) throws Exception {
                MLog.debug((String)StartupManager.TAG, (String)("testIpv6Performance NetCollectionSamlingRate = " + it.toString()));
                SharedPreferencesUtils.getDefaultPrf().edit().putInt("netCollectionSamlingRate", it.samlingRate).apply();
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable throwable) throws Exception {
                MLog.error((Object)StartupManager.TAG, (Throwable)throwable);
                SharedPreferencesUtils.getDefaultPrf().edit().putInt("netCollectionSamlingRate", 1).apply();
            }
        });
    }

    @SuppressLint(value={"CheckResult"})
    private void testIpv6Performance() {
        Publess.of(NetPerformanceCollectionJava.class).pull().subscribe((Consumer)new Consumer<NetPerformanceCollectionJava>(){

            public void accept(NetPerformanceCollectionJava netPerformanceCollection2) throws Exception {
                MLog.debug((String)StartupManager.TAG, (String)("testIpv6Performance netPerformanceCollection = " + netPerformanceCollection2.toString()));
                SharedPreferencesUtils.getDefaultPrf().edit().putBoolean("ipv6_performance_switch", netPerformanceCollection2.isOpen == 1).apply();
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable throwable) throws Exception {
                MLog.error((Object)StartupManager.TAG, (Throwable)throwable);
                SharedPreferencesUtils.getDefaultPrf().edit().putBoolean("ipv6_performance_switch", false).apply();
            }
        });
        if (MonitorEventListenerFactoryKt.getSwitch()) {
            List ipv6List = MonitorEventListenerFactoryKt.getIPV6_LIST();
            int index = Math.abs(new Random().nextInt()) % ipv6List.size();
            String path = (String)ipv6List.get(index);
            this.testIpv6ForHttp(path);
            List ipv4List = MonitorEventListenerFactoryKt.getIPV4_LIST();
            index = Math.abs(new Random().nextInt()) % ipv4List.size();
            path = (String)ipv4List.get(index);
            this.testIpv6ForHttp(path);
        }
    }

    private void testIpv6ForHttp(String path) {
        String newSegment = "srv/test";
        Uri uri = new Uri.Builder().scheme("http").path(path).appendPath(newSegment).build();
        StringQueryRequest request2 = new StringQueryRequest(RequestManager.instance().getCache(), uri.toString(), (ResponseListener)new ResponseListener<String>(){

            public void onResponse(String response) {
                MLog.debug((String)StartupManager.TAG, (String)("testIpv6Performance success response = " + response));
            }
        }, new ResponseErrorListener(){

            public void onErrorResponse(RequestError error) {
                MLog.error((Object)StartupManager.TAG, (String)"testIpv6Performance", (Throwable)error, (Object[])new Object[0]);
            }
        });
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Host", "web-ipv6test.yy.com");
        request2.setHeader(map);
        RequestManager.instance().submitRequest((Request)request2);
    }

    private void getWebpConfig() {
        Disposable disposable2 = Publess.of(WebPConfigData.class).pull().subscribeOn(Schedulers.io()).observeOn(Schedulers.io()).subscribe((Consumer)new Consumer<WebPConfigData>(){

            public void accept(WebPConfigData configData) throws Exception {
                int intSwitch = ((WebPConfigData)Publess.of(WebPConfigData.class).getData()).getASwitch();
                int imSwitch = ((WebPConfigData)Publess.of(WebPConfigData.class).getData()).getImSwitch();
                BS2CovertManager.getInstance().setIntSwitch(intSwitch);
                BS2CovertManager.getInstance().setImSwitch(imSwitch);
                CommonPref.instance().putInt("key_pref_switch", intSwitch);
                CommonPref.instance().putInt("key_im_pref_switch", imSwitch);
                List<String> bs2List = ((WebPConfigData)Publess.of(WebPConfigData.class).getData()).getWhiteListDomainName();
                List<String> aliyunList = ((WebPConfigData)Publess.of(WebPConfigData.class).getData()).getAliyunDomain();
                BS2CovertManager.getInstance().setBs2Domain(bs2List, aliyunList);
                MLog.info((String)StartupManager.TAG, (String)("thread: " + Thread.currentThread() + " isOpen:" + intSwitch + " imSwitch:" + imSwitch + " bs2WhiteList:" + bs2List.toString() + " aliyunList:" + aliyunList.toString()));
            }
        }, RxUtils.errorConsumer((String)TAG));
    }

    private void monitorWxChannelTest() {
        ((WXChannelABtest)Kinds.of(WXChannelABtest.class)).startMonitor();
    }

    private void handelEntLiveGetCore() {
        ISdkBackgroundCore sdkBackgroundCore;
        IStethoAction iStethoAction;
        MLog.info((String)TAG, (String)"handelEntLiveGetCore");
        ((Step)mStepPool.get(StepMsgDef.MSG_STEP_WEB_REDIRECT_CONFIG)).run();
        ((Step)mStepPool.get(StepMsgDef.MSG_STEP_DBMANAGER_INIT)).run();
        ((Step)mStepPool.get(StepMsgDef.MSG_STEP_SMALL_INIT_SETUPSMALL)).run();
        ((Step)mStepPool.get(StepMsgDef.MSG_STEP_COREMANAGER_POST_INIT)).run();
        RapidBoot.sTicker.start("Stetho");
        if (BasicConfig.getInstance().isDebuggable() && (iStethoAction = (IStethoAction)CoreFactory.getCore(IStethoAction.class)) != null) {
            iStethoAction.initStetho();
        }
        RapidBoot.sTicker.stop("Stetho");
        if (((YYState)YYStore.INSTANCE.getState()).getStartType() == 2 && (sdkBackgroundCore = (ISdkBackgroundCore)CoreManager.getCore(ISdkBackgroundCore.class)) != null) {
            try {
                sdkBackgroundCore.changeToBackground();
            }
            catch (Throwable e) {
                MLog.error((Object)TAG, (String)"changeToBackground error", (Throwable)e, (Object[])new Object[0]);
            }
        }
        ((Step)mStepPool.get(StepMsgDef.MSG_STEP_REQUEST_BASE_DATA)).run();
        ((Step)mStepPool.get(StepMsgDef.MSG_STEP_REPORT_UNCATCH_CRASH)).run();
        new LazyRun(BasicConfig.getInstance().getAppContext()).run();
        RxBus.getDefault().post((Object)new StartUpFinishEvent());
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                YYStore.INSTANCE.dispatch((Action)new YYState_StartUpStateAction(StartUpState.ONE_SECOND));
            }
        }, (long)1000L);
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                YYStore.INSTANCE.dispatch((Action)new YYState_StartUpStateAction(StartUpState.THREE_SECOND));
            }
        }, (long)3000L);
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                YYStore.INSTANCE.dispatch((Action)new YYState_StartUpStateAction(StartUpState.FIVE_SECOND));
            }
        }, (long)5000L);
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                YYStore.INSTANCE.dispatch((Action)new YYState_StartUpStateAction(StartUpState.TEN_SECOND));
            }
        }, (long)10000L);
    }

    static {
        mStepPool = new SparseArray();
        sStartupComsumeTime = -1L;
    }

    private class StepMoneyTestInitConfig
    extends Step {
        private StepMoneyTestInitConfig() {
        }

        @Override
        public void doAction() {
            if (BasicConfig.getInstance().isDebuggable()) {
                boolean isOpen = CommonPref.instance().getBoolean("test_open_monkey", false);
                String testUName = CommonPref.instance().getString("monkey_testname");
                String testPwd = CommonPref.instance().getString("monkey_testpwd");
                if (isOpen && !TextUtils.isEmpty((CharSequence)testUName) && !TextUtils.isEmpty((CharSequence)testPwd)) {
                    if (LoginUtil.isLogined()) {
                        MLog.info((String)StartupManager.TAG, (String)" cur is logined and not login monkey test");
                    } else {
                        String realPwd = ((ILoginCore)ICoreManagerBase.getCore(ILoginCore.class)).getPasswdSha1(testPwd);
                        ((ILoginCore)ICoreManagerBase.getCore(ILoginCore.class)).login(testUName, realPwd, LoginType.Passport, UserInfo.OnlineState.Online);
                        MLog.info((String)StartupManager.TAG, (String)"BEGIN TO loGIN monkey test");
                    }
                }
            } else {
                MLog.info((String)StartupManager.TAG, (String)" not debug env and no monkey");
            }
        }

        @Override
        public int getID() {
            return StepMsgDef.MSG_STEP_MONKEY_INIT_TEST_CONFIG;
        }

        @Override
        public String getDescription() {
            return "StepMoneyTestInitConfig";
        }
    }

    private class StepYCloudInitPublessConfig
    extends Step {
        private StepYCloudInitPublessConfig() {
        }

        @Override
        public void doAction() {
            AudioMutexManager.getInstance().initConfig();
        }

        @Override
        public int getID() {
            return StepMsgDef.MSG_STEP_YCLOUD_INIT_PUBLESS_CONFIG;
        }

        @Override
        public String getDescription() {
            return "StepYCloudInitPublessConfig";
        }
    }

    private class ABTestUpdateConfig
    extends Step {
        private ABTestUpdateConfig() {
        }

        @Override
        public void doAction() {
            ABTestConfigInitializer.INSTANCE.setupABTest();
        }

        @Override
        public int getID() {
            return StepMsgDef.MSG_STEP_ABTEST_CONFIG_UPDATE;
        }

        @Override
        public String getDescription() {
            return "ABTestUpdateConfig";
        }
    }

    private class WebRedirectConfigQuery
    extends Step {
        private WebRedirectConfigQuery() {
        }

        @Override
        public void doAction() {
            if (!MLog.isLogLevelAboveDebug()) {
                MLog.debug((String)StartupManager.TAG, (String)"WebRedirectConfigQuery is Running");
                WebConfig.getInstance().getWebRedirectInfoList();
            }
        }

        @Override
        public int getID() {
            return StepMsgDef.MSG_STEP_WEB_REDIRECT_CONFIG;
        }

        @Override
        public String getDescription() {
            return "WebRedirectConfigQuery";
        }
    }

    private class ReportUnCatchCrash
    extends Step {
        private ReportUnCatchCrash() {
        }

        @Override
        public void doAction() {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    PerformanceMonitorSwitchController.reportUncatchCrash();
                }
            }, (long)5000L);
        }

        @Override
        public String getDescription() {
            return "ReportUnCatchCrash";
        }

        @Override
        public int getID() {
            return StepMsgDef.MSG_STEP_REPORT_UNCATCH_CRASH;
        }
    }

    private class StepCoreManagerDelayInit
    extends Step {
        private StepCoreManagerDelayInit() {
        }

        @Override
        public void doAction() {
            CoreManager.postInit();
        }

        @Override
        public String getDescription() {
            return "CoreManagerDelayInit";
        }

        @Override
        public int getID() {
            return StepMsgDef.MSG_STEP_COREMANAGER_POST_INIT;
        }
    }

    private class StepDbManagerInit
    extends Step {
        private StepDbManagerInit() {
        }

        @Override
        public void doAction() {
        }

        @Override
        public String getDescription() {
            return "DbManagerInit";
        }

        @Override
        public int getID() {
            return StepMsgDef.MSG_STEP_DBMANAGER_INIT;
        }
    }

    private class StepGlobalActivityManager
    extends Step {
        private StepGlobalActivityManager() {
        }

        @Override
        public void doAction() {
            LoginBroadcastReceiver.getInstance().init((Application)BasicConfig.getInstance().getAppContext());
            NotifyBroadcastReceiver.getInstance().init((Application)BasicConfig.getInstance().getAppContext());
            GlobalActivityManager.INSTANCE.init((Application)BasicConfig.getInstance().getAppContext());
        }

        @Override
        public String getDescription() {
            return "GlobalActivityManagerInit";
        }

        @Override
        public int getID() {
            return StepMsgDef.MSG_STEP_GLOBAL_ACTIVITY_MANAGER;
        }
    }

    private class StepNavRest
    extends Step {
        private StepNavRest() {
        }

        private void addMatchList(@NonNull INavRestCore navRestCore, IRestApiList apiList) {
            if (apiList != null) {
                navRestCore.addMatchList(apiList.getList());
            }
        }

        @Override
        public void doAction() {
            INavRestCore navRestCore = (INavRestCore)ICoreManagerBase.getCore(INavRestCore.class);
            if (navRestCore != null) {
                this.addMatchList(navRestCore, new LoginApiList());
                this.addMatchList(navRestCore, new WebCtrlApiList());
                this.addMatchList(navRestCore, new LiveCenterApiList());
                this.addMatchList(navRestCore, new PersonalCenterApiList());
                this.addMatchList(navRestCore, new UserInfoApiList());
                this.addMatchList(navRestCore, new CommonApiList());
                this.addMatchList(navRestCore, new LivePreviewApiList());
                this.addMatchList(navRestCore, new MessageCenterApiList());
                this.addMatchList(navRestCore, new AnchorGalleryApiList());
                this.addMatchList(navRestCore, new LivingApiList());
                this.addMatchList(navRestCore, new DiamondApiList());
                this.addMatchList(navRestCore, new VoiceRoomApiList());
                this.addMatchList(navRestCore, new UnicomWspxApiList());
                this.addMatchList(navRestCore, new AggregationPageApiList());
                this.addMatchList(navRestCore, new ToastApiList());
                this.addMatchList(navRestCore, new PopwebApiList());
                this.addMatchList(navRestCore, new ImApiList());
            }
        }

        @Override
        public String getDescription() {
            return "NavRestInit";
        }

        @Override
        public int getID() {
            return StepMsgDef.MSG_STEP_NAV_REST;
        }
    }

    private class StepCoreManagerInit
    extends Step {
        private StepCoreManagerInit() {
        }

        @Override
        public void doAction() {
            CoreManager.init();
        }

        @Override
        public String getDescription() {
            return "@CoreManagerInit";
        }

        @Override
        public int getID() {
            return StepMsgDef.MSG_STEP_COREMANAGER_INIT;
        }
    }

    private class StepYLinkInit
    extends Step {
        private StepYLinkInit() {
        }

        @Override
        public void doAction() {
            YLink.init();
        }

        @Override
        public String getDescription() {
            return "YlinkInit";
        }

        @Override
        public int getID() {
            return StepMsgDef.MSG_STEP_YLINK_INIT;
        }
    }

    private class StepSmallInitializerSetup
    extends Step {
        private StepSmallInitializerSetup() {
        }

        @Override
        public void doAction() {
            SmallInitializer.setupSmall();
        }

        @Override
        public String getDescription() {
            return "MainSmallInitializerSmallSetup";
        }

        @Override
        public int getID() {
            return StepMsgDef.MSG_STEP_SMALL_INIT_SETUPSMALL;
        }
    }

    private class StepRequestBaseData
    extends Step {
        private StepRequestBaseData() {
        }

        private void requestHttpDnsInfo() {
            IHttpDnsConfigCore core = (IHttpDnsConfigCore)CoreFactory.getCore(IHttpDnsConfigCore.class);
            if (core != null) {
                core.reqHttpDnsConfig();
            }
        }

        private void requestDnsHookInfo() {
            IDnsHookConfigCore core = (IDnsHookConfigCore)CoreFactory.getCore(IDnsHookConfigCore.class);
            if (core != null) {
                core.reqDnsHookConfig();
            }
        }

        private void requestOKHttpInfo() {
            IOKHttpConfigCore core = (IOKHttpConfigCore)CoreFactory.getCore(IOKHttpConfigCore.class);
            if (core != null) {
                core.reqOKHttpConfig();
            }
        }

        @Override
        public void doAction() {
            this.requestHttpDnsInfo();
            this.requestDnsHookInfo();
            this.requestOKHttpInfo();
        }

        @Override
        public String getDescription() {
            return "RequestBaseData";
        }

        @Override
        public int getID() {
            return StepMsgDef.MSG_STEP_REQUEST_BASE_DATA;
        }
    }

    private class StepInitCrashSdk
    extends Step {
        private StepInitCrashSdk() {
        }

        @Override
        public void doAction() {
            if (ICoreManagerBase.getCore(ICrashDeversityCore.class) != null) {
                ((ICrashDeversityCore)ICoreManagerBase.getCore(ICrashDeversityCore.class)).addCrashExtInfo();
            }
        }

        @Override
        public String getDescription() {
            return "MainStepInitCrashSdkInit";
        }

        @Override
        public int getID() {
            return StepMsgDef.MSG_STEP_INIT_CRASH_SDK;
        }
    }

    private class StepInitImageAndRequestManager
    extends Step {
        private StepInitImageAndRequestManager() {
        }

        @Override
        public void doAction() {
        }

        @Override
        public String getDescription() {
            return "StepInitImageAndRequestManager";
        }

        @Override
        public int getID() {
            return StepMsgDef.MSG_STEP_INIT_IMAGE_AND_REQUEST_MANAGER;
        }
    }

    private class StepInitPubless
    extends Step {
        private StepInitPubless() {
        }

        @Override
        public void doAction() {
            MLog.info((String)StartupManager.TAG, (String)"StepInitPubless doAction");
            Publess.enableLog((ILog)new PublessLog());
            PublessCore.init();
            if (((ActivityEntranceShowTimeABTest)Kinds.of(ActivityEntranceShowTimeABTest.class)).isEnable()) {
                Publess.of(ScrollIntervalConfigData.class).update();
            }
        }

        @Override
        public int getID() {
            return StepMsgDef.MSG_STEP_INIT_PUBLESS;
        }

        @Override
        public String getDescription() {
            return "\u521d\u59cb\u5316\u7edf\u4e00\u914d\u7f6e\u4e2d\u5fc3";
        }
    }

    private static abstract class Step
    implements Runnable {
        private boolean mHasDone;

        private Step() {
        }

        @Override
        public final void run() {
            if (this.mHasDone && !this.needRedo()) {
                return;
            }
            this.mHasDone = false;
            String desCri = this.getDescription();
            if (DEBUG && desCri != null && !MLog.isLogLevelAboveDebug()) {
                MLog.debug((String)StartupManager.TAG, (String)("begin step: " + desCri));
            }
            RapidBoot.sTicker.start(desCri);
            this.doAction();
            RapidBoot.sTicker.stop(desCri);
            if (DEBUG && desCri != null && !MLog.isLogLevelAboveDebug()) {
                MLog.debug((String)StartupManager.TAG, (String)("end step: " + desCri));
            }
            this.mHasDone = true;
        }

        protected boolean needRedo() {
            return false;
        }

        public abstract void doAction();

        public abstract int getID();

        public abstract String getDescription();
    }

    public static class StepHostStoreInit
    extends Step {
        @Override
        public void doAction() {
            HostStore.INSTANCE.init(Arrays.asList(new AddDataModuleApiMethodMiddleware(), new AddUiModuleApiMethodMiddleware(), new UpdatePresenceMiddleware()));
        }

        @Override
        public int getID() {
            return StepMsgDef.MSG_STEP_HOST_STORE_INIT;
        }

        @Override
        public String getDescription() {
            return "StepHostStoreInit";
        }
    }
}

