/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.task;

import android.content.Context;
import com.yy.hiidostatis.defs.obj.Property;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.main.client.ICrashDeversityCore;
import com.yy.mobile.main.notify.INotifyCenterCore;
import com.yy.mobile.main.push.IPushMgrCore;
import com.yy.mobile.memoryrecycle.drawablerecycle.DrawableRecycler;
import com.yy.mobile.ui.facevalue.utils.CacheSetting;
import com.yy.mobile.ui.setting.DownLoadNotification;
import com.yy.mobile.ui.setting.UpdateNotification;
import com.yy.mobile.ui.widget.fps.FpsView;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.SystemUtils;
import com.yy.mobile.util.VersionUtil;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.pref.CommonPref;
import com.yy.mobile.util.taskexecutor.YYTaskExecutor;
import com.yymobile.core.AppConstants;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.artist.IArtistCore;
import com.yymobile.core.foundation.ILocationCore;
import com.yymobile.core.livepush.ILivePushCore;
import com.yymobile.core.logupload.ILogUploadCore;
import com.yymobile.core.messagenotifycenter.IMessageNotifyCenterCore;
import com.yymobile.core.mobilelive.ILivePluginCore;
import com.yymobile.core.performancemonitor.PerformanceMonitorSwitchController;
import com.yymobile.core.reportdeviceinfo.ReportDeviceCore;
import com.yymobile.core.sensitivewords.ISensitiveWordsCore;
import com.yymobile.core.setting.ISettingCore;
import com.yymobile.core.splash.ISplashCore;
import com.yymobile.core.statistic.IHiidoStatisticCore;
import java.io.File;
import java.io.Serializable;
import java.util.HashMap;

public class LazyRun
implements Runnable {
    private static final String TAG = "LazyRun";
    private Context mContext;

    LazyRun(Context context) {
        this.mContext = context;
    }

    @Override
    public void run() {
        long startTime = System.currentTimeMillis();
        boolean gPushRunning = CoreFactory.getCore(IPushMgrCore.class) != null && ((IPushMgrCore)CoreFactory.getCore(IPushMgrCore.class)).isPushRunning(this.mContext);
        MLog.info((String)TAG, (String)("gPushRunning=" + gPushRunning));
        Property pushRunningPro = new Property();
        pushRunningPro.putString("key1", String.valueOf(gPushRunning ? 1 : 0));
        ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "51201", "0008", (Serializable)pushRunningPro);
        if (CoreFactory.getCore(INotifyCenterCore.class) != null) {
            ((INotifyCenterCore)CoreFactory.getCore(INotifyCenterCore.class)).initNotify(this.mContext);
        }
        UpdateNotification.instance().init(this.mContext);
        DownLoadNotification.instance().init(this.mContext);
        this.coreManagerInit();
        this.requestBaseDataInit();
        if (BasicConfig.getInstance().isDebuggable() && CommonPref.instance().getBoolean("PRE_SETTING_JUMP_TO_FPS", false)) {
            FpsView.instance((Context)this.mContext, (String)this.mContext.getPackageName()).addToStage(0, (int)ResolutionUtils.convertDpToPixel((float)50.0f, (Context)this.mContext), (int)ResolutionUtils.convertDpToPixel((float)100.0f, (Context)this.mContext), (int)ResolutionUtils.convertDpToPixel((float)50.0f, (Context)this.mContext));
        }
        if (BasicConfig.getInstance().isDebuggable() && (CommonPref.instance().getBoolean("PRE_SETTING_JUMP_TO_CHANNELVIEW", false) || CommonPref.instance().getBoolean("PREF_ENABLE_MOBILE_LIVE_VIDEO_CONTROL", false))) {
            ((ILivePluginCore)CoreFactory.getCore(ILivePluginCore.class)).addToStage();
        }
        SystemUtils.fixMediaSessionLegacyHelper();
        this.logInfo();
        if (!CommonPref.instance().getBoolean("reportedDeviceInfo", false)) {
            MLog.info((String)TAG, (String)"reportDeviceInfo");
            ((ReportDeviceCore)CoreFactory.getCore(ReportDeviceCore.class)).reportDeviceInfo(BasicConfig.getInstance().getAppContext());
        }
        CacheSetting.INSTANCE.init(AppConstants.FACE_VALUE_CACHE_DIR);
        ((ISplashCore)CoreFactory.getCore(ISplashCore.class)).querySplashAd();
        this.statisAppStart();
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                PerformanceMonitorSwitchController.onStartupFinished();
            }
        }, (long)5000L);
        DrawableRecycler.updateSwitch((boolean)PerformanceMonitorSwitchController.isAutoRecycleDrawableSwitchOn());
        this.initAutoRecycleDrawableTestSwitch();
        long cost = System.currentTimeMillis() - startTime;
        MLog.info((String)TAG, (String)("LazyRun cost : " + cost));
    }

    private void initAutoRecycleDrawableTestSwitch() {
        if (BasicConfig.getInstance().isDebuggable()) {
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    File colseFlagFile = new File(BasicConfig.getInstance().getRootDir() + File.separator + "autorecycleclose.txt");
                    if (colseFlagFile.exists()) {
                        DrawableRecycler.updateSwitch((boolean)false);
                    }
                }
            }, (long)600L);
        }
    }

    private void logInfo() {
        MLog.info((String)TAG, (String)("Crash device id:" + ((ICrashDeversityCore)ICoreManagerBase.getCore(ICrashDeversityCore.class)).getDeviceId()));
        MLog.info((String)TAG, (String)("YYVersion:" + VersionUtil.getLocalVer((Context)BasicConfig.getInstance().getAppContext()).aboutDisplayName(BasicConfig.getInstance().getAppContext())));
        MLog.info((String)TAG, (String)"main SDKVersions , udbauthsdk:2.9.18.0, hiido_statis:3.5.23");
    }

    private void statisAppStart() {
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put("key1", "START");
        long userId = LoginUtil.getUid();
        ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(userId, "52002", "0001", map);
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"EVENT_ID_PERF_MONITOR, app start,userId=%d ", (Object[])new Object[]{LoginUtil.getUid()});
        }
    }

    private void coreManagerInit() {
        CoreFactory.getCore(ILocationCore.class);
        CoreFactory.getCore(ISettingCore.class);
        ((ISettingCore)CoreFactory.getCore(ISettingCore.class)).delayCacheShrink();
        CoreFactory.getCore(IArtistCore.class);
        CoreFactory.getCore(ILivePushCore.class);
        CoreFactory.getCore(ISensitiveWordsCore.class);
        CoreFactory.getCore(IMessageNotifyCenterCore.class);
    }

    private void requestBaseDataInit() {
        if (CoreFactory.getCore(ILogUploadCore.class) != null) {
            ((ILogUploadCore)CoreFactory.getCore(ILogUploadCore.class)).requestLogSwitchFlag();
        }
    }
}

