/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.router.service;

import android.content.Context;
import android.net.Uri;
import android.os.Build;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.facade.annotation.RouteDoc;
import com.alibaba.android.arouter.facade.service.PathReplaceService;
import com.yy.mobile.bizmodel.login.LoginUtilHomeApi;
import com.yy.mobile.channeltokenutil.JoinChannelTokenUtil;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.guid.GuidFactory;
import com.yy.mobile.perf.PerfSDK;
import com.yy.mobile.perf.loggable.model.CommonLogData;
import com.yy.mobile.ui.utils.DateUtils;
import com.yy.mobile.util.NetworkUtils;
import com.yy.mobile.util.VersionUtil;
import com.yy.mobile.util.log.MLog;
import java.util.Date;

@Route(path="/arouter/service/pathReplace", name="\u8def\u5f84\u5904\u7406")
@RouteDoc(desc="path\u548curi\u5904\u7406", minVer="7.16", eg="yymobile://arouter/service/pathReplace")
public class PathReplaceServiceImpl
implements PathReplaceService {
    private static final int LOG_SCODE = 50238;
    private static final String scode = "0";
    private static final String ucode = "1";
    private static final String TAG = "ArouterPathStatics";

    public String forString(String path) {
        this.reportLogInner(path, scode);
        return path;
    }

    public Uri forUri(Uri uri) {
        String scheme = (uri = JoinChannelTokenUtil.addOrReplaceChannelUrlToken((Uri)uri)).getScheme();
        if (scheme != null && !scheme.equals("http") && !scheme.equals("https")) {
            MLog.debug((String)TAG, (String)("uri1:" + uri.toString() + "---" + uri.getAuthority() + uri.getPath()));
            this.reportLogInner("/" + uri.getAuthority() + uri.getPath(), ucode);
        } else {
            MLog.debug((String)TAG, (String)("uri2:" + uri.toString() + "---" + uri.getPath()));
            this.reportLogInner(uri.getPath(), ucode);
        }
        return uri;
    }

    public void init(Context context) {
    }

    private void reportLogInner(String data, String methodid) {
        CommonLogData logData = new CommonLogData();
        logData.scode = 50238;
        logData.devId = GuidFactory.getInstance().getGuid();
        logData.model = Build.MANUFACTURER + "_" + Build.MODEL;
        logData.plat = "android";
        logData.osVer = Build.VERSION.RELEASE;
        logData.net = NetworkUtils.getNetworkName((Context)BasicConfig.getInstance().getAppContext());
        logData.uid = LoginUtilHomeApi.getUid();
        logData.app = "YYLive";
        logData.ver = VersionUtil.getLocalVer((Context)BasicConfig.getInstance().getAppContext()).toString();
        logData.time = DateUtils.dateToString((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
        logData.rev1 = methodid;
        logData.addInfoItem("{\"route\"", "\"" + data + "\"}");
        PerfSDK.instance().reportCommonLog(logData, null);
    }
}

