/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.livebizwrapper.widget.adapter;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.util.Linkify;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.widget.AdapterView;
import android.widget.CheckedTextView;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RatingBar;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import com.bumptech.glide.Glide;

public class BaseHolder
extends RecyclerView.ViewHolder {
    private final SparseArray<View> views = new SparseArray();
    private Context context;
    protected ViewGroup mParent;

    public BaseHolder(View itemView, ViewGroup mParent) {
        super(itemView);
        this.mParent = mParent;
        this.context = itemView.getContext();
    }

    public BaseHolder setText(int viewId, CharSequence value) {
        TextView view = (TextView)this.retrieveView(viewId);
        view.setText(value);
        return this;
    }

    public BaseHolder setImageResource(int viewId, int imageResId) {
        ImageView view = (ImageView)this.retrieveView(viewId);
        view.setImageResource(imageResId);
        return this;
    }

    public BaseHolder setBackgroundColor(int viewId, int color2) {
        Object view = this.retrieveView(viewId);
        view.setBackgroundColor(color2);
        return this;
    }

    public BaseHolder setBackgroundRes(int viewId, int backgroundRes) {
        Object view = this.retrieveView(viewId);
        view.setBackgroundResource(backgroundRes);
        return this;
    }

    public BaseHolder setTextColor(int viewId, int textColor) {
        TextView view = (TextView)this.retrieveView(viewId);
        view.setTextColor(textColor);
        return this;
    }

    public BaseHolder setTextColorRes(int viewId, int textColorRes) {
        TextView view = (TextView)this.retrieveView(viewId);
        view.setTextColor(this.context.getResources().getColor(textColorRes));
        return this;
    }

    public BaseHolder setImageDrawable(int viewId, Drawable drawable2) {
        ImageView view = (ImageView)this.retrieveView(viewId);
        view.setImageDrawable(drawable2);
        return this;
    }

    public BaseHolder setImageUrl(int viewId, String imageUrl) {
        ImageView view = (ImageView)this.retrieveView(viewId);
        Glide.with((Context)this.context).load((Object)imageUrl).into(view);
        return this;
    }

    public BaseHolder setImageBitmap(int viewId, Bitmap bitmap) {
        ImageView view = (ImageView)this.retrieveView(viewId);
        view.setImageBitmap(bitmap);
        return this;
    }

    public BaseHolder setAlpha(int viewId, float value) {
        if (Build.VERSION.SDK_INT >= 11) {
            this.retrieveView(viewId).setAlpha(value);
        } else {
            AlphaAnimation alpha = new AlphaAnimation(value, value);
            alpha.setDuration(0L);
            alpha.setFillAfter(true);
            this.retrieveView(viewId).startAnimation((Animation)alpha);
        }
        return this;
    }

    public BaseHolder setVisible(int viewId, boolean visible) {
        Object view = this.retrieveView(viewId);
        view.setVisibility(visible ? 0 : 8);
        return this;
    }

    public BaseHolder linkify(int viewId) {
        TextView view = (TextView)this.retrieveView(viewId);
        Linkify.addLinks((TextView)view, (int)15);
        return this;
    }

    public BaseHolder setTypeface(int viewId, Typeface typeface) {
        TextView view = (TextView)this.retrieveView(viewId);
        view.setTypeface(typeface);
        view.setPaintFlags(view.getPaintFlags() | 0x80);
        return this;
    }

    public BaseHolder setTypeface(Typeface typeface, int ... viewIds) {
        for (int viewId : viewIds) {
            TextView view = (TextView)this.retrieveView(viewId);
            view.setTypeface(typeface);
            view.setPaintFlags(view.getPaintFlags() | 0x80);
        }
        return this;
    }

    public BaseHolder setProgress(int viewId, int progress) {
        ProgressBar view = (ProgressBar)this.retrieveView(viewId);
        view.setProgress(progress);
        return this;
    }

    public BaseHolder setProgress(int viewId, int progress, int max) {
        ProgressBar view = (ProgressBar)this.retrieveView(viewId);
        view.setMax(max);
        view.setProgress(progress);
        return this;
    }

    public BaseHolder setMax(int viewId, int max) {
        ProgressBar view = (ProgressBar)this.retrieveView(viewId);
        view.setMax(max);
        return this;
    }

    public BaseHolder setRating(int viewId, float rating) {
        RatingBar view = (RatingBar)this.retrieveView(viewId);
        view.setRating(rating);
        return this;
    }

    public BaseHolder setRating(int viewId, float rating, int max) {
        RatingBar view = (RatingBar)this.retrieveView(viewId);
        view.setMax(max);
        view.setRating(rating);
        return this;
    }

    public BaseHolder setOnClickListener(int viewId, View.OnClickListener listener2) {
        Object view = this.retrieveView(viewId);
        view.setOnClickListener(listener2);
        return this;
    }

    public BaseHolder setOnTouchListener(int viewId, View.OnTouchListener listener2) {
        Object view = this.retrieveView(viewId);
        view.setOnTouchListener(listener2);
        return this;
    }

    public BaseHolder setOnLongClickListener(int viewId, View.OnLongClickListener listener2) {
        Object view = this.retrieveView(viewId);
        view.setOnLongClickListener(listener2);
        return this;
    }

    public BaseHolder setOnItemClickListener(int viewId, View.OnClickListener listener2) {
        Object view = this.retrieveView(viewId);
        view.setOnClickListener(listener2);
        return this;
    }

    public BaseHolder setOnItemSelectedClickListener(int viewId, AdapterView.OnItemSelectedListener listener2) {
        AdapterView view = (AdapterView)this.retrieveView(viewId);
        view.setOnItemSelectedListener(listener2);
        return this;
    }

    public BaseHolder setOnCheckedChangeListener(int viewId, CompoundButton.OnCheckedChangeListener listener2) {
        CompoundButton view = (CompoundButton)this.retrieveView(viewId);
        view.setOnCheckedChangeListener(listener2);
        return this;
    }

    public BaseHolder setTag(int viewId, Object tag) {
        Object view = this.retrieveView(viewId);
        view.setTag(tag);
        return this;
    }

    public BaseHolder setTag(int viewId, int key, Object tag) {
        Object view = this.retrieveView(viewId);
        view.setTag(key, tag);
        return this;
    }

    public BaseHolder setChecked(int viewId, boolean checked) {
        Object view = this.retrieveView(viewId);
        if (view instanceof CompoundButton) {
            ((CompoundButton)view).setChecked(checked);
        } else if (view instanceof CheckedTextView) {
            ((CheckedTextView)view).setChecked(checked);
        }
        return this;
    }

    protected <T extends View> T retrieveView(int viewId) {
        View view = (View)this.views.get(viewId);
        if (view == null) {
            view = this.itemView.findViewById(viewId);
            this.views.put(viewId, (Object)view);
        }
        return (T)view;
    }
}

