/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.livebizwrapper.widget;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import androidx.annotation.Nullable;

public class AnimationCircleView
extends View {
    private int mWidth = 0;
    private int mHeight = 0;
    private Paint mPaint;
    private float mStrokeWidth = 0.0f;
    private Context mContext;
    private boolean isAnimationPlaying = false;
    ValueAnimator mAnimator;
    RectF rectF;

    public AnimationCircleView(Context context) {
        super(context);
        this.mContext = context;
        this.initPaint();
    }

    public AnimationCircleView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.initPaint();
    }

    private void initPaint() {
        this.mPaint = new Paint(1);
        this.mPaint.setColor(Color.parseColor((String)"#ffdd00"));
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeWidth(this.mStrokeWidth);
        this.rectF = new RectF(0.0f, 0.0f, 0.0f, 0.0f);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.mWidth = this.getMeasuredWidth();
        this.mHeight = this.getMeasuredHeight();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.rectF != null) {
            this.rectF.set(this.mStrokeWidth / 2.0f, this.mStrokeWidth / 2.0f, (float)this.mWidth - this.mStrokeWidth / 2.0f, (float)this.mHeight - this.mStrokeWidth / 2.0f);
        }
        canvas.drawArc(this.rectF, -90.0f, 360.0f, false, this.mPaint);
    }

    public int dp2px(Context context, float dpVal) {
        return (int)TypedValue.applyDimension((int)1, (float)dpVal, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    public void playAnimation() {
        this.mAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 2.0f, 0.0f});
        this.mAnimator.setDuration(2000L);
        this.mAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float currentValue = ((Float)animation.getAnimatedValue()).floatValue();
                AnimationCircleView.this.mStrokeWidth = AnimationCircleView.this.dp2px(AnimationCircleView.this.mContext, currentValue);
                AnimationCircleView.this.mPaint.setStrokeWidth(AnimationCircleView.this.mStrokeWidth);
                int alpha = (int)(currentValue / 2.0f * 255.0f);
                AnimationCircleView.this.mPaint.setAlpha(alpha);
                AnimationCircleView.this.invalidate();
            }
        });
        this.mAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                AnimationCircleView.this.isAnimationPlaying = true;
                AnimationCircleView.this.setVisibility(0);
            }

            public void onAnimationEnd(Animator animation) {
                AnimationCircleView.this.isAnimationPlaying = false;
                AnimationCircleView.this.setVisibility(8);
            }

            public void onAnimationCancel(Animator animation) {
                AnimationCircleView.this.isAnimationPlaying = false;
            }
        });
        this.mAnimator.start();
    }

    public boolean isAnimationPlaying() {
        return this.isAnimationPlaying;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mAnimator != null && this.mAnimator.isRunning()) {
            this.mAnimator.cancel();
        }
    }
}

