/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.livebizwrapper.utils;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.style.ForegroundColorSpan;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.livebizwrapper.chatscreen.PublicMessageHelper;
import com.yy.mobile.livebizwrapper.chatscreen.parser.NobleEmotionParser;
import com.yy.mobile.livebizwrapper.utils.LiveRoomLoadDrawableWrapper;
import com.yy.mobile.livebizwrapper.utils.PublicChatUtils;
import com.yy.mobile.livebizwrapper.utils.RoleMobuleUtil;
import com.yy.mobile.ui.widget.CustomImageSpan;
import com.yy.mobile.util.ResolutionUtils;
import com.yymobile.core.channel.ChannelMessage;
import com.yymobile.core.channel.ChatMedalInfo;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RichTextUtil {
    private static final String TAG = "RichTextUtil";

    public static int getMedalMarginLeft(String text, int idx) {
        if (idx <= 0 || idx >= text.length()) {
            return 0;
        }
        if (text.charAt(idx - 1) == ']') {
            return 3;
        }
        return 4;
    }

    public static int getMedalMarginRight(String text, int idx) {
        if (idx <= 0 || idx >= text.length()) {
            return 0;
        }
        if (text.charAt(idx) == '[') {
            return 3;
        }
        return 4;
    }

    public static SpannableStringBuilder parseCommonMedal(ChannelMessage message, SpannableStringBuilder spannable, boolean isIcnShow) {
        String text = spannable.toString();
        for (ChatMedalInfo medal : message.commonMedals) {
            if (medal == null) continue;
            String imgKey = medal.imgKey;
            int imgId = PublicMessageHelper.getChatMedalImgId(imgKey);
            imgKey = "[" + imgKey + "]";
            Drawable drawable2 = LiveRoomLoadDrawableWrapper.INSTANCE.getDrawableWithCache(BasicConfig.getInstance().getAppContext(), imgId);
            int idx = text.indexOf(imgKey);
            if (idx < 0 || idx + imgKey.length() >= text.length()) continue;
            if (drawable2 != null && isIcnShow) {
                drawable2.setBounds(0, 0, drawable2.getIntrinsicWidth(), drawable2.getIntrinsicHeight());
                int marginLeft = RichTextUtil.getMedalMarginLeft(text, idx);
                int marginRight = RichTextUtil.getMedalMarginRight(text, idx + imgKey.length());
                spannable.setSpan((Object)new CustomImageSpan(drawable2, 2, ResolutionUtils.convertDpToPixel((float)marginLeft, (Context)RichTextUtil.getContext()), ResolutionUtils.convertDpToPixel((float)marginRight, (Context)RichTextUtil.getContext())), idx, idx + imgKey.length(), 33);
                continue;
            }
            spannable.replace(idx, idx + imgKey.length(), (CharSequence)"");
            if (message.medals.length() >= idx + imgKey.length()) {
                message.medals.replace(idx, idx + imgKey.length(), "");
            }
            message.text = message.text.replace(imgKey, "");
        }
        return spannable;
    }

    public static SpannableStringBuilder parseNobleLevel(ChannelMessage message, SpannableStringBuilder spannable, boolean isIcnShow) {
        int startIdx;
        String text = spannable.toString();
        if ((message.nobleLevel > 0 || message.vulgarLevel > 0) && (startIdx = spannable.toString().indexOf("[noblelv]")) > -1) {
            int nobleDrawableResId;
            Drawable nobleDrawable = null;
            int n = nobleDrawableResId = message.nobleLevel > 0 ? PublicChatUtils.getPublicNobleMedalIcon(message.nobleLevel) : PublicChatUtils.getPublicNobleMedalIcon(message.vulgarLevel);
            if (nobleDrawableResId > 0) {
                nobleDrawable = LiveRoomLoadDrawableWrapper.INSTANCE.getDrawableWithCache(BasicConfig.getInstance().getAppContext(), nobleDrawableResId);
            }
            if (nobleDrawable != null) {
                if (isIcnShow) {
                    nobleDrawable.setBounds(0, 0, PublicChatUtils.nobleIconWidth, PublicChatUtils.nobleIconHeight);
                    int marginLeft = RichTextUtil.getMedalMarginLeft(text, startIdx);
                    int marginRight = RichTextUtil.getMedalMarginRight(text, startIdx + "[noblelv]".length());
                    spannable.setSpan((Object)new CustomImageSpan(nobleDrawable, 2, ResolutionUtils.convertDpToPixel((float)marginLeft, (Context)RichTextUtil.getContext()), ResolutionUtils.convertDpToPixel((float)marginRight, (Context)RichTextUtil.getContext())), startIdx, startIdx + "[noblelv]".length(), 33);
                } else {
                    spannable.replace(startIdx, startIdx + "[noblelv]".length(), (CharSequence)"");
                    message.medals.replace(startIdx, startIdx + "[noblelv]".length(), "");
                    message.text = message.text.replace("[noblelv]", "");
                }
            }
        }
        return spannable;
    }

    public static SpannableStringBuilder parseRoleLevel(ChannelMessage message, SpannableStringBuilder spannable, boolean isIcnShow) {
        String text = spannable.toString();
        int roleIdx = spannable.toString().indexOf("[role]");
        if (roleIdx > -1) {
            Drawable roleDrawable = RoleMobuleUtil.getModuleDrawable(message.uid);
            int width = (int)ResolutionUtils.convertDpToPixel((float)16.0f, (Context)RichTextUtil.getContext());
            int height = (int)ResolutionUtils.convertDpToPixel((float)15.0f, (Context)RichTextUtil.getContext());
            if (null != roleDrawable && isIcnShow) {
                roleDrawable.setBounds(0, 0, width, height);
                int marginLeft = RichTextUtil.getMedalMarginLeft(text, roleIdx);
                int marginRight = RichTextUtil.getMedalMarginRight(text, roleIdx + "[role]".length());
                spannable.setSpan((Object)new CustomImageSpan(roleDrawable, 2, ResolutionUtils.convertDpToPixel((float)marginLeft, (Context)RichTextUtil.getContext()), ResolutionUtils.convertDpToPixel((float)marginRight, (Context)RichTextUtil.getContext())), roleIdx, roleIdx + "[role]".length(), 33);
            } else {
                spannable.replace(roleIdx, roleIdx + "[role]".length(), (CharSequence)"");
                message.medals.replace(roleIdx, roleIdx + "[role]".length(), "");
                message.text = message.text.replace("[role]", "");
            }
        }
        return spannable;
    }

    public static String filterEmotion(String text) {
        String emotionStr = "";
        if (TextUtils.isEmpty((CharSequence)text)) {
            return emotionStr;
        }
        StringBuilder stringBuilder = new StringBuilder();
        Pattern mPattern = Pattern.compile("#\\d{2}");
        Matcher matcher = mPattern.matcher(text);
        while (matcher.find()) {
            String uri = NobleEmotionParser.getInstance().getChatEmotionUri(matcher.group());
            if (TextUtils.isEmpty((CharSequence)uri)) continue;
            stringBuilder.append(matcher.group());
            if (text.indexOf(matcher.group()) == -1) continue;
            text = text.replace(matcher.group(), "");
        }
        if (stringBuilder.toString().length() >= 9) {
            emotionStr = stringBuilder.substring(0, 9) + text;
        } else if (stringBuilder.toString().length() >= 6) {
            emotionStr = stringBuilder.substring(0, 6) + text;
        } else if (stringBuilder.toString().length() >= 3) {
            emotionStr = stringBuilder.substring(0, 3) + text;
        }
        return emotionStr;
    }

    public static SpannableStringBuilder parseNickname(ChannelMessage message, SpannableStringBuilder spannable, int nicknameColor, int textColor) {
        int idx;
        if (spannable == null) {
            return null;
        }
        spannable.setSpan((Object)new ForegroundColorSpan(textColor), 0, spannable.length(), 33);
        if (!TextUtils.isEmpty((CharSequence)message.nickname) && (idx = spannable.toString().indexOf(message.nickname)) >= 0 && idx < spannable.length()) {
            spannable.setSpan((Object)new ForegroundColorSpan(nicknameColor), idx, idx + message.nickname.length(), 33);
        }
        return spannable;
    }

    private static Context getContext() {
        return BasicConfig.getInstance().getAppContext();
    }
}

