/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.livebizwrapper.utils;

import android.os.Bundle;
import com.yy.mobile.ui.basicchanneltemplate.component.IComponent;
import com.yy.mobile.ui.basicchanneltemplate.component.IComponentRoot;
import com.yy.mobile.ui.basicchanneltemplate.component.IPopupComponent;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.log.MLog;
import java.util.Collection;
import java.util.List;

public class PopupComponentShowUtils {
    private static final String TAG = "PopupComponentShowUtils";

    public static void show(IComponentRoot componentRoot, Class<? extends IPopupComponent> popupClazz) {
        PopupComponentShowUtils.show(componentRoot, popupClazz, null);
    }

    public static void show(IComponentRoot componentRoot, Class<? extends IPopupComponent> popupClazz, Bundle bundle) {
        if (componentRoot == null || popupClazz == null) {
            MLog.error((String)TAG, (String)"show: invalid params");
            return;
        }
        IPopupComponent componentToFind = PopupComponentShowUtils.findComponent(componentRoot, popupClazz);
        if (componentToFind == null || componentToFind.isShowing()) {
            MLog.info((String)TAG, (String)"show: already show so return");
            return;
        }
        MLog.debug((String)TAG, (String)"show: need show");
        componentToFind.show(componentRoot.getFragmentManager(), bundle);
    }

    public static void forceShow(IComponentRoot componentRoot, Class<? extends IPopupComponent> popupClazz, Bundle bundle) {
        if (componentRoot == null || popupClazz == null) {
            MLog.error((String)TAG, (String)"forceShow: invalid params");
            return;
        }
        IPopupComponent componentToFind = PopupComponentShowUtils.findComponent(componentRoot, popupClazz);
        if (componentToFind == null) {
            MLog.info((String)TAG, (String)"forceShow: find no component so return");
            return;
        }
        MLog.debug((String)TAG, (String)"forceShow: need show");
        componentToFind.show(componentRoot.getFragmentManager(), bundle);
    }

    private static IPopupComponent findComponent(IComponentRoot componentRoot, Class<? extends IPopupComponent> popupClazz) {
        IPopupComponent componentToFind = null;
        List components = componentRoot.getComponents();
        if (!FP.empty((Collection)components)) {
            for (IComponent component : components) {
                if (component == null || component.getClass() != popupClazz) continue;
                componentToFind = (IPopupComponent)component;
                break;
            }
        }
        return componentToFind;
    }
}

